/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.presentation.dialog;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.quickstart.BaseQuickStartDialog;
import com.kms.katalon.onboarding.application.controller.KnowledgeController;
import com.kms.katalon.onboarding.core.application.controller.IKnowledgeController;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.core.domain.repository.entity.OnboardingPreferences;
import java.util.ArrayList;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class TourCancellationDialog
extends BaseQuickStartDialog {
    private final int DIALOG_WIDTH = 600;
    private final int DIALOG_HEIGHT = 370;
    private boolean isActionButtonClicked = false;
    private boolean dontShowAgain = false;
    private Button dontShowAgainCheckbox;
    private Shell[] minimizedRecorderShells;

    public TourCancellationDialog() {
        super(null);
        this.setShellStyle(84080);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setMinimumSize(600, 370);
        shell.setSize(600, 370);
        Rectangle displayBounds = Display.getCurrent().getPrimaryMonitor().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shell.setLocation((displayBounds.width - shellBounds.width) / 2, (displayBounds.height - shellBounds.height) / 2);
        shell.setActive();
        shell.forceActive();
        try {
            Display.getCurrent().asyncExec(() -> {
                if (!shell.isDisposed()) {
                    shell.forceActive();
                    shell.forceFocus();
                }
            });
        }
        catch (Exception exception) {}
    }

    protected Point getInitialSize() {
        return new Point(600, 370);
    }

    public String getDialogTitle() {
        return "";
    }

    protected void createContent(Composite container) {
        ComponentBuilder.fromGrid((Composite)container).margin(30, 40, 30, 40).gridVerticalSpacing(25).fill().build();
        ComponentBuilder.label((Composite)container).text(OnboardingMessageConstants.TOUR_CANCELLATION_DIALOG_TITLE).font(FontUtil.H2_BOLD).center().textCenter().fillHorizontal().build();
        ComponentBuilder.label((Composite)container).text(OnboardingMessageConstants.TOUR_CANCELLATION_DIALOG_DESCRIPTION).center().fillHorizontal().textCenter().font(FontUtil.H4).build();
    }

    protected void createButtons(Composite parent) {
        Composite containerPanel = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1).fill().margin(0).build();
        Composite buttonBar = (Composite)ComponentBuilder.gridContainer((Composite)containerPanel, (int)2).margin(25, 40, 0, 40).gridHorizontalSpacing(20).center().build();
        ComponentBuilder.canvas((Composite)buttonBar).text(OnboardingMessageConstants.TOUR_CANCELLATION_DIALOG_EXIT_BUTTON_TEXT).secondaryButton().activeBackground(ColorUtil.GRAY_LIGHT_COLOR).background(ColorUtil.WHITE_COLOR).color(ColorUtil.BLACK_COLOR).border(ColorUtil.GRAY_LIGHT_COLOR).borderWidth(1).borderRadius(8).autoSize(120, 40).onClick(event -> {
            this.isActionButtonClicked = true;
            this.setReturnCode(1);
            this.close();
        }).build();
        ComponentBuilder.canvas((Composite)buttonBar).text(OnboardingMessageConstants.TOUR_CANCELLATION_DIALOG_RESUME_BUTTON_TEXT).hoverBackground(ColorUtil.LILAC_BUTTON_COLOR_HOVER).background(ColorUtil.LILAC_BUTTON_COLOR).color(ColorUtil.WHITE_COLOR).borderWidth(1).borderRadius(8).autoSize(120, 40).onClick(event -> {
            this.isActionButtonClicked = true;
            this.setReturnCode(0);
            this.close();
        }).build();
        Composite checkboxArea = (Composite)ComponentBuilder.gridContainer((Composite)containerPanel).fillHorizontal().bottom().backgroundMode(2).background(ColorUtil.themeColor((Color)ColorUtil.getWhiteBackgroundColor(), (Color)ColorUtil.getColor((String)"#2F2E2F"))).center().build();
        this.dontShowAgainCheckbox = (Button)ComponentBuilder.checkBox((Composite)checkboxArea).text(OnboardingMessageConstants.TOUR_CANCELLATION_DIALOG_DONT_SHOW_AGAIN_TEXT).onClick(event -> {
            this.dontShowAgain = this.dontShowAgainCheckbox.getSelection();
        }).build();
    }

    public boolean close() {
        if (!this.isActionButtonClicked) {
            this.setReturnCode(0);
        }
        if (this.dontShowAgain) {
            BundleContext bundleContext = FrameworkUtil.getBundle(TourCancellationDialog.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            IKnowledgeController knowledgeController = (IKnowledgeController)ContextInjectionFactory.make(KnowledgeController.class, (IEclipseContext)context);
            OnboardingPreferences preferences = knowledgeController.getOnboardingPreferences();
            preferences.setSkipExitOnboardingConfirmation(this.dontShowAgain);
            knowledgeController.updateOnboardingPreferences(preferences);
        }
        return super.close();
    }

    public boolean isDontShowAgainSelected() {
        return this.dontShowAgain;
    }

    protected boolean isResizable() {
        return true;
    }

    protected boolean isClosable() {
        return true;
    }

    protected void initializeBounds() {
        this.getShell().setSize(600, 370);
        Shell shell = this.getShell();
        Rectangle displayBounds = Display.getCurrent().getPrimaryMonitor().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shell.setLocation(displayBounds.x + (displayBounds.width - shellBounds.width) / 2, displayBounds.y + (displayBounds.height - shellBounds.height) / 2);
    }

    private void minimizeRecorderDialogs() {
        try {
            Shell shell;
            Display display = Display.getCurrent();
            if (display == null) {
                display = Display.getDefault();
            }
            Shell[] shells = display.getShells();
            ArrayList<Shell> recordersToMinimize = new ArrayList<Shell>();
            Shell[] shellArray = shells;
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                String shellText;
                shell = shellArray[n2];
                if (!shell.isDisposed() && ("Web Recorder".equals(shellText = shell.getText()) || "Mobile Recorder".equals(shellText) || "Windows Recorder".equals(shellText) || shellText != null && shellText.toLowerCase().contains("recorder")) && shell.isVisible() && !shell.getMinimized()) {
                    recordersToMinimize.add(shell);
                }
                ++n2;
            }
            if (!recordersToMinimize.isEmpty()) {
                this.minimizedRecorderShells = recordersToMinimize.toArray(new Shell[0]);
                shellArray = this.minimizedRecorderShells;
                n = this.minimizedRecorderShells.length;
                n2 = 0;
                while (n2 < n) {
                    shell = shellArray[n2];
                    shell.setMinimized(true);
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            this.minimizedRecorderShells = null;
        }
    }

    private void restoreRecorderDialogs() {
        if (this.minimizedRecorderShells != null) {
            try {
                try {
                    Shell[] shellArray = this.minimizedRecorderShells;
                    int n = this.minimizedRecorderShells.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Shell shell = shellArray[n2];
                        if (!shell.isDisposed()) {
                            shell.setMinimized(false);
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    this.minimizedRecorderShells = null;
                }
            }
            finally {
                this.minimizedRecorderShells = null;
            }
        }
    }

    public int open() {
        this.minimizeRecorderDialogs();
        try {
            this.create();
            final Shell shell = this.getShell();
            if (shell != null && !shell.isDisposed()) {
                shell.open();
                shell.setActive();
                shell.forceActive();
                shell.forceFocus();
                final Display display = shell.getDisplay();
                final int[] attempts = new int[1];
                Runnable focusForcer = new Runnable(){

                    @Override
                    public void run() {
                        if (!shell.isDisposed() && attempts[0] < 10) {
                            shell.setActive();
                            shell.forceActive();
                            shell.forceFocus();
                            attempts[0] = attempts[0] + 1;
                            display.timerExec(100, (Runnable)this);
                        }
                    }
                };
                display.timerExec(50, focusForcer);
                while (!shell.isDisposed()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                int n = this.getReturnCode();
                return n;
            }
            int n = super.open();
            return n;
        }
        finally {
            this.restoreRecorderDialogs();
        }
    }
}

