/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.presentation.dialog;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.quickstart.BaseQuickStartDialog;
import com.kms.katalon.onboarding.core.application.controller.IKnowledgeController;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTour;
import com.kms.katalon.onboarding.core.domain.model.OnboardingTourItem;
import com.kms.katalon.onboarding.core.domain.repository.IKnowledgeRepository;
import jakarta.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

@Creatable
public class WelcomeDialog
extends BaseQuickStartDialog {
    private static final int DIALOG_WIDTH = 600;
    private static final int DIALOG_HEIGHT = 370;
    private static final int TOP_MARGIN = 10;
    private static final int CONTENT_MARGIN_TOP = 40;
    private static final int CONTENT_MARGIN_SIDE = 40;
    private static final int BUTTON_MARGIN_TOP = 15;
    private static final int BUTTON_MARGIN_BOTTOM = 25;
    private static final int BUTTON_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 50;
    private static final int BUTTON_SPACING = 20;
    private OnboardingTour tour;
    @Inject
    IKnowledgeController controller;
    @Inject
    IKnowledgeRepository knowledgeRepository;

    public WelcomeDialog() {
        super(ShellManager.getMainShell());
        this.setShellStyle(67696);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("");
        shell.setMinimumSize(600, 370);
        shell.setSize(600, 370);
        Rectangle displayBounds = Display.getCurrent().getPrimaryMonitor().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shell.setLocation((displayBounds.width - shellBounds.width) / 2, (displayBounds.height - shellBounds.height) / 2);
    }

    protected Point getInitialSize() {
        return new Point(600, 370);
    }

    public String getDialogTitle() {
        return "";
    }

    protected void createContent(Composite container) {
        Composite contentContainer = (Composite)ComponentBuilder.gridContainer((Composite)container).fillHorizontal().build();
        this.createDialogContent(contentContainer);
    }

    private void createDialogContent(Composite parent) {
        Composite contentContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().marginBottom(ComponentUtil.applyZoom((int)10)).build();
        ComponentBuilder.fromGrid((Composite)contentContainer).margin(40, 40, 0, 40).gridVerticalSpacing(8).fill().build();
        ComponentBuilder.label((Composite)contentContainer).text(OnboardingMessageConstants.WELCOME_DIALOG_TITLE).font(FontUtil.H2_BOLD).center().marginTop(10).textCenter().fillHorizontal().build();
        ComponentBuilder.label((Composite)contentContainer).text(OnboardingMessageConstants.WELCOME_DIALOG_SUBTITLE).center().fillHorizontal().textCenter().font(FontUtil.H4).build();
        ComponentBuilder.label((Composite)contentContainer).text(OnboardingMessageConstants.WELCOME_DIALOG_DESCRIPTION).center().fillHorizontal().textCenter().font(FontUtil.H4).build();
    }

    protected void createButtons(Composite parent) {
        Composite containerPanel = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)1).fill().margin(0).build();
        ComponentBuilder.label((Composite)containerPanel).text("").fillHorizontal().build();
        Composite buttonContainer = (Composite)ComponentBuilder.gridContainer((Composite)containerPanel, (int)1).margin(15, 40, 25, 40).center().build();
        Composite buttonBar = (Composite)ComponentBuilder.gridContainer((Composite)buttonContainer, (int)2).gridHorizontalSpacing(20).build();
        ComponentBuilder.canvas((Composite)buttonBar).text(OnboardingMessageConstants.WELCOME_DIALOG_CANCEL_BUTTON_TEXT).secondaryButton().activeBackground(ColorUtil.GRAY_LIGHT_COLOR).background(ColorUtil.WHITE_COLOR).color(ColorUtil.BLACK_COLOR).border(ColorUtil.GRAY_LIGHT_COLOR).borderWidth(1).borderRadius(8).autoSize(200, 50).center().onClick(event -> this.close()).build();
        ComponentBuilder.canvas((Composite)buttonBar).text(OnboardingMessageConstants.WELCOME_DIALOG_ACCEPT_BUTTON_TEXT).hoverBackground(ColorUtil.LILAC_BUTTON_COLOR_HOVER).background(ColorUtil.LILAC_BUTTON_COLOR).color(ColorUtil.WHITE_COLOR).borderWidth(1).borderRadius(8).autoSize(200, 50).center().onClick(event -> {
            this.tour = (OnboardingTour)this.knowledgeRepository.loadHub().getItemById(OnboardingTourItem.WEB_RECORDING_TOUR.getTourId());
            this.controller.startTour(this.tour);
            this.close();
        }).build();
    }

    public boolean close() {
        return super.close();
    }

    protected boolean isResizable() {
        return true;
    }

    protected boolean isClosable() {
        return true;
    }

    protected void initializeBounds() {
        this.getShell().setSize(600, 370);
        Shell shell = this.getShell();
        Rectangle displayBounds = Display.getCurrent().getPrimaryMonitor().getBounds();
        Rectangle shellBounds = shell.getBounds();
        shell.setLocation(displayBounds.x + (displayBounds.width - shellBounds.width) / 2, displayBounds.y + (displayBounds.height - shellBounds.height) / 2);
    }
}

