/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.onboarding.presentation.popover;

import com.kms.katalon.composer.components.impl.overlay.GuidingPopover;
import com.kms.katalon.composer.components.impl.overlay.HighlightOverlay;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.components.util.ShellManager;
import com.kms.katalon.composer.components.util.UITimeUtil;
import com.kms.katalon.onboarding.core.constants.OnboardingMessageConstants;
import com.kms.katalon.onboarding.domain.tour.NativeStepHandler;
import com.kms.katalon.onboarding.presentation.dialog.TourCancellationDialog;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class NativePopoverHandler {
    public static GuidingPopover stepInfoPopover;
    private static TourCancellationDialog activeCancellationDialog;

    static {
        activeCancellationDialog = null;
    }

    public static void run(final NativeStepHandler stepInfo) {
        if (stepInfo.beforeStep != null) {
            stepInfo.beforeStep.run();
        }
        if (stepInfo.mainScript != null) {
            stepInfo.mainScript.run();
            return;
        }
        Predicate<Object> waitForDialog = timer -> {
            AtomicBoolean result = new AtomicBoolean(false);
            UISynchronizeService.syncExec(() -> result.set(nativeStepHandler.dialogFinder.find((Timer)timer) != null));
            return result.get();
        };
        Predicate<Object> waitToStart = stepInfo.waitToStart != null ? stepInfo.waitToStart : waitForDialog;
        UITimeUtil.waitForWithTimeout(waitToStart, () -> UISynchronizeService.asyncExec(() -> {
            Shell stepDialog = nativeStepHandler.dialogFinder.find(null);
            if (nativeStepHandler.setupDialog != null) {
                nativeStepHandler.setupDialog.call(stepDialog);
            }
            UITimeUtil.waitForWithTimeout(timer -> {
                AtomicBoolean result = new AtomicBoolean(false);
                UISynchronizeService.syncExec(() -> result.set(nativeStepHandler.targetFinder.find(stepDialog) != null));
                return result.get();
            }, () -> UISynchronizeService.asyncExec(() -> {
                Widget target = nativeStepHandler.targetFinder.find(stepDialog);
                if (target instanceof CTabItem) {
                    Rectangle bounds = ((CTabItem)target).getBounds();
                    if (bounds.width == 0 || bounds.height == 0) {
                        stepInfo.error(new Exception(OnboardingMessageConstants.ERROR_TARGET_ELEMENT_HIDDEN));
                    }
                }
                HighlightOverlay stepOverlay = nativeStepHandler.overlay != null ? nativeStepHandler.overlay : new HighlightOverlay((Control)stepDialog);
                int alpha = 40;
                stepOverlay.setAlpha(alpha);
                stepOverlay.setBlockingUI(nativeStepHandler.blockingUI);
                stepOverlay.setIgnoreFocusRegion(nativeStepHandler.ignoreFocusRegion);
                stepOverlay.add(target, nativeStepHandler.highlightAreaProvider);
                if (nativeStepHandler.keepTarget) {
                    NativePopoverHandler.setupTargetDisposeListener(stepInfo, stepDialog, stepOverlay, target);
                }
                stepInfoPopover = new GuidingPopover((Shell)stepOverlay, nativeStepHandler.description, (Widget)(!ControlUtil.isDisposed((Widget)target) ? target : stepDialog), nativeStepHandler.position);
                stepInfoPopover.setMarginLeftXButton(nativeStepHandler.marginLeftXButton);
                stepInfoPopover.setPositionProvider(nativeStepHandler.guidingDialogPositionProvider);
                stepInfoPopover.setUseNextButton(nativeStepHandler.nextable);
                stepInfoPopover.setUseFinishButton(nativeStepHandler.useFinishButton);
                stepInfoPopover.setOnNextListener(nativeStepHandler.onNextListener);
                if (nativeStepHandler.iconPath != null && !nativeStepHandler.iconPath.isEmpty()) {
                    stepInfoPopover.setIconPath(nativeStepHandler.iconPath);
                }
                if (nativeStepHandler.needConfirmDialogWhenClose) {
                    stepInfoPopover.setBeforeClose(() -> {
                        ShellManager.getMainShell().forceActive();
                        int returnCode = NativePopoverHandler.showTourCancellationDialog();
                        stepInfoPopover.setReturnCode(returnCode);
                        if (returnCode == 0) {
                            stepInfo.resumeStep();
                        }
                        return returnCode != 0;
                    });
                } else {
                    stepInfoPopover.setBeforeClose(null);
                }
                if ((nativeStepHandler.triggerWhenClickTarget || nativeStepHandler.customClickHandler != null) && nativeStepHandler.onTargetInteractionObserver == null) {
                    if (target instanceof CTabItem) {
                        CTabFolder parent = ((CTabItem)target).getParent();
                        parent.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event) {
                                if (stepInfo.triggerWhenClickTarget) {
                                    if (stepInfo.isDisposed) {
                                        return;
                                    }
                                    DialogUtil.close((Shell)stepInfoPopover);
                                }
                            }
                        });
                    } else {
                        ComponentEventUtil.replaceClickAction((Widget)target, event -> {
                            if (nativeStepHandler.isDisposed) {
                                return;
                            }
                            if (event.detail == 4) {
                                event.doit = false;
                            }
                            if (nativeStepHandler.customClickHandler != null) {
                                nativeStepHandler.customClickHandler.handleEvent(event);
                            }
                            if (!event.doit) {
                                return;
                            }
                            if (nativeStepHandler.triggerWhenClickTarget) {
                                DialogUtil.close((Shell)stepInfoPopover);
                            }
                        });
                    }
                }
                stepInfoPopover.addDisposeListener(event -> {
                    if (nativeStepHandler.isDisposed) {
                        return;
                    }
                    stepOverlay.removeAll();
                    if (!nativeStepHandler.keepOverlay) {
                        DialogUtil.close((Shell)stepOverlay);
                    }
                    nativeStepHandler.overlay = stepOverlay;
                    if (nativeStepHandler.afterStep != null) {
                        nativeStepHandler.afterStep.run();
                    }
                    if (stepInfoPopover.getReturnCode() == 0) {
                        stepInfo.completeStep();
                        return;
                    }
                    stepInfo.exitStep();
                });
                ComponentEventUtil.onClick((Widget)stepOverlay, event -> {
                    if (nativeStepHandler.clickOverlayToClose) {
                        DialogUtil.close((Shell)stepInfoPopover);
                        DialogUtil.close((Shell)stepOverlay);
                    }
                    if (!stepInfoPopover.isDisposed()) {
                        stepInfoPopover.forceFocus();
                    }
                });
                if (stepOverlay != nativeStepHandler.parentOverlay) {
                    ComponentEventUtil.onClick((Widget)nativeStepHandler.parentOverlay, event -> {
                        if (!stepInfoPopover.isDisposed()) {
                            stepOverlay.highlight();
                            stepInfoPopover.getParent().getShell().forceActive();
                            stepInfoPopover.forceActive();
                        }
                    });
                }
                stepInfoPopover.open();
                if (!stepOverlay.isVisible()) {
                    stepOverlay.open();
                }
                if (nativeStepHandler.onTargetInteractionObserver != null) {
                    nativeStepHandler.onTargetInteractionObserver.run();
                }
            }), () -> UISynchronizeService.asyncExec(() -> stepInfo.error(new Exception(MessageFormat.format(OnboardingMessageConstants.ERROR_TIMEOUT_COULD_NOT_FIND_FORMAT, OnboardingMessageConstants.ERROR_TIMEOUT_TARGET_WIDGET, TimeUnit.MILLISECONDS.toSeconds(nativeStepHandler.findElementTimeoutMs))))), (long)nativeStepHandler.findElementTimeoutMs, (long)300L);
        }), () -> UISynchronizeService.asyncExec(() -> stepInfo.error(new Exception(MessageFormat.format(OnboardingMessageConstants.ERROR_TIMEOUT_COULD_NOT_FIND_FORMAT, OnboardingMessageConstants.ERROR_TIMEOUT_DIALOG, TimeUnit.MILLISECONDS.toSeconds(nativeStepHandler.findElementTimeoutMs))))), (long)stepInfo.findElementTimeoutMs, (long)300L);
    }

    public static void cleanup() {
        NativePopoverHandler.cleanup(null);
    }

    public static void cleanup(NativeStepHandler stepInfo) {
        if (stepInfo != null) {
            NativePopoverHandler.cleanupTargetListener(stepInfo);
        }
        DialogUtil.close((Shell)stepInfoPopover);
    }

    private static void cleanupTargetListener(NativeStepHandler stepInfo) {
        if (stepInfo.targetDisposeListener == null) {
            return;
        }
        Widget trackedWidget = stepInfo.trackedTarget;
        if (trackedWidget != null && !trackedWidget.isDisposed()) {
            trackedWidget.removeListener(12, stepInfo.targetDisposeListener);
        }
        stepInfo.targetDisposeListener = null;
        stepInfo.trackedTarget = null;
    }

    private static int showTourCancellationDialog() {
        if (activeCancellationDialog != null && !activeCancellationDialog.getShell().isDisposed()) {
            activeCancellationDialog.getShell().forceActive();
            return 0;
        }
        activeCancellationDialog = new TourCancellationDialog();
        int returnCode = activeCancellationDialog.open();
        activeCancellationDialog = null;
        return returnCode;
    }

    private static void setupTargetDisposeListener(NativeStepHandler stepInfo, Shell stepDialog, HighlightOverlay stepOverlay, Widget target) {
        if (stepInfo.targetDisposeListener != null) {
            NativePopoverHandler.cleanupTargetListener(stepInfo);
        }
        stepInfo.trackedTarget = target;
        stepInfo.targetDisposeListener = event -> {
            if (nativeStepHandler.isDisposed) {
                return;
            }
            UISynchronizeService.asyncExec(() -> {
                if (nativeStepHandler.isDisposed) {
                    return;
                }
                UITimeUtil.waitForWithTimeout(timer -> {
                    if (nativeStepHandler.isDisposed) {
                        return false;
                    }
                    AtomicBoolean result = new AtomicBoolean(false);
                    UISynchronizeService.syncExec(() -> result.set(nativeStepHandler.targetFinder.find(stepDialog) != null));
                    return result.get();
                }, () -> UISynchronizeService.asyncExec(() -> {
                    if (nativeStepHandler.isDisposed) {
                        return;
                    }
                    Widget newTarget = nativeStepHandler.targetFinder.find(stepDialog);
                    if (newTarget != null && !newTarget.isDisposed()) {
                        NativePopoverHandler.cleanupTargetListener(stepInfo);
                        stepOverlay.removeAll();
                        stepOverlay.add(newTarget, nativeStepHandler.highlightAreaProvider);
                        nativeStepHandler.trackedTarget = newTarget;
                        newTarget.addListener(12, nativeStepHandler.targetDisposeListener);
                        if (stepOverlay.isVisible()) {
                            stepOverlay.redraw();
                        }
                    }
                }), () -> UISynchronizeService.asyncExec(() -> stepInfo.error(new Exception(MessageFormat.format(OnboardingMessageConstants.ERROR_TIMEOUT_COULD_NOT_FIND_FORMAT, OnboardingMessageConstants.ERROR_TIMEOUT_TARGET_WIDGET, TimeUnit.MILLISECONDS.toSeconds(nativeStepHandler.findElementTimeoutMs))))), (long)nativeStepHandler.findElementTimeoutMs, (long)300L);
            });
        };
        target.addListener(12, stepInfo.targetDisposeListener);
    }
}

