/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java;

import io.cucumber.eclipse.java.Activator;
import io.cucumber.eclipse.java.plugins.CucumberCodeLocation;
import io.cucumber.eclipse.java.steps.JavaStepDefinitionsProvider;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.RGB;

public class JDTUtil {
    public static IJavaProject getJavaProject(String projectName) {
        if (projectName == null || projectName.length() < 1) {
            return null;
        }
        return JDTUtil.getJavaModel().getJavaProject(projectName);
    }

    public static IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)JDTUtil.getWorkspaceRoot());
    }

    public static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public static IJavaProject getJavaProject(IDocument document) throws CoreException {
        IPath location;
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(document);
        if (buffer != null && (location = buffer.getLocation()) != null) {
            return JDTUtil.getJavaProject((IResource)ResourcesPlugin.getWorkspace().getRoot().getFile(location));
        }
        return null;
    }

    public static IJavaProject getJavaProject(IResource resource) throws CoreException {
        IProject project;
        if (resource != null && JDTUtil.isJavaProject(project = resource.getProject())) {
            return JavaCore.create((IProject)project);
        }
        return null;
    }

    public static boolean isJavaProject(IProject project) {
        try {
            return project != null && project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            return false;
        }
    }

    public static URLClassLoader createClassloader(IJavaProject javaProject) throws CoreException {
        return JDTUtil.createClassloader(javaProject, JDTUtil.class.getClassLoader());
    }

    public static URLClassLoader createClassloader(IJavaProject javaProject, ClassLoader parent) throws CoreException {
        String[] classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        ArrayList<URL> urlList = new ArrayList<URL>();
        String[] stringArray = classPathEntries;
        int n = classPathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            try {
                if (entry.startsWith("file:/")) {
                    urlList.add(new URL(entry));
                } else {
                    urlList.add(new File(entry).toURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                Activator.getDefault().getLog().error("can't add classpathentry " + entry + " for project " + javaProject.getProject().getName(), (Throwable)e);
            }
            ++n2;
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        return new URLClassLoader(urls, (ClassLoader)new FilteringClassLoader(parent));
    }

    public static IMethod[] resolveMethod(IJavaProject project, CucumberCodeLocation codeLocation, IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)codeLocation.toString(), (int)100);
        String typeName = codeLocation.getTypeName();
        if (typeName.isBlank()) {
            return new IMethod[0];
        }
        return JDTUtil.resolveTypeMethod(project.findType(typeName, (IProgressMonitor)subMonitor.split(10)), codeLocation, (IProgressMonitor)subMonitor.split(90));
    }

    public static IMethod[] resolveTypeMethod(IType type, CucumberCodeLocation codeLocation, IProgressMonitor monitor) throws JavaModelException {
        if (type != null) {
            String methodName = codeLocation.getMethodName();
            if (methodName.isBlank()) {
                return null;
            }
            IMethod[] candidates = (IMethod[])Arrays.stream(type.getMethods()).filter(method -> method.getElementName().equals(methodName)).toArray(IMethod[]::new);
            if (candidates.length > 1) {
                String[] parameter = codeLocation.getParameter();
                return (IMethod[])Arrays.stream(candidates).filter(method -> method.getNumberOfParameters() == parameter.length).filter(method -> {
                    try {
                        String[] resolvedMethodParameterNames = JDTUtil.resolveMethodParameterNames(method);
                        int i = 0;
                        while (true) {
                            if (i >= parameter.length) {
                                return true;
                            }
                            if (!resolvedMethodParameterNames[i].equals(parameter[i])) {
                                return false;
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException e) {
                        return false;
                    }
                }).toArray(IMethod[]::new);
            }
            return candidates;
        }
        return new IMethod[0];
    }

    public static String[] resolveMethodParameterNames(IMethod method) throws JavaModelException {
        ILocalVariable[] parameters = method.getParameters();
        String[] strings = new String[parameters.length];
        IType declaringType = method.getDeclaringType();
        int i = 0;
        while (i < strings.length) {
            ILocalVariable v = parameters[i];
            String name = v.getTypeSignature();
            String simpleName = Signature.getSignatureSimpleName((String)name);
            String[][] resolved = JDTUtil.resolveTypeWithRetry(declaringType, simpleName);
            strings[i] = resolved != null ? Signature.toQualifiedName((String[])resolved[0]) : simpleName;
            ++i;
        }
        return strings;
    }

    public static String[][] resolveTypeWithRetry(IType type, String simpleName) throws JavaModelException {
        if (type == null) {
            return null;
        }
        return JDTUtil.bug571150(type, simpleName, Runtime.getRuntime().availableProcessors());
    }

    private static String[][] bug571150(IType type, String simpleName, int retries) throws JavaModelException {
        try {
            return type.resolveType(simpleName);
        }
        catch (ConcurrentModificationException e) {
            if (retries <= 0) {
                return null;
            }
            Thread.yield();
            return JDTUtil.bug571150(type, simpleName, retries - 1);
        }
    }

    public static String getMethodName(IMethod method) throws JavaModelException {
        StringBuilder name = new StringBuilder();
        name.append(method.getDeclaringType().getElementName());
        name.append('.');
        name.append(method.getElementName());
        name.append("(");
        String.join((CharSequence)",", (CharSequence[])Arrays.stream(method.getParameterTypes()).map(Signature::toString).toArray(String[]::new));
        name.append(")");
        return name.toString();
    }

    public static String getJavadoc(IMethod method) {
        try {
            String content = JavadocContentAccess2.getHTMLContent((IJavaElement)method, (boolean)true);
            if (content != null) {
                StringBuilder buffer = new StringBuilder(content);
                ColorRegistry registry = JFaceResources.getColorRegistry();
                RGB fgRGB = registry.getRGB("org.eclipse.jdt.ui.Javadoc.foregroundColor");
                RGB bgRGB = registry.getRGB("org.eclipse.jdt.ui.Javadoc.backgroundColor");
                HTMLPrinter.insertPageProlog((StringBuilder)buffer, (int)0, (RGB)fgRGB, (RGB)bgRGB, (String)"");
                HTMLPrinter.addPageEpilog((StringBuilder)buffer);
                return buffer.toString();
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static Collection<ICompilationUnit> getGlueSources(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        if (javaProject == null) {
            return Collections.emptyList();
        }
        ArrayList<ICompilationUnit> units = new ArrayList<ICompilationUnit>();
        JDTUtil.findGlueSources(javaProject, units, new HashSet<String>(), monitor);
        return units;
    }

    private static void findGlueSources(IJavaProject javaProject, List<ICompilationUnit> units, Set<String> analyzedProjects, IProgressMonitor monitor) throws CoreException {
        IJavaProject[] references;
        IPackageFragment[] fragments = javaProject.getPackageFragments();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(units.size() * 100 + fragments.length * 100));
        IPackageFragment[] iPackageFragmentArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment fragment = iPackageFragmentArray[n2];
            ICompilationUnit[] compilationUnits = fragment.getCompilationUnits();
            SubMonitor subSub = subMonitor.split(100);
            subSub.setWorkRemaining(compilationUnits.length);
            ICompilationUnit[] iCompilationUnitArray = compilationUnits;
            int n3 = compilationUnits.length;
            int n4 = 0;
            while (n4 < n3) {
                ICompilationUnit unit = iCompilationUnitArray[n4];
                if (JDTUtil.hasCucumberGlueAnnotation(unit, (IProgressMonitor)subSub.split(1))) {
                    units.add(unit);
                }
                ++n4;
            }
            ++n2;
        }
        IJavaProject[] iJavaProjectArray = references = (IJavaProject[])Arrays.stream(javaProject.getProject().getReferencedProjects()).map(project -> {
            if (analyzedProjects.add(project.getName())) {
                try {
                    return JDTUtil.getJavaProject((IResource)project);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return null;
        }).filter(Objects::nonNull).toArray(IJavaProject[]::new);
        int n5 = references.length;
        n = 0;
        while (n < n5) {
            IJavaProject reference = iJavaProjectArray[n];
            JDTUtil.findGlueSources(reference, units, analyzedProjects, (IProgressMonitor)subMonitor.split(100));
            ++n;
        }
    }

    public static boolean hasCucumberGlueAnnotation(ICompilationUnit compilationUnit, IProgressMonitor monitor) throws JavaModelException {
        IImportDeclaration[] allimports;
        IImportDeclaration[] iImportDeclarationArray = allimports = compilationUnit.getImports();
        int n = allimports.length;
        int n2 = 0;
        while (n2 < n) {
            IImportDeclaration decl = iImportDeclarationArray[n2];
            Matcher m = JavaStepDefinitionsProvider.ioCucumberAnnotationMatcher.matcher(decl.getElementName());
            if (m.find()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static final class FilteringClassLoader
    extends ClassLoader {
        public FilteringClassLoader(ClassLoader parent) {
            super("FilteringClassLoader", parent);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            Spliterator<URL> spliterator = Spliterators.spliteratorUnknownSize(super.getResources(name).asIterator(), 16);
            return Collections.enumeration(StreamSupport.stream(spliterator, false).map(url -> {
                boolean equals = url.getProtocol().equals("bundleresource");
                if (equals) {
                    String host = url.getHost();
                    int indexOf = host.indexOf(46);
                    if (indexOf > 0) {
                        try {
                            long id = Long.parseLong(host.substring(0, indexOf));
                            if (id == Activator.getDefault().getBundle().getBundleId()) {
                                return null;
                            }
                        }
                        catch (Exception id) {
                            // empty catch block
                        }
                        try {
                            URL fileURL = FileLocator.toFileURL((URL)url);
                            if (fileURL.getProtocol().equals("file")) {
                                return fileURL;
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
                return url;
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
    }
}

