/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.validation;

import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.java.plugins.CucumberStepDefinition;
import io.cucumber.eclipse.java.plugins.MatchedStep;
import io.cucumber.eclipse.java.validation.GlueJob;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;

public class CucumberGlueValidator
implements IDocumentSetupParticipant {
    private static ConcurrentMap<IDocument, GlueJob> jobMap = new ConcurrentHashMap<IDocument, GlueJob>();

    static {
        FileBuffers.getTextFileBufferManager().addFileBufferListener(new IFileBufferListener(){

            public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
            }

            public void underlyingFileDeleted(IFileBuffer buffer) {
            }

            public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
            }

            public void stateChanging(IFileBuffer buffer) {
            }

            public void stateChangeFailed(IFileBuffer buffer) {
            }

            public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            }

            public void bufferDisposed(IFileBuffer buffer) {
                IDocument document;
                GlueJob remove;
                if (buffer instanceof ITextFileBuffer && (remove = (GlueJob)((Object)jobMap.remove(document = ((ITextFileBuffer)buffer).getDocument()))) != null) {
                    remove.cancel();
                    remove.disposeListener();
                }
            }

            public void bufferCreated(IFileBuffer buffer) {
            }

            public void bufferContentReplaced(IFileBuffer buffer) {
            }

            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
            }
        });
    }

    public static void revalidate(IDocument document) {
        CucumberGlueValidator.validate(document, 0);
    }

    public void setup(final IDocument document) {
        document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                CucumberGlueValidator.validate(document, 1000);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        CucumberGlueValidator.validate(document, 0);
    }

    private static void validate(IDocument document, int delay) {
        jobMap.compute(document, (key, oldJob) -> {
            if (oldJob != null) {
                oldJob.cancel();
                oldJob.disposeListener();
            }
            GlueJob verificationJob = new GlueJob((GlueJob)((Object)oldJob), () -> GherkinEditorDocument.get((IDocument)document));
            verificationJob.setUser(false);
            verificationJob.setPriority(50);
            if (delay > 0) {
                verificationJob.schedule(delay);
            } else {
                verificationJob.schedule();
            }
            return verificationJob;
        });
    }

    public static Job validate(final GherkinEditorDocument editorDocument) {
        return jobMap.compute(editorDocument.getDocument(), (key, oldJob) -> {
            if (oldJob != null) {
                oldJob.cancel();
                oldJob.disposeListener();
            }
            final GlueJob verificationJob = new GlueJob((GlueJob)((Object)oldJob), () -> editorDocument);
            verificationJob.addJobChangeListener(new IJobChangeListener(){

                public void sleeping(IJobChangeEvent event) {
                }

                public void scheduled(IJobChangeEvent event) {
                }

                public void running(IJobChangeEvent event) {
                }

                public void done(IJobChangeEvent event) {
                    jobMap.compute(editorDocument.getDocument(), (key, currentJob) -> {
                        if (currentJob == verificationJob && GherkinEditorDocument.get((IDocument)editorDocument.getDocument()) == null) {
                            return null;
                        }
                        return currentJob;
                    });
                }

                public void awake(IJobChangeEvent event) {
                }

                public void aboutToRun(IJobChangeEvent event) {
                }
            });
            verificationJob.setUser(false);
            verificationJob.setPriority(50);
            verificationJob.schedule();
            return verificationJob;
        });
    }

    private static GlueJob sync(IDocument document, IProgressMonitor monitor) throws OperationCanceledException, InterruptedException {
        GlueJob glueJob = (GlueJob)((Object)jobMap.get(document));
        if (glueJob != null) {
            glueJob.join(TimeUnit.SECONDS.toMillis(30L), monitor);
        }
        return glueJob;
    }

    public static Collection<MatchedStep<?>> getMatchedSteps(IDocument document, IProgressMonitor monitor) throws OperationCanceledException, InterruptedException {
        GlueJob job;
        if (document != null && (job = CucumberGlueValidator.sync(document, monitor)) != null) {
            return job.matchedSteps;
        }
        return Collections.emptyList();
    }

    public static Collection<CucumberStepDefinition> getAvaiableSteps(IDocument document, IProgressMonitor monitor) throws OperationCanceledException, InterruptedException {
        GlueJob job;
        if (document != null && (job = CucumberGlueValidator.sync(document, monitor)) != null) {
            return job.parsedSteps;
        }
        return Collections.emptyList();
    }
}

