/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.java.validation;

import io.cucumber.core.eventbus.IncrementingUuidGenerator;
import io.cucumber.core.eventbus.UuidGenerator;
import io.cucumber.core.feature.GluePath;
import io.cucumber.core.gherkin.FeatureParserException;
import io.cucumber.core.options.RuntimeOptionsBuilder;
import io.cucumber.eclipse.editor.Tracing;
import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.eclipse.editor.marker.MarkerFactory;
import io.cucumber.eclipse.java.JDTUtil;
import io.cucumber.eclipse.java.plugins.CucumberMatchedStepsPlugin;
import io.cucumber.eclipse.java.plugins.CucumberMissingStepsPlugin;
import io.cucumber.eclipse.java.plugins.CucumberStepDefinition;
import io.cucumber.eclipse.java.plugins.CucumberStepParserPlugin;
import io.cucumber.eclipse.java.plugins.MatchedStep;
import io.cucumber.eclipse.java.preferences.CucumberJavaPreferences;
import io.cucumber.eclipse.java.runtime.CucumberRuntime;
import io.cucumber.plugin.Plugin;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.service.debug.DebugTrace;

final class GlueJob
extends Job {
    private GlueJob oldJob;
    private Runnable listenerRegistration;
    volatile Collection<MatchedStep<?>> matchedSteps;
    volatile Collection<CucumberStepDefinition> parsedSteps;
    private Supplier<GherkinEditorDocument> documentSupplier;

    GlueJob(GlueJob oldJob, Supplier<GherkinEditorDocument> documentSupplier) {
        super("Verify Cucumber Glue Code");
        this.oldJob = oldJob;
        this.documentSupplier = documentSupplier;
        if (oldJob != null) {
            this.matchedSteps = oldJob.matchedSteps;
            this.parsedSteps = oldJob.parsedSteps;
        } else {
            this.matchedSteps = Collections.emptySet();
            this.parsedSteps = Collections.emptySet();
        }
    }

    protected void canceling() {
        this.disposeListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeListener() {
        GlueJob glueJob = this;
        synchronized (glueJob) {
            if (this.listenerRegistration != null) {
                this.listenerRegistration.run();
                this.listenerRegistration = () -> {};
            }
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        block22: {
            GherkinEditorDocument editorDocument;
            if (this.oldJob != null) {
                try {
                    this.oldJob.join();
                    this.oldJob = null;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return Status.CANCEL_STATUS;
                }
            }
            if ((editorDocument = this.documentSupplier.get()) != null) {
                try {
                    IResource resource = editorDocument.getResource();
                    IJavaProject javaProject = JDTUtil.getJavaProject(resource);
                    if (javaProject == null) break block22;
                    long start = System.currentTimeMillis();
                    DebugTrace debug = Tracing.get();
                    debug.traceEntry("/perf/steps", (Object)resource);
                    CucumberJavaPreferences projectProperties = this.getProperties(editorDocument);
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (CucumberRuntime rt = CucumberRuntime.create(javaProject);){
                        rt.setGenerator((UuidGenerator)new IncrementingUuidGenerator());
                        RuntimeOptionsBuilder runtimeOptions = rt.getRuntimeOptions();
                        runtimeOptions.setDryRun();
                        try {
                            rt.addFeature(editorDocument);
                        }
                        catch (FeatureParserException e) {
                            if (rt != null) {
                                rt.close();
                            }
                            return Status.CANCEL_STATUS;
                        }
                        GlueJob.addGlueOptions(runtimeOptions, projectProperties);
                        CucumberMissingStepsPlugin missingStepsPlugin = new CucumberMissingStepsPlugin();
                        CucumberStepParserPlugin stepParserPlugin = new CucumberStepParserPlugin();
                        CucumberMatchedStepsPlugin matchedStepsPlugin = new CucumberMatchedStepsPlugin();
                        rt.addPlugin(stepParserPlugin);
                        rt.addPlugin(matchedStepsPlugin);
                        rt.addPlugin(missingStepsPlugin);
                        Collection<Plugin> validationPlugins = GlueJob.addValidationPlugins(editorDocument, rt, projectProperties);
                        try {
                            rt.run(monitor);
                            HashMap<Integer, String> validationErrors = new HashMap<Integer, String>();
                            for (Plugin plugin : validationPlugins) {
                                GlueJob.addErrors(plugin, validationErrors);
                            }
                            Map<Integer, Collection<String>> snippets = missingStepsPlugin.getSnippets();
                            MarkerFactory.validationErrorOnStepDefinition((IResource)resource, validationErrors, (boolean)false);
                            MarkerFactory.missingSteps((IResource)resource, snippets, (String)"io.cucumber.eclipse.java", (boolean)false);
                            Collection<CucumberStepDefinition> steps = stepParserPlugin.getStepList();
                            this.matchedSteps = Collections.unmodifiableCollection(matchedStepsPlugin.getMatchedSteps());
                            this.parsedSteps = Collections.unmodifiableCollection(stepParserPlugin.getStepList());
                            debug.traceExit("/perf/steps", (Object)(this.matchedSteps.size() + " step(s) /  " + steps.size() + " step(s)  matched, " + snippets.size() + " snippet(s) where suggested || total run time " + (System.currentTimeMillis() - start) + "ms)"));
                        }
                        catch (Throwable e) {
                            ILog.get().error("Validate Glue-Code failed", e);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        }
        return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
    }

    private static Collection<Plugin> addValidationPlugins(GherkinEditorDocument editorDocument, CucumberRuntime rt, CucumberJavaPreferences projectProperties) {
        ArrayList<Plugin> validationPlugins = new ArrayList<Plugin>();
        IDocument doc = editorDocument.getDocument();
        int lines = doc.getNumberOfLines();
        LinkedHashSet<String> plugins = new LinkedHashSet<String>();
        int i = 0;
        while (i < lines) {
            try {
                String[] split;
                IRegion firstLine = doc.getLineInformation(i);
                String line = doc.get(firstLine.getOffset(), firstLine.getLength()).trim();
                if (line.startsWith("#") && (split = line.split("validation-plugin:", 2)).length == 2) {
                    plugins.add(split[1].trim());
                }
            }
            catch (BadLocationException firstLine) {
                // empty catch block
            }
            ++i;
        }
        projectProperties.plugins().forEach(plugins::add);
        for (String plugin : plugins) {
            Plugin classpathPlugin = rt.addPluginFromClasspath(plugin);
            if (classpathPlugin == null) continue;
            validationPlugins.add(classpathPlugin);
        }
        return validationPlugins;
    }

    private static void addErrors(Plugin plugin, Map<Integer, String> validationErrors) {
        try {
            Method method = plugin.getClass().getMethod("getValidationErrors", new Class[0]);
            Object invoke = method.invoke((Object)plugin, new Object[0]);
            if (invoke instanceof Map) {
                Map map = (Map)invoke;
                validationErrors.putAll(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CucumberJavaPreferences getProperties(GherkinEditorDocument editorDocument) {
        IResource resource = editorDocument.getResource();
        CucumberJavaPreferences projectProperties = CucumberJavaPreferences.of(resource);
        if (resource != null) {
            GlueJob glueJob = this;
            synchronized (glueJob) {
                if (this.listenerRegistration == null) {
                    IPreferenceStore store;
                    IEclipsePreferences node = projectProperties.node();
                    ArrayList<Runnable> list = new ArrayList<Runnable>();
                    if (node != null) {
                        IEclipsePreferences.IPreferenceChangeListener listener = new IEclipsePreferences.IPreferenceChangeListener(){

                            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                                GlueJob.this.schedule();
                            }
                        };
                        node.addPreferenceChangeListener(listener);
                        list.add(() -> node.removePreferenceChangeListener(listener));
                    }
                    if ((store = projectProperties.store()) != null) {
                        IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

                            public void propertyChange(PropertyChangeEvent event) {
                                GlueJob.this.schedule();
                            }
                        };
                        store.addPropertyChangeListener(propertyChangeListener);
                    }
                    this.listenerRegistration = () -> list.forEach(Runnable::run);
                }
            }
        }
        return projectProperties;
    }

    private static void addGlueOptions(RuntimeOptionsBuilder runtimeOptions, CucumberJavaPreferences projectProperties) {
        projectProperties.glueFilter().forEach(gluePath -> {
            if ((gluePath = gluePath.trim()).endsWith("*")) {
                gluePath = gluePath.substring(0, gluePath.length() - 1);
            }
            if (gluePath.endsWith("/")) {
                gluePath = gluePath.substring(0, gluePath.length() - 1);
            }
            if (gluePath.endsWith(".")) {
                gluePath = gluePath.substring(0, gluePath.length() - 1);
            }
            try {
                runtimeOptions.addGlue(GluePath.parse((String)gluePath));
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        });
    }
}

