/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.testcase.ast.dialogs.IAstDialogBuilder;
import com.kms.katalon.composer.testcase.ast.treetable.AstTreeTableNode;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.editors.TypeSelectionDialogCellEditor;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ParameterWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ClosureExpressionWrapper;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.ITestCasePart;
import com.kms.katalon.composer.testcase.parts.TestStepManualComposite;
import com.kms.katalon.composer.testcase.util.AstKeywordsInputUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class ClosureBuilderDialog
extends Dialog
implements IAstDialogBuilder,
ITestCasePart {
    private static final String NEW_PARAM_DEFAULT_NAME = "param";
    private ClosureBuilderDialog _instance;
    private TableViewer paramTableViewer;
    private TestStepManualComposite testStepManualComposite;
    private List<ParameterWrapper> parameterList = new ArrayList<ParameterWrapper>();
    private ClosureExpressionWrapper tempClosure = null;

    public ClosureBuilderDialog(Shell parentShell, ClosureExpressionWrapper closureExpressionWrapper, ASTNodeWrapper parent) {
        super(parentShell);
        this.initData(closureExpressionWrapper, parent);
        this._instance = this;
    }

    protected void initData(ClosureExpressionWrapper closureExpressionWrapper, ASTNodeWrapper parent) {
        this.tempClosure = closureExpressionWrapper.clone();
        ParameterWrapper[] parameterWrapperArray = closureExpressionWrapper.getParameters();
        int n = parameterWrapperArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParameterWrapper parameter = parameterWrapperArray[n2];
            this.parameterList.add(parameter);
            ++n2;
        }
    }

    @Override
    public TestCaseTreeTableInput getTreeTableInput() {
        return this.testStepManualComposite.getTreeTableInput();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite paramComposite = new Composite(container, 0);
        paramComposite.setLayout((Layout)new GridLayout(2, false));
        paramComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.createParamTableComposite(paramComposite);
        this.createParamButtonComposite(paramComposite);
        this.refreshParamTable();
        Composite childComposite = new Composite(container, 0);
        childComposite.setLayout((Layout)new GridLayout(1, false));
        childComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.testStepManualComposite = TestStepManualComposite.newInstance(this, childComposite);
        ScriptNodeWrapper scriptNodeWrapper = new ScriptNodeWrapper();
        scriptNodeWrapper.setMainBlock(this.tempClosure.getBlock());
        this.testStepManualComposite.loadASTNodesToTreeTable(scriptNodeWrapper);
        return container;
    }

    private void createParamButtonComposite(Composite paramComposite) {
        Composite paramButtonComposite = new Composite(paramComposite, 0);
        paramButtonComposite.setLayout((Layout)new GridLayout());
        paramButtonComposite.setLayoutData((Object)new GridData(4, 131072, false, false, 1, 1));
        new Label(paramButtonComposite, 0);
        this.createParamInsertButton(paramButtonComposite);
        this.createParamRemoveButton(paramButtonComposite);
        this.createParamMoveUpButton(paramButtonComposite);
        this.createParamMoveDownButton(paramButtonComposite);
    }

    protected Class<?> getClassFromIType(IType type) {
        return AstKeywordsInputUtil.loadType(type.getFullyQualifiedName(), this.tempClosure.getScriptClass());
    }

    protected void createParamTableComposite(Composite container) {
        Composite tableComposite = new Composite(container, 0);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tableComposite.setLayout((Layout)new GridLayout());
        Label paramLabel = new Label(tableComposite, 0);
        paramLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        paramLabel.setText(ComposerTestcaseMessageConstants.LABEL_PARAMETER_LIST);
        this.paramTableViewer = new TableViewer(tableComposite, 67586);
        Table table = this.paramTableViewer.getTable();
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        gridData.heightHint = 50;
        table.setLayoutData((Object)gridData);
        table.setLinesVisible(ControlUtils.shouldLineVisble((Display)table.getDisplay()));
        table.setHeaderVisible(true);
        ColumnViewerUtil.setTableActivation((TableViewer)this.paramTableViewer);
        this.addTableColumnParamType();
        this.addTableColumnParamName();
    }

    private void addTableColumnParamName() {
        TableViewerColumn tableViewerColumnParamName = new TableViewerColumn(this.paramTableViewer, 0);
        tableViewerColumnParamName.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_PARAM_NAME);
        tableViewerColumnParamName.getColumn().setWidth(365);
        tableViewerColumnParamName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ParameterWrapper) {
                    ParameterWrapper parameter = (ParameterWrapper)element;
                    return parameter.getName();
                }
                return "";
            }
        });
        tableViewerColumnParamName.setEditingSupport(new EditingSupport((ColumnViewer)this.paramTableViewer){

            protected void setValue(Object element, Object value) {
                if (!(element instanceof ParameterWrapper) || !(value instanceof String)) {
                    return;
                }
                ParameterWrapper oldParameterWrapper = (ParameterWrapper)element;
                int parameterIndex = ClosureBuilderDialog.this.parameterList.indexOf(oldParameterWrapper);
                if (parameterIndex >= 0 && parameterIndex < ClosureBuilderDialog.this.parameterList.size()) {
                    ClosureBuilderDialog.this.parameterList.set(parameterIndex, new ParameterWrapper(oldParameterWrapper.getType().getTypeClass(), (String)value, ClosureBuilderDialog.this.tempClosure));
                    ClosureBuilderDialog.this.refreshParamTable();
                }
            }

            protected Object getValue(Object element) {
                if (element instanceof ParameterWrapper) {
                    return ((ParameterWrapper)element).getName();
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)ClosureBuilderDialog.this.paramTableViewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return element instanceof ParameterWrapper;
            }
        });
    }

    private void addTableColumnParamType() {
        TableViewerColumn tableViewerColumnParamType = new TableViewerColumn(this.paramTableViewer, 0);
        tableViewerColumnParamType.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_PARAM_TYPE);
        tableViewerColumnParamType.getColumn().setWidth(365);
        tableViewerColumnParamType.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ParameterWrapper) {
                    ParameterWrapper parameter = (ParameterWrapper)element;
                    return parameter.getType().getName();
                }
                return "";
            }
        });
        tableViewerColumnParamType.setEditingSupport(new EditingSupport((ColumnViewer)this.paramTableViewer){

            protected void setValue(Object element, Object value) {
                if (!(element instanceof ParameterWrapper) || !(value instanceof IType)) {
                    return;
                }
                ParameterWrapper oldParameterWrapper = (ParameterWrapper)element;
                Class<?> newClass = ClosureBuilderDialog.this.getClassFromIType((IType)value);
                int parameterIndex = ClosureBuilderDialog.this.parameterList.indexOf(oldParameterWrapper);
                if (parameterIndex < 0 || parameterIndex >= ClosureBuilderDialog.this.parameterList.size() || newClass == null) {
                    return;
                }
                ClosureBuilderDialog.this.parameterList.set(parameterIndex, new ParameterWrapper(newClass, oldParameterWrapper.getName(), ClosureBuilderDialog.this.tempClosure));
                ClosureBuilderDialog.this.refreshParamTable();
            }

            protected Object getValue(Object element) {
                if (element instanceof ParameterWrapper) {
                    return ((ParameterWrapper)element).getType().getName();
                }
                return "";
            }

            protected CellEditor getCellEditor(Object element) {
                if (element instanceof ParameterWrapper) {
                    return new TypeSelectionDialogCellEditor((Composite)ClosureBuilderDialog.this.paramTableViewer.getTable(), ((ParameterWrapper)element).getType().getName());
                }
                return null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof ParameterWrapper;
            }
        });
    }

    public void refreshParamTable() {
        this.paramTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.paramTableViewer.setInput(this.parameterList);
        this.paramTableViewer.refresh();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createOKButton(parent);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createOKButton(Composite parent) {
        Button btnOK = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        btnOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClosureBuilderDialog.this._instance.close();
            }
        });
    }

    private void createParamRemoveButton(Composite parent) {
        Button btnRemove = new Button(parent, 8);
        btnRemove.setText(GlobalMessageConstants.DELETE);
        this.setButtonLayoutData(btnRemove);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] nArray = ClosureBuilderDialog.this.paramTableViewer.getTable().getSelectionIndices();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    if (index >= 0 && index < ClosureBuilderDialog.this.parameterList.size()) {
                        ClosureBuilderDialog.this.parameterList.remove(index);
                    }
                    ++n2;
                }
                ClosureBuilderDialog.this.paramTableViewer.refresh();
            }
        });
    }

    private void createParamInsertButton(Composite parent) {
        Button btnInsert = new Button(parent, 8);
        btnInsert.setText(GlobalMessageConstants.INSERT);
        this.setButtonLayoutData(btnInsert);
        btnInsert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ClosureBuilderDialog.this.paramTableViewer.getTable().getSelectionIndex();
                ParameterWrapper parameter = new ParameterWrapper(Object.class, ClosureBuilderDialog.NEW_PARAM_DEFAULT_NAME, ClosureBuilderDialog.this.tempClosure);
                if (selectionIndex < 0 || selectionIndex >= ClosureBuilderDialog.this.parameterList.size()) {
                    ClosureBuilderDialog.this.parameterList.add(parameter);
                } else {
                    ClosureBuilderDialog.this.parameterList.add(selectionIndex + 1, parameter);
                }
                ClosureBuilderDialog.this.paramTableViewer.refresh();
                ClosureBuilderDialog.this.paramTableViewer.getTable().setSelection(selectionIndex + 1);
            }
        });
    }

    private void createParamMoveUpButton(Composite parent) {
        Button btnMoveUp = new Button(parent, 8);
        btnMoveUp.setText(ComposerTestcaseMessageConstants.PA_BTN_TIP_MOVE_UP);
        this.setButtonLayoutData(btnMoveUp);
        btnMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ClosureBuilderDialog.this.paramTableViewer.getTable().getSelectionIndex();
                if (selectionIndex == 0) {
                    return;
                }
                Collections.swap(ClosureBuilderDialog.this.parameterList, selectionIndex, selectionIndex - 1);
                ClosureBuilderDialog.this.paramTableViewer.refresh();
                ClosureBuilderDialog.this.paramTableViewer.getTable().setSelection(selectionIndex - 1);
            }
        });
    }

    private void createParamMoveDownButton(Composite parent) {
        Button btnMoveDown = new Button(parent, 8);
        btnMoveDown.setText(ComposerTestcaseMessageConstants.PA_BTN_TIP_MOVE_DOWN);
        this.setButtonLayoutData(btnMoveDown);
        btnMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = ClosureBuilderDialog.this.paramTableViewer.getTable().getSelectionIndex();
                if (selectionIndex == ClosureBuilderDialog.this.parameterList.size() - 1) {
                    return;
                }
                Collections.swap(ClosureBuilderDialog.this.parameterList, selectionIndex, selectionIndex + 1);
                ClosureBuilderDialog.this.paramTableViewer.refresh();
                ClosureBuilderDialog.this.paramTableViewer.getTable().setSelection(selectionIndex + 1);
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.getDialogTitle());
    }

    @Override
    public ClosureExpressionWrapper getReturnValue() {
        this.tempClosure.setParameters(this.parameterList.toArray(new ParameterWrapper[this.parameterList.size()]));
        this.tempClosure.setBlock(this.getTreeTableInput().getMainClassNode().getBlock());
        return this.tempClosure;
    }

    protected Point getInitialSize() {
        return new Point(900, 700);
    }

    public String getDialogTitle() {
        return ComposerTestcaseMessageConstants.TREE_CLOSURE;
    }

    @Override
    public TestCaseEntity getTestCase() {
        return null;
    }

    @Override
    public void setDirty(boolean isDirty) {
    }

    @Override
    public void addVariables(VariableEntity[] variables) {
    }

    @Override
    public VariableEntity[] getVariables() {
        return new VariableEntity[0];
    }

    @Override
    public List<AstTreeTableNode> getDragNodes() {
        return new ArrayList<AstTreeTableNode>();
    }

    @Override
    public void createDynamicGotoMenu(Menu menu) {
    }

    @Override
    public void deleteVariables(List<VariableEntity> variableList) {
    }
}

