/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.ast.dialogs;

import com.kms.katalon.composer.testcase.ast.dialogs.AbstractAstBuilderWithTableDialog;
import com.kms.katalon.composer.testcase.constants.ComposerTestcaseMessageConstants;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapEntryExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.MapExpressionWrapper;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.providers.AstInputTypeLabelProvider;
import com.kms.katalon.composer.testcase.providers.AstInputValueLabelProvider;
import com.kms.katalon.composer.testcase.providers.UneditableTableCellLabelProvider;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueColumnSupport;
import com.kms.katalon.composer.testcase.support.AstInputBuilderValueTypeColumnSupport;
import com.kms.katalon.composer.testcase.util.AstInputValueTypeOptionsProvider;
import com.kms.katalon.constants.GlobalMessageConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class MapInputBuilderDialog
extends AbstractAstBuilderWithTableDialog {
    private final InputValueType[] defaultInputValueTypes = AstInputValueTypeOptionsProvider.getInputValueTypeOptions(InputValueType.Map);
    private MapExpressionWrapper mapExpression;

    public MapInputBuilderDialog(Shell parentShell, MapExpressionWrapper mapExpression) {
        super(parentShell);
        this.mapExpression = mapExpression.clone();
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createInsertButton(parent);
        this.createRemoveButton(parent);
        super.createButtonsForButtonBar(parent);
    }

    private void createRemoveButton(Composite parent) {
        Button btnRemove = this.createButton(parent, 200, GlobalMessageConstants.DELETE, false);
        btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = MapInputBuilderDialog.this.tableViewer.getTable().getSelectionIndex();
                if (index >= 0 && index < MapInputBuilderDialog.this.mapExpression.getMapEntryExpressions().size()) {
                    MapInputBuilderDialog.this.mapExpression.removeExpression(index);
                    MapInputBuilderDialog.this.tableViewer.refresh();
                }
            }
        });
    }

    private void createInsertButton(Composite parent) {
        Button btnInsert = this.createButton(parent, 100, GlobalMessageConstants.INSERT, true);
        btnInsert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = MapInputBuilderDialog.this.tableViewer.getTable().getSelectionIndex();
                MapEntryExpressionWrapper mapEntryExpression = new MapEntryExpressionWrapper((ASTNodeWrapper)MapInputBuilderDialog.this.mapExpression);
                if (selectionIndex < 0 || selectionIndex >= MapInputBuilderDialog.this.mapExpression.getMapEntryExpressions().size()) {
                    MapInputBuilderDialog.this.mapExpression.addExpression(mapEntryExpression);
                } else {
                    MapInputBuilderDialog.this.mapExpression.addExpression(mapEntryExpression, selectionIndex);
                }
                MapInputBuilderDialog.this.tableViewer.refresh();
                MapInputBuilderDialog.this.tableViewer.getTable().setSelection(selectionIndex + 1);
            }
        });
    }

    @Override
    public MapExpressionWrapper getReturnValue() {
        return this.mapExpression;
    }

    @Override
    public String getDialogTitle() {
        return ComposerTestcaseMessageConstants.DIA_TITLE_MAP_INPUT;
    }

    @Override
    protected void addTableColumns() {
        this.addTableColumnNo();
        this.addTableColumnKeyType();
        this.addTableColumnKeyValue();
        this.addTableColumnValueType();
        this.addTableColumnValueValue();
    }

    private void addTableColumnValueValue() {
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumnValue = tableViewerColumnValue.getColumn();
        tblclmnNewColumnValue.setText(GlobalMessageConstants.VALUE);
        tblclmnNewColumnValue.setWidth(170);
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.getText(((MapEntryExpressionWrapper)element).getValueExpression());
                }
                return "";
            }
        });
        tableViewerColumnValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer){

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(((MapEntryExpressionWrapper)element).getValueExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(((MapEntryExpressionWrapper)element).getValueExpression());
            }

            @Override
            protected boolean canEdit(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.canEdit(((MapEntryExpressionWrapper)element).getValueExpression());
                }
                return false;
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(((MapEntryExpressionWrapper)element).getValueExpression());
            }
        });
    }

    private void addTableColumnValueType() {
        TableViewerColumn tableViewerColumnValueType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnValueType.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_VALUE_TYPE);
        tableViewerColumnValueType.getColumn().setWidth(100);
        tableViewerColumnValueType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.getText(((MapEntryExpressionWrapper)element).getValueExpression());
                }
                return "";
            }
        });
        tableViewerColumnValueType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, this.defaultInputValueTypes){

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(((MapEntryExpressionWrapper)element).getValueExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(((MapEntryExpressionWrapper)element).getValueExpression());
            }

            @Override
            protected boolean canEdit(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.canEdit(((MapEntryExpressionWrapper)element).getValueExpression());
                }
                return false;
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(((MapEntryExpressionWrapper)element).getValueExpression());
            }
        });
    }

    private void addTableColumnKeyValue() {
        TableViewerColumn tableViewerColumnKeyValue = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnNewColumnKeyValue = tableViewerColumnKeyValue.getColumn();
        tblclmnNewColumnKeyValue.setText(ComposerTestcaseMessageConstants.DIA_COL_KEY);
        tblclmnNewColumnKeyValue.setWidth(170);
        tableViewerColumnKeyValue.setLabelProvider((CellLabelProvider)new AstInputValueLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.getText(((MapEntryExpressionWrapper)element).getKeyExpression());
                }
                return "";
            }
        });
        tableViewerColumnKeyValue.setEditingSupport((EditingSupport)new AstInputBuilderValueColumnSupport((ColumnViewer)this.tableViewer){

            @Override
            protected boolean canEdit(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.canEdit(((MapEntryExpressionWrapper)element).getKeyExpression());
                }
                return false;
            }

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(((MapEntryExpressionWrapper)element).getKeyExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(((MapEntryExpressionWrapper)element).getKeyExpression());
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(((MapEntryExpressionWrapper)element).getKeyExpression());
            }
        });
    }

    private void addTableColumnKeyType() {
        TableViewerColumn tableViewerColumnKeyType = new TableViewerColumn(this.tableViewer, 0);
        tableViewerColumnKeyType.getColumn().setText(ComposerTestcaseMessageConstants.DIA_COL_KEY_TYPE);
        tableViewerColumnKeyType.getColumn().setWidth(100);
        tableViewerColumnKeyType.setLabelProvider((CellLabelProvider)new AstInputTypeLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.getText(((MapEntryExpressionWrapper)element).getKeyExpression());
                }
                return "";
            }
        });
        tableViewerColumnKeyType.setEditingSupport((EditingSupport)new AstInputBuilderValueTypeColumnSupport((ColumnViewer)this.tableViewer, this.defaultInputValueTypes){

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(((MapEntryExpressionWrapper)element).getKeyExpression(), value);
            }

            @Override
            protected Object getValue(Object element) {
                return super.getValue(((MapEntryExpressionWrapper)element).getKeyExpression());
            }

            @Override
            protected boolean canEdit(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return super.canEdit(((MapEntryExpressionWrapper)element).getKeyExpression());
                }
                return false;
            }

            @Override
            protected CellEditor getCellEditor(Object element) {
                return super.getCellEditor(((MapEntryExpressionWrapper)element).getKeyExpression());
            }
        });
    }

    private void addTableColumnNo() {
        TableViewerColumn tableViewerColumnNo = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnColumnNo = tableViewerColumnNo.getColumn();
        tblclmnColumnNo.setText(GlobalMessageConstants.NO_);
        tblclmnColumnNo.setWidth(40);
        tableViewerColumnNo.setLabelProvider((CellLabelProvider)new UneditableTableCellLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof MapEntryExpressionWrapper) {
                    return String.valueOf(MapInputBuilderDialog.this.mapExpression.getMapEntryExpressions().indexOf(element) + 1);
                }
                return "";
            }
        });
    }

    @Override
    public void setInput() {
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.mapExpression.getMapEntryExpressions());
        this.tableViewer.refresh();
    }
}

