/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.components;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractKeywordNodeTooltip {
    private int preferedWidth = 600;
    private int preferedHeight = 200;
    protected Shell tip;
    protected Control control;
    private boolean showBelow = true;
    protected Point location;
    private static AbstractKeywordNodeTooltip currentTooltip = null;

    public Shell getShell() {
        return this.tip;
    }

    protected abstract void initComponents(Composite var1);

    private void createTooltip() {
        this.tip = new Shell(this.control.getShell(), 16404);
        this.tip.setLayout((Layout)new FillLayout());
        this.initComponents((Composite)this.tip);
    }

    public boolean isShowBelowPoint() {
        return this.showBelow;
    }

    public void setPreferedSize(int w, int h) {
        if (w > 0) {
            this.preferedWidth = w;
        }
        if (h > 0) {
            this.preferedHeight = h;
        }
    }

    public void show(Point p) {
        this.hide();
        this.location = p;
        this.createTooltip();
        this.tip.setLocation(p);
        Point tipSize = this.getBestSizeForKeywordDescriptionPopup();
        this.tip.setSize(tipSize);
        if (currentTooltip != null && currentTooltip != this) {
            currentTooltip.hide();
        }
        currentTooltip = this;
        this.tip.setVisible(true);
    }

    protected Point getBestSizeForKeywordDescriptionPopup() {
        Monitor currentMonitor = null;
        Monitor[] monitorArray = Display.getCurrent().getMonitors();
        int n = monitorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            if (monitor.getClientArea().contains(this.location)) {
                currentMonitor = monitor;
                break;
            }
            ++n2;
        }
        Rectangle displayRect = currentMonitor.getClientArea();
        int width = this.preferedWidth;
        if (this.location.x + width > displayRect.x + displayRect.width) {
            width = displayRect.x + displayRect.width - this.location.x;
        }
        return new Point(width, this.preferedHeight);
    }

    public synchronized void hide() {
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
            currentTooltip = null;
        }
    }

    public boolean isVisible() {
        return this.tip != null && !this.tip.isDisposed() && this.tip.isVisible();
    }

    public Rectangle getBounds() {
        return this.tip.getBounds();
    }
}

