/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testcase.dialogs.provider;

import com.kms.katalon.composer.components.impl.support.TypeCheckedEditingSupport;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.expressions.ExpressionWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testcase.util.AstValueUtil;
import com.kms.katalon.entity.link.VariableLink;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;

public class ScriptVariableValueEditingSupport
extends TypeCheckedEditingSupport<VariableLink> {
    private ExpressionWrapper expression;
    private CellEditor editor;

    public ScriptVariableValueEditingSupport(ColumnViewer viewer) {
        super(viewer);
    }

    protected Class<VariableLink> getElementType() {
        return VariableLink.class;
    }

    protected CellEditor getCellEditorByElement(VariableLink element) {
        this.editor = null;
        this.expression = GroovyWrapperParser.parseGroovyScriptAndGetFirstExpression(element.getValue());
        if (this.expression == null) {
            return null;
        }
        InputValueType inputValueType = AstValueUtil.getTypeValue(this.expression);
        if (inputValueType != null) {
            this.editor = inputValueType.getCellEditorForValue(this.getComposite(), this.expression);
            return this.editor;
        }
        return null;
    }

    protected boolean canEditElement(VariableLink element) {
        return true;
    }

    protected Object getElementValue(VariableLink element) {
        InputValueType inputValueType = AstValueUtil.getTypeValue(this.expression);
        if (inputValueType != null) {
            return inputValueType.getValueToEdit(this.expression);
        }
        return null;
    }

    protected void setElementValue(VariableLink element, Object value) {
        if (value == null) {
            return;
        }
        InputValueType inputValueType = AstValueUtil.getTypeValue(this.expression);
        if (inputValueType == null) {
            return;
        }
        Object object = inputValueType.changeValue(this.expression, value);
        if (!(object instanceof ASTNodeWrapper)) {
            return;
        }
        element.setValue(((ASTNodeWrapper)object).getText());
        this.getViewer().refresh((Object)element);
    }

    public CellEditor getEditor() {
        return this.editor;
    }
}

