/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import org.apache.groovy.util.Maps;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;

public class WideningCategories {
    private static final Map<ClassNode, Integer> NUMBER_TYPES_PRECEDENCE = Maps.of((Object)ClassHelper.double_TYPE, (Object)0, (Object)ClassHelper.float_TYPE, (Object)1, (Object)ClassHelper.long_TYPE, (Object)2, (Object)ClassHelper.int_TYPE, (Object)3, (Object)ClassHelper.short_TYPE, (Object)4, (Object)ClassHelper.byte_TYPE, (Object)5);
    private static final Comparator<ClassNode> INTERFACE_CLASSNODE_COMPARATOR = (o1, o2) -> {
        int methodCountForO2;
        int interfaceCountForO2;
        int interfaceCountForO1 = o1.getInterfaces().length;
        if (interfaceCountForO1 > (interfaceCountForO2 = o2.getInterfaces().length)) {
            return -1;
        }
        if (interfaceCountForO1 < interfaceCountForO2) {
            return 1;
        }
        int methodCountForO1 = o1.getMethods().size();
        if (methodCountForO1 > (methodCountForO2 = o2.getMethods().size())) {
            return -1;
        }
        if (methodCountForO1 < methodCountForO2) {
            return 1;
        }
        return o1.getName().compareTo(o2.getName());
    };

    public static boolean isInt(ClassNode type) {
        return ClassHelper.int_TYPE == type;
    }

    public static boolean isFloat(ClassNode type) {
        return ClassHelper.float_TYPE == type;
    }

    public static boolean isDouble(ClassNode type) {
        return ClassHelper.double_TYPE == type;
    }

    public static boolean isIntCategory(ClassNode type) {
        return ClassHelper.int_TYPE == type || ClassHelper.byte_TYPE == type || ClassHelper.char_TYPE == type || ClassHelper.short_TYPE == type;
    }

    public static boolean isLongCategory(ClassNode type) {
        return ClassHelper.long_TYPE == type || WideningCategories.isIntCategory(type);
    }

    public static boolean isBigIntCategory(ClassNode type) {
        return ClassHelper.BigInteger_TYPE == type || WideningCategories.isLongCategory(type);
    }

    public static boolean isBigDecCategory(ClassNode type) {
        return ClassHelper.BigDecimal_TYPE == type || WideningCategories.isBigIntCategory(type);
    }

    public static boolean isDoubleCategory(ClassNode type) {
        return ClassHelper.float_TYPE == type || ClassHelper.double_TYPE == type || WideningCategories.isBigDecCategory(type);
    }

    public static boolean isFloatingCategory(ClassNode type) {
        return ClassHelper.float_TYPE == type || ClassHelper.double_TYPE == type;
    }

    public static boolean isNumberCategory(ClassNode type) {
        return WideningCategories.isBigDecCategory(type) || type.isDerivedFrom(ClassHelper.Number_TYPE);
    }

    public static ClassNode lowestUpperBound(List<ClassNode> nodes) {
        int n = nodes.size();
        if (n == 1) {
            return nodes.get(0);
        }
        if (n == 2) {
            return WideningCategories.lowestUpperBound(nodes.get(0), nodes.get(1));
        }
        return WideningCategories.lowestUpperBound(nodes.get(0), WideningCategories.lowestUpperBound(nodes.subList(1, n)));
    }

    public static ClassNode lowestUpperBound(ClassNode a, ClassNode b) {
        ClassNode lub = WideningCategories.lowestUpperBound(a, b, null, null);
        if (lub == null || !lub.isUsingGenerics() || lub.isGenericsPlaceHolder()) {
            return lub;
        }
        if (lub instanceof LowestUpperBoundClassNode) {
            ClassNode superClass = lub.getUnresolvedSuperClass();
            if (superClass.redirect().getGenericsTypes() != null) {
                superClass = WideningCategories.parameterizeLowestUpperBound(superClass, a, b, lub);
            }
            ClassNode[] interfaces = (ClassNode[])lub.getInterfaces().clone();
            int i = 0;
            int n = interfaces.length;
            while (i < n) {
                ClassNode icn = interfaces[i];
                if (icn.redirect().getGenericsTypes() != null) {
                    interfaces[i] = WideningCategories.parameterizeLowestUpperBound(icn, a, b, lub);
                }
                ++i;
            }
            return new LowestUpperBoundClassNode(((LowestUpperBoundClassNode)lub).name, superClass, interfaces);
        }
        return WideningCategories.parameterizeLowestUpperBound(lub, a, b, lub);
    }

    private static ClassNode parameterizeLowestUpperBound(ClassNode lub, ClassNode a, ClassNode b, ClassNode fallback) {
        Object[] bgt;
        if (!lub.isUsingGenerics()) {
            return lub;
        }
        ClassNode holderForA = WideningCategories.findGenericsTypeHolderForClass(a, lub);
        ClassNode holderForB = WideningCategories.findGenericsTypeHolderForClass(b, lub);
        Object[] agt = holderForA == null ? null : holderForA.getGenericsTypes();
        Object[] objectArray = bgt = holderForB == null ? null : holderForB.getGenericsTypes();
        if (agt == null || bgt == null || agt.length != bgt.length || Arrays.toString(agt).equals(Arrays.toString(bgt))) {
            return lub;
        }
        int n = agt.length;
        GenericsType[] lubGTs = new GenericsType[n];
        int i = 0;
        while (i < n) {
            ClassNode t1 = WideningCategories.upperBound((GenericsType)agt[i]);
            ClassNode t2 = WideningCategories.upperBound((GenericsType)bgt[i]);
            ClassNode basicType = WideningCategories.areEqualWithGenerics(t1, ClassHelper.isPrimitiveType(a) ? ClassHelper.getWrapper(a) : a) && WideningCategories.areEqualWithGenerics(t2, ClassHelper.isPrimitiveType(b) ? ClassHelper.getWrapper(b) : b) ? fallback : WideningCategories.lowestUpperBound(t1, t2);
            lubGTs[i] = ((GenericsType)agt[i]).isWildcard() || ((GenericsType)bgt[i]).isWildcard() || !t1.equals(t2) ? GenericsUtils.buildWildcardType(basicType) : basicType.asGenericsType();
            ++i;
        }
        return GenericsUtils.makeClassSafe0(lub, lubGTs);
    }

    private static ClassNode findGenericsTypeHolderForClass(ClassNode source, ClassNode target) {
        if (ClassHelper.isPrimitiveType(source)) {
            source = ClassHelper.getWrapper(source);
        }
        if (source.equals(target)) {
            return source;
        }
        if (target.isInterface() ? source.implementsInterface(target) : source.isDerivedFrom(target)) {
            ClassNode sc;
            do {
                if (!GenericsUtils.hasUnresolvedGenerics(sc = ClassHelper.getNextSuperClass(source, target))) continue;
                sc = GenericsUtils.correctToGenericsSpecRecurse(GenericsUtils.createGenericsSpec(source), sc);
            } while (!(source = sc).equals(target));
            return sc;
        }
        return null;
    }

    private static ClassNode upperBound(GenericsType gt) {
        ClassNode[] ub;
        if ((gt.isPlaceholder() || gt.isWildcard()) && (ub = gt.getUpperBounds()) != null) {
            return ub[0];
        }
        return gt.getType();
    }

    private static ClassNode lowestUpperBound(ClassNode a, ClassNode b, Set<ClassNode> interfacesImplementedByA, Set<ClassNode> interfacesImplementedByB) {
        if (a == null || b == null) {
            return null;
        }
        if (a.isArray() && b.isArray()) {
            return WideningCategories.lowestUpperBound(a.getComponentType(), b.getComponentType(), interfacesImplementedByA, interfacesImplementedByB).makeArray();
        }
        if (a.equals(ClassHelper.OBJECT_TYPE) || b.equals(ClassHelper.OBJECT_TYPE)) {
            GenericsType[] gta = a.getGenericsTypes();
            GenericsType[] gtb = b.getGenericsTypes();
            if (gta != null && gtb != null && gta.length == 1 && gtb.length == 1 && gta[0].getName().equals(gtb[0].getName())) {
                return a;
            }
            return ClassHelper.OBJECT_TYPE;
        }
        if (a.equals(ClassHelper.VOID_TYPE) || b.equals(ClassHelper.VOID_TYPE)) {
            if (!b.equals(a)) {
                return ClassHelper.OBJECT_TYPE;
            }
            return ClassHelper.VOID_TYPE;
        }
        boolean aIsPrimitive = ClassHelper.isPrimitiveType(a);
        boolean bIsPrimitive = ClassHelper.isPrimitiveType(b);
        if (aIsPrimitive || bIsPrimitive) {
            ClassNode wb;
            if (a.equals(b)) {
                return a;
            }
            Integer pa = NUMBER_TYPES_PRECEDENCE.get(aIsPrimitive ? a : ClassHelper.getUnwrapper(a));
            Integer pb = NUMBER_TYPES_PRECEDENCE.get(bIsPrimitive ? b : ClassHelper.getUnwrapper(b));
            ClassNode wa = aIsPrimitive ? ClassHelper.getWrapper(a) : a;
            ClassNode classNode = wb = bIsPrimitive ? ClassHelper.getWrapper(b) : b;
            if (pa != null && pb != null) {
                if (pa.compareTo(pb) <= 0) {
                    return bIsPrimitive ? a : wa;
                }
                return aIsPrimitive ? b : wb;
            }
            return WideningCategories.lowestUpperBound(wa, wb, null, null);
        }
        if (ClassHelper.isNumberType(a) && ClassHelper.isNumberType(b)) {
            Integer pa = NUMBER_TYPES_PRECEDENCE.get(ClassHelper.getUnwrapper(a));
            Integer pb = NUMBER_TYPES_PRECEDENCE.get(ClassHelper.getUnwrapper(b));
            if (pa != null && pb != null) {
                return pa.compareTo(pb) <= 0 ? a : b;
            }
        }
        boolean aIsInterface = a.isInterface();
        boolean bIsInterface = b.isInterface();
        if (aIsInterface && bIsInterface) {
            List<ClassNode> common;
            if (a.equals(b)) {
                return a;
            }
            if (b.implementsInterface(a)) {
                return a;
            }
            if (a.implementsInterface(b)) {
                return b;
            }
            if (interfacesImplementedByA == null) {
                interfacesImplementedByA = GeneralUtils.getInterfacesAndSuperInterfaces((ClassNode)a);
            }
            if (interfacesImplementedByB == null) {
                interfacesImplementedByB = GeneralUtils.getInterfacesAndSuperInterfaces((ClassNode)b);
            }
            if ((common = WideningCategories.keepLowestCommonInterfaces(interfacesImplementedByA, interfacesImplementedByB)).size() == 1) {
                return common.get(0);
            }
            if (common.size() > 1) {
                return WideningCategories.buildTypeWithInterfaces(a, b, common);
            }
            return ClassHelper.OBJECT_TYPE;
        }
        if (bIsInterface) {
            return WideningCategories.lowestUpperBound(b, a, null, null);
        }
        if (aIsInterface) {
            LinkedList<ClassNode> matchingInterfaces = new LinkedList<ClassNode>();
            WideningCategories.extractMostSpecificImplementedInterfaces(b, a, matchingInterfaces);
            if (matchingInterfaces.isEmpty()) {
                return ClassHelper.OBJECT_TYPE;
            }
            if (matchingInterfaces.size() == 1) {
                return (ClassNode)matchingInterfaces.get(0);
            }
            return WideningCategories.buildTypeWithInterfaces(a, b, matchingInterfaces);
        }
        if (a.equals(b)) {
            return WideningCategories.buildTypeWithInterfaces(a, b, WideningCategories.keepLowestCommonInterfaces(interfacesImplementedByA, interfacesImplementedByB));
        }
        if (a.isDerivedFrom(b) || b.isDerivedFrom(a)) {
            return WideningCategories.buildTypeWithInterfaces(a, b, WideningCategories.keepLowestCommonInterfaces(interfacesImplementedByA, interfacesImplementedByB));
        }
        ClassNode sa = a.getUnresolvedSuperClass();
        ClassNode sb = b.getUnresolvedSuperClass();
        if (interfacesImplementedByA == null) {
            interfacesImplementedByA = GeneralUtils.getInterfacesAndSuperInterfaces((ClassNode)a);
        }
        if (interfacesImplementedByB == null) {
            interfacesImplementedByB = GeneralUtils.getInterfacesAndSuperInterfaces((ClassNode)b);
        }
        if (sa == null || sb == null) {
            return WideningCategories.buildTypeWithInterfaces(ClassHelper.OBJECT_TYPE, ClassHelper.OBJECT_TYPE, WideningCategories.keepLowestCommonInterfaces(interfacesImplementedByA, interfacesImplementedByB));
        }
        if (GenericsUtils.hasUnresolvedGenerics(sa)) {
            sa = GenericsUtils.correctToGenericsSpecRecurse(GenericsUtils.createGenericsSpec(a), sa);
        }
        if (GenericsUtils.hasUnresolvedGenerics(sb)) {
            sb = GenericsUtils.correctToGenericsSpecRecurse(GenericsUtils.createGenericsSpec(b), sb);
        }
        if (sa.isDerivedFrom(sb) || sb.isDerivedFrom(sa)) {
            return WideningCategories.buildTypeWithInterfaces(sa, sb, WideningCategories.keepLowestCommonInterfaces(interfacesImplementedByA, interfacesImplementedByB));
        }
        return WideningCategories.lowestUpperBound(sa, sb, interfacesImplementedByA, interfacesImplementedByB);
    }

    private static List<ClassNode> keepLowestCommonInterfaces(Set<ClassNode> fromA, Set<ClassNode> fromB) {
        if (fromA == null || fromB == null) {
            return Collections.emptyList();
        }
        HashSet<ClassNode> common = new HashSet<ClassNode>(fromA);
        common.retainAll(fromB);
        ArrayList<ClassNode> result = new ArrayList<ClassNode>(common.size());
        for (ClassNode classNode : common) {
            WideningCategories.addMostSpecificInterface(classNode, result);
        }
        return result;
    }

    private static void addMostSpecificInterface(ClassNode interfaceNode, List<ClassNode> nodes) {
        if (nodes.isEmpty()) {
            nodes.add(interfaceNode);
        }
        int i = 0;
        int n = nodes.size();
        while (i < n) {
            ClassNode node = nodes.get(i);
            if (node.equals(interfaceNode) || node.implementsInterface(interfaceNode)) {
                return;
            }
            if (interfaceNode.implementsInterface(node)) {
                nodes.set(i, interfaceNode);
                return;
            }
            ++i;
        }
        nodes.add(interfaceNode);
    }

    private static void extractMostSpecificImplementedInterfaces(ClassNode type, ClassNode inode, List<ClassNode> result) {
        if (type.implementsInterface(inode)) {
            result.add(inode);
        } else {
            ClassNode interfaceNode;
            ClassNode[] interfaces;
            ClassNode[] classNodeArray = interfaces = inode.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                interfaceNode = classNodeArray[n2];
                if (type.implementsInterface(interfaceNode)) {
                    result.add(interfaceNode);
                }
                ++n2;
            }
            if (result.isEmpty() && interfaces.length > 0) {
                classNodeArray = interfaces;
                n = interfaces.length;
                n2 = 0;
                while (n2 < n) {
                    interfaceNode = classNodeArray[n2];
                    WideningCategories.extractMostSpecificImplementedInterfaces(type, interfaceNode, result);
                    ++n2;
                }
            }
        }
    }

    private static ClassNode buildTypeWithInterfaces(ClassNode baseType1, ClassNode baseType2, Collection<ClassNode> interfaces) {
        String name;
        ClassNode superClass;
        if (interfaces.isEmpty()) {
            if (baseType2.isDerivedFrom(baseType1)) {
                return baseType1;
            }
            if (baseType1.isDerivedFrom(baseType2)) {
                return baseType2;
            }
        }
        if (baseType1.equals(ClassHelper.OBJECT_TYPE) && baseType2.equals(ClassHelper.OBJECT_TYPE) && interfaces.size() == 1) {
            return interfaces.iterator().next();
        }
        if (baseType1.equals(baseType2)) {
            superClass = baseType1;
            name = baseType1.equals(ClassHelper.OBJECT_TYPE) ? "Virtual$Object" : "Virtual$" + baseType1.getName();
        } else {
            superClass = baseType1.isDerivedFrom(baseType2) ? baseType2 : (baseType2.isDerivedFrom(baseType1) ? baseType1 : ClassHelper.OBJECT_TYPE);
            name = "CommonAssignOf$" + baseType1.getName() + "$" + baseType2.getName();
        }
        interfaces.removeIf(i -> superClass.equals(i) || superClass.implementsInterface((ClassNode)i));
        int nInterfaces = interfaces.size();
        if (nInterfaces == 0) {
            return superClass;
        }
        if (nInterfaces == 1 && superClass.equals(ClassHelper.OBJECT_TYPE)) {
            return interfaces.iterator().next();
        }
        ClassNode[] interfaceArray = interfaces.toArray(ClassNode.EMPTY_ARRAY);
        Arrays.sort(interfaceArray, INTERFACE_CLASSNODE_COMPARATOR);
        return new LowestUpperBoundClassNode(name, superClass, interfaceArray);
    }

    private static boolean areEqualWithGenerics(ClassNode a, ClassNode b) {
        if (a == null) {
            return b == null;
        }
        if (!a.equals(b)) {
            return false;
        }
        if (a.isUsingGenerics() && !b.isUsingGenerics()) {
            return false;
        }
        GenericsType[] gta = a.getGenericsTypes();
        GenericsType[] gtb = b.getGenericsTypes();
        if (gta == null && gtb != null) {
            return false;
        }
        if (gtb == null && gta != null) {
            return false;
        }
        if (gta != null && gtb != null) {
            if (gta.length != gtb.length) {
                return false;
            }
            int i = 0;
            int n = gta.length;
            while (i < n) {
                GenericsType gta_i = gta[i];
                GenericsType gtb_i = gtb[i];
                ClassNode[] upperA = gta_i.getUpperBounds();
                ClassNode[] upperB = gtb_i.getUpperBounds();
                if (gta_i.isPlaceholder() != gtb_i.isPlaceholder() || gta_i.isWildcard() != gtb_i.isWildcard() || !gta_i.getName().equals(gtb_i.getName()) || !WideningCategories.areEqualWithGenerics(gta_i.getType(), gtb_i.getType()) || !WideningCategories.areEqualWithGenerics(gta_i.getLowerBound(), gtb_i.getLowerBound()) || (upperA == null ? upperB != null : upperB.length != upperA.length || IntStream.range(0, upperA.length).anyMatch(j -> !WideningCategories.areEqualWithGenerics(upperA[j], upperB[j])))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean implementsInterfaceOrSubclassOf(ClassNode source, ClassNode target) {
        if (source.isDerivedFrom(target) || source.implementsInterface(target)) {
            return true;
        }
        if (target instanceof LowestUpperBoundClassNode) {
            LowestUpperBoundClassNode lub = (LowestUpperBoundClassNode)target;
            if (WideningCategories.implementsInterfaceOrSubclassOf(source, lub.getSuperClass())) {
                return true;
            }
            ClassNode[] classNodeArray = lub.getInterfaces();
            int n = classNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode classNode = classNodeArray[n2];
                if (source.implementsInterface(classNode)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static class LowestUpperBoundClassNode
    extends ClassNode {
        private final String name;
        private final String text;
        private final ClassNode upper;
        private final ClassNode[] interfaces;
        private final ClassNode compileTimeClassNode;

        public LowestUpperBoundClassNode(String name, ClassNode upper, ClassNode ... interfaces) {
            super(name, 17, upper, interfaces, null);
            this.name = name;
            this.upper = upper;
            this.interfaces = interfaces;
            Arrays.sort(interfaces, (cn1, cn2) -> {
                String n1 = cn1 instanceof LowestUpperBoundClassNode ? ((LowestUpperBoundClassNode)cn1).name : cn1.getName();
                String n2 = cn2 instanceof LowestUpperBoundClassNode ? ((LowestUpperBoundClassNode)cn2).name : cn2.getName();
                return n1.compareTo(n2);
            });
            this.compileTimeClassNode = upper.equals(ClassHelper.OBJECT_TYPE) && interfaces.length > 0 ? interfaces[0] : upper;
            StringJoiner sj = new StringJoiner(" & ", "(", ")");
            if (!upper.equals(ClassHelper.OBJECT_TYPE)) {
                sj.add(upper.getText());
            }
            ClassNode[] classNodeArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode i = classNodeArray[n2];
                sj.add(i.getText());
                ++n2;
            }
            this.text = sj.toString();
            boolean usesGenerics = upper.isUsingGenerics();
            ArrayList<GenericsType[]> genericsTypesList = new ArrayList<GenericsType[]>();
            genericsTypesList.add(upper.getGenericsTypes());
            ClassNode[] classNodeArray2 = interfaces;
            int n3 = interfaces.length;
            int n4 = 0;
            while (n4 < n3) {
                ClassNode anInterface = classNodeArray2[n4];
                usesGenerics |= anInterface.isUsingGenerics();
                genericsTypesList.add(anInterface.getGenericsTypes());
                ++n4;
            }
            this.setUsingGenerics(usesGenerics);
            if (usesGenerics) {
                ArrayList flatList = new ArrayList();
                for (GenericsType[] gts : genericsTypesList) {
                    if (gts == null) continue;
                    Collections.addAll(flatList, gts);
                }
                this.setGenericsTypes(flatList.toArray(GenericsType.EMPTY_ARRAY));
            }
        }

        public String getLubName() {
            return this.name;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public String getName() {
            return this.compileTimeClassNode.getName();
        }

        @Override
        public Class getTypeClass() {
            return this.compileTimeClassNode.getTypeClass();
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + (this.name != null ? this.name.hashCode() : 0);
        }

        @Override
        public String toString(boolean x) {
            return this.text;
        }

        @Override
        public GenericsType asGenericsType() {
            ClassNode[] ubs;
            if (this.upper.equals(ClassHelper.OBJECT_TYPE)) {
                ubs = this.interfaces;
            } else {
                ubs = new ClassNode[this.interfaces.length + 1];
                ubs[0] = this.upper;
                System.arraycopy(this.interfaces, 0, ubs, 1, this.interfaces.length);
            }
            GenericsType gt = new GenericsType(ClassHelper.makeWithoutCaching("?"), ubs, null);
            gt.setWildcard(true);
            return gt;
        }

        @Override
        public ClassNode getPlainNodeReference() {
            ClassNode[] faces = (ClassNode[])this.interfaces.clone();
            int i = 0;
            while (i < this.interfaces.length) {
                faces[i] = this.interfaces[i].getPlainNodeReference();
                ++i;
            }
            return new LowestUpperBoundClassNode(this.name, this.upper.getPlainNodeReference(), faces);
        }
    }
}

