/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import groovy.lang.Tuple;
import groovy.lang.Tuple2;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.groovy.ast.tools.ExpressionUtils;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImmutableClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.classgen.VariableScopeVisitor;
import org.codehaus.groovy.control.ClassNodeResolver;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.trait.Traits;

public class ResolveVisitor
extends ClassCodeExpressionTransformer {
    public static final String[] DEFAULT_IMPORTS = new String[]{"java.lang.", "java.util.", "java.io.", "java.net.", "groovy.lang.", "groovy.util."};
    private static final String BIGINTEGER_STR = "BigInteger";
    private static final String BIGDECIMAL_STR = "BigDecimal";
    public static final String QUESTION_MARK = "?";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected ClassNode currentClass;
    public final CompilationUnit compilationUnit;
    private SourceUnit source;
    private VariableScope currentScope;
    private boolean isTopLevelProperty = true;
    private boolean inPropertyExpression;
    private boolean inClosure;
    private Map<GenericsType.GenericsTypeName, GenericsType> genericParameterNames = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
    private Set<FieldNode> fieldTypesChecked;
    private Set<String> resolutionFailed;
    int phase;
    private boolean checkingVariableTypeInDeclaration;
    private ImportNode currImportNode;
    private MethodNode currentMethod;
    private ClassNodeResolver classNodeResolver;

    public ResolveVisitor(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
        this.setClassNodeResolver(new ClassNodeResolver(){

            public ClassNodeResolver.LookupResult findClassNode(String name, CompilationUnit compilationUnit) {
                return compilationUnit == null ? null : super.findClassNode(name, compilationUnit);
            }
        });
    }

    public void setClassNodeResolver(ClassNodeResolver classNodeResolver) {
        this.classNodeResolver = classNodeResolver;
    }

    public void startResolving(ClassNode node, SourceUnit source) {
        if (this.fieldTypesChecked == null) {
            this.fieldTypesChecked = new HashSet<FieldNode>();
            this.resolutionFailed = new HashSet<String>();
        }
        this.source = source;
        this.visitClass(node);
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    protected void resetSourceUnit() {
        this.source = null;
    }

    protected void resetVariableScope() {
        this.currentScope = null;
    }

    public void visitField(FieldNode node) {
        Map<GenericsType.GenericsTypeName, GenericsType> oldNames = this.genericParameterNames;
        if (!ResolveVisitor.canSeeTypeVars(node.getModifiers(), node.getDeclaringClass())) {
            this.genericParameterNames = Collections.emptyMap();
        }
        try {
            if (!this.fieldTypesChecked.contains(node)) {
                this.resolveOrFail(node.getType(), (ASTNode)node);
            }
            super.visitField(node);
        }
        finally {
            this.genericParameterNames = oldNames;
        }
    }

    public void visitProperty(PropertyNode node) {
        Map<GenericsType.GenericsTypeName, GenericsType> oldNames = this.genericParameterNames;
        if (!ResolveVisitor.canSeeTypeVars(node.getModifiers(), node.getDeclaringClass())) {
            this.genericParameterNames = Collections.emptyMap();
        }
        try {
            this.resolveOrFail(node.getType(), (ASTNode)node);
            this.fieldTypesChecked.add(node.getField());
            super.visitProperty(node);
        }
        finally {
            this.genericParameterNames = oldNames;
        }
    }

    private static boolean canSeeTypeVars(int mods, ClassNode node) {
        return !Modifier.isStatic(mods) || Traits.isTrait(node);
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        VariableScope oldScope = this.currentScope;
        this.currentScope = node.getVariableScope();
        Map<GenericsType.GenericsTypeName, GenericsType> oldNames = this.genericParameterNames;
        this.genericParameterNames = ResolveVisitor.canSeeTypeVars(node.getModifiers(), node.getDeclaringClass()) ? new HashMap<GenericsType.GenericsTypeName, GenericsType>(this.genericParameterNames) : new HashMap();
        MethodNode oldCurrentMethod = this.currentMethod;
        try {
            this.resolveGenericsHeader(node.getGenericsTypes());
            this.resolveOrFail(node.getReturnType(), node);
            AnnotatedNode[] annotatedNodeArray = node.getParameters();
            int n = annotatedNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter p = annotatedNodeArray[n2];
                p.setInitialExpression(this.transform(p.getInitialExpression()));
                ClassNode t = p.getType();
                this.resolveOrFail(t, t);
                this.visitAnnotations(p);
                ++n2;
            }
            if (node.getExceptions() != null) {
                annotatedNodeArray = node.getExceptions();
                n = annotatedNodeArray.length;
                n2 = 0;
                while (n2 < n) {
                    AnnotatedNode t = annotatedNodeArray[n2];
                    this.resolveOrFail((ClassNode)t, t);
                    ++n2;
                }
            }
            this.currentMethod = node;
            super.visitConstructorOrMethod(node, isConstructor);
        }
        finally {
            this.currentMethod = oldCurrentMethod;
            this.genericParameterNames = oldNames;
            this.currentScope = oldScope;
        }
    }

    private void resolveOrFail(ClassNode type, ASTNode node) {
        this.resolveOrFail(type, "", node);
    }

    private void resolveOrFail(ClassNode type, String msg, ASTNode node) {
        this.resolveOrFail(type, msg, node, false);
    }

    private void resolveOrFail(ClassNode type, String msg, ASTNode node, boolean preferImports) {
        if (preferImports && !type.isResolved() && !type.isPrimaryClassNode()) {
            this.resolveGenericsTypes(type.getGenericsTypes());
            if (this.resolveAliasFromModule(type)) {
                return;
            }
        }
        ClassNode temp = type;
        while (temp.isArray()) {
            temp = temp.getComponentType();
        }
        String name = temp.getName();
        try {
            if (this.resolve(type)) {
                return;
            }
        }
        catch (LinkageError e) {
            String message = "unable to define class " + name + msg + " : " + e.getLocalizedMessage();
            this.addError(message, temp.getEnd() > 0 ? temp : node);
            return;
        }
        String nameAsType = name.replace('.', '$');
        ModuleNode module = this.currentClass.getModule();
        if (!name.equals(nameAsType) && module.hasPackageName()) {
            temp.setName(String.valueOf(module.getPackageName()) + nameAsType);
            if (this.resolve(temp, false, false, false)) {
                return;
            }
        }
        for (ImportNode star : module.getStarImports()) {
            String cName = star.getClassName();
            if (cName == null) continue;
            temp.setName(String.valueOf(cName) + '$' + nameAsType);
            if (!this.resolve(temp, false, false, false)) continue;
            return;
        }
        if (!name.equals(nameAsType)) {
            String[] stringArray = DEFAULT_IMPORTS;
            int n = DEFAULT_IMPORTS.length;
            int n2 = 0;
            while (n2 < n) {
                String pack = stringArray[n2];
                temp.setName(String.valueOf(pack) + nameAsType);
                if (this.resolve(temp, false, false, false)) {
                    return;
                }
                ++n2;
            }
        }
        temp.setName(name);
        this.addError("unable to resolve class " + name + msg, temp.getEnd() > 0 ? temp : node);
    }

    protected boolean resolveToInner(ClassNode type) {
        String name;
        if (type instanceof ConstructedClassWithPackage) {
            return false;
        }
        if (type instanceof ConstructedNestedClass) {
            return false;
        }
        ClassNode t = type;
        while (t.isArray()) {
            t = t.getComponentType();
        }
        String temp = name = t.getName();
        while (temp.lastIndexOf(46) != -1) {
            temp = ResolveVisitor.replaceLastPointWithDollar(temp);
            t.setName(temp);
            if (!this.resolve(t, true, false, false)) continue;
            return true;
        }
        t.setName(name);
        return false;
    }

    public ClassNode resolve(String name) {
        return null;
    }

    protected boolean resolve(ClassNode type) {
        return this.resolve(type, true, true, true);
    }

    protected boolean resolve(ClassNode type, boolean testModuleImports, boolean testDefaultImports, boolean testStaticInnerClasses) {
        boolean resolved;
        GenericsType[] genericsTypes = type.getGenericsTypes();
        this.resolveGenericsTypes(genericsTypes);
        if (type.isPrimaryClassNode()) {
            return true;
        }
        if (type.isArray()) {
            ClassNode element = type.getComponentType();
            boolean resolved2 = this.resolve(element, testModuleImports, testDefaultImports, testStaticInnerClasses);
            if (resolved2) {
                ClassNode cn = element.makeArray();
                type.setRedirect(cn);
            }
            return resolved2;
        }
        if (type.isResolved()) {
            return true;
        }
        String typeName = type.getName();
        GenericsType typeParameter = this.genericParameterNames.get(new GenericsType.GenericsTypeName(typeName));
        if (typeParameter != null) {
            type.setDeclaringClass(typeParameter.getType().getDeclaringClass());
            type.setGenericsTypes(new GenericsType[]{typeParameter});
            type.setRedirect(typeParameter.getType());
            type.setGenericsPlaceHolder(true);
            return true;
        }
        if (this.currentClass.getNameWithoutPackage().equals(typeName)) {
            type.setRedirect(this.currentClass);
            resolved = true;
        } else {
            boolean bl = resolved = !type.hasPackageName() && this.resolveNestedClass(type) || this.resolveFromModule(type, testModuleImports) || this.resolveFromCompileUnit(type) || testDefaultImports && !type.hasPackageName() && this.resolveFromDefaultImports(type, true) || this.resolveToOuter(type) || testStaticInnerClasses && type.hasPackageName() && this.resolveFromStaticInnerClasses(type, true);
        }
        if (resolved && genericsTypes != null) {
            ResolveVisitor.resolveWildcardBounding(genericsTypes, type);
        }
        return resolved;
    }

    protected boolean resolveNestedClass(ClassNode type) {
        if (type instanceof ConstructedNestedClass || type instanceof ConstructedClassWithPackage) {
            return false;
        }
        HashSet<ClassNode> cycleCheck = new HashSet<ClassNode>();
        cycleCheck.add(ClassHelper.OBJECT_TYPE);
        ClassNode cn = this.currentClass;
        while (cn != null && cycleCheck.add(cn)) {
            if (this.setRedirect(type, cn)) {
                return true;
            }
            cn = cn.getSuperClass();
        }
        List<ClassNode> outerClasses = this.currentClass.getOuterClasses();
        if (!outerClasses.isEmpty()) {
            ListIterator<ClassNode> it = outerClasses.listIterator(outerClasses.size());
            while (it.hasPrevious()) {
                ClassNode outerClass = it.previous();
                if (!this.setRedirect(type, outerClass)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean setRedirect(ClassNode type, ClassNode classToCheck) {
        String typeName = type.getName();
        Predicate<ClassNode> resolver = maybeOuter -> {
            ConstructedNestedClass maybeNested;
            if (!typeName.equals(maybeOuter.getName()) && !this.resolutionFailed.contains((maybeNested = new ConstructedNestedClass((ClassNode)maybeOuter, typeName)).getName())) {
                if (this.resolveFromCompileUnit(maybeNested) || this.resolveToOuter(maybeNested)) {
                    type.setRedirect(maybeNested);
                    return true;
                }
                this.resolutionFailed.add(maybeNested.getName());
            }
            return false;
        };
        if (resolver.test(classToCheck)) {
            if (this.currentClass != classToCheck && !this.currentClass.getOuterClasses().contains(classToCheck) && !ResolveVisitor.isVisibleNestedClass(type.redirect(), this.currentClass)) {
                type.setRedirect(null);
            } else {
                return true;
            }
        }
        if (classToCheck.getInterfaces().length > 0) {
            for (ClassNode face : classToCheck.getAllInterfaces()) {
                if (!resolver.test(face)) continue;
                return true;
            }
        }
        return false;
    }

    private static String replaceLastPointWithDollar(String name) {
        int lastPointIndex = name.lastIndexOf(46);
        return String.valueOf(name.substring(0, lastPointIndex)) + "$" + name.substring(lastPointIndex + 1);
    }

    protected boolean resolveFromStaticInnerClasses(ClassNode type, boolean unused) {
        if (!(type instanceof LowerCaseClass) && !(type instanceof ConstructedNestedClass)) {
            if (type instanceof ConstructedClassWithPackage) {
                ConstructedClassWithPackage tmp = (ConstructedClassWithPackage)type;
                String savedName = tmp.className;
                tmp.className = ResolveVisitor.replaceLastPointWithDollar(savedName);
                if (this.resolve(tmp, false, false, true)) {
                    type.setRedirect(tmp.redirect());
                    return true;
                }
                tmp.className = savedName;
            } else {
                String savedName = type.getName();
                type.setName(ResolveVisitor.replaceLastPointWithDollar(savedName));
                if (this.resolve(type, false, false, true)) {
                    return true;
                }
                type.setName(savedName);
            }
        }
        return false;
    }

    protected boolean resolveFromDefaultImports(ClassNode type, boolean unused) {
        if (!(type instanceof LowerCaseClass)) {
            String typeName = type.getName();
            if (this.resolveFromDefaultImports(type, DEFAULT_IMPORTS)) {
                return true;
            }
            if (BIGINTEGER_STR.equals(typeName)) {
                type.setRedirect(ClassHelper.BigInteger_TYPE);
                return true;
            }
            if (BIGDECIMAL_STR.equals(typeName)) {
                type.setRedirect(ClassHelper.BigDecimal_TYPE);
                return true;
            }
        }
        return false;
    }

    protected boolean resolveFromDefaultImports(ClassNode type, String[] packagePrefixes) {
        String typeName = type.getName();
        String[] stringArray = packagePrefixes;
        int n = packagePrefixes.length;
        int n2 = 0;
        while (n2 < n) {
            String packagePrefix = stringArray[n2];
            ConstructedClassWithPackage tmp = new ConstructedClassWithPackage(packagePrefix, typeName);
            if (!this.resolutionFailed.contains(tmp.getName())) {
                if (this.resolve(tmp, false, false, false)) {
                    type.setRedirect(tmp.redirect());
                    return true;
                }
                this.resolutionFailed.add(tmp.getName());
            }
            ++n2;
        }
        return false;
    }

    protected boolean resolveFromCompileUnit(ClassNode type) {
        CompileUnit compileUnit = this.currentClass.getCompileUnit();
        if (compileUnit == null) {
            return false;
        }
        ClassNode cuClass = compileUnit.getClass(type.getName());
        if (cuClass != null) {
            if (type != cuClass) {
                type.setRedirect(cuClass);
            }
            return true;
        }
        return false;
    }

    private void ambiguousClass(ClassNode type, ClassNode iType, String name) {
        if (type.getName().equals(iType.getName())) {
            this.addError("reference to " + name + " is ambiguous, both class " + type.getName() + " and " + iType.getName() + " match", type);
        } else {
            type.setRedirect(iType);
        }
    }

    private boolean resolveAliasFromModule(ClassNode type) {
        String name;
        if (type instanceof ConstructedClassWithPackage) {
            return false;
        }
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return false;
        }
        String pname = name = type.getName();
        int index = name.length();
        do {
            ConstructedNestedClass tmp;
            pname = name.substring(0, index);
            ClassNode aliasedNode = null;
            ImportNode importNode = module.getImport(pname);
            if (importNode != null && importNode != this.currImportNode) {
                aliasedNode = importNode.getType();
            }
            if (aliasedNode == null && (importNode = module.getStaticImports().get(pname)) != null && importNode != this.currImportNode && this.resolve(tmp = new ConstructedNestedClass(importNode.getType(), importNode.getFieldName()), false, false, true) && Modifier.isStatic(tmp.getModifiers())) {
                type.setRedirect(tmp.redirect());
                return true;
            }
            if (aliasedNode == null) continue;
            if (pname.length() == name.length()) {
                type.setRedirect(aliasedNode);
                return true;
            }
            String className = String.valueOf(aliasedNode.getNameWithoutPackage()) + "$" + name.substring(pname.length() + 1).replace('.', '$');
            ConstructedClassWithPackage tmp2 = new ConstructedClassWithPackage(String.valueOf(aliasedNode.getPackageName()) + ".", className);
            if (!this.resolve(tmp2, true, true, false)) continue;
            type.setRedirect(tmp2.redirect());
            return true;
        } while ((index = pname.lastIndexOf(46)) != -1);
        return false;
    }

    protected boolean resolveFromModule(ClassNode type, boolean testModuleImports) {
        if (type instanceof ConstructedNestedClass) {
            return false;
        }
        if (type instanceof LowerCaseClass) {
            return this.resolveAliasFromModule(type);
        }
        String name = type.getName();
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return false;
        }
        boolean newNameUsed = false;
        if (!type.hasPackageName() && module.hasPackageName() && !(type instanceof ConstructedClassWithPackage)) {
            type.setName(String.valueOf(module.getPackageName()) + name);
            newNameUsed = true;
        }
        List<ClassNode> moduleClasses = module.getClasses();
        for (ClassNode mClass : moduleClasses) {
            if (!mClass.getName().equals(type.getName())) continue;
            if (mClass != type) {
                type.setRedirect(mClass);
            }
            return true;
        }
        if (newNameUsed) {
            type.setName(name);
        }
        if (testModuleImports) {
            ClassNode tmp;
            ConstructedClassWithPackage tmp2;
            if (this.resolveAliasFromModule(type)) {
                return true;
            }
            if (module.hasPackageName() && !this.resolutionFailed.contains(((ClassNode)(tmp2 = new ConstructedClassWithPackage(module.getPackageName(), name))).getName())) {
                if (this.resolve(tmp2, false, false, false)) {
                    this.ambiguousClass(type, tmp2, name);
                    return true;
                }
                this.resolutionFailed.add(((ClassNode)tmp2).getName());
            }
            for (ImportNode importNode : module.getStaticImports().values()) {
                if (!importNode.getFieldName().equals(name) || this.resolutionFailed.contains((tmp = new ConstructedNestedClass(importNode.getType(), name)).getName())) continue;
                if (this.resolve(tmp, false, false, true) && Modifier.isStatic(tmp.getModifiers())) {
                    type.setRedirect(tmp.redirect());
                    return true;
                }
                this.resolutionFailed.add(tmp.getName());
            }
            for (ImportNode importNode : module.getStaticStarImports().values()) {
                tmp = new ConstructedNestedClass(importNode.getType(), name);
                if (this.resolutionFailed.contains(tmp.getName())) continue;
                if (this.resolve(tmp, false, false, true) && Modifier.isStatic(tmp.getModifiers())) {
                    this.ambiguousClass(type, tmp, name);
                    return true;
                }
                this.resolutionFailed.add(tmp.getName());
            }
            for (ImportNode importNode : module.getStarImports()) {
                if (importNode.getType() != null) {
                    tmp = new ConstructedNestedClass(importNode.getType(), name);
                    if (this.resolutionFailed.contains(tmp.getName())) continue;
                    if (this.resolve(tmp, false, false, true) && Modifier.isStatic(tmp.getModifiers())) {
                        this.ambiguousClass(type, tmp, name);
                        return true;
                    }
                    this.resolutionFailed.add(tmp.getName());
                    continue;
                }
                tmp = new ConstructedClassWithPackage(importNode.getPackageName(), name);
                if (this.resolutionFailed.contains(tmp.getName())) continue;
                if (this.resolve(tmp, false, false, true)) {
                    this.ambiguousClass(type, tmp, name);
                    return true;
                }
                this.resolutionFailed.add(tmp.getName());
            }
        }
        return false;
    }

    protected boolean resolveToOuter(ClassNode type) {
        String name = type.getName();
        if (type instanceof LowerCaseClass) {
            this.classNodeResolver.cacheClass(name, ClassNodeResolver.NO_CLASS);
            return false;
        }
        if (this.currentClass.getModule().hasPackageName() && name.indexOf(46) == -1) {
            return false;
        }
        ClassNodeResolver.LookupResult lr = this.classNodeResolver.resolveName(name, this.compilationUnit);
        if (lr != null) {
            if (lr.isSourceUnit()) {
                SourceUnit su = lr.getSourceUnit();
                this.currentClass.getCompileUnit().addClassNodeToCompile(type, su);
            } else {
                type.setRedirect(lr.getClassNode());
            }
            return true;
        }
        return false;
    }

    public Expression transform(Expression exp) {
        Expression ret;
        if (exp == null) {
            return null;
        }
        if (exp instanceof VariableExpression) {
            ret = this.transformVariableExpression((VariableExpression)exp);
        } else if (exp.getClass() == PropertyExpression.class) {
            ret = this.transformPropertyExpression((PropertyExpression)exp);
        } else if (exp instanceof DeclarationExpression) {
            ret = this.transformDeclarationExpression((DeclarationExpression)exp);
        } else if (exp instanceof BinaryExpression) {
            ret = this.transformBinaryExpression((BinaryExpression)exp);
        } else if (exp instanceof MethodCallExpression) {
            ret = this.transformMethodCallExpression((MethodCallExpression)exp);
        } else if (exp instanceof ClosureExpression) {
            ret = this.transformClosureExpression((ClosureExpression)exp);
        } else if (exp instanceof ConstructorCallExpression) {
            ret = this.transformConstructorCallExpression((ConstructorCallExpression)exp);
        } else if (exp instanceof AnnotationConstantExpression) {
            ret = this.transformAnnotationConstantExpression((AnnotationConstantExpression)exp);
        } else {
            this.resolveOrFail(exp.getType(), (ASTNode)exp);
            ret = exp.transformExpression((ExpressionTransformer)this);
        }
        if (ret != null && ret != exp) {
            ret.setSourcePosition((ASTNode)exp);
        }
        return ret;
    }

    private static String lookupClassName(PropertyExpression pe) {
        boolean doInitialClassTest = true;
        StringBuilder name = new StringBuilder(32);
        PropertyExpression expr = pe;
        while (expr != null && name != null) {
            if (expr instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)expr;
                if (ve.isSuperExpression() || ve.isThisExpression()) {
                    return null;
                }
                String varName = ve.getName();
                Tuple2<StringBuilder, Boolean> classNameInfo = ResolveVisitor.makeClassName(doInitialClassTest, name, varName);
                name = (StringBuilder)classNameInfo.getV1();
                doInitialClassTest = (Boolean)classNameInfo.getV2();
                break;
            }
            if (expr.getClass() != PropertyExpression.class) {
                return null;
            }
            String property = expr.getPropertyAsString();
            if (property == null || property.equals("class")) {
                return null;
            }
            Tuple2<StringBuilder, Boolean> classNameInfo = ResolveVisitor.makeClassName(doInitialClassTest, name, property);
            name = (StringBuilder)classNameInfo.getV1();
            doInitialClassTest = (Boolean)classNameInfo.getV2();
            expr = expr.getObjectExpression();
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        return name.toString();
    }

    private static Tuple2<StringBuilder, Boolean> makeClassName(boolean doInitialClassTest, StringBuilder name, String varName) {
        if (doInitialClassTest) {
            if (!ResolveVisitor.testVanillaNameForClass(varName)) {
                return Tuple.tuple(null, (Object)Boolean.TRUE);
            }
            return Tuple.tuple((Object)new StringBuilder(varName), (Object)Boolean.FALSE);
        }
        name.insert(0, String.valueOf(varName) + ".");
        return Tuple.tuple((Object)name, (Object)Boolean.FALSE);
    }

    private static Expression correctClassClassChain(PropertyExpression pe) {
        ClassExpression ce = null;
        LinkedList<PropertyExpression> stack = new LinkedList<PropertyExpression>();
        PropertyExpression e = pe;
        while (e != null) {
            if (e.getClass() != PropertyExpression.class) {
                if (e instanceof ClassExpression) {
                    ce = (ClassExpression)e;
                    break;
                }
                return pe;
            }
            stack.push(e);
            e = e.getObjectExpression();
        }
        if (ce == null) {
            return pe;
        }
        PropertyExpression classProperty = (PropertyExpression)stack.pop();
        String propertyName = classProperty.getPropertyAsString();
        if (propertyName == null || !propertyName.equals("class")) {
            return pe;
        }
        ce.setSourcePosition((ASTNode)classProperty);
        if (stack.isEmpty()) {
            return ce;
        }
        PropertyExpression classPropertyExpressionContainer = (PropertyExpression)stack.pop();
        classPropertyExpressionContainer.setObjectExpression((Expression)ce);
        return pe;
    }

    protected Expression transformPropertyExpression(PropertyExpression pe) {
        ClassNode type;
        Expression property;
        Expression objectExpression = pe.getObjectExpression();
        boolean ipe = this.inPropertyExpression;
        boolean itlp = this.isTopLevelProperty;
        try {
            this.inPropertyExpression = true;
            this.isTopLevelProperty = objectExpression.getClass() != PropertyExpression.class;
            objectExpression = this.transform(objectExpression);
            this.inPropertyExpression = false;
            property = this.transform(pe.getProperty());
        }
        finally {
            this.inPropertyExpression = ipe;
            this.isTopLevelProperty = itlp;
        }
        PropertyExpression xe = new PropertyExpression(objectExpression, property, pe.isSafe());
        xe.setSpreadSafe(pe.isSpreadSafe());
        xe.setSourcePosition((ASTNode)pe);
        String className = ResolveVisitor.lookupClassName(xe);
        if (className != null && this.resolve(type = ClassHelper.make(className))) {
            if (type instanceof ImmutableClassNode && !ClassHelper.isPrimitiveType(type)) {
                ClassNode wrapper = ClassHelper.makeWithoutCaching(className);
                wrapper.setRedirect(type);
                type = wrapper;
            }
            type.setStart(pe.getStart());
            type.setEnd(pe.getEnd());
            type.setNameStart2(property.getStart());
            return new ClassExpression(type);
        }
        if (objectExpression instanceof ClassExpression && property instanceof ConstantExpression) {
            ClassNode propertyOwner = objectExpression.getType();
            while (propertyOwner != null) {
                ConstructedNestedClass type2 = new ConstructedNestedClass(propertyOwner, xe.getPropertyAsString());
                if (this.resolve(type2, false, false, false) && (propertyOwner == objectExpression.getType() || ResolveVisitor.isVisibleNestedClass(type2, objectExpression.getType()))) {
                    type2.setNameStart2(property.getStart());
                    return new ClassExpression(type2);
                }
                propertyOwner = propertyOwner.getSuperClass();
            }
        }
        this.checkThisAndSuperAsPropertyAccess(xe);
        return this.isTopLevelProperty ? ResolveVisitor.correctClassClassChain(xe) : xe;
    }

    private static boolean isVisibleNestedClass(ClassNode innerType, ClassNode outerType) {
        int modifiers = innerType.getModifiers();
        return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || !Modifier.isPrivate(modifiers) && Objects.equals(innerType.getPackageName(), outerType.getPackageName());
    }

    private boolean directlyImplementsTrait(ClassNode trait) {
        ClassNode[] interfaces = this.currentClass.getInterfaces();
        if (interfaces == null) {
            return this.currentClass.getSuperClass().equals(trait);
        }
        ClassNode[] classNodeArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode node = classNodeArray[n2];
            if (node.equals(trait)) {
                return true;
            }
            ++n2;
        }
        return this.currentClass.getSuperClass().equals(trait);
    }

    private void checkThisAndSuperAsPropertyAccess(PropertyExpression expression) {
        if (expression.isImplicitThis()) {
            return;
        }
        String prop = expression.getPropertyAsString();
        if (prop == null) {
            return;
        }
        if (!prop.equals("this") && !prop.equals("super")) {
            return;
        }
        ClassNode type = expression.getObjectExpression().getType();
        if (expression.getObjectExpression() instanceof ClassExpression) {
            if (!(this.currentClass instanceof InnerClassNode) && !Traits.isTrait(type)) {
                this.addError("The usage of 'Class.this' and 'Class.super' is only allowed in nested/inner classes.", (ASTNode)expression);
                return;
            }
            if (this.currentScope != null && !this.currentScope.isInStaticContext() && Traits.isTrait(type) && "super".equals(prop) && this.directlyImplementsTrait(type)) {
                return;
            }
            ClassNode iterType = this.currentClass;
            while (iterType != null) {
                if (iterType.equals(type)) break;
                iterType = iterType.getOuterClass();
            }
            if (iterType == null) {
                this.addError("The class '" + type.getName() + "' needs to be an outer class of '" + this.currentClass.getName() + "' when using '.this' or '.super'.", (ASTNode)expression);
            }
            if (!Modifier.isStatic(this.currentClass.getModifiers())) {
                return;
            }
            if (this.currentScope != null && !this.currentScope.isInStaticContext()) {
                return;
            }
            this.addError("The usage of 'Class.this' and 'Class.super' within static nested class '" + this.currentClass.getName() + "' is not allowed in a static context.", (ASTNode)expression);
        }
    }

    protected Expression transformVariableExpression(VariableExpression ve) {
        this.visitAnnotations((AnnotatedNode)ve);
        Variable v = ve.getAccessedVariable();
        if (v instanceof DynamicVariable) {
            String name = ve.getName();
            ClassNode t = ClassHelper.make(name);
            boolean isClass = t.isResolved();
            if (!isClass) {
                if (Character.isLowerCase(name.charAt(0))) {
                    t = new LowerCaseClass(name);
                }
                isClass = this.resolve(t);
            }
            if (isClass) {
                VariableScope scope = this.currentScope;
                while (scope != null && !scope.isRoot()) {
                    if (scope.removeReferencedClassVariable(ve.getName()) == null) break;
                    scope = scope.getParent();
                }
                ClassExpression ce = new ClassExpression(t);
                ce.setSourcePosition((ASTNode)ve);
                return ce;
            }
        } else if (!this.checkingVariableTypeInDeclaration) {
            return ve;
        }
        this.resolveOrFail(ve.getType(), (ASTNode)ve);
        ClassNode origin = ve.getOriginType();
        if (origin != ve.getType()) {
            this.resolveOrFail(origin, (ASTNode)ve);
        }
        return ve;
    }

    private static boolean testVanillaNameForClass(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return !Character.isLowerCase(name.charAt(0));
    }

    protected Expression transformBinaryExpression(BinaryExpression be) {
        Expression left = this.transform(be.getLeftExpression());
        if (be.getOperation().isA(1100) && left instanceof ClassExpression) {
            ClassExpression ce = (ClassExpression)left;
            String error = "you tried to assign a value to the class '" + ce.getType().getName() + "'";
            if (ce.getType().isScript()) {
                error = String.valueOf(error) + ". Do you have a script with this name?";
            }
            this.addError(error, (ASTNode)be.getLeftExpression());
            return be;
        }
        if (left instanceof ClassExpression && be.getOperation().isOneOf(new int[]{1905, 810, 811})) {
            if (be.getRightExpression() instanceof ListExpression) {
                ListExpression list = (ListExpression)be.getRightExpression();
                if (list.getExpressions().isEmpty()) {
                    return new ClassExpression(left.getType().makeArray());
                }
                boolean map = true;
                for (Expression expression : list.getExpressions()) {
                    if (expression instanceof MapEntryExpression) continue;
                    map = false;
                    break;
                }
                if (map) {
                    MapExpression me = new MapExpression();
                    for (Expression expression : list.getExpressions()) {
                        me.addMapEntryExpression((MapEntryExpression)this.transform(expression));
                    }
                    me.setSourcePosition((ASTNode)list);
                    return CastExpression.asExpression((ClassNode)left.getType(), (Expression)me);
                }
            } else if (be.getRightExpression() instanceof SpreadMapExpression) {
                SpreadMapExpression mapExpression = (SpreadMapExpression)be.getRightExpression();
                Expression right = this.transform(mapExpression.getExpression());
                return CastExpression.asExpression((ClassNode)left.getType(), (Expression)right);
            }
            if (be.getRightExpression() instanceof MapEntryExpression) {
                MapExpression me = new MapExpression();
                me.addMapEntryExpression((MapEntryExpression)this.transform(be.getRightExpression()));
                me.setSourcePosition((ASTNode)be.getRightExpression());
                return new CastExpression(left.getType(), (Expression)me);
            }
        }
        Expression right = this.transform(be.getRightExpression());
        be.setLeftExpression(left);
        be.setRightExpression(right);
        return be;
    }

    protected Expression transformClosureExpression(ClosureExpression ce) {
        boolean oldInClosure = this.inClosure;
        this.inClosure = true;
        Parameter[] parameterArray = ClosureUtils.getParametersSafe((ClosureExpression)ce);
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter p = parameterArray[n2];
            ClassNode t = p.getType();
            this.resolveOrFail(t, t);
            this.visitAnnotations(p);
            if (p.hasInitialExpression()) {
                p.setInitialExpression(this.transform(p.getInitialExpression()));
            }
            this.visitAnnotations(p);
            ++n2;
        }
        Statement code = ce.getCode();
        if (code != null) {
            code.visit((GroovyCodeVisitor)((Object)this));
        }
        this.inClosure = oldInClosure;
        return ce;
    }

    protected Expression transformConstructorCallExpression(ConstructorCallExpression cce) {
        if (!cce.isUsingAnonymousInnerClass()) {
            ClassNode type = cce.getType();
            this.resolveOrFail(type, (ASTNode)cce);
            if (type.isAbstract()) {
                this.addError("You cannot create an instance from the abstract " + ResolveVisitor.getDescription(type) + ".", (ASTNode)cce);
            }
        }
        return cce.transformExpression((ExpressionTransformer)this);
    }

    private static String getDescription(ClassNode node) {
        return String.valueOf(node.isInterface() ? "interface" : "class") + " '" + node.getName() + "'";
    }

    protected Expression transformMethodCallExpression(MethodCallExpression mce) {
        Expression args = this.transform(mce.getArguments());
        Expression method = this.transform(mce.getMethod());
        Expression object = this.transform(mce.getObjectExpression());
        this.resolveGenericsTypes(mce.getGenericsTypes());
        MethodCallExpression ret = new MethodCallExpression(object, method, args);
        ret.setGenericsTypes(mce.getGenericsTypes());
        ret.setMethodTarget(mce.getMethodTarget());
        ret.setImplicitThis(mce.isImplicitThis());
        ret.setSpreadSafe(mce.isSpreadSafe());
        ret.setSafe(mce.isSafe());
        return ret;
    }

    protected Expression transformDeclarationExpression(DeclarationExpression de) {
        this.visitAnnotations((AnnotatedNode)de);
        Expression oldLeft = de.getLeftExpression();
        this.checkingVariableTypeInDeclaration = true;
        Expression left = this.transform(oldLeft);
        this.checkingVariableTypeInDeclaration = false;
        if (left instanceof ClassExpression) {
            ClassExpression ce = (ClassExpression)left;
            this.addError("you tried to assign a value to the class " + ce.getType().getName(), (ASTNode)oldLeft);
            return de;
        }
        Expression right = this.transform(de.getRightExpression());
        if (right == de.getRightExpression()) {
            this.fixDeclaringClass(de);
            return de;
        }
        DeclarationExpression newDeclExpr = new DeclarationExpression(left, de.getOperation(), right);
        newDeclExpr.setDeclaringClass(de.getDeclaringClass());
        newDeclExpr.addAnnotations(de.getAnnotations());
        newDeclExpr.copyNodeMetaData((ASTNode)de);
        this.fixDeclaringClass(newDeclExpr);
        return newDeclExpr;
    }

    private void fixDeclaringClass(DeclarationExpression newDeclExpr) {
        if (newDeclExpr.getDeclaringClass() == null && this.currentMethod != null) {
            newDeclExpr.setDeclaringClass(this.currentMethod.getDeclaringClass());
        }
    }

    protected Expression transformAnnotationConstantExpression(AnnotationConstantExpression ace) {
        AnnotationNode an = (AnnotationNode)ace.getValue();
        ClassNode type = an.getClassNode();
        this.resolveOrFail(type, " for annotation", (ASTNode)an);
        for (Map.Entry entry : an.getMembers().entrySet()) {
            entry.setValue(this.transform((Expression)entry.getValue()));
        }
        return ace;
    }

    protected void visitAnnotation(AnnotationNode node) {
        this.resolveOrFail(node.getClassNode(), " for annotation", (ASTNode)node);
        for (Map.Entry entry : node.getMembers().entrySet()) {
            Expression value = ResolveVisitor.transformInlineConstants(this.transform((Expression)entry.getValue()));
            entry.setValue(value);
            this.checkAnnotationMemberValue(value);
        }
    }

    private static Expression transformInlineConstants(Expression exp) {
        if (exp instanceof AnnotationConstantExpression) {
            ConstantExpression ce = (ConstantExpression)exp;
            if (ce.getValue() instanceof AnnotationNode) {
                AnnotationNode an = (AnnotationNode)ce.getValue();
                for (Map.Entry entry : an.getMembers().entrySet()) {
                    entry.setValue(ResolveVisitor.transformInlineConstants((Expression)entry.getValue()));
                }
            }
        } else {
            return ExpressionUtils.transformInlineConstants(exp);
        }
        return exp;
    }

    private void checkAnnotationMemberValue(Expression newValue) {
        if (newValue instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)newValue;
            if (!(pe.getObjectExpression() instanceof ClassExpression)) {
                this.addError("unable to find class '" + pe.getText() + "' for annotation attribute constant", (ASTNode)pe.getObjectExpression());
            }
        } else if (newValue instanceof ListExpression) {
            ListExpression le = (ListExpression)newValue;
            for (Expression e : le.getExpressions()) {
                this.checkAnnotationMemberValue(e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitClass(ClassNode node) {
        ClassNode oldNode = this.currentClass;
        this.currentClass = node;
        Map<GenericsType.GenericsTypeName, GenericsType> outerNames = null;
        if (this.phase != 2 && !this.commencingResolution()) return;
        try {
            if (node instanceof InnerClassNode) {
                outerNames = this.genericParameterNames;
                this.genericParameterNames = new HashMap<GenericsType.GenericsTypeName, GenericsType>();
                if (!Modifier.isStatic(node.getModifiers())) {
                    this.genericParameterNames.putAll(outerNames);
                }
            } else {
                this.genericParameterNames.clear();
            }
            this.resolveGenericsHeader(node.getGenericsTypes());
            ModuleNode module = node.getModule();
            if (!module.hasImportsResolved()) {
                ClassNode type;
                Iterator<ImportNode> iterator = module.getImports().iterator();
                while (iterator.hasNext()) {
                    ImportNode importNode;
                    this.currImportNode = importNode = iterator.next();
                    type = importNode.getType();
                    if (this.resolve(type, false, false, true)) {
                        this.currImportNode = null;
                        continue;
                    }
                    this.currImportNode = null;
                    this.addError("unable to resolve class " + type.getName(), type);
                }
                for (ImportNode importNode : module.getStarImports()) {
                    if (importNode.getLineNumber() <= 0) continue;
                    this.currImportNode = importNode;
                    String importName = importNode.getPackageName();
                    ClassNode type2 = ClassHelper.makeWithoutCaching(importName = importName.substring(0, importName.length() - 1));
                    if (this.resolve(type2, false, false, true)) {
                        importNode.setType(type2);
                        type2.setStart(importNode.getStart() + 7);
                        type2.setEnd(type2.getStart() + importName.length());
                    }
                    this.currImportNode = null;
                }
                for (ImportNode importNode : module.getStaticImports().values()) {
                    type = importNode.getType();
                    if (!this.resolve(type, false, false, true)) {
                        this.addError("unable to resolve class " + type.getName(), type);
                        continue;
                    }
                    if (!this.resolve(type = ClassHelper.makeWithoutCaching(String.valueOf(type.getName()) + "$" + importNode.getFieldName()), false, false, true)) continue;
                    Expression nameExpr = importNode.getFieldNameExpr();
                    importNode.setFieldNameExpr(new ClassExpression(type));
                    importNode.getFieldNameExpr().setSourcePosition((ASTNode)nameExpr);
                }
                for (ImportNode importNode : module.getStaticStarImports().values()) {
                    type = importNode.getType();
                    if (this.resolve(type, false, false, true)) continue;
                    this.addError("unable to resolve class " + type.getName(), type);
                }
                module.setImportsResolved(true);
            }
            switch (this.phase) {
                case 0: 
                case 1: {
                    ClassNode in;
                    ClassNode sn = node.getUnresolvedSuperClass();
                    if (sn != null) {
                        this.resolveOrFail(sn, "", node, true);
                    }
                    ASTNode[] aSTNodeArray = node.getInterfaces();
                    int nameExpr = aSTNodeArray.length;
                    int type = 0;
                    while (type < nameExpr) {
                        in = aSTNodeArray[type];
                        this.resolveOrFail(in, "", node, true);
                        ++type;
                    }
                    if (sn != null) {
                        this.checkCyclicInheritance(node, sn);
                    }
                    aSTNodeArray = node.getInterfaces();
                    nameExpr = aSTNodeArray.length;
                    type = 0;
                    while (type < nameExpr) {
                        in = aSTNodeArray[type];
                        this.checkCyclicInheritance(node, in);
                        ++type;
                    }
                    if (node.getGenericsTypes() != null) {
                        aSTNodeArray = node.getGenericsTypes();
                        nameExpr = aSTNodeArray.length;
                        type = 0;
                        while (type < nameExpr) {
                            ASTNode gt = aSTNodeArray[type];
                            if (gt != null && ((GenericsType)gt).getUpperBounds() != null) {
                                ClassNode[] classNodeArray = ((GenericsType)gt).getUpperBounds();
                                int n = classNodeArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    ClassNode variant = classNodeArray[n2];
                                    if (variant.isGenericsPlaceHolder()) {
                                        this.checkCyclicInheritance(variant, ((GenericsType)gt).getType());
                                    }
                                    ++n2;
                                }
                            }
                            ++type;
                        }
                    }
                }
                case 2: {
                    Iterator<InnerClassNode> it = node.getInnerClasses();
                    while (it.hasNext()) {
                        InnerClassNode cn = it.next();
                        if (!cn.isAnonymous()) continue;
                        MethodNode enclosingMethod = cn.getEnclosingMethod();
                        if (enclosingMethod != null) {
                            this.resolveGenericsHeader(enclosingMethod.getGenericsTypes());
                        }
                        this.resolveOrFail(cn.getUnresolvedSuperClass(false), (ASTNode)cn);
                    }
                    if (this.phase == 1) return;
                    new VariableScopeVisitor(this.source).visitClass(node);
                    super.visitClass(node);
                    this.finishedResolution();
                }
                default: {
                    return;
                }
            }
        }
        finally {
            if (outerNames != null) {
                this.genericParameterNames = outerNames;
            }
            this.currentClass = oldNode;
        }
    }

    protected boolean commencingResolution() {
        return true;
    }

    protected void finishedResolution() {
    }

    private void checkCyclicInheritance(ClassNode node, ClassNode type) {
        if (type.redirect() == node || type.getOuterClasses().contains(node)) {
            this.addError("Cycle detected: the type " + node.getUnresolvedName() + " cannot extend/implement itself or one of its own member types", type);
            node.setHasInconsistentHierarchy(true);
        } else if (type != ClassHelper.OBJECT_TYPE) {
            HashSet<ClassNode> done = new HashSet<ClassNode>();
            done.add(ClassHelper.OBJECT_TYPE);
            done.add(null);
            LinkedList<ClassNode> todo = new LinkedList<ClassNode>();
            Collections.addAll(todo, type.getInterfaces());
            todo.add(type.getUnresolvedSuperClass());
            todo.add(type.getOuterClass());
            do {
                ClassNode next;
                if (!done.add(next = (ClassNode)todo.poll())) continue;
                if (next.redirect() == node) {
                    ClassNode cn = type;
                    while (cn.getOuterClass() != null) {
                        cn = cn.getOuterClass();
                    }
                    this.addError("Cycle detected: a cycle exists in the type hierarchy between " + node.getName() + " and " + cn.getName(), type);
                    node.setHasInconsistentHierarchy(true);
                    return;
                }
                Collections.addAll(todo, next.getInterfaces());
                todo.add(next.getUnresolvedSuperClass());
                todo.add(next.getOuterClass());
            } while (!todo.isEmpty());
        }
    }

    public void visitCatchStatement(CatchStatement cs) {
        this.resolveOrFail(cs.getExceptionType(), (ASTNode)cs);
        if (cs.getExceptionType() == ClassHelper.DYNAMIC_TYPE) {
            cs.getVariable().setType(ClassHelper.make(Exception.class));
        }
        super.visitCatchStatement(cs);
    }

    public void visitForLoop(ForStatement forLoop) {
        this.resolveOrFail(forLoop.getVariableType(), (ASTNode)((Object)forLoop));
        super.visitForLoop(forLoop);
    }

    public void visitBlockStatement(BlockStatement block) {
        VariableScope oldScope = this.currentScope;
        this.currentScope = block.getVariableScope();
        try {
            super.visitBlockStatement(block);
        }
        finally {
            this.currentScope = oldScope;
        }
    }

    private boolean resolveGenericsTypes(GenericsType[] types) {
        if (types == null) {
            return true;
        }
        this.currentClass.setUsingGenerics(true);
        boolean resolved = true;
        GenericsType[] genericsTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            GenericsType type = genericsTypeArray[n2];
            resolved = this.resolveGenericsType(type) && resolved;
            ++n2;
        }
        return resolved;
    }

    private void resolveGenericsHeader(GenericsType[] types) {
        this.resolveGenericsHeader(types, null, 0);
    }

    private void resolveGenericsHeader(GenericsType[] types, GenericsType rootType, int level) {
        if (types == null) {
            return;
        }
        this.currentClass.setUsingGenerics(true);
        LinkedList<Tuple2> upperBoundsWithGenerics = new LinkedList<Tuple2>();
        LinkedList<Tuple2> upperBoundsToResolve = new LinkedList<Tuple2>();
        GenericsType[] genericsTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            GenericsType type = genericsTypeArray[n2];
            if (level <= 0 || !type.getName().equals(rootType.getName())) {
                boolean dealWithGenerics;
                String name = type.getName();
                ClassNode typeType = type.getType();
                GenericsType.GenericsTypeName gtn = new GenericsType.GenericsTypeName(name);
                boolean isWildcardGT = QUESTION_MARK.equals(name);
                boolean bl = dealWithGenerics = level == 0 || level > 0 && this.genericParameterNames.get(gtn) != null;
                if (type.getUpperBounds() != null) {
                    boolean nameAdded = false;
                    ClassNode[] classNodeArray = type.getUpperBounds();
                    int n3 = classNodeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ClassNode upperBound = classNodeArray[n4];
                        if (upperBound != null && !upperBound.hasInconsistentHierarchy()) {
                            if (!isWildcardGT) {
                                if (!(nameAdded && this.resolve(typeType) || !dealWithGenerics)) {
                                    type.setPlaceholder(true);
                                    typeType.setRedirect(upperBound);
                                    this.genericParameterNames.put(gtn, type);
                                    nameAdded = true;
                                }
                                upperBoundsToResolve.add(Tuple.tuple((Object)upperBound, (Object)typeType));
                            }
                            if (upperBound.isUsingGenerics()) {
                                upperBoundsWithGenerics.add(Tuple.tuple((Object)upperBound, (Object)type));
                            }
                        }
                        ++n4;
                    }
                } else if (!isWildcardGT && dealWithGenerics) {
                    type.setPlaceholder(true);
                    GenericsType last = this.genericParameterNames.put(gtn, type);
                    typeType.setRedirect(last != null ? last.getType().redirect() : ClassHelper.OBJECT_TYPE);
                }
            }
            ++n2;
        }
        for (Tuple2 tp : upperBoundsToResolve) {
            ClassNode upperBound = (ClassNode)tp.getV1();
            ClassNode classNode = (ClassNode)tp.getV2();
            this.resolveOrFail(upperBound, classNode);
        }
        for (Tuple2 tp : upperBoundsWithGenerics) {
            ClassNode upperBound = (ClassNode)tp.getV1();
            GenericsType gt = (GenericsType)tp.getV2();
            this.resolveGenericsHeader(upperBound.getGenericsTypes(), level == 0 ? gt : rootType, level + 1);
        }
    }

    private boolean resolveGenericsType(GenericsType genericsType) {
        if (genericsType.isResolved()) {
            return true;
        }
        this.currentClass.setUsingGenerics(true);
        ClassNode type = genericsType.getType();
        GenericsType.GenericsTypeName name = new GenericsType.GenericsTypeName(type.getName());
        ClassNode[] bounds = genericsType.getUpperBounds();
        if (!this.genericParameterNames.containsKey(name)) {
            if (bounds != null) {
                ClassNode[] classNodeArray = bounds;
                int n = bounds.length;
                int n2 = 0;
                while (n2 < n) {
                    ClassNode upperBound = classNodeArray[n2];
                    this.resolveOrFail(upperBound, genericsType);
                    type.setRedirect(upperBound);
                    this.resolveGenericsTypes(upperBound.getGenericsTypes());
                    ++n2;
                }
            } else if (genericsType.isWildcard()) {
                type.setRedirect(ClassHelper.OBJECT_TYPE);
            } else {
                this.resolveOrFail(type, genericsType);
            }
        } else {
            GenericsType gt = this.genericParameterNames.get(name);
            type.setRedirect(gt.getType());
            type.setDeclaringClass(gt.getType().getDeclaringClass());
            genericsType.setPlaceholder(true);
        }
        if (genericsType.getLowerBound() != null) {
            this.resolveOrFail(genericsType.getLowerBound(), genericsType);
        }
        if (this.resolveGenericsTypes(type.getGenericsTypes())) {
            genericsType.setResolved(genericsType.getType().isResolved());
        }
        return genericsType.isResolved();
    }

    private static void resolveWildcardBounding(GenericsType[] typeArguments, ClassNode type) {
        int i = 0;
        int n = typeArguments.length;
        while (i < n) {
            ClassNode implicitBound;
            GenericsType[] parameters;
            GenericsType argument = typeArguments[i];
            if (argument.isWildcard() && argument.getUpperBounds() == null && (parameters = type.redirect().getGenericsTypes()) != null && i < parameters.length && !ClassHelper.OBJECT_TYPE.equals(implicitBound = parameters[i].getType())) {
                argument.getType().setRedirect(implicitBound);
            }
            ++i;
        }
    }

    private static class ConstructedClassWithPackage
    extends ClassNode {
        final String prefix;
        String className;

        public ConstructedClassWithPackage(String pkg, String name) {
            super(String.valueOf(pkg) + name, 1, ClassHelper.OBJECT_TYPE);
            this.isPrimaryNode = false;
            this.prefix = pkg;
            this.className = name;
        }

        @Override
        public String getName() {
            if (this.redirect() != this) {
                return super.getName();
            }
            return String.valueOf(this.prefix) + this.className;
        }

        @Override
        public boolean hasPackageName() {
            if (this.redirect() != this) {
                return super.hasPackageName();
            }
            return this.className.indexOf(46) != -1;
        }

        @Override
        public String setName(String name) {
            if (this.redirect() != this) {
                return super.setName(name);
            }
            throw new GroovyBugError("ConstructedClassWithPackage#setName should not be called");
        }
    }

    private static class ConstructedNestedClass
    extends ClassNode {
        final ClassNode knownEnclosingType;

        public ConstructedNestedClass(ClassNode outer, String inner) {
            super(String.valueOf(outer.getName()) + "$" + inner.replace('.', '$'), 1, ClassHelper.OBJECT_TYPE);
            this.knownEnclosingType = outer;
            this.isPrimaryNode = false;
        }

        @Override
        public String getUnresolvedName() {
            return super.getUnresolvedName().replace(this.knownEnclosingType.getName(), this.knownEnclosingType.getUnresolvedName());
        }

        @Override
        public boolean hasPackageName() {
            if (this.redirect() != this) {
                return super.hasPackageName();
            }
            return this.knownEnclosingType.hasPackageName();
        }

        @Override
        public String setName(String name) {
            if (this.redirect() != this) {
                return super.setName(name);
            }
            throw new GroovyBugError("ConstructedNestedClass#setName should not be called");
        }
    }

    private static class LowerCaseClass
    extends ClassNode {
        final String className;

        public LowerCaseClass(String name) {
            super(name, 1, ClassHelper.OBJECT_TYPE);
            this.isPrimaryNode = false;
            this.className = name;
        }

        @Override
        public String getName() {
            if (this.redirect() != this) {
                return super.getName();
            }
            return this.className;
        }

        @Override
        public boolean hasPackageName() {
            if (this.redirect() != this) {
                return super.hasPackageName();
            }
            return false;
        }

        @Override
        public String setName(String name) {
            if (this.redirect() != this) {
                return super.setName(name);
            }
            throw new GroovyBugError("LowerCaseClass#setName should not be called");
        }
    }
}

