/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.requestor;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.ASTNodeFinder;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.CodeSelectRequestor;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.jdt.groovy.model.GroovyClassFileWorkingCopy;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.model.ICodeSelectHelper;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.groovy.core.util.GroovyCodeVisitorAdapter;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorFactory;
import org.eclipse.jdt.groovy.search.TypeInferencingVisitorWithRequestor;

public class CodeSelectHelper
implements ICodeSelectHelper {
    public IJavaElement[] select(GroovyCompilationUnit unit, int start, int length) {
        ModuleNode module;
        char[] contents = unit.getContents();
        if (start >= 0 && length == 0) {
            while (start > 0 && Character.isJavaIdentifierPart(contents[start - 1])) {
                --start;
                ++length;
            }
            while (contents.length > start + length && Character.isJavaIdentifierPart(contents[start + length])) {
                ++length;
            }
        }
        if (length > 1 && contents.length > start + 1 && contents[start] == '$' && contents[start + 1] != '{') {
            ++start;
            --length;
        }
        if ((module = unit.getModuleNode()) != null) {
            String event;
            block15: {
                IJavaElement[] iJavaElementArray;
                block18: {
                    Region region;
                    ASTNode node;
                    Region select;
                    block16: {
                        IJavaElement[] iJavaElementArray2;
                        block17: {
                            event = null;
                            if (GroovyLogManager.manager.hasLoggers()) {
                                GroovyLogManager.manager.log(TraceCategory.CODE_SELECT, unit.getElementName() + " at [" + start + "," + length + "]");
                                event = "Code select: " + unit.getElementName();
                                GroovyLogManager.manager.logStart(event);
                            }
                            select = new Region(start, length);
                            Object[] result = this.findNodeForRegion(module, select);
                            node = (ASTNode)result[0];
                            region = (Region)result[1];
                            if (node != null && start > 0 && node.getStart() == start - 1 && contents[start - 1] == '$') {
                                --start;
                                ++length;
                            }
                            if (!(node instanceof AnnotatedNode) || CodeSelectHelper.isKeyword(node, contents, start, length) || CodeSelectHelper.isStringLiteral(node, contents, start, length)) break block15;
                            if (!CodeSelectHelper.isTypeDeclaration(node, module)) break block16;
                            iJavaElementArray2 = CodeSelectHelper.returnThisNode(node, unit);
                            if (event == null) break block17;
                            GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
                        }
                        return iJavaElementArray2;
                    }
                    try {
                        CodeSelectRequestor requestor = this.createRequestor(node, region, select, unit);
                        TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(unit);
                        visitor.visitCompilationUnit((ITypeRequestor)requestor);
                        iJavaElementArray = requestor.getRequestedElements();
                        if (event == null) break block18;
                    }
                    catch (RuntimeException e) {
                        try {
                            if (event != null) {
                                GroovyLogManager.manager.logException(TraceCategory.CODE_SELECT, (Throwable)e);
                            }
                            throw e;
                        }
                        catch (Throwable throwable) {
                            if (event != null) {
                                GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
                            }
                            throw throwable;
                        }
                    }
                    GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
                }
                return iJavaElementArray;
            }
            if (event != null) {
                GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
            }
        }
        return new IJavaElement[0];
    }

    public ASTNode selectASTNode(GroovyCompilationUnit unit, int start, int length) {
        ModuleNode module = unit.getModuleNode();
        if (module != null) {
            String event;
            block7: {
                ASTNode aSTNode;
                block10: {
                    Region region;
                    ASTNode node;
                    Region select;
                    block8: {
                        ClassNode classNode;
                        block9: {
                            event = null;
                            if (GroovyLogManager.manager.hasLoggers()) {
                                GroovyLogManager.manager.log(TraceCategory.CODE_SELECT, "Code select on " + unit.getElementName() + " at [ " + start + "," + length + " ]");
                                event = "Code select: " + unit.getElementName();
                                GroovyLogManager.manager.logStart(event);
                            }
                            try {
                                select = new Region(start, length);
                                Object[] result = this.findNodeForRegion(module, select);
                                node = (ASTNode)result[0];
                                region = (Region)result[1];
                                if (node == null) break block7;
                                if (!CodeSelectHelper.isTypeDeclaration(node, module)) break block8;
                                classNode = ((ClassNode)node).redirect();
                                if (event == null) break block9;
                            }
                            catch (Throwable throwable) {
                                if (event != null) {
                                    GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
                                }
                                throw throwable;
                            }
                            GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
                        }
                        return classNode;
                    }
                    CodeSelectRequestor requestor = this.createRequestor(node, region, select, unit);
                    TypeInferencingVisitorWithRequestor visitor = new TypeInferencingVisitorFactory().createVisitor(unit);
                    visitor.visitCompilationUnit((ITypeRequestor)requestor);
                    aSTNode = requestor.getRequestedNode();
                    if (event == null) break block10;
                    GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
                }
                return aSTNode;
            }
            if (event != null) {
                GroovyLogManager.manager.logEnd(event, TraceCategory.CODE_SELECT);
            }
        }
        return null;
    }

    protected CodeSelectRequestor createRequestor(ASTNode node, Region nodeRegion, Region selectRegion, GroovyCompilationUnit unit) {
        return new CodeSelectRequestor(node, nodeRegion, selectRegion, unit);
    }

    protected Object[] findNodeForRegion(ModuleNode module, Region r) {
        ASTNodeFinder finder = new ASTNodeFinder(r);
        finder.doVisit(module);
        return new Object[]{finder.result, finder.sloc};
    }

    protected static boolean isKeyword(ASTNode node, final char[] contents, final int start, final int length) {
        if (node instanceof Expression) {
            final boolean[] keyword = new boolean[1];
            node.visit((GroovyCodeVisitor)new GroovyCodeVisitorAdapter(){

                public void visitCastExpression(CastExpression expr) {
                    keyword[0] = expr.isCoerce() && length == 2 && String.valueOf(contents, start, length).equals("as");
                }

                public void visitClassExpression(ClassExpression expr) {
                    keyword[0] = length == 5 && String.valueOf(contents, start, length).equals("class");
                }

                public void visitConstantExpression(ConstantExpression expr) {
                    keyword[0] = expr.isNullExpression() || expr.isTrueExpression() || expr.isFalseExpression() || length == 4 && expr.getText().equals("this") || length == 5 && expr.getText().equals("super");
                }

                public void visitConstructorCallExpression(ConstructorCallExpression expr) {
                    keyword[0] = length == 3 && start < expr.getNameStart() && String.valueOf(contents, start, length).equals("new");
                }

                public void visitMethodCallExpression(MethodCallExpression expr) {
                    keyword[0] = expr.getMethodAsString().equals("isCase") && length == 2 && String.valueOf(contents, start, length).equals("in");
                }

                public void visitMethodPointerExpression(MethodPointerExpression expr) {
                    keyword[0] = length == 2;
                }

                public void visitVariableExpression(VariableExpression expr) {
                    keyword[0] = expr.isThisExpression();
                }
            });
            return keyword[0];
        }
        if (node instanceof ImportNode) {
            ImportNode imp = (ImportNode)node;
            switch (length) {
                case 1: {
                    if (!imp.isStar() || start != node.getEnd() - 1) break;
                    return true;
                }
                case 2: {
                    if (imp.getAliasExpr() == null || !String.valueOf(contents, start, length).equals("as")) break;
                    return true;
                }
                case 6: {
                    if (start != node.getStart() && (!imp.isStatic() || start >= node.getStart() + 14)) break;
                    return true;
                }
            }
        }
        return length >= 3 && String.valueOf(contents, start, length).matches("def|var|final");
    }

    protected static boolean isStringLiteral(ASTNode node, char[] contents, int start, int length) {
        if (node instanceof ConstantExpression && ((ConstantExpression)node).getType().equals((Object)ClassHelper.STRING_TYPE)) {
            return start > node.getStart() && length < node.getLength();
        }
        if (node instanceof MethodNode) {
            return start > ((MethodNode)node).getNameStart() && start + length <= ((MethodNode)node).getNameEnd();
        }
        return false;
    }

    protected static boolean isTypeDeclaration(ASTNode node, ModuleNode module) {
        if (node instanceof ClassNode && ((ClassNode)node).getOuterClass() == null && !((ClassNode)node).isGenericsPlaceHolder()) {
            for (ClassNode clazz : module.getClasses()) {
                if (!clazz.equals((Object)node)) continue;
                return true;
            }
        }
        return false;
    }

    protected static IJavaElement[] returnThisNode(ASTNode node, GroovyCompilationUnit unit) {
        String rawName = ((ClassNode)node).getNameWithoutPackage();
        String[] enclosingTypes = rawName.split("\\$");
        IJavaElement candidate = null;
        int i = 0;
        int n = enclosingTypes.length;
        while (i < n) {
            candidate = i == 0 ? unit.getType(enclosingTypes[i]) : candidate.getType(enclosingTypes[i]);
            ++i;
        }
        IJavaElement result = unit instanceof GroovyClassFileWorkingCopy ? ((GroovyClassFileWorkingCopy)unit).convertToBinary(candidate) : candidate;
        return new IJavaElement[]{result};
    }
}

