/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.application.event;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.recorder.web.application.event.IWebViewUpdateEventBus;
import com.katalon.recorder.web.application.event.WebViewUpdateEvent;
import com.katalon.recorder.web.constant.WebViewUpdateEventType;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import jakarta.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class WebViewUpdateEventBus
implements IWebViewUpdateEventBus {
    private static final Logger logger = LoggerFactory.getLogger(WebViewUpdateEventBus.class);
    private final Subject<WebViewUpdateEvent> webViewUpdateEventSubject = PublishSubject.create();

    @Inject
    public WebViewUpdateEventBus() {
    }

    public void publishUpdateWebViewEvent(WebViewUpdateEvent event) {
        try {
            logger.info("Publishing WebViewUpdateEvent | type = {} | event = {}", (Object)event.getClass().getName(), (Object)new ObjectMapper().writeValueAsString((Object)event));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        this.webViewUpdateEventSubject.onNext((Object)event);
    }

    public <T extends WebViewUpdateEvent> Observable<T> getWebViewUpdateObservableToSubscribe(Class<T> clazz) {
        return this.webViewUpdateEventSubject.filter(clazz::isInstance).cast(clazz);
    }

    public <T extends WebViewUpdateEvent> Observable<T> getWebViewUpdateObservableToSubscribe(Class<T> clazz, WebViewUpdateEventType type) {
        return this.webViewUpdateEventSubject.filter(clazz::isInstance).cast(clazz).filter(event -> event.getType() == type);
    }

    public <T extends WebViewUpdateEvent> Observable<T> getWebViewUpdateObservableToSubscribe(Class<T> clazz, Predicate<T> predicate) {
        return this.webViewUpdateEventSubject.filter(clazz::isInstance).cast(clazz).filter(predicate);
    }
}

