/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.domain.manager;

import com.katalon.capability.constant.DriverType;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.core.constant.WebRecorderEngineType;
import com.katalon.recorder.core.domain.manager.ITestCaseManager;
import com.katalon.recorder.core.domain.manager.IVariableManager;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.web.domain.exception.ExtensionNotFoundException;
import com.katalon.recorder.web.domain.exception.LoadExtensionFileException;
import com.katalon.recorder.web.domain.exception.UnsupportedDriverTypeException;
import com.katalon.recorder.web.domain.exception.WebDriverCreationException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionNotFoundException;
import com.katalon.recorder.web.domain.exception.WebRecordingRunStepsException;
import com.katalon.recorder.web.domain.manager.IWebCapturedObjectManager;
import com.katalon.recorder.web.domain.manager.IWebDriverManager;
import com.katalon.recorder.web.domain.manager.IWebRecorderSettingManager;
import com.katalon.recorder.web.domain.manager.IWebRecordingConnectionManager;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.domain.model.IWebDriverConnection;
import com.katalon.recorder.web.domain.model.IWebRecorderSetting;
import com.katalon.recorder.web.domain.model.IWebRecordingConnection;
import com.katalon.recorder.web.domain.model.IWebRecordingConnectionMetadata;
import com.katalon.recorder.web.domain.model.IWebRecordingSession;
import com.katalon.recorder.web.infrastructure.IWebDriverService;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class WebDriverManager
implements IWebDriverManager {
    private static final Logger logger = LoggerFactory.getLogger(WebDriverManager.class);
    private final IWebRecorderSettingManager webRecorderSettingManager;
    private final IWebDriverService webDriverService;
    private final ITestCaseManager testCaseManager;
    private final IWebCapturedObjectManager capturedObjectManager;
    private final IVariableManager variableManager;

    @Inject
    public WebDriverManager(IWebRecorderSettingManager webRecorderSettingManager, IWebDriverService webDriverService, ITestCaseManager testCaseManager, IWebCapturedObjectManager capturedObjectManager, IVariableManager variableManager) {
        this.webRecorderSettingManager = webRecorderSettingManager;
        this.webDriverService = webDriverService;
        this.testCaseManager = testCaseManager;
        this.capturedObjectManager = capturedObjectManager;
        this.variableManager = variableManager;
    }

    public IWebDriverConnection startWebDriver(DriverType driverType, String profile, String customCapabilityName, String startupUrl) throws ExtensionNotFoundException, LoadExtensionFileException, UnsupportedDriverTypeException, WebDriverCreationException {
        IWebRecorderSetting webRecorderSetting = this.webRecorderSettingManager.getWebRecorderSetting();
        return this.webDriverService.startWebDriver(webRecorderSetting.getRecorderEnginePort(), driverType, profile, customCapabilityName, startupUrl);
    }

    public void close(IWebDriverConnection connection) {
        DriverType driverType = connection.getDriverType();
        String profile = connection.getProfile();
        String customCapabilityName = connection.getCustomCapabilityName();
        try {
            this.webDriverService.close(connection.getWebDriverConnectionId());
            logger.info("WebDriverConnection closed | driverType = {} | profile = {} | customCapabilityName = {}", new Object[]{driverType, profile, customCapabilityName});
        }
        catch (Exception e) {
            logger.error("Exception when closing WebDriver", (Throwable)e);
        }
    }

    public void close() {
        this.webDriverService.close();
        logger.info("WebDriverManager closed");
    }

    public void runScript(IWebRecordingSession session, List<IStep> selectedSteps, IWebRecordingConnectionManager webRecordingConnectionManager) throws ExtensionNotFoundException, LoadExtensionFileException, UnsupportedDriverTypeException, WebDriverCreationException, WebRecordingRunStepsException {
        if (CollectionUtils.isEmpty(selectedSteps)) {
            return;
        }
        if (session == null || session.getRecordingRequest() == null) {
            throw new IllegalArgumentException("Session and recording request must not be null");
        }
        IWebDriverConnection driverConnection = this.getOrCreateDriverConnection(session);
        WebDriver webDriver = this.getWebDriver(driverConnection);
        this.executeScript(session, selectedSteps, driverConnection, webDriver);
        IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.subscribe("WEBUI_VERIFICATION/EXECUTION_FINISHED", event -> {
            WebRecorderEngineType engineType = Optional.ofNullable(session.getActiveConnection()).map(IWebRecordingConnection::getMetadata).map(IWebRecordingConnectionMetadata::getEngineType).orElse(null);
            if (WebRecorderEngineType.BUILT_IN == engineType) {
                try {
                    webRecordingConnectionManager.startRecording(session.getActiveConnection());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public Integer verifyAndHighlightTestObject(IWebDriverConnection connection, IWebCapturedObject capturedObject, LocatorType locatorType) throws WebRecordingConnectionNotFoundException {
        return this.webDriverService.verifyAndHighlightTestObject(connection.getWebDriverConnectionId(), capturedObject, locatorType);
    }

    public Integer takeScreenshot(IWebDriverConnection connection, IWebCapturedObject capturedObject, LocatorType locatorType) throws WebRecordingConnectionNotFoundException {
        return this.webDriverService.takeScreenshot(connection.getWebDriverConnectionId(), capturedObject, locatorType);
    }

    private IWebDriverConnection getOrCreateDriverConnection(IWebRecordingSession session) throws ExtensionNotFoundException, LoadExtensionFileException, UnsupportedDriverTypeException, WebDriverCreationException {
        IWebDriverConnection existingConnection = this.findExistingConnection(session);
        if (existingConnection != null) {
            return existingConnection;
        }
        return this.createNewDriverConnection(session);
    }

    public void stopRunningSteps() {
        this.webDriverService.stopRunningSteps();
    }

    private IWebDriverConnection findExistingConnection(IWebRecordingSession session) {
        if (session.getActiveConnection() != null) {
            return session.getActiveWebDriverConnection();
        }
        DriverType driverType = session.getRecordingRequest().getDriverType();
        return this.webDriverService.getActiveWebDriverConnection(driverType);
    }

    private IWebDriverConnection createNewDriverConnection(IWebRecordingSession session) throws ExtensionNotFoundException, LoadExtensionFileException, UnsupportedDriverTypeException, WebDriverCreationException {
        String profile = this.extractProfile(session);
        DriverType driverType = session.getRecordingRequest().getDriverType();
        String startupUrl = session.getRecordingRequest().getStartupUrl();
        return this.startWebDriver(driverType, profile, null, startupUrl);
    }

    private String extractProfile(IWebRecordingSession session) {
        if (!Boolean.TRUE.equals(session.getRecordingRequest().getWithProfile())) {
            return null;
        }
        return Optional.ofNullable(session.getRecorderSetting()).map(IWebRecorderSetting::getChromeProfile).orElse(null);
    }

    private WebDriver getWebDriver(IWebDriverConnection driverConnection) {
        String connectionId = driverConnection.getWebDriverConnectionId();
        return this.webDriverService.getWebDriver(connectionId);
    }

    private void executeScript(IWebRecordingSession session, List<IStep> selectedSteps, IWebDriverConnection driverConnection, WebDriver webDriver) throws WebRecordingRunStepsException {
        ScriptNodeWrapper scriptNodeWrapper = this.testCaseManager.parseStepsIntoScriptNodeWrapper(session.getContinuedTestCaseNodeWrapperMap(), selectedSteps);
        String sessionId = driverConnection.getWebDriverConnectionId();
        WebUIDriverType driverType = this.parseToWebUIDriverType(driverConnection.getDriverType());
        this.webDriverService.runScript(sessionId, driverType, webDriver, this.capturedObjectManager.parseToTestObjects(session.getCapturedObjects()), this.variableManager.parseToVariableEntities(session.getVariables()), scriptNodeWrapper);
    }

    private WebUIDriverType parseToWebUIDriverType(DriverType driverType) {
        switch (driverType) {
            case FIREFOX_DRIVER: {
                return WebUIDriverType.FIREFOX_DRIVER;
            }
            case EDGE_CHROMIUM_DRIVER: {
                return WebUIDriverType.EDGE_CHROMIUM_DRIVER;
            }
            case SAFARI_DRIVER: {
                return WebUIDriverType.SAFARI_DRIVER;
            }
            case HEADLESS_DRIVER: {
                return WebUIDriverType.HEADLESS_DRIVER;
            }
            case FIREFOX_HEADLESS_DRIVER: {
                return WebUIDriverType.FIREFOX_HEADLESS_DRIVER;
            }
        }
        return WebUIDriverType.CHROME_DRIVER;
    }
}

