/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.recorder.core.constant.LocatorType;
import com.katalon.recorder.web.constant.WebRecorderEngineMessageType;
import com.katalon.recorder.web.domain.event.IWebRecordingConnectionEventBus;
import com.katalon.recorder.web.domain.event.WebRecordingConnectionClosedEvent;
import com.katalon.recorder.web.domain.event.WebRecordingConnectionErrorOccurredEvent;
import com.katalon.recorder.web.domain.event.WebRecordingConnectionEvent;
import com.katalon.recorder.web.domain.event.WebRecordingConnectionOpenedEvent;
import com.katalon.recorder.web.domain.event.WebRecordingMessageReceivedEvent;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionClosedException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionMessageParsingException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionNotFoundException;
import com.katalon.recorder.web.domain.exception.WebRecordingConnectionSendMessageException;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.domain.model.IWebRecorderSetting;
import com.katalon.recorder.web.infrastructure.IWebRecorderEngineService;
import com.katalon.recorder.web.infrastructure.WebSocketEndpoint;
import com.katalon.recorder.web.infrastructure.dto.IEngineMessage;
import com.katalon.recorder.web.infrastructure.dto.SetRecorderSettingMessage;
import com.katalon.recorder.web.infrastructure.dto.StartRecordingMessage;
import com.katalon.recorder.web.infrastructure.dto.StopRecordingMessage;
import com.katalon.recorder.web.infrastructure.dto.TakeScreenshotObjectMessage;
import com.katalon.recorder.web.infrastructure.dto.UpdateEngineSettingMessage;
import com.katalon.recorder.web.infrastructure.dto.VerifyAndHighlightElementMessage;
import com.katalon.recorder.web.infrastructure.event.IWebSocketEventBus;
import com.katalon.recorder.web.infrastructure.event.WebSocketConnectionCloseEvent;
import com.katalon.recorder.web.infrastructure.event.WebSocketConnectionOpenEvent;
import com.katalon.recorder.web.infrastructure.event.WebSocketErrorOccurredEvent;
import com.katalon.recorder.web.infrastructure.event.WebSocketEventBus;
import com.katalon.recorder.web.infrastructure.event.WebSocketMessageReceivedEvent;
import com.kms.katalon.controller.ProjectController;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import jakarta.inject.Inject;
import jakarta.websocket.CloseReason;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class WebRecorderEngineService
implements IWebRecorderEngineService {
    private static final Logger logger = LoggerFactory.getLogger(WebRecorderEngineService.class);
    private static final String EQUALS = "=";
    private static final String SCREENSHOT_PATH = "/Screenshots/Targets/";
    private Server socketServer;
    private final ConcurrentHashMap<String, Session> sessions;
    private final IWebSocketEventBus webSocketEventBus;
    private final CompositeDisposable compositeDisposable;
    private final IWebRecordingConnectionEventBus webRecordingConnectionEventBus;

    @Inject
    public WebRecorderEngineService(IWebRecordingConnectionEventBus webRecordingConnectionEventBus) {
        this.webRecordingConnectionEventBus = webRecordingConnectionEventBus;
        this.sessions = new ConcurrentHashMap();
        this.webSocketEventBus = WebSocketEventBus.getInstance();
        this.compositeDisposable = new CompositeDisposable();
        this.subscribeWebSocketEvents();
    }

    public void openForConnection(IWebRecorderSetting webRecorderSetting) throws Exception {
        if (this.socketServer != null && this.socketServer.isRunning()) {
            logger.info("Recorder engine websocket server is already running | port = {}", (Object)this.socketServer.getURI().getPort());
            return;
        }
        int port = webRecorderSetting == null ? 50000 : webRecorderSetting.getRecorderEnginePort();
        this.socketServer = new Server(port);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        this.socketServer.setHandler((Handler)context);
        JakartaWebSocketServletContainerInitializer.configure((ServletContextHandler)context, (servletContext, serverContainer) -> serverContainer.addEndpoint(WebSocketEndpoint.class));
        this.socketServer.start();
        logger.info("Recorder engine websocket server start | port = {}", (Object)this.socketServer.getURI().getPort());
    }

    public void injectRecorderSetting(String recordingConnectionId, String exclusionPattern) throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        this.sendEngineMessage(recordingConnectionId, (IEngineMessage)new SetRecorderSettingMessage(exclusionPattern));
    }

    public void startRecording(String recordingConnectionId) throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        this.sendEngineMessage(recordingConnectionId, (IEngineMessage)new StartRecordingMessage());
    }

    public void stopRecording(String recordingConnectionId) throws WebRecordingConnectionClosedException, WebRecordingConnectionMessageParsingException, WebRecordingConnectionSendMessageException, WebRecordingConnectionNotFoundException {
        this.sendEngineMessage(recordingConnectionId, (IEngineMessage)new StopRecordingMessage());
    }

    private void sendEngineMessage(String recordingConnectionId, IEngineMessage message) throws WebRecordingConnectionClosedException, WebRecordingConnectionMessageParsingException, WebRecordingConnectionSendMessageException, WebRecordingConnectionNotFoundException {
        Session session = this.sessions.get(recordingConnectionId);
        if (session == null) {
            throw new WebRecordingConnectionNotFoundException("Web recorder engine socket session not found | id: " + recordingConnectionId);
        }
        if (!session.isOpen()) {
            throw new WebRecordingConnectionClosedException("Web recorder engine socket session has been closed");
        }
        try {
            RemoteEndpoint.Basic basicRemote = session.getBasicRemote();
            ObjectMapper objectMapper = new ObjectMapper();
            String data = objectMapper.writeValueAsString((Object)message);
            basicRemote.sendText(data);
            logger.info("Send message to recorder engine | id = {} | message = {}", (Object)recordingConnectionId, (Object)data);
        }
        catch (JsonProcessingException e) {
            throw new WebRecordingConnectionMessageParsingException("Exception when parsing message to JSON string", (Throwable)e);
        }
        catch (IOException e) {
            throw new WebRecordingConnectionSendMessageException("Exception when sending message via WebSocket", (Throwable)e);
        }
    }

    public void close(String recordingConnectionId) {
        try {
            Session session = this.sessions.remove(recordingConnectionId);
            if (session == null) {
                logger.error("Web recorder engine socket session not found | id = {}", (Object)recordingConnectionId);
                return;
            }
            try {
                if (session.isOpen()) {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Connection closed by server"));
                }
            }
            catch (Exception e) {
                logger.error("Exception when closing recorder engine socket connection", (Throwable)e);
            }
        }
        finally {
            logger.info("Close recorder engine socket connection | id = {} | remaining connections = {}", (Object)recordingConnectionId, (Object)this.sessions.size());
        }
    }

    public void closeForConnection() {
        try {
            try {
                this.webSocketEventBus.close();
                this.sessions.clear();
                if (this.socketServer != null && this.socketServer.isRunning()) {
                    this.socketServer.stop();
                }
            }
            catch (Exception e) {
                logger.error("Exception when stopping recorder engine webSocket server", (Throwable)e);
                logger.info("WebRecorderEngineService stopped");
            }
        }
        finally {
            logger.info("WebRecorderEngineService stopped");
        }
    }

    public void verifyAndHighlightObject(String recordingConnectionId, IWebCapturedObject capturedObject, LocatorType locatorType) throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        this.sendEngineMessage(recordingConnectionId, (IEngineMessage)new VerifyAndHighlightElementMessage(locatorType.name(), capturedObject.getLocator(locatorType)));
    }

    public void takeScreenshot(String recordingConnectionId, IWebCapturedObject capturedObject, LocatorType locatorType) throws WebRecordingConnectionClosedException, WebRecordingConnectionNotFoundException, WebRecordingConnectionSendMessageException, WebRecordingConnectionMessageParsingException {
        String capturedObjectName = capturedObject.getName();
        String locator = capturedObject.getLocator(capturedObject.getLocatorType());
        if (StringUtils.isBlank((CharSequence)locator)) {
            locator = capturedObject.getLocator(LocatorType.XPATH);
        }
        String currentProjectLocation = ProjectController.getInstance().getCurrentProject().getFolderLocation();
        String objectRepositoryFolder = capturedObject.getId().replace(capturedObjectName, "");
        String path = currentProjectLocation + SCREENSHOT_PATH + objectRepositoryFolder;
        this.sendEngineMessage(recordingConnectionId, (IEngineMessage)new TakeScreenshotObjectMessage(capturedObject.getId(), capturedObjectName, path, locator));
    }

    public void updateRecorderEngineSetting(String recordingConnectionId, boolean smartLocatorCaptureEnabledResult) throws WebRecordingConnectionClosedException, WebRecordingConnectionMessageParsingException, WebRecordingConnectionSendMessageException, WebRecordingConnectionNotFoundException {
        this.sendEngineMessage(recordingConnectionId, (IEngineMessage)new UpdateEngineSettingMessage(smartLocatorCaptureEnabledResult));
    }

    private void subscribeWebSocketEvents() {
        this.compositeDisposable.add(this.webSocketEventBus.getObservableToSubscribe(WebSocketConnectionOpenEvent.class).subscribe(event -> {
            Session session = event.getSession();
            this.sessions.put(event.getSessionId(), session);
            this.webRecordingConnectionEventBus.publishEvent((WebRecordingConnectionEvent)new WebRecordingConnectionOpenedEvent(event.getSessionId(), event.getDriverType(), event.getBrowserVersion(), event.getPageTitle(), event.getEngine(), event.getEngineType(), event.getEngineVersion(), event.getEngineExtensionId(), event.getSmartLocatorCaptureEnabled()));
        }));
        this.compositeDisposable.add(this.webSocketEventBus.getObservableToSubscribe(WebSocketConnectionCloseEvent.class).subscribe(event -> {
            this.webRecordingConnectionEventBus.publishEvent((WebRecordingConnectionEvent)new WebRecordingConnectionClosedEvent(event.getSessionId()));
            Session removed = this.sessions.remove(event.getSessionId());
            try {
                if (removed != null && removed.isOpen()) {
                    removed.close();
                }
            }
            catch (Exception e) {
                logger.error("Exception when closing socket connection after close event", (Throwable)e);
            }
        }));
        this.compositeDisposable.add(this.webSocketEventBus.getObservableToSubscribe(WebSocketErrorOccurredEvent.class).subscribe(event -> {
            logger.info("WebSocketErrorOccurred | sessionId = {}, error = {}", (Object)event.getSessionId(), (Object)event.getError().getMessage());
            this.webRecordingConnectionEventBus.publishEvent((WebRecordingConnectionEvent)new WebRecordingConnectionErrorOccurredEvent(event.getSessionId(), event.getError()));
            Session removed = this.sessions.remove(event.getSessionId());
            try {
                if (removed != null && removed.isOpen()) {
                    removed.close();
                }
            }
            catch (Exception e) {
                logger.error("Exception when closing socket connection after error event", (Throwable)e);
            }
        }));
        this.compositeDisposable.add(this.webSocketEventBus.getObservableToSubscribe(WebSocketMessageReceivedEvent.class).subscribe(event -> {
            try {
                String message = event.getMessage();
                String type = message.substring(0, message.indexOf(EQUALS));
                String data = message.substring(message.indexOf(EQUALS) + 1);
                this.webRecordingConnectionEventBus.publishEvent((WebRecordingConnectionEvent)new WebRecordingMessageReceivedEvent(event.getSessionId(), WebRecorderEngineMessageType.fromValue((String)type), data));
                logger.info("WebSocketMessageReceived | sessionId = {} | message = {}", (Object)event.getSessionId(), (Object)message);
            }
            catch (Exception e) {
                logger.error("Exception when handling message received event | sessionId = {} | message = {}", new Object[]{event.getSessionId(), event.getMessage(), e});
            }
        }));
    }
}

