/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.infrastructure;

import com.katalon.recorder.core.domain.model.ICapturedObject;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.IVariable;
import com.katalon.recorder.core.infrastructure.ITestCaseService;
import com.katalon.recorder.core.infrastructure.dto.ASTNodeWrapperAdapter;
import com.katalon.recorder.web.domain.exception.WebRecordingSaveException;
import com.katalon.recorder.web.domain.model.IWebCapturedObject;
import com.katalon.recorder.web.domain.model.IWebRecordingSession;
import com.katalon.recorder.web.infrastructure.IWebRecordingSessionService;
import com.katalon.recorder.web.infrastructure.util.WebElementUtils;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testcase.dialogs.NewTestCaseDialog;
import com.kms.katalon.composer.testcase.exceptions.GroovyParsingException;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.ScriptNodeWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.parser.GroovyWrapperParser;
import com.kms.katalon.composer.testcase.groovy.ast.statements.BlockStatementWrapper;
import com.kms.katalon.composer.testcase.groovy.ast.statements.ExpressionStatementWrapper;
import com.kms.katalon.composer.testcase.model.TestCaseTreeTableInput;
import com.kms.katalon.composer.testcase.parts.TestCaseCompositePart;
import com.kms.katalon.composer.testcase.parts.TestCasePart;
import com.kms.katalon.composer.webui.recorder.constants.ComposerWebuiRecorderMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testobject.events.TestObjectUpdatedEvent;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.objectspy.dialog.ObjectRepositoryService;
import com.kms.katalon.objectspy.dialog.SaveToObjectRepositoryDialog;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.element.WebParent;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.openqa.selenium.Keys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
@Singleton
public class WebRecordingSessionService
implements IWebRecordingSessionService {
    private static final Logger logger = LoggerFactory.getLogger(WebRecordingSessionService.class);
    private static final String DEFAULT_NEW_TEST_CASE_NAME = "New Test Case";
    private static final String RECORDER = "RECORDER";
    private final EModelService modelService;
    private final MApplication application;
    private final IEventBroker eventBroker;
    private final UISynchronize sync;
    private final ITestCaseService testCaseService;

    @Inject
    public WebRecordingSessionService(EModelService modelService, MApplication application, IEventBroker eventBroker, UISynchronize sync, ITestCaseService testCaseService) {
        this.modelService = modelService;
        this.application = application;
        this.eventBroker = eventBroker;
        this.sync = sync;
        this.testCaseService = testCaseService;
    }

    public Boolean save(IWebRecordingSession recordingSession) throws Exception {
        TestCaseCompositePart testCaseCompositePart;
        TestCaseEntity testCaseEntity;
        String testCaseId = recordingSession.getRecordingRequest().getTestCaseId();
        List<WebPage> capturedPages = this.convertCapturedObjects(recordingSession.getCapturedObjects());
        List capturedSteps = recordingSession.getSteps();
        VariableEntity[] variables = this.convertVariable(recordingSession.getVariables());
        if (StringUtils.isBlank((CharSequence)testCaseId) && capturedPages.isEmpty() && capturedSteps.isEmpty() && variables.length == 0) {
            return true;
        }
        Shell activeShell = Display.getDefault().getActiveShell();
        SaveToObjectRepositoryDialog addToObjectRepositoryDialog = new SaveToObjectRepositoryDialog(activeShell, true, capturedPages, capturedPages.toArray());
        if (addToObjectRepositoryDialog.open() != 0) {
            return false;
        }
        boolean shouldOverride = false;
        boolean isNew = false;
        if (StringUtils.isBlank((CharSequence)testCaseId)) {
            testCaseEntity = this.createNewTestCase(activeShell);
            if (testCaseEntity == null) {
                return false;
            }
            testCaseCompositePart = this.getTestCasePartByTestCase(testCaseEntity);
            isNew = true;
        } else {
            testCaseCompositePart = this.getSelectedTestCasePart();
            if (testCaseCompositePart == null) {
                throw new WebRecordingSaveException("Cannot find test case composite part | testCaseId = " + testCaseId);
            }
            testCaseEntity = testCaseCompositePart.getTestCase();
            MessageDialog dialog = new MessageDialog(activeShell, GlobalStringConstants.CONFIRMATION, null, MessageFormat.format(ComposerWebuiRecorderMessageConstants.DIA_APPEND_TEST_CASE_SCRIPT, testCaseEntity.getName()), 6, 0, new String[]{ComposerWebuiRecorderMessageConstants.DIA_CONFIRM_APPEND_TEST_CASE_SCRIPT, ComposerWebuiRecorderMessageConstants.DIA_CONFIRM_REPLACE_TEST_CASE_SCRIPT});
            shouldOverride = dialog.open() != 0;
        }
        SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult saveToObjectRepositoryDialogResult = this.saveCapturedObjects(recordingSession, capturedPages, addToObjectRepositoryDialog);
        ScriptNodeWrapper scriptNodeWrapper = this.buildScriptNodeWrapper(recordingSession, saveToObjectRepositoryDialogResult);
        this.updateRecordedElementsAfterSavingToObjectRepository(capturedPages, saveToObjectRepositoryDialogResult != null ? saveToObjectRepositoryDialogResult.getEntitySavedMap() : Collections.emptyMap());
        this.doGenerateTestScripts(testCaseEntity, testCaseCompositePart, saveToObjectRepositoryDialogResult, capturedPages, scriptNodeWrapper, variables, shouldOverride, isNew);
        return true;
    }

    private SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult saveCapturedObjects(IWebRecordingSession recordingSession, List<WebPage> capturedPages, SaveToObjectRepositoryDialog addToObjectRepositoryDialog) throws Exception {
        ObjectRepositoryService objectRepositoryService = new ObjectRepositoryService();
        SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult saveToObjectRepositoryDialogResult = addToObjectRepositoryDialog.getDialogResult();
        ObjectRepositoryService.SaveActionResult saveResult = objectRepositoryService.saveObjectForWebRecorder(saveToObjectRepositoryDialogResult);
        this.refreshExplorer(saveResult, addToObjectRepositoryDialog.getSelectedParentFolderResult());
        int totalCapturedObjects = this.countCapturedObjectsRecursively(recordingSession.getCapturedObjects());
        int capturedObjectsNumber = totalCapturedObjects - capturedPages.size();
        int savedObjectsNumber = saveResult.getSavedObjectCount();
        int duplicatedByObjectsID = addToObjectRepositoryDialog.getDuplicatedByObjectsID();
        int duplicatedByHashedAttributes = addToObjectRepositoryDialog.getDuplicatedByHashedAttributes();
        String chosenConflictOption = saveToObjectRepositoryDialogResult.getSelectedConflictOption().name();
        int duplicatedObjectsNumber = duplicatedByObjectsID + duplicatedByHashedAttributes;
        String capturedBy = RECORDER;
        Trackings.trackSaveWebSpy((int)capturedObjectsNumber, (int)savedObjectsNumber, (int)duplicatedObjectsNumber, (int)duplicatedByObjectsID, (int)duplicatedByHashedAttributes, (String)chosenConflictOption, (String)capturedBy);
        return saveToObjectRepositoryDialogResult;
    }

    private int countCapturedObjectsRecursively(List<? extends ICapturedObject> capturedObjects) {
        if (capturedObjects == null || capturedObjects.isEmpty()) {
            return 0;
        }
        int count = capturedObjects.size();
        for (ICapturedObject iCapturedObject : capturedObjects) {
            List children = iCapturedObject.getChildren();
            if (children == null || children.isEmpty()) continue;
            count += this.countCapturedObjectsRecursively(children);
        }
        return count;
    }

    private void refreshExplorer(ObjectRepositoryService.SaveActionResult saveResult, FolderTreeEntity selectedParentFolder) {
        this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)selectedParentFolder);
        for (Object[] testObj : saveResult.getUpdatedTestObjectIds()) {
            Object object = testObj[1];
            if (!(object instanceof WebElementEntity)) continue;
            WebElementEntity webElementEntity = (WebElementEntity)object;
            String webElementPk = String.valueOf(testObj[0]);
            this.eventBroker.post("TESTOBJECT/UPDATED", (Object)new TestObjectUpdatedEvent(webElementPk, (FileEntity)webElementEntity, TestObjectUpdatedEvent.TriggeredBy.RECORDING_SESSION));
        }
        if (saveResult.getNewSelectionOnExplorer() == null) {
            return;
        }
    }

    private TestCaseCompositePart getTestCasePartByTestCase(TestCaseEntity testCaseEntity) {
        if (testCaseEntity == null) {
            return null;
        }
        MPart selectedPart = (MPart)this.modelService.find(EntityPartUtil.getTestCaseCompositePartId((String)testCaseEntity.getId()), (MUIElement)this.application);
        if (selectedPart == null || !(selectedPart.getObject() instanceof TestCaseCompositePart)) {
            return null;
        }
        return (TestCaseCompositePart)selectedPart.getObject();
    }

    private ScriptNodeWrapper buildScriptNodeWrapper(IWebRecordingSession recordingSession, SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult saveToObjectRepositoryDialogResult) throws GroovyParsingException {
        Map entitySavedMap = saveToObjectRepositoryDialogResult.getEntitySavedMap();
        List capturedSteps = recordingSession.getSteps();
        Map continuedTestCaseNodeWrapperMap = recordingSession.getContinuedTestCaseNodeWrapperMap();
        ScriptNodeWrapper scriptNodeWrapper = new ScriptNodeWrapper();
        scriptNodeWrapper.addDefaultImports();
        scriptNodeWrapper.addImport(Keys.class);
        BlockStatementWrapper blockStatementWrapper = scriptNodeWrapper.getBlock();
        for (IStep step : capturedSteps) {
            if (StringUtils.isBlank((CharSequence)step.getAstRefId())) {
                ExpressionStatementWrapper expressionStatementWrapper = this.testCaseService.generateTestStep(step, scriptNodeWrapper, entitySavedMap);
                blockStatementWrapper.addChild((ASTNodeWrapper)expressionStatementWrapper);
                continue;
            }
            ASTNodeWrapperAdapter astNodeWrapperAdapter = (ASTNodeWrapperAdapter)continuedTestCaseNodeWrapperMap.get(step.getAstRefId());
            blockStatementWrapper.addChild(astNodeWrapperAdapter.getAstNodeWrapper());
        }
        StringBuilder stringBuilder = new StringBuilder();
        new GroovyWrapperParser(stringBuilder).parseGroovyAstIntoScript(scriptNodeWrapper);
        return GroovyWrapperParser.parseGroovyScriptIntoNodeWrapper((String)stringBuilder.toString());
    }

    private VariableEntity[] convertVariable(List<IVariable> variables) {
        return (VariableEntity[])Optional.ofNullable(variables).orElse(Collections.emptyList()).stream().map(variable -> {
            VariableEntity variableEntity = new VariableEntity();
            variableEntity.setName(variable.getName());
            variableEntity.setDefaultValue(Objects.isNull(variable.getDefaultBindingValue()) ? null : variable.getDefaultBindingValue().toString());
            variableEntity.setDescription(variable.getDescription());
            variableEntity.setMasked(variable.getMasked().booleanValue());
            return variableEntity;
        }).toArray(VariableEntity[]::new);
    }

    private void doGenerateTestScripts(final TestCaseEntity newTestCase, final TestCaseCompositePart testCaseCompositePart, final SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult folderSelectionResult, final List<WebPage> capturedElements, final ScriptNodeWrapper wrapper, final VariableEntity[] variables, final boolean shouldOverride, final boolean isNew) {
        if (testCaseCompositePart == null) {
            return;
        }
        final TestCasePart testCasePart = testCaseCompositePart.getChildTestCasePart();
        if (testCasePart.getTreeTableInput() == null) {
            testCaseCompositePart.loadTreeTableInput();
        }
        Job job = new Job(ComposerWebuiRecorderMessageConstants.JOB_GENERATE_SCRIPT_MESSAGE){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.beginTask(ComposerWebuiRecorderMessageConstants.JOB_GENERATE_SCRIPT_MESSAGE, -1);
                    WebRecordingSessionService.this.addRecordedElements(capturedElements, folderSelectionResult, monitor);
                    WebRecordingSessionService.this.sync.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                List children = wrapper.getBlock().getAstChildren();
                                if (children.isEmpty()) {
                                    return;
                                }
                                testCasePart.addDefaultImports();
                                testCasePart.getTreeTableInput().getMainClassNode().addImport(Keys.class);
                                if (shouldOverride) {
                                    testCasePart.clearAndAddStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
                                } else {
                                    testCasePart.addStatementsToMainBlock(children, TestCaseTreeTableInput.NodeAddType.Add, true);
                                }
                                testCasePart.addVariables(variables);
                                testCasePart.getTreeTableInput().setChanged(true);
                                testCaseCompositePart.changeScriptNode(testCasePart.getTreeTableInput().getMainClassNode());
                                testCaseCompositePart.recorderSave(isNew);
                                if (OSUtil.isMacBigSurOrLater() && testCaseCompositePart.getSelectedPart() == testCaseCompositePart.getChildManualPart() && testCasePart.getTestCaseTreeTable() != null) {
                                    testCasePart.getTestCaseTreeTable().getTree().redraw();
                                }
                            }
                            catch (Exception e) {
                                logger.error("Exception while save testCaseCompositePart", (Throwable)e);
                            }
                        }
                    });
                    if (folderSelectionResult != null) {
                        FolderTreeEntity targetFolderTreeEntity = folderSelectionResult.getSelectedParentFolder();
                        WebRecordingSessionService.this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)targetFolderTreeEntity.getParent());
                        WebRecordingSessionService.this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)targetFolderTreeEntity);
                        WebRecordingSessionService.this.eventBroker.send("EXPLORER/EXPAND_TREE_ENTITY", (Object)targetFolderTreeEntity);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    WebRecordingSessionService.this.sync.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalStringConstants.ERROR, (String)ComposerWebuiRecorderMessageConstants.HAND_ERROR_MSG_CANNOT_GEN_TEST_STEPS);
                        }
                    });
                    logger.error("Exception while generate test steps", (Throwable)e);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
                if (newTestCase != null && currentProfile.isNewUser() && !currentProfile.isDoneRunFirstTestCase()) {
                    currentProfile.setDoneSaveFirstRecord(true);
                    UserProfileHelper.saveProfile((UserProfile)currentProfile);
                    WebRecordingSessionService.this.eventBroker.post("FIRST_TEST_CASE_CREATED", (Object)newTestCase);
                }
            }
        });
        job.setUser(true);
        job.schedule();
    }

    private void addRecordedElements(List<WebPage> recordedElements, SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult folderSelectionResult, IProgressMonitor monitor) throws Exception {
        for (WebPage pageElement : recordedElements) {
            FolderEntity importedFolder = (FolderEntity)folderSelectionResult.getEntitySavedMap().get(pageElement);
            if (importedFolder != null) {
                pageElement.setFolderAlias(importedFolder);
            }
            for (WebElement childElement : pageElement.getChildren()) {
                this.addRecordedElement(childElement, importedFolder, folderSelectionResult);
            }
            monitor.worked(1);
        }
    }

    private void addRecordedElement(WebElement element, FolderEntity parentFolder, SaveToObjectRepositoryDialog.SaveToObjectRepositoryDialogResult folderSelectionResult) throws Exception {
        FileEntity entity = folderSelectionResult.getEntitySavedMap().entrySet().stream().filter(e -> {
            WebElement savedElement = (WebElement)e.getKey();
            WebPage savedRoot = savedElement.getRoot();
            if (savedRoot == null) {
                return false;
            }
            WebPage root = element.getRoot();
            return savedElement.equals((Object)element) && root != null && savedRoot.getName().equals(root.getName());
        }).map(Map.Entry::getValue).findFirst().orElse(null);
        if (entity != null) {
            element.setName(entity.getName());
        }
        if (element instanceof WebParent) {
            WebParent webParent = (WebParent)element;
            for (WebElement childElement : webParent.getChildren()) {
                this.addRecordedElement(childElement, parentFolder, folderSelectionResult);
            }
        }
    }

    private void updateRecordedElementsAfterSavingToObjectRepository(List<WebPage> recordedElements, Map<WebElement, FileEntity> entitySavedMap) {
        List recordedElementNames = recordedElements.stream().map(b -> b.getName()).collect(Collectors.toList());
        entitySavedMap.entrySet().stream().filter(a -> a.getKey() instanceof WebPage && ((WebElement)a.getKey()).getTag() != null && ((WebElement)a.getKey()).getTag().equals("cloned")).map(a -> (WebPage)a.getKey()).forEach(a -> {
            try {
                WebPage recordedWebPage = (WebPage)recordedElements.get(recordedElementNames.indexOf(a.getName()));
                List aChildNames = a.getChildren().stream().map(b -> b.getName()).collect(Collectors.toList());
                recordedWebPage.getChildren().removeIf(b -> aChildNames.contains(b.getName()));
                recordedElements.add((WebPage)a);
            }
            catch (Exception e) {
                logger.error("Exception while update recorded elements after saving to object repository", (Throwable)e);
            }
        });
    }

    private TestCaseCompositePart getSelectedTestCasePart() throws Exception {
        MPartStack composerStack = (MPartStack)this.modelService.find("com.kms.katalon.composer.content", (MUIElement)this.application);
        MPart selectedPart = (MPart)composerStack.getSelectedElement();
        if (selectedPart == null || !selectedPart.getElementId().startsWith("com.kms.katalon.composer.content.testcase") || !(selectedPart.getObject() instanceof TestCaseCompositePart)) {
            return null;
        }
        return (TestCaseCompositePart)selectedPart.getObject();
    }

    private TestCaseEntity createNewTestCase(Shell activeShell) throws Exception {
        TestCaseController tcController;
        String suggestedName;
        FolderTreeEntity parentTreeEntity = new FolderTreeEntity(FolderController.getInstance().getTestCaseRoot(ProjectController.getInstance().getCurrentProject()), null);
        FolderEntity parentFolderEntity = parentTreeEntity.getObject();
        NewTestCaseDialog dialog = new NewTestCaseDialog(activeShell, parentFolderEntity, suggestedName = (tcController = TestCaseController.getInstance()).getAvailableTestCaseName(parentFolderEntity, DEFAULT_NEW_TEST_CASE_NAME));
        if (dialog.open() != 0) {
            return null;
        }
        TestCaseEntity testCaseEntity = tcController.saveNewTestCase((TestCaseEntity)dialog.getEntity());
        if (testCaseEntity == null) {
            throw new WebRecordingSaveException("Cannot create test case entity.");
        }
        Trackings.trackCreatingObject((String)"testCase", (Object[])new Object[0]);
        UserProfile userProfile = UserProfileHelper.getCurrentProfile();
        userProfile.setDoneCreateFirstTestCase(true);
        UserProfileHelper.saveProfile((UserProfile)userProfile);
        IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
        eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
        eventBroker.send("EXPLORER/REFRESH_SELECTED_ITEM", (Object)parentTreeEntity);
        eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)new TestCaseTreeEntity(testCaseEntity, (ITreeEntity)parentTreeEntity));
        eventBroker.send("TESTCASE/OPEN", (Object)testCaseEntity);
        return testCaseEntity;
    }

    private List<WebPage> convertCapturedObjects(List<IWebCapturedObject> capturedObjects) {
        return WebElementUtils.convert(capturedObjects);
    }
}

