/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.presentation;

import com.kms.katalon.constants.DocumentationMessageConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class WebRecorderEngineSettingDialog
extends Dialog {
    private static final String DIALOG_TITLE = "Engine Settings";
    private static final String DIALOG_MESSAGE = "Update engine settings at runtime to fit your recording needs.";
    private static final String ENABLE_SMART_LOCATOR_LABEL = "Enable Smart Locator";
    private static final String PERFORMANCE_NOTE = "Performance may be effected";
    private Button checkboxEnableSmartLocator;
    private Boolean smartLocatorCaptureEnabled;

    public WebRecorderEngineSettingDialog(Shell parentShell, Boolean smartLocatorCaptureEnabled) {
        super(parentShell);
        this.smartLocatorCaptureEnabled = smartLocatorCaptureEnabled;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 15;
        layout.marginWidth = 15;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        Label messageLabel = new Label(container, 64);
        messageLabel.setText(DIALOG_MESSAGE);
        GridData messageLabelData = new GridData(4, 0x1000000, true, false);
        messageLabelData.widthHint = 500;
        messageLabel.setLayoutData((Object)messageLabelData);
        Composite checkboxComposite = new Composite(container, 0);
        GridLayout checkboxLayout = new GridLayout(2, false);
        checkboxLayout.marginHeight = 0;
        checkboxLayout.marginWidth = 0;
        checkboxLayout.horizontalSpacing = 5;
        checkboxComposite.setLayout((Layout)checkboxLayout);
        checkboxComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.checkboxEnableSmartLocator = new Button(checkboxComposite, 32);
        this.checkboxEnableSmartLocator.setText(ENABLE_SMART_LOCATOR_LABEL);
        this.checkboxEnableSmartLocator.setSelection(this.smartLocatorCaptureEnabled.booleanValue());
        this.checkboxEnableSmartLocator.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.checkboxEnableSmartLocator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebRecorderEngineSettingDialog.this.smartLocatorCaptureEnabled = WebRecorderEngineSettingDialog.this.checkboxEnableSmartLocator.getSelection();
            }
        });
        Button infoButton = new Button(checkboxComposite, 0x800008);
        infoButton.setText("\u24d8");
        infoButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)DocumentationMessageConstants.SMART_WEB_INSPECTORS);
            }
        });
        Label performanceLabel = new Label(container, 0);
        performanceLabel.setText(PERFORMANCE_NOTE);
        performanceLabel.setForeground(parent.getDisplay().getSystemColor(16));
        GridData performanceLabelData = new GridData(16384, 0x1000000, false, false);
        performanceLabelData.horizontalIndent = 20;
        performanceLabel.setLayoutData((Object)performanceLabelData);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "Cancel", false);
        this.createButton(parent, 0, "Save", true);
    }

    protected void okPressed() {
        this.smartLocatorCaptureEnabled = this.checkboxEnableSmartLocator.getSelection();
        super.okPressed();
    }

    protected Point getInitialSize() {
        return new Point(550, 180);
    }

    public Boolean getSmartLocatorCaptureEnabled() {
        return this.smartLocatorCaptureEnabled;
    }
}

