/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.recorder.web.presentation;

import com.equo.chromium.swt.Browser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.katalon.composer.core.webview.browserfunction.BrowserFunctionUtil;
import com.katalon.recorder.core.domain.model.IStep;
import com.katalon.recorder.core.domain.model.IVariable;
import com.katalon.recorder.web.constant.WebViewInteractionEventType;
import com.katalon.recorder.web.presentation.IWebRecordingView;
import com.katalon.recorder.web.presentation.event.IWebViewInteractionEventBus;
import com.katalon.recorder.web.presentation.event.RecordingPauseRecordingClickedEvent;
import com.katalon.recorder.web.presentation.event.RecordingRecordingConnectionSwitchedEvent;
import com.katalon.recorder.web.presentation.event.RecordingResumeRecordingClickedEvent;
import com.katalon.recorder.web.presentation.event.RecordingRunStepsClickedEvent;
import com.katalon.recorder.web.presentation.event.RecordingUpdateStepsEvent;
import com.katalon.recorder.web.presentation.event.RecordingUpdateVariablesEvent;
import com.katalon.recorder.web.presentation.event.WebViewInteractionEmptyEvent;
import com.katalon.recorder.web.presentation.event.WebViewInteractionEvent;
import com.katalon.recorder.web.presentation.request.PlayStepsClickedEventRequestBody;
import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class WebRecordingView
implements IWebRecordingView {
    private final AtomicReference<Browser> browser = new AtomicReference();
    private final IWebViewInteractionEventBus webViewInteractionEventBus;

    @Inject
    public WebRecordingView(IWebViewInteractionEventBus webViewInteractionEventBus) {
        this.webViewInteractionEventBus = webViewInteractionEventBus;
    }

    public void init(Browser browser) {
        this.browser.set(browser);
        this.registerBrowserFunctions();
    }

    private void registerBrowserFunctions() {
        BrowserFunctionUtil.registerBrowserFunction((String)"recordingView.onRecordingConnectionSwitched", String.class, recordingConnectionId -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new RecordingRecordingConnectionSwitchedEvent(recordingConnectionId)));
        BrowserFunctionUtil.registerBrowserFunction((String)"recordingView.onPauseRecordingClicked", String.class, recordingConnectionId -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new RecordingPauseRecordingClickedEvent(recordingConnectionId)));
        BrowserFunctionUtil.registerBrowserFunction((String)"recordingView.onResumeRecordingClicked", String.class, recordingConnectionId -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new RecordingResumeRecordingClickedEvent(recordingConnectionId)));
        BrowserFunctionUtil.registerBrowserFunction((String)"recordingView.onRunStepsClicked", PlayStepsClickedEventRequestBody.class, requestBody -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new RecordingRunStepsClickedEvent(requestBody.getPlayOption(), requestBody.getStepIndices())));
        BrowserFunctionUtil.registerBrowserFunction((String)"recordingView.onUpdateSteps", (TypeReference)new TypeReference<List<IStep>>(){}, steps -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new RecordingUpdateStepsEvent(steps)));
        BrowserFunctionUtil.registerBrowserFunction((String)"recordingView.onUpdateVariables", (TypeReference)new TypeReference<List<IVariable>>(){}, variables -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new RecordingUpdateVariablesEvent(variables)));
        BrowserFunctionUtil.registerBrowserFunction((String)"recordingView.onStopRunningStepsClicked", () -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new WebViewInteractionEmptyEvent(WebViewInteractionEventType.RECORDING_STOP_RUNNING_STEPS_CLICKED)));
        BrowserFunctionUtil.registerBrowserFunction((String)"recordingView.onSaveClicked", () -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new WebViewInteractionEmptyEvent(WebViewInteractionEventType.RECORDING_SAVE_CLICKED)));
        BrowserFunctionUtil.registerBrowserFunction((String)"recordingView.onOpenEngineSettingsClicked", () -> this.webViewInteractionEventBus.publishWebViewInteractionEvent((WebViewInteractionEvent)new WebViewInteractionEmptyEvent(WebViewInteractionEventType.RECORDING_OPEN_ENGINE_SETTING_CLICKED)));
    }
}

