/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.client.transport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kms.katalon.ai.mcp.client.McpTransportUnauthorizedException;
import com.kms.katalon.ai.mcp.client.transport.ResponseSubscribers;
import io.modelcontextprotocol.client.transport.HttpClientStreamableHttpTransport;
import io.modelcontextprotocol.client.transport.customizer.McpAsyncHttpClientRequestCustomizer;
import io.modelcontextprotocol.client.transport.customizer.McpSyncHttpClientRequestCustomizer;
import io.modelcontextprotocol.common.McpTransportContext;
import io.modelcontextprotocol.spec.DefaultMcpTransportSession;
import io.modelcontextprotocol.spec.DefaultMcpTransportStream;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpTransportException;
import io.modelcontextprotocol.spec.McpTransportSession;
import io.modelcontextprotocol.spec.McpTransportSessionNotFoundException;
import io.modelcontextprotocol.spec.McpTransportStream;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class CustomHttpClientStreamableHttpTransport
implements McpClientTransport {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientStreamableHttpTransport.class);
    private static final String MCP_PROTOCOL_VERSION = "2025-03-26";
    private static final String DEFAULT_ENDPOINT = "/mcp";
    private final HttpClient httpClient;
    private final HttpRequest.Builder requestBuilder;
    private static final String MESSAGE_EVENT_TYPE = "message";
    private static final String APPLICATION_JSON = "application/json";
    private static final String TEXT_EVENT_STREAM = "text/event-stream";
    public static int NOT_FOUND = 404;
    public static int METHOD_NOT_ALLOWED = 405;
    public static int BAD_REQUEST = 400;
    public static int UNAUTHORIZED = 401;
    private final ObjectMapper objectMapper;
    private final URI baseUri;
    private final String endpoint;
    private final boolean openConnectionOnStartup;
    private final boolean resumableStreams;
    private final McpAsyncHttpClientRequestCustomizer httpRequestCustomizer;
    private final AtomicReference<DefaultMcpTransportSession> activeSession = new AtomicReference();
    private final AtomicReference<Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>>> handler = new AtomicReference();
    private final AtomicReference<Consumer<Throwable>> exceptionHandler = new AtomicReference();

    private CustomHttpClientStreamableHttpTransport(ObjectMapper objectMapper, HttpClient httpClient, HttpRequest.Builder requestBuilder, String baseUri, String endpoint, boolean resumableStreams, boolean openConnectionOnStartup, McpAsyncHttpClientRequestCustomizer httpRequestCustomizer) {
        this.objectMapper = objectMapper;
        this.httpClient = httpClient;
        this.requestBuilder = requestBuilder;
        this.baseUri = URI.create(baseUri);
        this.endpoint = endpoint;
        this.resumableStreams = resumableStreams;
        this.openConnectionOnStartup = openConnectionOnStartup;
        this.activeSession.set(this.createTransportSession());
        this.httpRequestCustomizer = httpRequestCustomizer;
    }

    public List<String> protocolVersions() {
        return List.of("2024-11-05", MCP_PROTOCOL_VERSION);
    }

    public static Builder builder(String baseUri) {
        return new Builder(baseUri);
    }

    public Mono<Void> connect(Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> handler) {
        return Mono.deferContextual(ctx -> {
            this.handler.set(handler);
            if (this.openConnectionOnStartup) {
                logger.debug("Eagerly opening connection on startup");
                return this.reconnect(null).onErrorComplete(t -> {
                    logger.warn("Eager connect failed ", t);
                    return true;
                }).then();
            }
            return Mono.empty();
        });
    }

    private DefaultMcpTransportSession createTransportSession() {
        Function<String, Publisher> onClose = sessionId -> sessionId == null ? Mono.empty() : this.createDelete((String)sessionId);
        return new DefaultMcpTransportSession(onClose);
    }

    private Publisher<Void> createDelete(String sessionId) {
        URI uri = Utils.resolveUri((URI)this.baseUri, (String)this.endpoint);
        return Mono.deferContextual(ctx -> {
            HttpRequest.Builder builder = this.requestBuilder.copy().uri(uri).header("Cache-Control", "no-cache").header("mcp-session-id", sessionId).header("MCP-Protocol-Version", MCP_PROTOCOL_VERSION).DELETE();
            McpTransportContext transportContext = (McpTransportContext)ctx.getOrDefault((Object)"MCP_TRANSPORT_CONTEXT", (Object)McpTransportContext.EMPTY);
            return Mono.from((Publisher)this.httpRequestCustomizer.customize(builder, "DELETE", uri, null, transportContext));
        }).flatMap(requestBuilder -> {
            HttpRequest request = requestBuilder.build();
            return Mono.fromFuture(() -> this.httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()));
        }).then();
    }

    public void setExceptionHandler(Consumer<Throwable> handler) {
        logger.debug("Exception handler registered");
        this.exceptionHandler.set(handler);
    }

    private void handleException(Throwable t) {
        Consumer<Throwable> handler;
        logger.debug("Handling exception for session {}", (Object)CustomHttpClientStreamableHttpTransport.sessionIdOrPlaceholder((McpTransportSession)this.activeSession.get()), (Object)t);
        if (t instanceof McpTransportSessionNotFoundException) {
            McpTransportSession invalidSession = (McpTransportSession)this.activeSession.getAndSet(this.createTransportSession());
            logger.warn("Server does not recognize session {}. Invalidating.", (Object)invalidSession.sessionId());
            invalidSession.close();
        }
        if ((handler = this.exceptionHandler.get()) != null) {
            handler.accept(t);
        }
    }

    public Mono<Void> closeGracefully() {
        return Mono.defer(() -> {
            logger.debug("Graceful close triggered");
            DefaultMcpTransportSession currentSession = this.activeSession.getAndSet(this.createTransportSession());
            if (currentSession != null) {
                return currentSession.closeGracefully();
            }
            return Mono.empty();
        });
    }

    private Mono<Disposable> reconnect(McpTransportStream<Disposable> stream) {
        return Mono.deferContextual(ctx -> {
            if (stream != null) {
                logger.debug("Reconnecting stream {} with lastId {}", (Object)stream.streamId(), (Object)stream.lastId());
            } else {
                logger.debug("Reconnecting with no prior stream");
            }
            AtomicReference<Disposable> disposableRef = new AtomicReference<Disposable>();
            McpTransportSession transportSession = (McpTransportSession)this.activeSession.get();
            URI uri = Utils.resolveUri((URI)this.baseUri, (String)this.endpoint);
            Disposable connection = Mono.deferContextual(connectionCtx -> {
                HttpRequest.Builder requestBuilder = this.requestBuilder.copy();
                if (transportSession != null && transportSession.sessionId().isPresent()) {
                    requestBuilder = requestBuilder.header("mcp-session-id", (String)transportSession.sessionId().get());
                }
                if (stream != null && stream.lastId().isPresent()) {
                    requestBuilder = requestBuilder.header("Last-Event-ID", (String)stream.lastId().get());
                }
                HttpRequest.Builder builder = requestBuilder.uri(uri).header("Accept", TEXT_EVENT_STREAM).header("Cache-Control", "no-cache").header("MCP-Protocol-Version", MCP_PROTOCOL_VERSION).GET();
                McpTransportContext transportContext = (McpTransportContext)connectionCtx.getOrDefault((Object)"MCP_TRANSPORT_CONTEXT", (Object)McpTransportContext.EMPTY);
                return Mono.from((Publisher)this.httpRequestCustomizer.customize(builder, "GET", uri, null, transportContext));
            }).flatMapMany(requestBuilder -> Flux.create(sseSink -> {
                CompletionStage completionStage = this.httpClient.sendAsync(requestBuilder.build(), responseInfo -> ResponseSubscribers.sseToBodySubscriber(responseInfo, (FluxSink<ResponseSubscribers.ResponseEvent>)sseSink)).whenComplete((response, throwable) -> {
                    if (throwable != null) {
                        sseSink.error(throwable);
                    } else {
                        logger.debug("SSE connection established successfully");
                    }
                });
            }).map(responseEvent -> (ResponseSubscribers.SseResponseEvent)responseEvent).flatMap(responseEvent -> {
                int statusCode = responseEvent.responseInfo().statusCode();
                responseEvent.responseInfo().headers();
                if (statusCode >= 200 && statusCode < 300) {
                    if (MESSAGE_EVENT_TYPE.equals(responseEvent.sseEvent().event())) {
                        try {
                            McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.objectMapper, (String)responseEvent.sseEvent().data());
                            Tuple2 idWithMessages = Tuples.of(Optional.ofNullable(responseEvent.sseEvent().id()), List.of(message));
                            McpTransportStream sessionStream = stream != null ? stream : new DefaultMcpTransportStream(this.resumableStreams, this::reconnect);
                            logger.debug("Connected stream {}", (Object)sessionStream.streamId());
                            return Flux.from((Publisher)sessionStream.consumeSseStream((Publisher)Flux.just((Object)idWithMessages)));
                        }
                        catch (IOException ioException) {
                            return Flux.error((Throwable)new McpTransportException("Error parsing JSON-RPC message: " + String.valueOf(responseEvent), (Throwable)ioException));
                        }
                    }
                    logger.debug("Received SSE event with type: {}", (Object)responseEvent.sseEvent());
                    return Flux.empty();
                }
                if (statusCode == METHOD_NOT_ALLOWED) {
                    logger.debug("The server does not support SSE streams, using request-response mode.");
                    return Flux.empty();
                }
                if (statusCode == NOT_FOUND) {
                    if (transportSession != null && transportSession.sessionId().isPresent()) {
                        logger.debug("Session not found for session ID: {}", transportSession.sessionId().get());
                        String sessionIdRepresentation = CustomHttpClientStreamableHttpTransport.sessionIdOrPlaceholder(transportSession);
                        McpTransportSessionNotFoundException exception = new McpTransportSessionNotFoundException("Session not found for session ID: " + sessionIdRepresentation);
                        return Flux.error((Throwable)exception);
                    }
                    return Flux.error((Throwable)new McpTransportException("Server Not Found. Status code:" + statusCode + ", response-event:" + String.valueOf(responseEvent)));
                }
                if (statusCode == BAD_REQUEST) {
                    if (transportSession != null && transportSession.sessionId().isPresent()) {
                        String sessionIdRepresentation = CustomHttpClientStreamableHttpTransport.sessionIdOrPlaceholder(transportSession);
                        McpTransportSessionNotFoundException exception = new McpTransportSessionNotFoundException("Session not found for session ID: " + sessionIdRepresentation);
                        return Flux.error((Throwable)exception);
                    }
                    return Flux.error((Throwable)new McpTransportException("Bad Request. Status code:" + statusCode + ", response-event:" + String.valueOf(responseEvent)));
                }
                if (statusCode == UNAUTHORIZED) {
                    return Flux.error((Throwable)((Object)new McpTransportUnauthorizedException()));
                }
                return Flux.error((Throwable)new McpTransportException("Received unrecognized SSE event type: " + responseEvent.sseEvent().event()));
            }).flatMap(jsonrpcMessage -> (Publisher)this.handler.get().apply((Mono<McpSchema.JSONRPCMessage>)Mono.just((Object)jsonrpcMessage))).onErrorMap(CompletionException.class, t -> t.getCause()).onErrorComplete(t -> {
                this.handleException((Throwable)t);
                return true;
            }).doFinally(s -> {
                Disposable ref = disposableRef.getAndSet(null);
                if (ref != null) {
                    transportSession.removeConnection((Object)ref);
                }
            })).contextWrite(ctx).subscribe();
            disposableRef.set(connection);
            transportSession.addConnection((Object)connection);
            return Mono.just((Object)connection);
        });
    }

    private HttpResponse.BodyHandler<Void> toSendMessageBodySubscriber(FluxSink<ResponseSubscribers.ResponseEvent> sink) {
        HttpResponse.BodyHandler<Void> responseBodyHandler = responseInfo -> {
            String contentType = responseInfo.headers().firstValue("Content-Type").orElse("").toLowerCase();
            if (contentType.contains(TEXT_EVENT_STREAM)) {
                logger.debug("Received SSE stream response, using line subscriber");
                return ResponseSubscribers.sseToBodySubscriber(responseInfo, sink);
            }
            if (contentType.contains(APPLICATION_JSON)) {
                logger.debug("Received response, using string subscriber");
                return ResponseSubscribers.aggregateBodySubscriber(responseInfo, sink);
            }
            logger.debug("Received Bodyless response, using discarding subscriber");
            return ResponseSubscribers.bodilessBodySubscriber(responseInfo, sink);
        };
        return responseBodyHandler;
    }

    public String toString(McpSchema.JSONRPCMessage message) {
        try {
            return this.objectMapper.writeValueAsString((Object)message);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize JSON-RPC message", e);
        }
    }

    public Mono<Void> sendMessage(McpSchema.JSONRPCMessage sentMessage) {
        return Mono.create(deliveredSink -> {
            logger.debug("Sending message {}", (Object)sentMessage);
            AtomicReference<Disposable> disposableRef = new AtomicReference<Disposable>();
            McpTransportSession transportSession = (McpTransportSession)this.activeSession.get();
            URI uri = Utils.resolveUri((URI)this.baseUri, (String)this.endpoint);
            String jsonBody = this.toString(sentMessage);
            Disposable connection = Mono.deferContextual(ctx -> {
                HttpRequest.Builder requestBuilder = this.requestBuilder.copy();
                if (transportSession != null && transportSession.sessionId().isPresent()) {
                    requestBuilder = requestBuilder.header("mcp-session-id", (String)transportSession.sessionId().get());
                }
                HttpRequest.Builder builder = requestBuilder.uri(uri).header("Accept", "application/json, text/event-stream").header("Content-Type", APPLICATION_JSON).header("Cache-Control", "no-cache").header("MCP-Protocol-Version", MCP_PROTOCOL_VERSION).POST(HttpRequest.BodyPublishers.ofString(jsonBody));
                McpTransportContext transportContext = (McpTransportContext)ctx.getOrDefault((Object)"MCP_TRANSPORT_CONTEXT", (Object)McpTransportContext.EMPTY);
                return Mono.from((Publisher)this.httpRequestCustomizer.customize(builder, "POST", uri, jsonBody, transportContext));
            }).flatMapMany(requestBuilder -> Flux.create(responseEventSink -> Mono.fromFuture((CompletableFuture)this.httpClient.sendAsync(requestBuilder.build(), this.toSendMessageBodySubscriber((FluxSink<ResponseSubscribers.ResponseEvent>)responseEventSink)).whenComplete((response, throwable) -> {
                if (throwable != null) {
                    responseEventSink.error(throwable);
                } else {
                    logger.debug("SSE connection established successfully");
                }
            })).onErrorMap(CompletionException.class, t -> t.getCause()).onErrorComplete().subscribe())).flatMap(responseEvent -> {
                if (transportSession.markInitialized(responseEvent.responseInfo().headers().firstValue("mcp-session-id").orElseGet(() -> null))) {
                    this.reconnect(null).contextWrite(deliveredSink.contextView()).subscribe();
                }
                String sessionRepresentation = CustomHttpClientStreamableHttpTransport.sessionIdOrPlaceholder(transportSession);
                int statusCode = responseEvent.responseInfo().statusCode();
                if (statusCode >= 200 && statusCode < 300) {
                    String contentType = responseEvent.responseInfo().headers().firstValue("Content-Type").orElse("").toLowerCase();
                    if (contentType.isBlank()) {
                        logger.debug("No content type returned for POST in session {}", (Object)sessionRepresentation);
                        deliveredSink.success();
                        return Flux.empty();
                    }
                    if (contentType.contains(TEXT_EVENT_STREAM)) {
                        return Flux.just((Object)((ResponseSubscribers.SseResponseEvent)responseEvent).sseEvent()).flatMap(sseEvent -> {
                            try {
                                McpSchema.JSONRPCMessage message = McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.objectMapper, (String)sseEvent.data());
                                Tuple2 idWithMessages = Tuples.of(Optional.ofNullable(sseEvent.id()), List.of(message));
                                DefaultMcpTransportStream sessionStream = new DefaultMcpTransportStream(this.resumableStreams, this::reconnect);
                                logger.debug("Connected stream {}", (Object)sessionStream.streamId());
                                deliveredSink.success();
                                return Flux.from((Publisher)sessionStream.consumeSseStream((Publisher)Flux.just((Object)idWithMessages)));
                            }
                            catch (IOException ioException) {
                                return Flux.error((Throwable)new McpTransportException("Error parsing JSON-RPC message: " + String.valueOf(responseEvent), (Throwable)ioException));
                            }
                        });
                    }
                    if (contentType.contains(APPLICATION_JSON)) {
                        deliveredSink.success();
                        String data = ((ResponseSubscribers.AggregateResponseEvent)responseEvent).data();
                        if (sentMessage instanceof McpSchema.JSONRPCNotification && Utils.hasText((String)data)) {
                            logger.warn("Notification: {} received non-compliant response: {}", (Object)sentMessage, (Object)data);
                            return Mono.empty();
                        }
                        try {
                            return Mono.just((Object)McpSchema.deserializeJsonRpcMessage((ObjectMapper)this.objectMapper, (String)data));
                        }
                        catch (IOException e) {
                            return Mono.error((Throwable)new McpTransportException("Error deserializing JSON-RPC message: " + String.valueOf(responseEvent), (Throwable)e));
                        }
                    }
                    logger.warn("Unknown media type {} returned for POST in session {}", (Object)contentType, (Object)sessionRepresentation);
                    return Flux.error((Throwable)new RuntimeException("Unknown media type returned: " + contentType));
                }
                if (statusCode == NOT_FOUND) {
                    if (transportSession != null && transportSession.sessionId().isPresent()) {
                        logger.debug("Session not found for session ID: {}", transportSession.sessionId().get());
                        McpTransportSessionNotFoundException exception = new McpTransportSessionNotFoundException("Session not found for session ID: " + sessionRepresentation);
                        return Flux.error((Throwable)exception);
                    }
                    return Flux.error((Throwable)new McpTransportException("Server Not Found. Status code:" + statusCode + ", response-event:" + String.valueOf(responseEvent)));
                }
                if (statusCode == BAD_REQUEST) {
                    if (transportSession != null && transportSession.sessionId().isPresent()) {
                        McpTransportSessionNotFoundException exception = new McpTransportSessionNotFoundException("Session not found for session ID: " + sessionRepresentation);
                        return Flux.error((Throwable)exception);
                    }
                    return Flux.error((Throwable)new McpTransportException("Bad Request. Status code:" + statusCode + ", response-event:" + String.valueOf(responseEvent)));
                }
                if (statusCode == UNAUTHORIZED) {
                    return Flux.error((Throwable)((Object)new McpTransportUnauthorizedException()));
                }
                return Flux.error((Throwable)new RuntimeException("Failed to send message: " + String.valueOf(responseEvent)));
            }).flatMap(jsonRpcMessage -> (Publisher)this.handler.get().apply((Mono<McpSchema.JSONRPCMessage>)Mono.just((Object)jsonRpcMessage))).onErrorMap(CompletionException.class, t -> t.getCause()).onErrorComplete(t -> {
                this.handleException((Throwable)t);
                deliveredSink.error(t);
                return true;
            }).doFinally(s -> {
                logger.debug("SendMessage finally: {}", s);
                Disposable ref = disposableRef.getAndSet(null);
                if (ref != null) {
                    transportSession.removeConnection((Object)ref);
                }
            }).contextWrite(deliveredSink.contextView()).subscribe();
            disposableRef.set(connection);
            transportSession.addConnection((Object)connection);
        });
    }

    private static String sessionIdOrPlaceholder(McpTransportSession<?> transportSession) {
        return transportSession.sessionId().orElse("[missing_session_id]");
    }

    public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
        return (T)this.objectMapper.convertValue(data, typeRef);
    }

    public static class Builder {
        private final String baseUri;
        private ObjectMapper objectMapper;
        private HttpClient.Builder clientBuilder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1);
        private String endpoint = "/mcp";
        private boolean resumableStreams = true;
        private boolean openConnectionOnStartup = false;
        private HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
        private McpAsyncHttpClientRequestCustomizer httpRequestCustomizer = McpAsyncHttpClientRequestCustomizer.NOOP;
        private Duration connectTimeout = Duration.ofSeconds(10L);

        private Builder(String baseUri) {
            Assert.hasText((String)baseUri, (String)"baseUri must not be empty");
            this.baseUri = baseUri;
        }

        public Builder clientBuilder(HttpClient.Builder clientBuilder) {
            Assert.notNull((Object)clientBuilder, (String)"clientBuilder must not be null");
            this.clientBuilder = clientBuilder;
            return this;
        }

        public Builder customizeClient(Consumer<HttpClient.Builder> clientCustomizer) {
            Assert.notNull(clientCustomizer, (String)"clientCustomizer must not be null");
            clientCustomizer.accept(this.clientBuilder);
            return this;
        }

        public Builder requestBuilder(HttpRequest.Builder requestBuilder) {
            Assert.notNull((Object)requestBuilder, (String)"requestBuilder must not be null");
            this.requestBuilder = requestBuilder;
            return this;
        }

        public Builder customizeRequest(Consumer<HttpRequest.Builder> requestCustomizer) {
            Assert.notNull(requestCustomizer, (String)"requestCustomizer must not be null");
            requestCustomizer.accept(this.requestBuilder);
            return this;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
            this.objectMapper = objectMapper;
            return this;
        }

        public Builder endpoint(String endpoint) {
            Assert.hasText((String)endpoint, (String)"endpoint must be a non-empty String");
            this.endpoint = endpoint;
            return this;
        }

        public Builder resumableStreams(boolean resumableStreams) {
            this.resumableStreams = resumableStreams;
            return this;
        }

        public Builder openConnectionOnStartup(boolean openConnectionOnStartup) {
            this.openConnectionOnStartup = openConnectionOnStartup;
            return this;
        }

        public Builder httpRequestCustomizer(McpSyncHttpClientRequestCustomizer syncHttpRequestCustomizer) {
            this.httpRequestCustomizer = McpAsyncHttpClientRequestCustomizer.fromSync((McpSyncHttpClientRequestCustomizer)syncHttpRequestCustomizer);
            return this;
        }

        public Builder asyncHttpRequestCustomizer(McpAsyncHttpClientRequestCustomizer asyncHttpRequestCustomizer) {
            this.httpRequestCustomizer = asyncHttpRequestCustomizer;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            Assert.notNull((Object)connectTimeout, (String)"connectTimeout must not be null");
            this.connectTimeout = connectTimeout;
            return this;
        }

        public CustomHttpClientStreamableHttpTransport build() {
            ObjectMapper objectMapper = this.objectMapper != null ? this.objectMapper : new ObjectMapper();
            HttpClient httpClient = this.clientBuilder.connectTimeout(this.connectTimeout).build();
            return new CustomHttpClientStreamableHttpTransport(objectMapper, httpClient, this.requestBuilder, this.baseUri, this.endpoint, this.resumableStreams, this.openConnectionOnStartup, this.httpRequestCustomizer);
        }
    }
}

