/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.mcp.tools;

import com.kms.katalon.composer.components.impl.tree.TestSuiteCollectionTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.FilteringTestSuiteEntity;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.entity.testsuite.TestSuiteRunConfiguration;
import com.kms.katalon.logging.LogUtil;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;

public class TestSuiteTools {
    @Inject
    private IEventBroker eventBroker;
    private static final String TEST_SUITE_FOLDER_ROOT = "Test Suites";
    private static final String TEST_CASE_FOLDER_ROOT = "Test Cases";

    public McpServerFeatures.SyncToolSpecification getTestSuiteTool() {
        McpSchema.Tool tool = new McpSchema.Tool("getTestSuite", "Get Test Suite Details", "Retrieves detailed information about a specific test suite in the current Katalon Studio project", this.createInputSchemaForGetTestSuiteTool(), this.createOutputSchemaForGetTestSuiteTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.getTestSuiteToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult getTestSuiteToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        Map<String, Object> structuredContent = null;
        try {
            String testSuiteId;
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            if (StringUtils.isBlank((CharSequence)(testSuiteId = (String)arguments.get("testSuiteId")))) {
                isError = true;
                resultContent = "testSuiteId parameter is required";
            } else {
                structuredContent = this.getTestSuiteData(testSuiteId.trim());
                resultContent = JsonUtil.toJson(structuredContent);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error retrieving test suite details: " + e.getMessage();
            structuredContent = Map.of("result", new HashMap());
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private Map<String, Object> getTestSuiteData(String testSuiteId) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        testSuiteId = this.normalizeData(testSuiteId, TEST_SUITE_FOLDER_ROOT);
        TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteId, project);
        if (testSuite instanceof FilteringTestSuiteEntity) {
            return this.createStructuredContentResultForGetDynamicTestSuite((FilteringTestSuiteEntity)testSuite);
        }
        if (testSuite instanceof TestSuiteEntity) {
            return this.createStructuredContentResultForGetTestSuite(testSuite);
        }
        TestSuiteCollectionEntity testSuiteCollection = TestSuiteCollectionController.getInstance().getTestRunByDisplayId(testSuiteId);
        if (testSuiteCollection != null) {
            return this.createStructuredContentResultForGetTestSuiteCollection(testSuiteCollection);
        }
        throw new Exception("Test suite not found at: " + testSuiteId);
    }

    private Map<String, Object> createStructuredContentResultForGetTestSuite(TestSuiteEntity testSuite) {
        HashMap<String, Object> testSuiteResult = new HashMap<String, Object>();
        if (testSuite == null) {
            return Map.of("result", testSuiteResult);
        }
        testSuiteResult.put("testSuiteId", testSuite.getIdForDisplay() != null ? testSuite.getIdForDisplay() : "");
        testSuiteResult.put("testSuiteType", "Test Suite");
        testSuiteResult.put("testSuiteName", testSuite.getName() != null ? testSuite.getName() : "");
        testSuiteResult.put("testSuiteDescription", testSuite.getDescription() != null ? testSuite.getDescription() : "");
        testSuiteResult.put("testSuiteScriptContent", this.extractTestSuiteScriptContent(testSuite));
        testSuiteResult.put("testCaseLinks", this.extractTestCaseLinks(testSuite.getTestSuiteTestCaseLinks()));
        testSuiteResult.put("executionConfiguration", this.extractExecutionConfiguration(testSuite));
        return Map.of("result", testSuiteResult);
    }

    private Map<String, Object> createStructuredContentResultForGetTestSuiteCollection(TestSuiteCollectionEntity testSuiteCollection) {
        HashMap<String, Object> testSuiteCollectionResult = new HashMap<String, Object>();
        if (testSuiteCollection == null) {
            return Map.of("result", testSuiteCollectionResult);
        }
        testSuiteCollectionResult.put("testSuiteId", testSuiteCollection.getIdForDisplay() != null ? testSuiteCollection.getIdForDisplay() : "");
        testSuiteCollectionResult.put("testSuiteType", "Test Suite Collection");
        testSuiteCollectionResult.put("testSuiteName", testSuiteCollection.getName() != null ? testSuiteCollection.getName() : "");
        testSuiteCollectionResult.put("testSuiteDescription", testSuiteCollection.getDescription() != null ? testSuiteCollection.getDescription() : "");
        testSuiteCollectionResult.put("testSuiteTag", testSuiteCollection.getTag() != null ? testSuiteCollection.getTag() : "");
        testSuiteCollectionResult.put("testSuiteRunConfigurations", this.extractTestSuiteRunConfigurations(testSuiteCollection.getTestSuiteRunConfigurations()));
        testSuiteCollectionResult.put("executionConfiguration", this.extractTestSuiteCollectionExecutionConfiguration(testSuiteCollection));
        return Map.of("result", testSuiteCollectionResult);
    }

    private Map<String, Object> createStructuredContentResultForGetDynamicTestSuite(FilteringTestSuiteEntity dynamicTestSuite) {
        HashMap<String, Object> dynamicTestSuiteResult = new HashMap<String, Object>();
        if (dynamicTestSuite == null) {
            return Map.of("result", dynamicTestSuiteResult);
        }
        dynamicTestSuiteResult.put("testSuiteId", dynamicTestSuite.getIdForDisplay() != null ? dynamicTestSuite.getIdForDisplay() : "");
        dynamicTestSuiteResult.put("testSuiteType", "Dynamic Test Suite");
        dynamicTestSuiteResult.put("testSuiteName", dynamicTestSuite.getName() != null ? dynamicTestSuite.getName() : "");
        dynamicTestSuiteResult.put("testSuiteDescription", dynamicTestSuite.getDescription() != null ? dynamicTestSuite.getDescription() : "");
        dynamicTestSuiteResult.put("executionConfiguration", this.extractExecutionConfiguration((TestSuiteEntity)dynamicTestSuite));
        dynamicTestSuiteResult.put("filteringConfiguration", this.extractFilteringConfiguration(dynamicTestSuite));
        return Map.of("result", dynamicTestSuiteResult);
    }

    private List<Map<String, Object>> extractTestCaseLinks(List<TestSuiteTestCaseLink> testCaseLinks) {
        if (testCaseLinks == null || testCaseLinks.isEmpty()) {
            return List.of();
        }
        ArrayList<Map<String, Object>> testCaseList = new ArrayList<Map<String, Object>>();
        for (TestSuiteTestCaseLink testCaseLink : testCaseLinks) {
            HashMap<String, String> testCaseInfo = new HashMap<String, String>();
            try {
                TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseLink.getTestCaseId());
                if (testCase == null) continue;
                testCaseInfo.put("testCaseId", testCase.getIdForDisplay() != null ? testCase.getIdForDisplay() : "");
                testCaseInfo.put("testCaseName", testCase.getName() != null ? testCase.getName() : "");
                testCaseInfo.put("testCaseDescription", testCase.getDescription() != null ? testCase.getDescription() : "");
                testCaseList.add(testCaseInfo);
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e, (String)("Error retrieving test case for link: " + testCaseLink.getTestCaseId()));
            }
        }
        return testCaseList;
    }

    private String extractTestSuiteScriptContent(TestSuiteEntity testSuite) {
        String scriptContent = "";
        if (testSuite == null) {
            return scriptContent;
        }
        try {
            File scriptFile = TestSuiteController.getInstance().getTestSuiteScriptFile(testSuite);
            if (scriptFile != null && scriptFile.exists()) {
                scriptContent = FileUtils.readFileToString((File)scriptFile, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Error reading test suite script content");
        }
        return scriptContent;
    }

    private Map<String, Object> extractExecutionConfiguration(TestSuiteEntity testSuite) {
        HashMap<String, Object> executionConfiguration = new HashMap<String, Object>();
        executionConfiguration.put("mailRecipient", testSuite.getMailRecipient() != null ? testSuite.getMailRecipient() : "");
        executionConfiguration.put("pageLoadTimeoutInSeconds", testSuite.getPageLoadTimeout());
        executionConfiguration.put("isPageLoadTimeoutDefault", testSuite.isPageLoadTimeoutDefault());
        boolean retryFailedExecutionsImmediately = testSuite.isRerunImmediately();
        if (retryFailedExecutionsImmediately) {
            executionConfiguration.put("retryFailedExecutionsImmediately", testSuite.isRerunImmediately());
            executionConfiguration.put("numberOfRetry", testSuite.getNumberOfRerun());
        } else {
            boolean retryFailedTestCasesOnly = testSuite.isRerunFailedTestCasesOnly();
            if (retryFailedTestCasesOnly) {
                executionConfiguration.put("retryFailedTestCasesOnly", testSuite.isRerunFailedTestCasesOnly());
                executionConfiguration.put("numberOfRetry", testSuite.getNumberOfRerun());
            } else {
                executionConfiguration.put("retryAllExecutions", true);
                executionConfiguration.put("numberOfRetry", testSuite.getNumberOfRerun());
            }
        }
        return executionConfiguration;
    }

    private List<Map<String, Object>> extractTestSuiteRunConfigurations(List<TestSuiteRunConfiguration> testSuiteRunConfigurations) {
        if (testSuiteRunConfigurations == null || testSuiteRunConfigurations.isEmpty()) {
            return List.of();
        }
        ArrayList<Map<String, Object>> testSuiteRunConfigList = new ArrayList<Map<String, Object>>();
        for (TestSuiteRunConfiguration runConfig : testSuiteRunConfigurations) {
            HashMap<String, Object> runConfigInfo = new HashMap<String, Object>();
            TestSuiteEntity testSuite = runConfig.getTestSuiteEntity();
            if (testSuite != null) {
                runConfigInfo.put("testSuiteId", testSuite.getIdForDisplay() != null ? testSuite.getIdForDisplay() : "");
                runConfigInfo.put("testSuiteName", testSuite.getName() != null ? testSuite.getName() : "");
                runConfigInfo.put("testSuiteDescription", testSuite.getDescription() != null ? testSuite.getDescription() : "");
                runConfigInfo.put("testCaseLinks", this.extractTestCaseLinks(testSuite.getTestSuiteTestCaseLinks()));
            }
            runConfigInfo.put("runConfiguration", this.extractRunConfigurationDescription(runConfig.getConfiguration()));
            testSuiteRunConfigList.add(runConfigInfo);
        }
        return testSuiteRunConfigList;
    }

    private Map<String, Object> extractRunConfigurationDescription(RunConfigurationDescription configuration) {
        HashMap<String, Object> configInfo = new HashMap<String, Object>();
        if (configuration == null) {
            return configInfo;
        }
        configInfo.put("groupName", configuration.getGroupName() != null ? configuration.getGroupName() : "");
        configInfo.put("runConfigurationId", configuration.getRunConfigurationId() != null ? configuration.getRunConfigurationId() : "");
        configInfo.put("profileName", configuration.getProfileName() != null ? configuration.getProfileName() : "");
        configInfo.put("requireConfigurationData", configuration.isRequireConfigurationData());
        Map runConfigurationData = configuration.getRunConfigurationData();
        configInfo.put("runConfigurationData", runConfigurationData != null ? runConfigurationData : Map.of());
        return configInfo;
    }

    private Map<String, Object> extractTestSuiteCollectionExecutionConfiguration(TestSuiteCollectionEntity testSuiteCollection) {
        HashMap<String, Object> executionConfig = new HashMap<String, Object>();
        TestSuiteCollectionEntity.ExecutionMode executionMode = testSuiteCollection.getExecutionMode();
        executionConfig.put("executionMode", testSuiteCollection.getExecutionMode().toString());
        if (executionMode.equals((Object)TestSuiteCollectionEntity.ExecutionMode.PARALLEL)) {
            executionConfig.put("maxConcurrentInstances", testSuiteCollection.getMaxConcurrentInstances());
            executionConfig.put("delayBetweenInstancesInSeconds", testSuiteCollection.getDelayBetweenInstances());
        }
        return executionConfig;
    }

    private Map<String, Object> extractFilteringConfiguration(FilteringTestSuiteEntity dynamicTestSuite) {
        HashMap<String, Object> filteringConfig = new HashMap<String, Object>();
        filteringConfig.put("filteringText", dynamicTestSuite.getFilteringText() != null ? dynamicTestSuite.getFilteringText() : "");
        filteringConfig.put("filteringBuiltIn", dynamicTestSuite.getFilteringBuiltIn() != null ? dynamicTestSuite.getFilteringBuiltIn() : "");
        return filteringConfig;
    }

    public McpServerFeatures.SyncToolSpecification createTestSuiteTool() {
        McpSchema.Tool tool = new McpSchema.Tool("createTestSuite", "Create Test Suite", "Creates a new test suite with metadata and test cases in the current Katalon Studio project", this.createInputSchemaForCreateTestSuiteTool(), this.createOutputSchemaForCreateNewOrUpdateTestSuiteTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.createTestSuiteToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult createTestSuiteToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        TestSuiteEntity newTestSuite = null;
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String testSuiteName = (String)arguments.get("testSuiteName");
            String folderPath = (String)arguments.get("folderPath");
            String description = (String)arguments.get("description");
            List testCaseIds = (List)arguments.get("testCaseIds");
            if (StringUtils.isBlank((CharSequence)testSuiteName)) {
                isError = true;
                resultContent = "testSuiteName parameter is required";
            } else {
                newTestSuite = this.createNewTestSuite(folderPath, testSuiteName, description, testCaseIds);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error creating test suite: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateNewOrUpdateTestSuite(newTestSuite, null);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private TestSuiteEntity createNewTestSuite(String folderPath, String testSuiteName, String description, List<String> testCaseIds) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        this.validateTestSuiteName(testSuiteName);
        folderPath = StringUtils.isBlank((CharSequence)folderPath) ? TEST_SUITE_FOLDER_ROOT : this.normalizeData(folderPath, TEST_SUITE_FOLDER_ROOT);
        TestSuiteController testSuiteController = TestSuiteController.getInstance();
        TestCaseController testCaseController = TestCaseController.getInstance();
        String fullTestSuiteId = folderPath + "/" + testSuiteName;
        TestSuiteEntity existingTestSuite = testSuiteController.getTestSuiteByDisplayId(fullTestSuiteId, project);
        if (existingTestSuite != null) {
            throw new Exception("Test suite already exists: " + fullTestSuiteId);
        }
        FolderEntity folderToCreateTestSuite = this.getOrCreateFeatureFolder(project, folderPath);
        TestSuiteEntity testSuite = testSuiteController.newTestSuiteWithoutSave(folderToCreateTestSuite, testSuiteName);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            testSuite.setDescription(description);
        }
        if (testCaseIds != null && !testCaseIds.isEmpty()) {
            ArrayList<TestSuiteTestCaseLink> testCaseLinks = new ArrayList<TestSuiteTestCaseLink>();
            for (String testCaseId : testCaseIds) {
                TestCaseEntity testCase;
                if (!StringUtils.isNotBlank((CharSequence)testCaseId) || (testCase = testCaseController.getTestCaseByDisplayId(this.normalizeData(testCaseId.trim(), TEST_CASE_FOLDER_ROOT))) == null) continue;
                TestSuiteTestCaseLink link = new TestSuiteTestCaseLink();
                link.setTestCaseId(this.normalizeData(testCaseId.trim(), TEST_CASE_FOLDER_ROOT));
                testCaseLinks.add(link);
            }
            testSuite.setTestSuiteTestCaseLinks(testCaseLinks);
        }
        TestSuiteEntity newTestSuite = testSuiteController.saveNewTestSuite(testSuite);
        this.refreshTestSuiteInExplorer(newTestSuite, null, project);
        this.openTestSuiteInEditor(newTestSuite, null, project);
        return newTestSuite;
    }

    private Map<String, Object> createStructuredContentResultForCreateNewOrUpdateTestSuite(TestSuiteEntity testSuite, TestSuiteCollectionEntity testSuiteCollection) {
        String testSuiteId = "";
        if (testSuite != null) {
            testSuiteId = testSuite.getIdForDisplay();
        } else if (testSuiteCollection != null) {
            testSuiteId = testSuiteCollection.getIdForDisplay();
        }
        HashMap<String, Object> structuredContent = new HashMap<String, Object>();
        structuredContent.put("testSuiteId", testSuiteId);
        return structuredContent;
    }

    public McpServerFeatures.SyncToolSpecification createTestSuiteCollectionTool() {
        McpSchema.Tool tool = new McpSchema.Tool("createTestSuiteCollection", "Create Test Suite Collection", "Creates a new test suite collection with metadata and test suites in the current Katalon Studio project", this.createInputSchemaForCreateTestSuiteCollectionTool(), this.createOutputSchemaForCreateNewOrUpdateTestSuiteTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.createTestSuiteCollectionToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult createTestSuiteCollectionToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        TestSuiteCollectionEntity newTestSuiteCollection = null;
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String testSuiteName = (String)arguments.get("testSuiteName");
            String folderPath = (String)arguments.get("folderPath");
            String description = (String)arguments.get("description");
            String tag = (String)arguments.get("tag");
            List testSuiteIds = (List)arguments.get("testSuiteIds");
            if (StringUtils.isBlank((CharSequence)testSuiteName)) {
                isError = true;
                resultContent = "testSuiteName parameter is required";
            } else {
                newTestSuiteCollection = this.createNewTestSuiteCollection(folderPath, testSuiteName, description, tag, testSuiteIds);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error creating test suite collection: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateNewOrUpdateTestSuite(null, newTestSuiteCollection);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private TestSuiteCollectionEntity createNewTestSuiteCollection(String folderPath, String testSuiteName, String description, String tag, List<String> testSuiteIds) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        this.validateTestSuiteName(testSuiteName);
        folderPath = StringUtils.isBlank((CharSequence)folderPath) ? TEST_SUITE_FOLDER_ROOT : this.normalizeData(folderPath, TEST_SUITE_FOLDER_ROOT);
        TestSuiteCollectionController testSuiteCollectionController = TestSuiteCollectionController.getInstance();
        String fullTestSuiteId = folderPath + "/" + testSuiteName;
        TestSuiteCollectionEntity existingTestSuite = testSuiteCollectionController.getTestRunByDisplayId(fullTestSuiteId);
        if (existingTestSuite != null) {
            throw new Exception("Test suite already exists: " + fullTestSuiteId);
        }
        FolderEntity folderToCreateTestSuite = this.getOrCreateFeatureFolder(project, folderPath);
        TestSuiteCollectionEntity testSuiteCollection = testSuiteCollectionController.newTestSuiteCollection(folderToCreateTestSuite, testSuiteName);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            testSuiteCollection.setDescription(description);
        }
        if (StringUtils.isNotBlank((CharSequence)tag)) {
            testSuiteCollection.setTag(tag);
        }
        if (testSuiteIds != null && !testSuiteIds.isEmpty()) {
            ArrayList<TestSuiteRunConfiguration> testSuiteRunConfigurations = new ArrayList<TestSuiteRunConfiguration>();
            for (String testSuiteId : testSuiteIds) {
                if (!StringUtils.isNotBlank((CharSequence)testSuiteId)) continue;
                String normalizedTestSuiteId = this.normalizeData(testSuiteId.trim(), TEST_SUITE_FOLDER_ROOT);
                TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(normalizedTestSuiteId, project);
                if (testSuite == null) continue;
                TestSuiteRunConfiguration runConfig = TestSuiteRunConfiguration.newInstance((TestSuiteEntity)testSuite, (RunConfigurationDescription)new RunConfigurationDescription());
                testSuiteRunConfigurations.add(runConfig);
            }
            testSuiteCollection.setTestSuiteRunConfigurations(testSuiteRunConfigurations);
        }
        testSuiteCollectionController.updateTestSuiteCollection(testSuiteCollection);
        this.refreshTestSuiteInExplorer(null, testSuiteCollection, project);
        this.openTestSuiteInEditor(null, testSuiteCollection, project);
        return testSuiteCollection;
    }

    public McpServerFeatures.SyncToolSpecification createDynamicTestSuiteTool() {
        McpSchema.Tool tool = new McpSchema.Tool("createDynamicTestSuite", "Create Dynamic Test Suite", "Creates a new dynamic test suite with metadata and filtering configuration in current Katalon Studio project", this.createInputSchemaForCreateDynamicTestSuiteTool(), this.createOutputSchemaForCreateNewOrUpdateTestSuiteTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.createDynamicTestSuiteToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult createDynamicTestSuiteToolCallHandler(McpSchema.CallToolRequest request) {
        boolean isError = false;
        Object resultContent = "";
        FilteringTestSuiteEntity newDynamicTestSuite = null;
        try {
            HashMap arguments = request.arguments();
            if (arguments == null) {
                arguments = new HashMap();
            }
            String testSuiteName = (String)arguments.get("testSuiteName");
            String folderPath = (String)arguments.get("folderPath");
            String description = (String)arguments.get("description");
            String filteringText = (String)arguments.get("filteringText");
            String filteringBuiltIn = (String)arguments.get("filteringBuiltIn");
            String filteringPlugin = (String)arguments.get("filteringPlugin");
            String filteringExtension = (String)arguments.get("filteringExtension");
            if (StringUtils.isBlank((CharSequence)testSuiteName)) {
                isError = true;
                resultContent = "testSuiteName parameter is required";
            } else {
                newDynamicTestSuite = this.createNewDynamicTestSuite(folderPath, testSuiteName, description, filteringText, filteringBuiltIn, filteringPlugin, filteringExtension);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Error creating dynamic test suite: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateNewOrUpdateTestSuite((TestSuiteEntity)newDynamicTestSuite, null);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private FilteringTestSuiteEntity createNewDynamicTestSuite(String folderPath, String testSuiteName, String description, String filteringText, String filteringBuiltIn, String filteringPlugin, String filteringExtension) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        this.validateTestSuiteName(testSuiteName);
        folderPath = StringUtils.isBlank((CharSequence)folderPath) ? TEST_SUITE_FOLDER_ROOT : this.normalizeData(folderPath, TEST_SUITE_FOLDER_ROOT);
        TestSuiteController testSuiteController = TestSuiteController.getInstance();
        String fullTestSuiteId = folderPath + "/" + testSuiteName;
        TestSuiteEntity existingTestSuite = testSuiteController.getTestSuiteByDisplayId(fullTestSuiteId, project);
        if (existingTestSuite != null) {
            throw new Exception("Test suite already exists: " + fullTestSuiteId);
        }
        FolderEntity folderToCreateTestSuite = this.getOrCreateFeatureFolder(project, folderPath);
        FilteringTestSuiteEntity dynamicTestSuite = testSuiteController.newFilteringTestSuiteWithoutSave(folderToCreateTestSuite, testSuiteName);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            dynamicTestSuite.setDescription(description);
        }
        if (StringUtils.isNotBlank((CharSequence)filteringText)) {
            dynamicTestSuite.setFilteringText(filteringText);
        }
        if (StringUtils.isNotBlank((CharSequence)filteringBuiltIn)) {
            dynamicTestSuite.setFilteringBuiltIn(filteringBuiltIn);
        }
        if (StringUtils.isNotBlank((CharSequence)filteringPlugin)) {
            dynamicTestSuite.setFilteringPlugin(filteringPlugin);
        }
        if (StringUtils.isNotBlank((CharSequence)filteringExtension)) {
            dynamicTestSuite.setFilteringExtension(filteringExtension);
        }
        FilteringTestSuiteEntity newDynamicTestSuite = (FilteringTestSuiteEntity)testSuiteController.saveNewTestSuite((TestSuiteEntity)dynamicTestSuite);
        this.refreshTestSuiteInExplorer((TestSuiteEntity)newDynamicTestSuite, null, project);
        this.openTestSuiteInEditor((TestSuiteEntity)newDynamicTestSuite, null, project);
        return newDynamicTestSuite;
    }

    public McpServerFeatures.SyncToolSpecification updateTestSuiteTool() {
        McpSchema.Tool tool = new McpSchema.Tool("updateTestSuite", "Update Test Suite", "Update an existing test suite with new metadata and test cases in the current Katalon Studio project", this.createInputSchemaForUpdateTestSuiteTool(), this.createOutputSchemaForCreateNewOrUpdateTestSuiteTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.updateTestSuiteToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult updateTestSuiteToolCallHandler(McpSchema.CallToolRequest request) {
        Object resultContent = "";
        boolean isError = false;
        TestSuiteEntity updatedTestSuite = null;
        try {
            Map arguments = request.arguments();
            String testSuiteId = (String)arguments.get("testSuiteId");
            String description = (String)arguments.get("description");
            List testCaseIds = (List)arguments.get("testCaseIds");
            if (StringUtils.isBlank((CharSequence)testSuiteId)) {
                isError = true;
                resultContent = "testSuiteId parameter is required";
            } else {
                updatedTestSuite = this.updateExistingTestSuite(testSuiteId, description, testCaseIds);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Failed to update test suite: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateNewOrUpdateTestSuite(updatedTestSuite, null);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private TestSuiteEntity updateExistingTestSuite(String testSuiteId, String description, List<String> testCaseIds) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        testSuiteId = this.normalizeData(testSuiteId, TEST_SUITE_FOLDER_ROOT);
        TestSuiteController testSuiteController = TestSuiteController.getInstance();
        TestSuiteEntity existingTestSuite = testSuiteController.getTestSuiteByDisplayId(testSuiteId, project);
        if (existingTestSuite == null) {
            throw new Exception("Test suite not found: " + testSuiteId);
        }
        if (description != null) {
            existingTestSuite.setDescription(description);
        }
        if (testCaseIds != null) {
            ArrayList<TestSuiteTestCaseLink> newTestCaseLinks = new ArrayList<TestSuiteTestCaseLink>();
            TestCaseController testCaseController = TestCaseController.getInstance();
            for (String testCaseId : testCaseIds) {
                TestCaseEntity testCase;
                if (!StringUtils.isNotBlank((CharSequence)testCaseId) || (testCase = testCaseController.getTestCaseByDisplayId(testCaseId)) == null) continue;
                TestSuiteTestCaseLink link = new TestSuiteTestCaseLink();
                link.setTestCaseId(testCaseId);
                newTestCaseLinks.add(link);
            }
            existingTestSuite.setTestSuiteTestCaseLinks(newTestCaseLinks);
        }
        TestSuiteEntity updatedTestSuite = testSuiteController.updateTestSuite(existingTestSuite);
        String pk = existingTestSuite.getId();
        this.eventBroker.post("TESTSUITE/UPDATED", (Object)new Object[]{pk, existingTestSuite});
        this.refreshTestSuiteInExplorer(updatedTestSuite, null, project);
        return updatedTestSuite;
    }

    public McpServerFeatures.SyncToolSpecification updateTestSuiteCollectionTool() {
        McpSchema.Tool tool = new McpSchema.Tool("updateTestSuiteCollection", "Update Test Suite Collection", "Update an existing test suite collection with new metadata and test suites in the current Katalon Studio project", this.createInputSchemaForUpdateTestSuiteCollectionTool(), this.createOutputSchemaForCreateNewOrUpdateTestSuiteTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.updateTestSuiteCollectionToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult updateTestSuiteCollectionToolCallHandler(McpSchema.CallToolRequest request) {
        Object resultContent = "";
        boolean isError = false;
        TestSuiteCollectionEntity updatedTestSuiteCollection = null;
        try {
            Map arguments = request.arguments();
            String testSuiteId = (String)arguments.get("testSuiteId");
            String description = (String)arguments.get("description");
            String tag = (String)arguments.get("tag");
            List testSuiteIds = (List)arguments.get("testSuiteIds");
            if (StringUtils.isBlank((CharSequence)testSuiteId)) {
                isError = true;
                resultContent = "testSuiteId parameter is required";
            } else {
                updatedTestSuiteCollection = this.updateExistingTestSuiteCollection(testSuiteId, description, tag, testSuiteIds);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Failed to update test suite collection: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateNewOrUpdateTestSuite(null, updatedTestSuiteCollection);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private TestSuiteCollectionEntity updateExistingTestSuiteCollection(String testSuiteCollectionId, String description, String tag, List<String> testSuiteIds) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        testSuiteCollectionId = this.normalizeData(testSuiteCollectionId, TEST_SUITE_FOLDER_ROOT);
        TestSuiteCollectionController testSuiteCollectionController = TestSuiteCollectionController.getInstance();
        TestSuiteCollectionEntity existingTestSuiteCollection = testSuiteCollectionController.getTestRunByDisplayId(testSuiteCollectionId);
        if (existingTestSuiteCollection == null) {
            throw new Exception("Test suite not found: " + testSuiteCollectionId);
        }
        if (description != null) {
            existingTestSuiteCollection.setDescription(description);
        }
        if (tag != null) {
            existingTestSuiteCollection.setTag(tag);
        }
        if (testSuiteIds != null) {
            ArrayList<TestSuiteRunConfiguration> newRunConfigurations = new ArrayList<TestSuiteRunConfiguration>();
            TestSuiteController testSuiteController = TestSuiteController.getInstance();
            for (String testSuiteId : testSuiteIds) {
                String normalizedTestSuiteId;
                TestSuiteEntity testSuite;
                if (!StringUtils.isNotBlank((CharSequence)testSuiteId) || (testSuite = testSuiteController.getTestSuiteByDisplayId(normalizedTestSuiteId = this.normalizeData(testSuiteId.trim(), TEST_SUITE_FOLDER_ROOT), project)) == null) continue;
                TestSuiteRunConfiguration runConfig = TestSuiteRunConfiguration.newInstance((TestSuiteEntity)testSuite, (RunConfigurationDescription)new RunConfigurationDescription());
                newRunConfigurations.add(runConfig);
            }
            existingTestSuiteCollection.setTestSuiteRunConfigurations(newRunConfigurations);
        }
        testSuiteCollectionController.updateTestSuiteCollection(existingTestSuiteCollection);
        String pk = existingTestSuiteCollection.getId();
        this.eventBroker.post("TEST_SUITE_COLLECTION/UPDATED", (Object)new Object[]{pk, existingTestSuiteCollection});
        this.refreshTestSuiteInExplorer(null, existingTestSuiteCollection, project);
        return existingTestSuiteCollection;
    }

    public McpServerFeatures.SyncToolSpecification updateDynamicTestSuiteTool() {
        McpSchema.Tool tool = new McpSchema.Tool("updateDynamicTestSuite", "Update Dynamic Test Suite", "Update an existing dynamic test suite with new metadata and filtering configuration in the current Katalon Studio project", this.createInputSchemaForUpdateDynamicTestSuiteTool(), this.createOutputSchemaForCreateNewOrUpdateTestSuiteTool(), null, null);
        return McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((exchange, request) -> this.updateDynamicTestSuiteToolCallHandler((McpSchema.CallToolRequest)request)).build();
    }

    private McpSchema.CallToolResult updateDynamicTestSuiteToolCallHandler(McpSchema.CallToolRequest request) {
        Object resultContent = "";
        boolean isError = false;
        FilteringTestSuiteEntity updatedDynamicTestSuite = null;
        try {
            Map arguments = request.arguments();
            String testSuiteId = (String)arguments.get("testSuiteId");
            String description = (String)arguments.get("description");
            String filteringText = (String)arguments.get("filteringText");
            String filteringBuiltIn = (String)arguments.get("filteringBuiltIn");
            String filteringPlugin = (String)arguments.get("filteringPlugin");
            String filteringExtension = (String)arguments.get("filteringExtension");
            if (StringUtils.isBlank((CharSequence)testSuiteId)) {
                isError = true;
                resultContent = "testSuiteId parameter is required";
            } else {
                updatedDynamicTestSuite = this.updateExistingDynamicTestSuite(testSuiteId, description, filteringText, filteringBuiltIn, filteringPlugin, filteringExtension);
            }
        }
        catch (Exception e) {
            isError = true;
            resultContent = "Failed to update dynamic test suite: " + e.getMessage();
        }
        Map<String, Object> structuredContent = this.createStructuredContentResultForCreateNewOrUpdateTestSuite((TestSuiteEntity)updatedDynamicTestSuite, null);
        if (!isError) {
            resultContent = JsonUtil.toJson(structuredContent);
        }
        return new McpSchema.CallToolResult(List.of(new McpSchema.TextContent(null, (String)resultContent, null)), Boolean.valueOf(isError), structuredContent, null);
    }

    private FilteringTestSuiteEntity updateExistingDynamicTestSuite(String testSuiteId, String description, String filteringText, String filteringBuiltIn, String filteringPlugin, String filteringExtension) throws Exception {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project == null) {
            throw new Exception("No project is currently opened.");
        }
        testSuiteId = this.normalizeData(testSuiteId, TEST_SUITE_FOLDER_ROOT);
        TestSuiteController testSuiteController = TestSuiteController.getInstance();
        TestSuiteEntity existingTestSuite = testSuiteController.getTestSuiteByDisplayId(testSuiteId, project);
        FilteringTestSuiteEntity existingDynamicTestSuite = (FilteringTestSuiteEntity)existingTestSuite;
        if (existingDynamicTestSuite == null) {
            throw new Exception("Test suite not found: " + testSuiteId);
        }
        if (description != null) {
            existingDynamicTestSuite.setDescription(description);
        }
        if (filteringText != null) {
            existingDynamicTestSuite.setFilteringText(filteringText);
        }
        if (filteringBuiltIn != null) {
            existingDynamicTestSuite.setFilteringBuiltIn(filteringBuiltIn);
        }
        if (filteringPlugin != null) {
            existingDynamicTestSuite.setFilteringPlugin(filteringPlugin);
        }
        if (filteringExtension != null) {
            existingDynamicTestSuite.setFilteringExtension(filteringExtension);
        }
        FilteringTestSuiteEntity updatedDynamicTestSuite = (FilteringTestSuiteEntity)testSuiteController.updateTestSuite((TestSuiteEntity)existingDynamicTestSuite);
        String pk = existingTestSuite.getId();
        this.eventBroker.post("TESTSUITE/UPDATED", (Object)new Object[]{pk, existingTestSuite});
        this.refreshTestSuiteInExplorer((TestSuiteEntity)updatedDynamicTestSuite, null, project);
        return updatedDynamicTestSuite;
    }

    private String normalizeData(String id, String folderRoot) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        if (((String)(id = ((String)id).trim().replace("\\", "/"))).startsWith("/")) {
            id = ((String)id).substring(1);
        }
        if (((String)id).endsWith("/")) {
            id = ((String)id).substring(0, ((String)id).length() - 1);
        }
        if (!((String)id).startsWith(folderRoot) && !((String)id).equals(folderRoot)) {
            id = folderRoot + "/" + (String)id;
        }
        return id;
    }

    private FolderEntity getOrCreateFeatureFolder(ProjectEntity project, String folderPath) throws Exception {
        FolderEntity folder = FolderController.getInstance().getFolderByDisplayId(project, folderPath);
        if (folder != null) {
            return folder;
        }
        File fullFolderPath = new File(project.getFolderLocation() + "/" + folderPath);
        if (!fullFolderPath.exists()) {
            fullFolderPath.mkdirs();
        }
        return FolderController.getInstance().getFolderByDisplayId(project, folderPath);
    }

    private void refreshTestSuiteInExplorer(TestSuiteEntity testSuiteEntity, TestSuiteCollectionEntity testSuiteCollectionEntity, ProjectEntity project) {
        try {
            if (testSuiteEntity != null) {
                TestSuiteTreeEntity testSuiteTreeEntity = TreeEntityUtil.getTestSuiteTreeEntity((TestSuiteEntity)testSuiteEntity, (ProjectEntity)project);
                this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)testSuiteTreeEntity);
            } else if (testSuiteCollectionEntity != null) {
                TestSuiteCollectionTreeEntity testSuiteCollectionTreeEntity = TreeEntityUtil.getTestSuiteCollectionTreeEntity((TestSuiteCollectionEntity)testSuiteCollectionEntity, (ProjectEntity)project);
                this.eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)testSuiteCollectionTreeEntity);
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to refresh test suite in explorer");
        }
    }

    private void openTestSuiteInEditor(TestSuiteEntity testSuiteEntity, TestSuiteCollectionEntity testSuiteCollectionEntity, ProjectEntity project) {
        try {
            if (testSuiteEntity != null) {
                TestSuiteTreeEntity testSuiteTreeEntity = TreeEntityUtil.getTestSuiteTreeEntity((TestSuiteEntity)testSuiteEntity, (ProjectEntity)project);
                this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", (Object)testSuiteTreeEntity.getObject());
            } else if (testSuiteCollectionEntity != null) {
                TestSuiteCollectionTreeEntity testSuiteCollectionTreeEntity = TreeEntityUtil.getTestSuiteCollectionTreeEntity((TestSuiteCollectionEntity)testSuiteCollectionEntity, (ProjectEntity)project);
                this.eventBroker.post("EXPLORER/OPEN_SELECTED_ITEM", testSuiteCollectionTreeEntity.getObject());
            }
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e, (String)"Failed to open test suite in editor");
        }
    }

    private void validateTestSuiteName(String testSuiteName) throws Exception {
        if (StringUtils.isBlank((CharSequence)testSuiteName)) {
            throw new Exception("Test Suite name cannot be blank.");
        }
        if (!testSuiteName.matches("^[a-zA-Z0-9][a-zA-Z0-9\\s().,_-]*$")) {
            throw new Exception("Test Suite name must start with English letters or numbers, and can contain spaces and these characters: ( ) . , _ -");
        }
    }

    private McpSchema.JsonSchema createInputSchemaForGetTestSuiteTool() {
        Map<String, Map<String, String>> properties = Map.of("testSuiteId", Map.of("type", "string", "description", "The ID of the test suite to retrieve details (e.g., 'Test Suites/My Test Suite' or 'Test Suites/Folder1/My Test Suite' or 'Folder1/My Test Suite')"));
        return new McpSchema.JsonSchema("object", properties, List.of("testSuiteId"), null, null, null);
    }

    private Map<String, Object> createOutputSchemaForGetTestSuiteTool() {
        return Map.of("type", "object", "properties", Map.of("result", Map.of("type", "object", "description", "Detailed information about the test suite", "properties", this.createTestSuiteProperties())), "required", List.of("result"));
    }

    private Map<String, Object> createTestSuiteProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("testSuiteId", Map.of("type", "string", "description", "The ID of the test suite"));
        properties.put("testSuiteType", Map.of("type", "string", "description", "The type of the test suite (e.g., Test Suite, Test Suite Collection, Dynamic Test Suite)"));
        properties.put("testSuiteName", Map.of("type", "string", "description", "The name of the test suite"));
        properties.put("testSuiteDescription", Map.of("type", "string", "description", "The description of the test suite"));
        properties.put("testSuiteTag", Map.of("type", "string", "description", "The tag of the test suite (for Test Suite Collection only)"));
        properties.put("testSuiteScriptContent", Map.of("type", "string", "description", "The Groovy script content of the test suite (for Test Suite only)"));
        Map<String, Map<String, String>> testCaseProperties = Map.of("testCaseId", Map.of("type", "string", "description", "The ID of the test case"), "testCaseName", Map.of("type", "string", "description", "Test case name"), "testCaseDescription", Map.of("type", "string", "description", "Test case description"));
        properties.put("testCaseLinks", Map.of("type", "array", "items", Map.of("type", "object", "properties", testCaseProperties, "required", List.of("testCaseId", "testCaseName")), "description", "List of test cases in the test suite (for Test Suite only)"));
        Map<String, Map<String, String>> executionConfigurationProperties = Map.of("mailRecipient", Map.of("type", "string", "description", "The email recipients for test suite reports (for Test Suite, Dynamic Test Suite only)"), "pageLoadTimeoutInSeconds", Map.of("type", "integer", "description", "Page load timeout in seconds (for Test Suite, Dynamic Test Suite only)"), "isPageLoadTimeoutDefault", Map.of("type", "boolean", "description", "Whether using default page load timeout (for Test Suite, Dynamic Test Suite only)"), "retryFailedExecutionsImmediately", Map.of("type", "boolean", "description", "Whether to retry failed executions immediately (for Test Suite, Dynamic Test Suite only)"), "retryFailedTestCasesOnly", Map.of("type", "boolean", "description", "Whether to retry failed test cases only (for Test Suite, Dynamic Test Suite only)"), "retryAllExecutions", Map.of("type", "boolean", "description", "Whether to retry all executions (for Test Suite, Dynamic Test Suite only)"), "numberOfRetry", Map.of("type", "integer", "description", "Number of retries (for Test Suite, Dynamic Test Suite only)"), "executionMode", Map.of("type", "string", "description", "Execution mode (e.g., SEQUENTIAL, PARALLEL) (for Test Suite Collection only)"), "maxConcurrentInstances", Map.of("type", "integer", "description", "Maximum number of concurrent instances (for Test Suite Collection only)"), "delayBetweenInstancesInSeconds", Map.of("type", "integer", "description", "Delay between instances in seconds (for Test Suite Collection only)"));
        properties.put("executionConfiguration", Map.of("type", "object", "properties", executionConfigurationProperties, "description", "Execution configuration of the test suite"));
        Map<String, Map<String, String>> testSuiteProperties = Map.of("testSuiteId", Map.of("type", "string", "description", "The ID of the test suite"), "testSuiteName", Map.of("type", "string", "description", "Test suite name"), "testSuiteDescription", Map.of("type", "string", "description", "Test suite description"));
        properties.put("testSuiteRunConfigurations", Map.of("type", "array", "items", Map.of("type", "object", "properties", testSuiteProperties, "required", List.of("testSuiteId", "testSuiteName")), "description", "List of test suites in the test suite collection (for Test Suite Collection only)"));
        Map<String, Map<String, String>> filteringConfigurationProperties = Map.of("filteringText", Map.of("type", "string", "description", "The filtering text/query used to dynamically select test cases (for Dynamic Test Suite only)"), "filteringBuiltIn", Map.of("type", "string", "description", "The built-in filtering method used (e.g., basic search, advanced search, tag-based filtering) (for Dynamic Test Suite only)"));
        properties.put("filteringConfiguration", Map.of("type", "object", "properties", filteringConfigurationProperties, "description", "Filtering configuration that defines how test cases are dynamically selected (for Dynamic Test Suite only)"));
        return properties;
    }

    private McpSchema.JsonSchema createInputSchemaForCreateTestSuiteTool() {
        Map<String, Map<String, String>> properties = Map.of("folderPath", Map.of("type", "string", "description", "The folder path where the test suite should be created (e.g., 'Test Suites/Login', optional, defaults to root)"), "testSuiteName", Map.of("type", "string", "description", "The name of the test suite to create. Test Suite name must start with English letters or numbers, and can contain spaces and these characters: ( ) . , _ -"), "description", Map.of("type", "string", "description", "Description of the test suite (optional)"), "testCaseIds", Map.of("type", "array", "items", Map.of("type", "string"), "description", "List of test case IDs to include in the test suite (optional)"));
        return new McpSchema.JsonSchema("object", properties, List.of("testSuiteName"), null, null, null);
    }

    private McpSchema.JsonSchema createInputSchemaForCreateTestSuiteCollectionTool() {
        Map<String, Map<String, String>> properties = Map.of("folderPath", Map.of("type", "string", "description", "The folder path where the test suite collection should be created (e.g., 'Test Suites/Collections', optional, defaults to root)"), "testSuiteName", Map.of("type", "string", "description", "The name of the test suite collection to create. Test Suite Collection name must start with English letters or numbers, and can contain spaces and these characters: ( ) . , _ -"), "description", Map.of("type", "string", "description", "Description of the test suite collection (optional)"), "tag", Map.of("type", "string", "description", "Tags for the test suite collection (optional)"), "testSuiteIds", Map.of("type", "array", "items", Map.of("type", "string"), "description", "List of test suite IDs to include in the test suite collection (optional)"));
        return new McpSchema.JsonSchema("object", properties, List.of("testSuiteName"), null, null, null);
    }

    private McpSchema.JsonSchema createInputSchemaForCreateDynamicTestSuiteTool() {
        Map<String, Map<String, String>> properties = Map.of("folderPath", Map.of("type", "string", "description", "The folder path where the dynamic test suite should be created (e.g., 'Test Suites/Login', optional, defaults to root)"), "testSuiteName", Map.of("type", "string", "description", "The name of the dynamic test suite to create. Test Suite name must start with English letters or numbers, and can contain spaces and these characters: ( ) . , _ -"), "description", Map.of("type", "string", "description", "Description of the dynamic test suite (optional)"), "filteringText", Map.of("type", "string", "description", "The filtering text/query used to dynamically select test cases (optional)"), "filteringBuiltIn", Map.of("type", "string", "description", "The built-in filtering method (e.g., 'basic-search', 'advanced-search', 'tag-based-filtering', optional)"), "filteringPlugin", Map.of("type", "string", "description", "The plugin ID used for filtering (optional, used with external plugins)"), "filteringExtension", Map.of("type", "string", "description", "The extension ID used for filtering (optional, used with external extensions)"));
        return new McpSchema.JsonSchema("object", properties, List.of("testSuiteName"), null, null, null);
    }

    private McpSchema.JsonSchema createInputSchemaForUpdateTestSuiteTool() {
        Map<String, Map<String, String>> properties = Map.of("testSuiteId", Map.of("type", "string", "description", "The ID of the test suite to update"), "description", Map.of("type", "string", "description", "The new description of the test suite (optional, null to keep current)"), "testCaseIds", Map.of("type", "array", "items", Map.of("type", "string"), "description", "The list of test case IDs to include in this test suite (optional, null to keep current if provide will replaces existing list)"));
        return new McpSchema.JsonSchema("object", properties, List.of("testSuiteId"), null, null, null);
    }

    private McpSchema.JsonSchema createInputSchemaForUpdateTestSuiteCollectionTool() {
        Map<String, Map<String, String>> properties = Map.of("testSuiteId", Map.of("type", "string", "description", "The ID of the test suite collection to update"), "description", Map.of("type", "string", "description", "The new description of the test suite collection (optional, null to keep current)"), "tag", Map.of("type", "string", "description", "The new tags for the test suite collection (optional, null to keep current)"), "testSuiteIds", Map.of("type", "array", "items", Map.of("type", "string"), "description", "The list of test suite IDs to include in this collection (optional, null to keep current if provide will replaces existing list)"));
        return new McpSchema.JsonSchema("object", properties, List.of("testSuiteId"), null, null, null);
    }

    private McpSchema.JsonSchema createInputSchemaForUpdateDynamicTestSuiteTool() {
        Map<String, Map<String, String>> properties = Map.of("testSuiteId", Map.of("type", "string", "description", "The ID of the dynamic test suite to update"), "description", Map.of("type", "string", "description", "The new description of the dynamic test suite (optional, null to keep current)"), "filteringText", Map.of("type", "string", "description", "The new filtering text/query used to dynamically select test cases (optional, null to keep current)"), "filteringBuiltIn", Map.of("type", "string", "description", "The new built-in filtering method (e.g., 'basic-search', 'advanced-search', 'tag-based-filtering', optional, null to keep current)"), "filteringPlugin", Map.of("type", "string", "description", "The new plugin ID used for filtering (optional, null to keep current, used with external plugins)"), "filteringExtension", Map.of("type", "string", "description", "The new extension ID used for filtering (optional, null to keep current, used with external extensions)"));
        return new McpSchema.JsonSchema("object", properties, List.of("testSuiteId"), null, null, null);
    }

    private Map<String, Object> createOutputSchemaForCreateNewOrUpdateTestSuiteTool() {
        return Map.of("type", "object", "properties", Map.of("testSuiteId", Map.of("type", "string", "description", "The ID of the created or updated test suite")), "required", List.of("testSuiteId"));
    }
}

