/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.preferences;

import com.kms.katalon.ai.core.model.config.StudioAssistConfig;
import com.kms.katalon.ai.core.model.config.StudioAssistConfigType;
import com.kms.katalon.ai.core.model.exception.StudioAssistLoadingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistSavingConfigException;
import com.kms.katalon.ai.core.model.exception.StudioAssistUnavailableException;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.util.CryptoUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;

public abstract class StudioAssistPreferenceStore {
    protected static String STUDIO_ASSIST_CONFIG_TYPE = "studio_assist_config_type";
    protected ScopedPreferenceStore store = StudioAssistPreferenceStore.get();

    public static ScopedPreferenceStore get() {
        return PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.ai");
    }

    public static StudioAssistConfigType getSavedConfigType() {
        StudioAssistConfigType type;
        String rawConfigType = StudioAssistPreferenceStore.get().getString(STUDIO_ASSIST_CONFIG_TYPE);
        if (rawConfigType == null || rawConfigType.isBlank()) {
            return StudioAssistConfigType.GEN_AI;
        }
        try {
            type = StudioAssistConfigType.valueOf((String)rawConfigType);
        }
        catch (IllegalArgumentException e) {
            type = StudioAssistConfigType.GEN_AI;
            LoggerSingleton.logError((Throwable)e, (String)("Failed to get saved config type '" + rawConfigType + "', fallback to GEN_AI"));
        }
        return type;
    }

    public abstract StudioAssistConfig getConfig() throws StudioAssistLoadingConfigException;

    public abstract void saveConfig(StudioAssistConfig var1) throws StudioAssistSavingConfigException;

    public void saveCustomPrompt(PromptType promptType, String content) throws StudioAssistSavingConfigException {
        switch (promptType) {
            case CODE_GENERATE: {
                StudioAssistPreferenceStore.get().setValue("studioassist.prompt.generateCode", content);
                break;
            }
            case CODE_EXPLAIN: {
                StudioAssistPreferenceStore.get().setValue("studioassist.prompt.explainCode", content);
                break;
            }
            case CHATBOT: {
                StudioAssistPreferenceStore.get().setValue("studioassist.prompt.chatbot", content);
                break;
            }
            case FAILURE_ANALYSIS: {
                StudioAssistPreferenceStore.get().setValue("studioassist.prompt.testExecutionFailureAnalysis", content);
                break;
            }
            case AGENT: {
                StudioAssistPreferenceStore.get().setValue("studioassist.prompt.agent", content);
                break;
            }
        }
        try {
            StudioAssistPreferenceStore.get().save();
        }
        catch (IOException e) {
            throw new StudioAssistSavingConfigException((Throwable)e);
        }
    }

    public String getCustomPrompt(PromptType promptType) throws StudioAssistUnavailableException {
        switch (promptType) {
            case CODE_GENERATE: {
                return StudioAssistPreferenceStore.get().getString("studioassist.prompt.generateCode");
            }
            case CODE_EXPLAIN: {
                return StudioAssistPreferenceStore.get().getString("studioassist.prompt.explainCode");
            }
            case CHATBOT: {
                return StudioAssistPreferenceStore.get().getString("studioassist.prompt.chatbot");
            }
            case FAILURE_ANALYSIS: {
                return StudioAssistPreferenceStore.get().getString("studioassist.prompt.testExecutionFailureAnalysis");
            }
            case AGENT: {
                return StudioAssistPreferenceStore.get().getString("studioassist.prompt.agent");
            }
        }
        throw new StudioAssistUnavailableException("Katalon Studio has not supported custom prompt for " + promptType.getName());
    }

    protected String encode(String value) throws UnsupportedEncodingException, GeneralSecurityException {
        CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)value);
        return CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo);
    }

    protected String decode(String value) throws GeneralSecurityException, IOException {
        CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)value);
        return CryptoUtil.decode((CryptoUtil.CrytoInfo)cryptoInfo);
    }
}

