/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.ai.services;

import com.katalon.network.core.utils.UrlParser;
import com.katalon.network.oauth.core.model.AuthorizationRequest;
import com.katalon.network.oauth.core.model.exception.OAuthException;
import com.katalon.network.oauth.core.services.IOAuthService;
import com.kms.katalon.ai.core.constant.StudioAssistErrorEnum;
import com.kms.katalon.ai.core.model.StudioAssistChatAnswerMessageFuture;
import com.kms.katalon.ai.core.model.agent.AgentConversation;
import com.kms.katalon.ai.core.model.agent.AgentMessage;
import com.kms.katalon.ai.core.model.agent.AgentMessageStatus;
import com.kms.katalon.ai.core.model.agent.AgentSession;
import com.kms.katalon.ai.core.model.agent.AgentSetting;
import com.kms.katalon.ai.core.model.agent.Authorization;
import com.kms.katalon.ai.core.model.agent.AuthorizationStatus;
import com.kms.katalon.ai.core.model.agent.MaxedToolCallStatus;
import com.kms.katalon.ai.core.model.agent.McpClient;
import com.kms.katalon.ai.core.model.agent.McpServerConnectionStatus;
import com.kms.katalon.ai.core.model.agent.ToolCallApproval;
import com.kms.katalon.ai.core.model.agent.ToolCallMessage;
import com.kms.katalon.ai.core.model.agent.ToolCallStatus;
import com.kms.katalon.ai.core.model.agent.config.McpHttpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerDefinition;
import com.kms.katalon.ai.core.model.agent.config.McpServerSetting;
import com.kms.katalon.ai.core.model.agent.config.McpSetting;
import com.kms.katalon.ai.core.model.agent.config.McpSseServerDefinition;
import com.kms.katalon.ai.core.model.agent.event.AgentMessageUpdatedEvent;
import com.kms.katalon.ai.core.model.agent.event.McpClientUpdatedEvent;
import com.kms.katalon.ai.core.model.chat.ResponseMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatAnswerMessage;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatPair;
import com.kms.katalon.ai.core.model.chat.StudioAssistChatQuestionMessage;
import com.kms.katalon.ai.core.model.exception.McpClientException;
import com.kms.katalon.ai.core.model.exception.McpClientUnauthorizedException;
import com.kms.katalon.ai.core.model.exception.StudioAssistBaseException;
import com.kms.katalon.ai.core.model.prompt.PromptType;
import com.kms.katalon.ai.core.services.IAgentManager;
import com.kms.katalon.ai.core.services.IAgentPreferences;
import com.kms.katalon.ai.core.services.IMcpService;
import com.kms.katalon.ai.core.services.IStudioAssistService;
import com.kms.katalon.ai.core.util.ToolUtil;
import com.kms.katalon.ai.mcp.server.McpServerManager;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryService;
import com.kms.katalon.session.core.services.ISessionManager;
import com.kms.katalon.util.collections.Pair;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.client.ClientInformation;
import com.nimbusds.oauth2.sdk.client.ClientMetadata;
import com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import io.modelcontextprotocol.spec.McpSchema;
import jakarta.inject.Inject;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Creatable
public class AgentManager
implements IAgentManager {
    private static final Logger logger = LoggerFactory.getLogger(AgentManager.class);
    private static final String KATALON_STUDIO_MCP_SERVER_NAME = "katalon-studio";
    private static final String KATALON_MCP_SERVER_NAME = "katalon";
    private static final String KATALON_MCP_SERVER_DEFAULT_URL = "https://mcp.katalon.com/mcp";
    private static final String KATALON_MCP_SERVER_URL_VARIABLE = "KATALON_MCP_SERVER_URL";
    private static final String KATALON_TESTOPS_MCP_SERVER_URL_VARIABLE = "KATALON_TESTOPS_MCP_SERVER_URL";
    public static final String KATALON_TESTOPS_MCP_SERVER_NAME = "katalon-testops";
    @Inject
    private IAgentPreferences agentPreferences;
    @Inject
    private IMcpService mcpService;
    @Inject
    private IStudioAssistService studioAssistService;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private McpServerManager mcpServerManager;
    @Inject
    private ISessionManager sessionManager;
    @Inject
    private IOAuthService oauthService;
    @Inject
    private IDiscoveryService discoveryService;

    public void addServer(AgentSession session, McpServerDefinition server) {
        McpSetting setting = this.agentPreferences.loadMcpSetting();
        setting.addServer(server);
        this.agentPreferences.saveMcpSetting(setting);
        AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
        agentSetting.addMcpServerSettings(new McpServerSetting(server.getName()));
        this.agentPreferences.saveAgentSetting(agentSetting);
        McpClient client = new McpClient(server.getName());
        client.setStatus(McpServerConnectionStatus.DISCONNECTED);
        this.updateOrAddMcpClient(session, client);
        this.eventBroker.post("ON_MCP_CLIENT_ADDED", (Object)server);
    }

    public void removeServer(AgentSession session, String server) {
        this.mcpService.disconnectServer(server);
        McpSetting mcpSetting = this.agentPreferences.loadMcpSetting();
        mcpSetting.getServers().removeIf(serverDef -> server.equals(serverDef.getName()));
        this.agentPreferences.saveMcpSetting(mcpSetting);
        logger.debug("Removed server {} from MCP settings", (Object)server);
        AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
        agentSetting.getMcpServerSettings().removeIf(serverSetting -> server.equals(serverSetting.getServer()));
        this.agentPreferences.saveAgentSetting(agentSetting);
        logger.debug("Removed server {} from Agent settings", (Object)server);
        try {
            this.mcpService.removeOAuthInfo(server);
        }
        catch (McpClientException e) {
            logger.error("Failed to remove OAuth info for server: {}", (Object)server, (Object)e);
        }
        session.getMcpClients().removeIf(client -> server.equals(client.getServer()));
        logger.info("Successfully removed server: {}", (Object)server);
    }

    public CompletableFuture<Void> connectServer(AgentSession session, McpServerDefinition server) {
        return CompletableFuture.runAsync(() -> {
            McpClient mcpClient = new McpClient(server.getName());
            mcpClient.setBuiltin(server.isBuiltin());
            this.updateOrAddMcpClient(session, mcpClient);
            ClientInformation clientInfo = null;
            Tokens tokens = null;
            try {
                clientInfo = this.mcpService.loadOAuthClient(server.getName());
                tokens = this.mcpService.loadOauthTokens(server.getName());
                if (clientInfo != null) {
                    Authorization authorization = new Authorization();
                    authorization.setClient(clientInfo);
                    authorization.setTokens(tokens);
                    mcpClient.setAuthorization(authorization);
                    tokens = this.tryRefreshTokens(mcpClient, server);
                }
            }
            catch (McpClientException mcpClientException) {
                logger.warn("Cannot load OAuth client and tokens for server: {}", (Object)server.getName());
            }
            Consumer<Throwable> handleError = exception -> {
                logger.error("Failed to connect to MCP server: {}", (Object)server.getName(), exception);
                boolean isUnauthorized = exception instanceof McpClientUnauthorizedException;
                if (isUnauthorized) {
                    this.setClientStatus(mcpClient, McpServerConnectionStatus.UNAUTHORIZED);
                    this.updateOrAddMcpClient(session, mcpClient);
                    this.handleUnauthorizedClient(session, mcpClient, server);
                } else {
                    mcpClient.setConnectionError(new McpClientException("Connection failed: " + exception.getMessage()));
                    this.setClientStatus(mcpClient, McpServerConnectionStatus.ERROR);
                    this.updateOrAddMcpClient(session, mcpClient);
                }
            };
            try {
                String token;
                logger.debug("Connecting to MCP server: {}", (Object)server.getName());
                this.setClientStatus(session.getMcpClient(server.getName()), McpServerConnectionStatus.CONNECTING);
                AccessToken accessToken = tokens == null ? null : tokens.getAccessToken();
                String string = token = accessToken == null ? "" : accessToken.getValue();
                if (server.getName().equals(KATALON_TESTOPS_MCP_SERVER_NAME)) {
                    token = this.sessionManager.getSession().getKatOneToken().getAccessToken();
                }
                this.mcpService.connectServer(server, token);
                this.mcpService.initialize(server.getName()).handleAsync((initialized, throwable) -> {
                    if (throwable != null) {
                        handleError.accept((Throwable)throwable);
                        return CompletableFuture.completedFuture(false);
                    }
                    return this.mcpService.getTools(server.getName()).thenApply(tools -> {
                        mcpClient.setAvailableTools(tools);
                        this.setClientStatus(mcpClient, McpServerConnectionStatus.CONNECTED);
                        this.updateOrAddMcpClient(session, mcpClient);
                        return true;
                    });
                });
            }
            catch (Exception ex) {
                handleError.accept(ex);
            }
        });
    }

    public AuthorizationRequest requestServerAuthorization(AgentSession session, String server) {
        McpClient mcpClient = session.getMcpClient(server);
        if (mcpClient == null) {
            logger.error("No MCP client found for server: {}", (Object)server);
            return null;
        }
        if (mcpClient.getStatus() != McpServerConnectionStatus.UNAUTHORIZED) {
            logger.warn("MCP client is not in unauthorized state for server: {}", (Object)server);
            return null;
        }
        Authorization authorization = mcpClient.getAuthorization();
        if (authorization == null) {
            logger.error("No authorization info found for server: {}", (Object)server);
            return null;
        }
        if (!Set.of(AuthorizationStatus.UNAUTHORIZED, AuthorizationStatus.ERROR).contains(authorization.getStatus())) {
            logger.error("Authorization info is not in proper state for authentication of server: {}", (Object)server);
            return null;
        }
        if (!this.mcpServerManager.isRunning()) {
            authorization.setStatus(AuthorizationStatus.ERROR);
            authorization.setErrorMessage("Katalon Studio MCP server is not available to process authorization. Please reload Katalon Studio MCP server and try again.");
            McpClientUpdatedEvent.post((McpClient)mcpClient, (IEventBroker)this.eventBroker);
            return null;
        }
        authorization.setStatus(AuthorizationStatus.PROCESSING);
        authorization.setErrorMessage("");
        McpClientUpdatedEvent.post((McpClient)mcpClient, (IEventBroker)this.eventBroker);
        ClientInformation oauthClient = authorization.getClient();
        URI callbackUri = URI.create(this.mcpServerManager.getOAuthCallbackUrl());
        if (oauthClient == null) {
            try {
                ClientMetadata clientMetadata = new ClientMetadata();
                clientMetadata.setName("Katalon Studio");
                clientMetadata.setURI(URI.create("https://katalon.com/katalon-studio"));
                clientMetadata.setGrantTypes(Set.of(GrantType.AUTHORIZATION_CODE, GrantType.REFRESH_TOKEN));
                clientMetadata.setResponseTypes(Set.of(ResponseType.CODE));
                clientMetadata.setTokenEndpointAuthMethod(ClientAuthenticationMethod.NONE);
                clientMetadata.setRedirectionURI(callbackUri);
                oauthClient = this.oauthService.registerClient(clientMetadata, authorization.getServerMetadata());
                authorization.setClient(oauthClient);
                this.mcpService.saveOAuthClient(mcpClient.getServer(), oauthClient);
            }
            catch (Exception e) {
                logger.error("Failed to register OAuth client", (Throwable)e);
                authorization.setStatus(AuthorizationStatus.ERROR);
                authorization.setErrorMessage("Failed to register OAuth client");
                McpClientUpdatedEvent.post((McpClient)mcpClient, (IEventBroker)this.eventBroker);
                return null;
            }
        }
        try {
            AuthorizationRequest authRequest = this.oauthService.setupRequest(oauthClient, callbackUri, authorization.getServerMetadata());
            authorization.getRequests().put(authRequest.getState(), authRequest);
            authorization.setStatus(AuthorizationStatus.UNAUTHORIZED);
            McpClientUpdatedEvent.post((McpClient)mcpClient, (IEventBroker)this.eventBroker);
            return authRequest;
        }
        catch (Exception e) {
            logger.error("Failed to setup OAuth request", (Throwable)e);
            authorization.setErrorMessage("Failed to setup OAuth request");
            authorization.setStatus(AuthorizationStatus.ERROR);
            McpClientUpdatedEvent.post((McpClient)mcpClient, (IEventBroker)this.eventBroker);
            return null;
        }
    }

    public void authorizeServer(AgentSession session, String state, String authorizationCode) {
        McpClient mcpClient = session.getMcpClientByOAuthState(state);
        if (mcpClient == null) {
            logger.warn("No MCP client found for authorized state: {}", (Object)state);
            return;
        }
        Authorization authorization = mcpClient.getAuthorization();
        AuthorizationRequest authRequest = (AuthorizationRequest)authorization.getRequests().get(state);
        try {
            Tokens tokens = this.oauthService.generateToken(authorizationCode, authRequest, authorization.getServerMetadata());
            authorization.setTokens(tokens);
            authorization.setStatus(AuthorizationStatus.AUTHORIZED);
            this.mcpService.saveOAuthTokens(mcpClient.getServer(), tokens);
            this.refreshClient(session, mcpClient);
        }
        catch (OAuthException | McpClientException throwable) {
            authorization.setErrorMessage("Failed to generate OAuth tokens");
            McpClientUpdatedEvent.post((McpClient)mcpClient, (IEventBroker)this.eventBroker);
        }
    }

    public CompletableFuture<Void> refreshClient(AgentSession session, McpClient client) {
        this.mcpService.disconnectServer(client.getServer());
        McpServerDefinition serverDefinition = this.getServerDefinition(client.getServer());
        if (serverDefinition == null) {
            logger.error("Server definition not found for: {}", (Object)client.getServer());
            return CompletableFuture.failedFuture(new McpClientException("Server definition not found"));
        }
        if (client.getServer().equals(KATALON_STUDIO_MCP_SERVER_NAME) && !this.mcpServerManager.isRunning()) {
            return this.mcpServerManager.start().handle((result, exception) -> {
                this.connectServer(session, serverDefinition);
                return null;
            });
        }
        return this.connectServer(session, serverDefinition);
    }

    public void closeClient(McpClient client) {
        this.mcpService.disconnectServer(client.getServer());
    }

    public void disableServer(AgentSession session, String server) {
        this.mcpService.disconnectServer(server);
        AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
        agentSetting.addDisabledServer(server);
        this.agentPreferences.saveAgentSetting(agentSetting);
        McpClient client = session.getMcpClient(server);
        if (client != null) {
            client.setStatus(McpServerConnectionStatus.DISCONNECTED);
            this.updateOrAddMcpClient(session, client);
        }
    }

    public void enableServer(AgentSession session, String server) {
        AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
        agentSetting.removeDisabledServer(server);
        this.agentPreferences.saveAgentSetting(agentSetting);
        McpClient client = session.getMcpClient(server);
        this.refreshClient(session, client);
    }

    /*
     * WARNING - void declaration
     */
    public CompletableFuture<Pair<AgentMessage, ResponseMessage>> sendMessage(AgentSession session, StudioAssistChatQuestionMessage question) {
        void agentMessage;
        question.setConversationId(session.getConversation().getConversationId());
        StudioAssistChatPair chatItem = session.appendAgentChatItem(question, true);
        if (chatItem == null) {
            return null;
        }
        ResponseMessage chatResponse = chatItem.getResponse();
        if (!(chatResponse instanceof AgentMessage)) {
            return null;
        }
        AgentMessage agentMessage2 = (AgentMessage)chatResponse;
        return this.generateAnswer(session, (AgentMessage)agentMessage).thenApply(arg_0 -> AgentManager.lambda$8((AgentMessage)agentMessage, arg_0));
    }

    public CompletableFuture<Pair<AgentMessage, ResponseMessage>> retryMessage(AgentSession session, StudioAssistChatQuestionMessage question) {
        StudioAssistChatPair chatItem = session.getConversation().getValidChatItems().stream().filter(item -> item instanceof StudioAssistChatPair).map(item -> (StudioAssistChatPair)item).filter(item -> StringUtils.equals((CharSequence)question.getQuestionMsgId(), (CharSequence)item.getQuestion().getQuestionMsgId())).findFirst().orElse(null);
        if (chatItem == null) {
            return CompletableFuture.completedFuture(null);
        }
        AgentMessage agentMessage = new AgentMessage(question.getQuestionMsgId(), question.getConversationId());
        chatItem.setResponse((ResponseMessage)agentMessage);
        return this.generateAnswer(session, agentMessage).thenApply(response -> Pair.of((Object)agentMessage, (Object)response));
    }

    public CompletableFuture<ResponseMessage> processAgentResponseMessage(AgentSession session, Pair<AgentMessage, ResponseMessage> messages) {
        AgentMessage agentMessage = (AgentMessage)messages.getLeft();
        ResponseMessage responseMessage = (ResponseMessage)messages.getRight();
        if (agentMessage.isFinished()) {
            return CompletableFuture.completedFuture(null);
        }
        if (responseMessage instanceof StudioAssistChatAnswerMessage) {
            StudioAssistChatAnswerMessage answerMessage = (StudioAssistChatAnswerMessage)responseMessage;
            if (StringUtils.isEmpty((CharSequence)answerMessage.getFinalAnswer())) {
                if (answerMessage.getWarning() != null) {
                    answerMessage.setFinalAnswer(StudioAssistErrorEnum.INLINE_VIOLATION_ERROR.getMessage());
                } else {
                    answerMessage.setFinalAnswer(StudioAssistErrorEnum.INLINE_GENERAL_ERROR.getMessage());
                }
            }
            agentMessage.addChild((ResponseMessage)answerMessage);
            agentMessage.setStatus(AgentMessageStatus.FINISHED);
            this.onAgentMessageUpdated(agentMessage);
            return CompletableFuture.completedFuture(null);
        }
        if (responseMessage instanceof AgentMessage) {
            AgentMessage agentResponseMessage = (AgentMessage)responseMessage;
            Stream<ToolCallMessage> toolCallMessages = agentResponseMessage.getChildren().stream().filter(child -> child instanceof ToolCallMessage).map(child -> (ToolCallMessage)child);
            agentMessage.setRequestedToolCalls(new ArrayList<ToolCallMessage>(toolCallMessages.toList()));
            return this.processAgentMessage(session, agentMessage);
        }
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - void declaration
     */
    public void approveToolCall(AgentSession session, AgentMessage agentMessage, ToolCallApproval approval) {
        void toolCallMessage;
        List children = agentMessage.getChildren();
        if (children.isEmpty()) {
            return;
        }
        ResponseMessage lastChild = (ResponseMessage)children.get(children.size() - 1);
        if (!(lastChild instanceof ToolCallMessage)) {
            return;
        }
        ToolCallMessage toolCallMessage2 = (ToolCallMessage)lastChild;
        if (toolCallMessage.getStatus() != ToolCallStatus.REVIEWING) {
            return;
        }
        toolCallMessage.setApproval(approval);
        if (approval == ToolCallApproval.ALLOW_IN_CONVERSATION) {
            List approvedTools = session.getConversation().getApprovedTools().computeIfAbsent(toolCallMessage.getServer(), k -> new ArrayList());
            approvedTools.add(toolCallMessage.getTool().name());
        } else if (approval == ToolCallApproval.ALLOW_ALWAYS) {
            AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
            McpServerSetting serverSetting = agentSetting.getMcpServerSettings().stream().filter(arg_0 -> AgentManager.lambda$16((ToolCallMessage)toolCallMessage, arg_0)).findFirst().orElse(null);
            if (serverSetting == null) {
                serverSetting = new McpServerSetting();
                serverSetting.setServer(toolCallMessage.getServer());
                agentSetting.getMcpServerSettings().add(serverSetting);
            }
            serverSetting.getApprovedTools().add(toolCallMessage.getTool().name());
            this.agentPreferences.saveAgentSetting(agentSetting);
        }
        toolCallMessage.setStatus(ToolCallStatus.CALLING);
        this.processAgentMessage(session, agentMessage);
    }

    /*
     * WARNING - void declaration
     */
    public void denyToolCall(AgentSession session, AgentMessage agentMessage) {
        void toolCallMessage;
        List children = agentMessage.getChildren();
        if (children.isEmpty()) {
            return;
        }
        ResponseMessage lastChild = (ResponseMessage)children.get(children.size() - 1);
        if (!(lastChild instanceof ToolCallMessage)) {
            return;
        }
        ToolCallMessage toolCallMessage2 = (ToolCallMessage)lastChild;
        if (toolCallMessage.getStatus() != ToolCallStatus.REVIEWING) {
            return;
        }
        toolCallMessage.setStatus(ToolCallStatus.CANCELLED);
        toolCallMessage.setOutput("The user has chosen to deny the tool call");
        this.onAgentMessageUpdated(agentMessage);
        this.processAgentMessage(session, agentMessage);
    }

    public void acknowledgeMaxedToolCall(AgentSession session, AgentMessage agentMessage) {
        if (agentMessage.getMaxedToolCallStatus() == null) {
            return;
        }
        if (agentMessage.getMaxedToolCallStatus() != MaxedToolCallStatus.REVIEWING) {
            return;
        }
        agentMessage.setMaxedToolCallStatus(MaxedToolCallStatus.ACKNOWLEDGED);
        this.processAgentMessage(session, agentMessage);
    }

    public void rejectMaxedToolCall(AgentSession session, AgentMessage agentMessage) {
        if (agentMessage.getMaxedToolCallStatus() == null) {
            return;
        }
        if (agentMessage.getMaxedToolCallStatus() != MaxedToolCallStatus.REVIEWING) {
            return;
        }
        ToolCallMessage toolCallMessage = agentMessage.getChildren().stream().filter(child -> child instanceof ToolCallMessage).map(child -> (ToolCallMessage)child).filter(call -> call.getStatus() == ToolCallStatus.REQUESTED).findFirst().orElse(null);
        if (toolCallMessage == null) {
            return;
        }
        agentMessage.setMaxedToolCallStatus(MaxedToolCallStatus.REJECTED);
        String message = "The user has chosen to stop the tool call for this chat response because of too much tool calls already";
        toolCallMessage.setOutput(message);
        this.onAgentMessageUpdated(agentMessage);
    }

    public void stopGeneration(AgentSession session, AgentMessage agentMessage) {
        if (agentMessage.isFinished()) {
            return;
        }
        agentMessage.setStatus(AgentMessageStatus.CANCELLED);
        agentMessage.getChildren().stream().filter(child -> child instanceof ToolCallMessage).map(child -> (ToolCallMessage)child).filter(call -> call.getStatus() == ToolCallStatus.CALLING).findFirst().ifPresent(callingTool -> callingTool.setStatus(ToolCallStatus.CANCELLED));
        this.onAgentMessageUpdated(agentMessage);
    }

    public void clearConversation(AgentSession session) {
        session.setConversation(new AgentConversation());
    }

    public McpSetting getMcpSetting() {
        McpSetting setting = this.agentPreferences.loadMcpSetting();
        setting.addServers(this.getBuiltinServers());
        return setting;
    }

    public void selectTool(String server, String tool) {
        AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
        McpServerSetting setting = this.findOrCreateMcpServerSetting(agentSetting, server);
        boolean removed = setting.getExcludedTools().remove(tool);
        logger.debug("Tool {} removed from excluded tools: {}", (Object)tool, (Object)removed);
        this.agentPreferences.saveAgentSetting(agentSetting);
    }

    public void deselectTool(String server, String tool) {
        AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
        McpServerSetting setting = this.findOrCreateMcpServerSetting(agentSetting, server);
        if (!setting.getExcludedTools().contains(tool)) {
            setting.getExcludedTools().add(tool);
            logger.debug("Tool {} added to excluded tools", (Object)tool);
        } else {
            logger.debug("Tool {} already in excluded tools", (Object)tool);
        }
        this.agentPreferences.saveAgentSetting(agentSetting);
    }

    public void selectAllTools(McpClient server) {
        AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
        McpServerSetting setting = this.findOrCreateMcpServerSetting(agentSetting, server.getServer());
        setting.getExcludedTools().clear();
        this.agentPreferences.saveAgentSetting(agentSetting);
    }

    public void deselectAllTools(McpClient server) {
        AgentSetting agentSetting = this.agentPreferences.loadAgentSetting();
        McpServerSetting setting = this.findOrCreateMcpServerSetting(agentSetting, server.getServer());
        setting.getExcludedTools().clear();
        if (server.getAvailableTools() != null) {
            for (McpSchema.Tool tool : server.getAvailableTools()) {
                setting.getExcludedTools().add(tool.name());
            }
            logger.debug("All tools deselected for server: {} ({} tools excluded)", (Object)server.getServer(), (Object)server.getAvailableTools().size());
        }
        this.agentPreferences.saveAgentSetting(agentSetting);
    }

    public StudioAssistChatAnswerMessageFuture getFollowUpQuestions(AgentSession session, String conversationId, String questionId) throws StudioAssistBaseException {
        List validConversation = session.getConversation().getValidChatItems();
        String followUpQuestionRequest = "Based on your last answer, list out 2 follow up questions relating to Katalon to deep dive into it. Output them in the \"suggestedQuestions\" field without explaining into \"finalAnswer\".";
        if (validConversation.isEmpty()) {
            followUpQuestionRequest = "As an automation tester using Katalon Studio, suggest 2 questions. Output them in the \"suggestedQuestions\" field without explaining into \"finalAnswer\".";
        }
        new StudioAssistChatQuestionMessage(conversationId, questionId, followUpQuestionRequest);
        return null;
    }

    public void resetApprovedTools(List<McpServerSetting> mcpServerSettings) {
        AgentSetting agentSettings = this.agentPreferences.loadAgentSetting();
        if (agentSettings == null) {
            logger.warn("Agent settings is null, cannot update approved tools.");
            return;
        }
        List persistedServerSettings = agentSettings.getMcpServerSettings();
        if (persistedServerSettings == null || persistedServerSettings.isEmpty()) {
            logger.warn("No persisted server settings found, cannot update approved tools.");
            return;
        }
        Map<String, List> resetApprovedToolsMap = mcpServerSettings.stream().collect(Collectors.toMap(McpServerSetting::getServer, McpServerSetting::getApprovedTools));
        persistedServerSettings.forEach(serverSetting -> {
            List updatedApprovedTools = (List)resetApprovedToolsMap.get(serverSetting.getServer());
            if (updatedApprovedTools != null) {
                serverSetting.setApprovedTools(updatedApprovedTools);
            }
        });
        this.agentPreferences.saveAgentSetting(agentSettings);
    }

    private void handleUnauthorizedClient(AgentSession session, McpClient mcpClient, McpServerDefinition server) {
        Tokens tokens;
        String serverUrl = "";
        if (server instanceof McpHttpServerDefinition) {
            McpHttpServerDefinition httpServer = (McpHttpServerDefinition)server;
            serverUrl = httpServer.getUrl();
        } else if (server instanceof McpSseServerDefinition) {
            McpSseServerDefinition sseServer = (McpSseServerDefinition)server;
            serverUrl = sseServer.getUrl();
        }
        if (StringUtils.isEmpty((CharSequence)serverUrl)) {
            return;
        }
        Authorization authorization = mcpClient.getAuthorization();
        if (authorization == null) {
            authorization = new Authorization();
            mcpClient.setAuthorization(authorization);
        }
        try {
            String baseUrl = UrlParser.parseBaseUrl((String)serverUrl);
            AuthorizationServerMetadata serverMetadata = this.oauthService.getAuthServerMetadata(baseUrl);
            String serverName = UrlParser.parseHost((String)serverMetadata.getAuthorizationEndpointURI().toString());
            authorization.setServer(serverName);
            authorization.setServerMetadata(serverMetadata);
            if (!this.isSupportedAuthorizationServer(serverMetadata)) {
                authorization.setStatus(AuthorizationStatus.UNSUPPORTED);
                authorization.setErrorMessage("Unsupported authorization server configuration");
            }
        }
        catch (MalformedURLException malformedURLException) {
            authorization.setStatus(AuthorizationStatus.UNSUPPORTED);
            authorization.setErrorMessage("Invalid server URL: " + serverUrl);
        }
        catch (OAuthException oAuthException) {
            authorization.setStatus(AuthorizationStatus.UNSUPPORTED);
            authorization.setErrorMessage("Failed to fetch authorization server metadata for server URL: " + serverUrl);
        }
        McpClientUpdatedEvent.post((McpClient)mcpClient, (IEventBroker)this.eventBroker);
        if (authorization.getClient() != null && (tokens = this.tryRefreshTokens(mcpClient, server)) != null) {
            this.connectServer(session, server);
        }
    }

    private boolean isSupportedAuthorizationServer(AuthorizationServerMetadata metadata) {
        if (metadata.getAuthorizationEndpointURI() == null) {
            return false;
        }
        if (metadata.getTokenEndpointURI() == null) {
            return false;
        }
        if (metadata.getGrantTypes() == null) {
            return false;
        }
        if (!metadata.getGrantTypes().contains(GrantType.AUTHORIZATION_CODE)) {
            return false;
        }
        if (!metadata.getGrantTypes().contains(GrantType.REFRESH_TOKEN)) {
            return false;
        }
        if (metadata.getResponseTypes() == null) {
            return false;
        }
        if (!metadata.getResponseTypes().contains(ResponseType.CODE)) {
            return false;
        }
        if (metadata.getTokenEndpointAuthMethods() == null) {
            return false;
        }
        if (!metadata.getTokenEndpointAuthMethods().contains(ClientAuthenticationMethod.NONE)) {
            return false;
        }
        if (metadata.getCodeChallengeMethods() == null) {
            return false;
        }
        return metadata.getCodeChallengeMethods().contains(CodeChallengeMethod.S256);
    }

    private Tokens tryRefreshTokens(McpClient mcpClient, McpServerDefinition server) {
        Tokens tokens;
        AuthorizationServerMetadata serverMetadata;
        Authorization authorization;
        String serverUrl;
        block11: {
            block10: {
                serverUrl = "";
                if (server instanceof McpHttpServerDefinition) {
                    McpHttpServerDefinition httpServer = (McpHttpServerDefinition)server;
                    serverUrl = httpServer.getUrl();
                } else if (server instanceof McpSseServerDefinition) {
                    McpSseServerDefinition sseServer = (McpSseServerDefinition)server;
                    serverUrl = sseServer.getUrl();
                }
                if (StringUtils.isEmpty((CharSequence)serverUrl)) {
                    return null;
                }
                authorization = mcpClient.getAuthorization();
                String baseUrl = UrlParser.parseBaseUrl((String)serverUrl);
                serverMetadata = this.oauthService.getAuthServerMetadata(baseUrl);
                String serverName = UrlParser.parseHost((String)serverMetadata.getAuthorizationEndpointURI().toString());
                authorization.setServer(serverName);
                authorization.setServerMetadata(serverMetadata);
                if (this.isSupportedAuthorizationServer(serverMetadata)) break block10;
                return null;
            }
            tokens = authorization.getTokens();
            if (tokens != null && tokens.getRefreshToken() != null) break block11;
            return null;
        }
        try {
            Tokens newTokens = this.oauthService.refreshToken(tokens.getRefreshToken(), authorization.getClient(), serverMetadata);
            authorization.setTokens(newTokens);
            authorization.setStatus(AuthorizationStatus.AUTHORIZED);
            this.mcpService.saveOAuthTokens(server.getName(), newTokens);
            return newTokens;
        }
        catch (MalformedURLException e) {
            logger.error("Invalid MCP server URL: " + serverUrl, (Throwable)e);
        }
        catch (OAuthException e) {
            logger.error("Failed to load authorization server metadata for URL: " + serverUrl, (Throwable)e);
        }
        catch (McpClientException e) {
            logger.error("Cannot save new tokens for MCP server: " + server.getName(), (Throwable)e);
        }
        return null;
    }

    private CompletableFuture<ResponseMessage> processAgentMessage(AgentSession session, AgentMessage agentMessage) {
        if (agentMessage == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<ResponseMessage> future = this.doProcessAgentMessage(session, agentMessage);
        if (future == null) {
            return CompletableFuture.completedFuture(null);
        }
        return future.thenCompose(msg -> {
            if (msg == null) {
                return CompletableFuture.completedFuture(null);
            }
            return this.processAgentMessage(session, agentMessage);
        });
    }

    private CompletableFuture<ResponseMessage> doProcessAgentMessage(AgentSession session, AgentMessage agentMessage) {
        AgentSetting agentSetting;
        if (agentMessage.isFinished()) {
            return null;
        }
        ToolCallMessage callingTool = agentMessage.getFirstToolCall(ToolCallStatus.CALLING);
        if (callingTool != null) {
            return this.callTool(session, agentMessage, callingTool);
        }
        ToolCallMessage requestedTool = agentMessage.getFirstToolCall(ToolCallStatus.REQUESTED);
        if (requestedTool == null) {
            ArrayList requestedToolCalls = agentMessage.getRequestedToolCalls();
            if (requestedToolCalls.isEmpty()) {
                return this.generateAnswer(session, agentMessage).thenCompose(newAnswer -> {
                    newAnswer.setMessageId(agentMessage.getMessageId());
                    newAnswer.setConversationId(agentMessage.getConversationId());
                    return this.processAgentResponseMessage(session, (Pair<AgentMessage, ResponseMessage>)Pair.of((Object)agentMessage, (Object)newAnswer));
                });
            }
            requestedTool = (ToolCallMessage)requestedToolCalls.remove(0);
            agentMessage.addChild((ResponseMessage)requestedTool);
        }
        if (agentMessage.isReachedMaxToolCalls(agentSetting = this.agentPreferences.loadAgentSetting())) {
            MaxedToolCallStatus maxedToolCallStatus = agentMessage.getMaxedToolCallStatus();
            if (maxedToolCallStatus == null) {
                agentMessage.setMaxedToolCallStatus(MaxedToolCallStatus.REVIEWING);
                this.onAgentMessageUpdated(agentMessage);
                return null;
            }
            if (maxedToolCallStatus != MaxedToolCallStatus.ACKNOWLEDGED) {
                return null;
            }
        }
        if (!this.isToolApproved(session, requestedTool, agentSetting)) {
            requestedTool.setStatus(ToolCallStatus.REVIEWING);
            this.onAgentMessageUpdated(agentMessage);
            return null;
        }
        return this.callTool(session, agentMessage, requestedTool);
    }

    private CompletableFuture<ResponseMessage> callTool(AgentSession session, AgentMessage agentMessage, ToolCallMessage toolCallMessage) {
        toolCallMessage.setStatus(ToolCallStatus.CALLING);
        this.onAgentMessageUpdated(agentMessage);
        return ((CompletableFuture)this.mcpService.callTool(toolCallMessage).handle((result, throwable) -> {
            ToolCallStatus callStatus = toolCallMessage.getStatus();
            if (callStatus == ToolCallStatus.CANCELLED) {
                return null;
            }
            if (throwable != null) {
                toolCallMessage.setStatus(ToolCallStatus.FAILED);
                toolCallMessage.setOutput("Error: " + throwable.getMessage());
                this.onAgentMessageUpdated(agentMessage);
                return agentMessage;
            }
            if (Boolean.TRUE.equals(result.getRight())) {
                toolCallMessage.setOutput("Error: " + (String)result.getLeft());
                toolCallMessage.setStatus(ToolCallStatus.FAILED);
            } else {
                toolCallMessage.setOutput((String)result.getLeft());
                toolCallMessage.setStatus(ToolCallStatus.SUCCESS);
            }
            this.onAgentMessageUpdated(agentMessage);
            return agentMessage;
        })).thenCompose(msg -> this.processAgentMessage(session, (AgentMessage)msg));
    }

    private CompletableFuture<ResponseMessage> generateAnswer(AgentSession session, AgentMessage agentMessage) {
        Map<String, List<McpSchema.Tool>> availableTools = this.getTools(session);
        CompletableFuture completableFuture = new CompletableFuture();
        try {
            StudioAssistChatAnswerMessageFuture future = this.studioAssistService.askQuestion(PromptType.AGENT, session.getConversation().getValidChatItems(), null, availableTools);
            future.setCallback(completableFuture::complete);
            future.setExceptionCallback(completableFuture::completeExceptionally);
        }
        catch (StudioAssistBaseException e) {
            completableFuture.completeExceptionally(e);
        }
        return completableFuture.exceptionally(throwable -> {
            StudioAssistChatAnswerMessage errorMessage = new StudioAssistChatAnswerMessage();
            errorMessage.setMessageId(agentMessage.getMessageId());
            errorMessage.setConversationId(agentMessage.getConversationId());
            errorMessage.setFinalAnswer(throwable.getMessage());
            agentMessage.addChild((ResponseMessage)errorMessage);
            agentMessage.setStatus(AgentMessageStatus.FAILED);
            this.onAgentMessageUpdated(agentMessage);
            return null;
        });
    }

    private boolean isToolApproved(AgentSession session, ToolCallMessage toolCallMessage, AgentSetting agentSetting) {
        if (agentSetting.isAutoToolApproval()) {
            return true;
        }
        return Stream.concat(session.getConversation().getApprovedTools().entrySet().stream(), agentSetting.getMcpServerSettings().stream().map(setting -> Map.entry(setting.getServer(), setting.getApprovedTools()))).anyMatch(approvalEntry -> StringUtils.equals((CharSequence)((CharSequence)approvalEntry.getKey()), (CharSequence)toolCallMessage.getServer()) && ((List)approvalEntry.getValue()).contains(toolCallMessage.getTool().name()));
    }

    private void onAgentMessageUpdated(AgentMessage message) {
        AgentMessageUpdatedEvent event = AgentMessageUpdatedEvent.create((AgentMessage)message);
        this.eventBroker.post(event.getTopic(), (Object)event);
    }

    private McpServerSetting findOrCreateMcpServerSetting(AgentSetting agentSetting, String serverName) {
        McpServerSetting setting = agentSetting.getMcpServerSettings().stream().filter(s -> serverName.equals(s.getServer())).findFirst().orElse(null);
        if (setting == null) {
            setting = new McpServerSetting(serverName);
            agentSetting.getMcpServerSettings().add(setting);
            logger.debug("Created new McpServerSetting for server: {}", (Object)serverName);
        }
        return setting;
    }

    private McpServerDefinition getServerDefinition(String serverName) {
        McpSetting mcpSetting = this.agentPreferences.loadMcpSetting();
        mcpSetting.addServers(this.getBuiltinServers());
        return mcpSetting.getServers().stream().filter(server -> serverName.equals(server.getName())).findFirst().orElse(null);
    }

    private List<McpServerDefinition> getBuiltinServers() {
        ArrayList<McpServerDefinition> builtinServers = new ArrayList<McpServerDefinition>();
        String katalonMcpServerUrl = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{System.getenv(KATALON_MCP_SERVER_URL_VARIABLE), KATALON_MCP_SERVER_DEFAULT_URL});
        builtinServers.add((McpServerDefinition)McpHttpServerDefinition.builtin((String)KATALON_MCP_SERVER_NAME, (String)"Katalon MCP", (String)katalonMcpServerUrl));
        builtinServers.add((McpServerDefinition)McpHttpServerDefinition.builtin((String)KATALON_STUDIO_MCP_SERVER_NAME, (String)"Katalon Studio MCP", (String)this.mcpServerManager.getStreamableEndpointUrl()));
        String katalonTestOpsMcpServerUrl = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{System.getenv(KATALON_TESTOPS_MCP_SERVER_URL_VARIABLE), this.discoveryService.getServerUrl(ServerType.TESTOPSMCP)});
        if (StringUtils.isNotBlank((CharSequence)katalonTestOpsMcpServerUrl)) {
            builtinServers.add((McpServerDefinition)McpHttpServerDefinition.builtin((String)KATALON_TESTOPS_MCP_SERVER_NAME, (String)"Katalon TestOps MCP", (String)katalonTestOpsMcpServerUrl));
        }
        return builtinServers;
    }

    private void setClientStatus(McpClient mcpClient, McpServerConnectionStatus status) {
        McpServerConnectionStatus oldStatus = mcpClient.getStatus();
        mcpClient.setStatus(status);
        if (oldStatus != status) {
            McpClientUpdatedEvent event = McpClientUpdatedEvent.create((McpClient)mcpClient);
            this.eventBroker.post(event.getTopic(), (Object)event);
        }
    }

    private void updateOrAddMcpClient(AgentSession session, McpClient newClient) {
        List clients = session.getMcpClients();
        boolean found = false;
        int i = 0;
        while (i < clients.size()) {
            McpClient existingClient = (McpClient)clients.get(i);
            if (newClient.getServer().equals(existingClient.getServer())) {
                clients.set(i, newClient);
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            session.addMcpClient(newClient);
        }
    }

    public AgentSetting getAgentSetting() {
        return this.agentPreferences.loadAgentSetting();
    }

    public List<ToolCallMessage> getAvailableTools(AgentSession session) {
        AgentSetting agentSetting = this.getAgentSetting();
        HashMap serverSettings = new HashMap();
        agentSetting.getMcpServerSettings().forEach(setting -> {
            McpServerSetting mcpServerSetting = serverSettings.put(setting.getServer(), setting);
        });
        return session.getMcpClients().stream().filter(mcpClient -> mcpClient.getStatus() == McpServerConnectionStatus.CONNECTED).filter(mcpClient -> !agentSetting.getDisabledServers().contains(mcpClient.getServer())).flatMap(mcpClient -> mcpClient.getAvailableTools().stream().filter(tool -> !serverSettings.computeIfAbsent(mcpClient.getServer(), name -> new McpServerSetting()).getExcludedTools().contains(tool.name())).map(tool -> ToolUtil.toToolCallMessage((McpClient)mcpClient, (McpSchema.Tool)tool))).collect(Collectors.toList());
    }

    private Map<String, List<McpSchema.Tool>> getTools(AgentSession session) {
        AgentSetting agentSetting = this.getAgentSetting();
        HashMap serverSettings = new HashMap();
        agentSetting.getMcpServerSettings().forEach(setting -> {
            McpServerSetting mcpServerSetting = serverSettings.put(setting.getServer(), setting);
        });
        return session.getMcpClients().stream().filter(mcpClient -> mcpClient.getStatus() == McpServerConnectionStatus.CONNECTED).filter(mcpClient -> !agentSetting.getDisabledServers().contains(mcpClient.getServer())).map(mcpClient -> {
            List<McpSchema.Tool> tools = mcpClient.getAvailableTools().stream().filter(tool -> !serverSettings.computeIfAbsent(mcpClient.getServer(), name -> new McpServerSetting()).getExcludedTools().contains(tool.name())).toList();
            return Map.entry(mcpClient.getServer(), tools);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static /* synthetic */ Pair lambda$8(AgentMessage agentMessage, ResponseMessage response) {
        return Pair.of((Object)agentMessage, (Object)response);
    }

    private static /* synthetic */ boolean lambda$16(ToolCallMessage toolCallMessage, McpServerSetting setting) {
        return StringUtils.equals((CharSequence)setting.getServer(), (CharSequence)toolCallMessage.getServer());
    }
}

