/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.parser;

import com.kms.katalon.entity.global.ExecutionProfileEntity;
import groovy.lang.GroovyObject;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.resources.IFolder;

public class GlobalVariableParser {
    public static final String GLOBAL_VARIABLE_CLASS_NAME = "GlobalVariable";
    public static final String GLOBAL_VARIABLE_FILE_NAME = "GlobalVariable.groovy";
    private static GlobalVariableParser _instance;
    private static final String TEMPLATE_CLASS_NAME = "com.kms.katalon.custom.generation.GlobalVariableTemplate";
    private static final String GENERATED_GLOBAL_VARIABLE_LIB_FILE_METHOD_NAME = "generateGlobalVariableFile";
    public static final String INTERNAL_PACKAGE_NAME = "internal";

    private GlobalVariableParser() {
    }

    public static GlobalVariableParser getInstance() {
        if (_instance == null) {
            _instance = new GlobalVariableParser();
        }
        return _instance;
    }

    public void generateGlobalVariableLibFile(IFolder libFolder, List<ExecutionProfileEntity> executionProfiles) throws Exception {
        String libFolderPath = libFolder.getRawLocation().toString();
        File internalPackageFolder = new File(libFolderPath, INTERNAL_PACKAGE_NAME);
        File internalGlobalVariableFile = new File(internalPackageFolder, GLOBAL_VARIABLE_FILE_NAME);
        this.generateGlobalVariableFile(executionProfiles, internalGlobalVariableFile);
        libFolder.getFolder(INTERNAL_PACKAGE_NAME).refreshLocal(2, null);
    }

    private void generateGlobalVariableFile(List<ExecutionProfileEntity> globalVariables, File globalVariableFile) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        if (!globalVariableFile.exists()) {
            globalVariableFile.getParentFile().mkdirs();
            globalVariableFile.createNewFile();
        }
        Class<?> clazz = Class.forName(TEMPLATE_CLASS_NAME);
        GroovyObject object = (GroovyObject)clazz.newInstance();
        object.invokeMethod(GENERATED_GLOBAL_VARIABLE_LIB_FILE_METHOD_NAME, (Object)new Object[]{globalVariableFile, globalVariables});
    }
}

