/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.dialog;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.handlers.AbstractExecutionHandler;
import com.kms.katalon.composer.execution.jobs.ExecuteTestCaseJob;
import com.kms.katalon.composer.quickstart.BaseQuickStartDialog;
import com.kms.katalon.composer.quickstart.BrowserSelect;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.webui.configuration.ChromeRunConfiguration;
import com.kms.katalon.execution.webui.configuration.EdgeChromiumRunConfiguration;
import com.kms.katalon.execution.webui.configuration.FirefoxRunConfiguration;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QuickExecuteFirstWebUITestCaseDialog
extends BaseQuickStartDialog {
    private TestCaseEntity firstTestCase;
    private Text txtTestCase;
    private BrowserSelect browserSelect;

    public QuickExecuteFirstWebUITestCaseDialog(Shell parentShell, TestCaseEntity firstTestCase) {
        super(parentShell);
        this.firstTestCase = firstTestCase;
    }

    protected void createContent(Composite parent) {
        Composite body = (Composite)ComponentBuilder.gridContainer((Composite)parent).margin(50).gridVerticalSpacing(5).build();
        this.createTitle(body);
        this.createRunTestCaseComposite(body);
        Trackings.trackQuickStartRunOpen();
    }

    private void createTitle(Composite parent) {
        ComponentBuilder.label((Composite)parent).text("Run to verify your test script").font(FontUtil.size((Font)FontUtil.BOLD, (int)18)).build();
    }

    private void createRunTestCaseComposite(Composite parent) {
        Composite runFirstTestCaseComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent).marginTop(30).marginBottom(20).gridVerticalSpacing(10).build();
        Composite configComposite = (Composite)ComponentBuilder.gridContainer((Composite)runFirstTestCaseComposite, (int)3).gridHorizontalSpacing(10).build();
        Composite textWrapper = (Composite)ComponentBuilder.gridContainer((Composite)configComposite, (int)1, (int)2048).build();
        this.txtTestCase = (Text)ComponentBuilder.text((Composite)textWrapper, (int)4).marginTop(5).marginLeft(5).autoSize(350, 22).fontSize(10).build();
        this.txtTestCase.setEditable(false);
        this.browserSelect = new BrowserSelect(configComposite, 0);
        ComponentBuilder.canvas((Composite)configComposite).text("Run").autoSizeMD(100).primaryButton().image(ImageManager.getImage((String)"quick_start/right_arrow.png"), 131072).onClick(event -> {
            this.executeFirstTestCase();
            this.okPressed();
        }).build();
    }

    private void executeFirstTestCase() {
        ExecuteTestCaseJob firstExecutionJob = ExecuteTestCaseJob.newInstance(StringConstants.HAND_JOB_LAUNCHING_TEST_CASE, this.firstTestCase, LaunchMode.RUN, UISynchronizeService.getInstance().getSync(), new AbstractExecutionHandler(){

            @Override
            protected IRunConfiguration getRunConfigurationForExecution(String projectDir) throws IOException, ExecutionException, InterruptedException {
                switch (QuickExecuteFirstWebUITestCaseDialog.this.browserSelect.getInput()) {
                    case CHROME_DRIVER: {
                        return new ChromeRunConfiguration(projectDir);
                    }
                    case FIREFOX_DRIVER: {
                        return new FirefoxRunConfiguration(projectDir);
                    }
                    case EDGE_CHROMIUM_DRIVER: {
                        return new EdgeChromiumRunConfiguration(projectDir);
                    }
                }
                return new ChromeRunConfiguration(projectDir);
            }
        });
        firstExecutionJob.setUser(true);
        firstExecutionJob.schedule();
    }

    protected String getTipContent() {
        return "Click the Run button on the menu bar to execute tests.";
    }

    @Deprecated
    protected void createMoreTips(Composite tipsComposite) {
        this.addTip((Control)ComponentBuilder.label((Composite)tipsComposite).autoSize(5, 24).build());
    }

    protected void setInput() {
        UserProfile currentProfile = UserProfileHelper.getCurrentProfile();
        this.browserSelect.setInput(currentProfile.getPreferredBrowser());
        this.txtTestCase.setText(this.firstTestCase.getIdForDisplay());
    }

    protected void okPressed() {
        Trackings.trackQuickStartStartRun((String)this.browserSelect.getInput().name());
        super.okPressed();
    }

    protected boolean isClosable() {
        return false;
    }

    static interface BrowserSelectionCallback {
        public void call(WebUIDriverType var1);
    }
}

