/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.settings.AbstractExecutionSettingPage;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.helper.screenrecorder.VideoFileFormat;
import com.kms.katalon.core.helper.screenrecorder.VideoQuality;
import com.kms.katalon.core.setting.TakeScreenshotSettings;
import com.kms.katalon.core.setting.VideoRecorderSettings;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.execution.setting.ExecutionSettingStore;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class ExecutionSettingPage
extends AbstractExecutionSettingPage {
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;
    private static final String LBL_DEFAULT_EXECUTION = ExecutionMessageConstants.LBL_DEFAULT_EXECUTION;
    private static final String[] BROWSER_RECORDER_VIDEO_FORMAT_ITEMS = Arrays.asList(VideoFileFormat.values()).stream().map(format -> format.toString()).collect(Collectors.toList()).toArray(new String[0]);
    private static final String[] SCREENSHOOT_RECORDER_VIDEO_FORMAT_ITEMS = Arrays.asList(VideoFileFormat.values()).stream().filter(format -> format == VideoFileFormat.AVI || format == VideoFileFormat.MOV).map(format -> format.toString()).collect(Collectors.toList()).toArray(new String[0]);
    private static final String[] VIDEO_QUALITY_ITEMS = Arrays.asList(VideoQuality.values()).stream().map(format -> format.getReadableName()).collect(Collectors.toList()).toArray(new String[0]);
    private ExecutionDefaultSettingStore defaultSettingStore = ExecutionDefaultSettingStore.getStore();
    private ExecutionSettingStore store = ExecutionSettingStore.getStore();
    private Combo cbDefaultBrowser;
    private Combo cbLogTestSteps;
    private Combo cbHideHostName;
    private Button chckOpenReport;
    private Button chckQuitDriversTestCase;
    private Button chckQuitDriversTestSuite;
    private Composite recorderTypeSetting;
    private Composite applicableToSetting;
    private Composite videoSetting;
    private Button btnEnableScreenshot;
    private Button btnEnableVideoRecording;
    private Button btnScreenRecorder;
    private Button btnBrowserRecorder;
    private Combo cbbVideoFormat;
    private Combo cbbVideoQuality;
    private Button btnAllTestCases;
    private Button btnFailedTestCases;
    private IRunConfigurationContributor[] runConfigs;
    private String selectedExecutionConfiguration;

    @Override
    protected void createSettingsArea(Composite container) {
        this.createCommonExecutionOptions(container);
        this.createDuringExecutionOptionsGroup(container);
        this.createPostExecutionOptionsGroup(container);
    }

    private void createCommonExecutionOptions(Composite parent) {
        Composite commonContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).margin(0).gridVerticalSpacing(10).build();
        ComponentBuilder.label((Composite)commonContainer).text(LBL_DEFAULT_EXECUTION).build();
        this.cbDefaultBrowser = (Combo)ComponentBuilder.comboBox((Composite)commonContainer, (int)8).width(120).build();
        ComponentBuilder.label((Composite)commonContainer).text(StringConstants.PREF_LBL_LOG_TEST_STEPS).build();
        this.cbLogTestSteps = (Combo)ComponentBuilder.comboBox((Composite)commonContainer, (int)2056).width(120).build();
        ComponentBuilder.label((Composite)commonContainer).text(StringConstants.PREF_LBL_HIDE_HOST_NAME).build();
        this.cbHideHostName = (Combo)ComponentBuilder.comboBox((Composite)commonContainer, (int)2056).width(120).build();
    }

    private void createDuringExecutionOptionsGroup(Composite parent) {
        Group grpDuringExecution = (Group)ComponentBuilder.group((Composite)parent).margin(this.applyZoom(0)).text(ComposerExecutionMessageConstants.PREF_GRP_DURING_EXECUTION_OPTIONS).fillHorizontal().build();
        this.btnEnableScreenshot = (Button)ComponentBuilder.checkBox((Composite)grpDuringExecution).text(ComposerExecutionMessageConstants.PAGE_TXT_ENABLE_TAKE_SCREENSHOT).build();
        this.btnEnableVideoRecording = (Button)ComponentBuilder.checkBox((Composite)grpDuringExecution).text(ComposerExecutionMessageConstants.PREF_CHCK_ENABLE_VIDEO_RECORDER).build();
        this.recorderTypeSetting = (Composite)ComponentBuilder.gridContainer((Composite)grpDuringExecution).build();
        GridLayout recorderTypeLayout = new GridLayout(1, false);
        recorderTypeLayout.marginWidth = 0;
        recorderTypeLayout.marginHeight = 0;
        recorderTypeLayout.marginLeft = this.applyZoom(18);
        recorderTypeLayout.marginTop = this.applyZoom(8);
        recorderTypeLayout.marginBottom = this.applyZoom(8);
        recorderTypeLayout.horizontalSpacing = 0;
        recorderTypeLayout.verticalSpacing = 0;
        this.recorderTypeSetting.setLayout((Layout)recorderTypeLayout);
        ComponentBuilder.label((Composite)this.recorderTypeSetting).text("Record Type").bold().marginBottom(this.applyZoom(4)).build();
        Composite browserRecorderGroup = (Composite)ComponentBuilder.gridContainer((Composite)this.recorderTypeSetting, (int)2).build();
        this.btnBrowserRecorder = (Button)ComponentBuilder.radio((Composite)browserRecorderGroup).text(ComposerExecutionMessageConstants.PREF_RADIO_RECORD_BROWSER_WINDOW).check().build();
        new HelpComposite(browserRecorderGroup, DocumentationMessageConstants.BROWSER_BASED_RECORDER);
        Composite screenRecorderGroup = (Composite)ComponentBuilder.gridContainer((Composite)this.recorderTypeSetting, (int)2).build();
        this.btnScreenRecorder = (Button)ComponentBuilder.radio((Composite)screenRecorderGroup).text(ComposerExecutionMessageConstants.PREF_RADIO_RECORD_FULLSCREEN).check().build();
        new HelpComposite(screenRecorderGroup, DocumentationMessageConstants.SCREEN_RECORDER);
        this.applicableToSetting = (Composite)ComponentBuilder.gridContainer((Composite)grpDuringExecution).marginLeft(this.applyZoom(18)).marginBottom(this.applyZoom(8)).build();
        ComponentBuilder.label((Composite)this.applicableToSetting).text("Applicable To").bold().build();
        this.btnFailedTestCases = (Button)ComponentBuilder.radio((Composite)this.applicableToSetting).text(ComposerExecutionMessageConstants.PREF_RADIO_RECORD_FAILED_TEST_CASES).build();
        this.btnAllTestCases = (Button)ComponentBuilder.radio((Composite)this.applicableToSetting).text(ComposerExecutionMessageConstants.PREF_RADIO_RECORD_ALL_TEST_CASES).build();
        this.videoSetting = (Composite)ComponentBuilder.gridContainer((Composite)grpDuringExecution).build();
        GridLayout qualityGroupLayout = new GridLayout(1, false);
        qualityGroupLayout.marginWidth = 0;
        qualityGroupLayout.marginHeight = 0;
        qualityGroupLayout.marginLeft = this.applyZoom(18);
        qualityGroupLayout.marginBottom = this.applyZoom(8);
        qualityGroupLayout.verticalSpacing = 0;
        this.videoSetting.setLayout((Layout)qualityGroupLayout);
        ComponentBuilder.label((Composite)this.videoSetting).text("Video Setting").bold().build();
        Composite videoFormatGroup = (Composite)ComponentBuilder.gridContainer((Composite)this.videoSetting, (int)2).build();
        ComponentBuilder.label((Composite)videoFormatGroup).text(ComposerExecutionMessageConstants.PREF_LBL_VIDEO_FORMAT).width(this.applyZoom(120)).build();
        this.cbbVideoFormat = (Combo)ComponentBuilder.comboBox((Composite)videoFormatGroup, (int)8).width(this.applyZoom(100)).build();
        Composite videoQualityGroup = (Composite)ComponentBuilder.gridContainer((Composite)this.videoSetting, (int)2).build();
        ComponentBuilder.label((Composite)videoQualityGroup).text(ComposerExecutionMessageConstants.PREF_LBL_VIDEO_QUALITY).width(this.applyZoom(120)).build();
        this.cbbVideoQuality = (Combo)ComponentBuilder.comboBox((Composite)videoQualityGroup, (int)8).width(this.applyZoom(100)).build();
        this.cbbVideoQuality.setItems(VIDEO_QUALITY_ITEMS);
    }

    private void createPostExecutionOptionsGroup(Composite parent) {
        Group grpAfterExecuting = (Group)ComponentBuilder.group((Composite)parent).text(StringConstants.PREF_GRP_POST_EXECUTION_OPTIONS).fillHorizontal().gridLayout().build();
        this.chckOpenReport = new Button((Composite)grpAfterExecuting, 32);
        this.chckOpenReport.setText(StringConstants.PREF_CHKBOX_OPEN_RPT_AFTER_EXE_COMPLETELY);
        this.chckQuitDriversTestCase = new Button((Composite)grpAfterExecuting, 32);
        this.chckQuitDriversTestCase.setText(StringConstants.PREF_CHKBOX_QUIT_DRIVERS_AFTER_EXE_COMPLETELY);
        this.chckQuitDriversTestSuite = new Button((Composite)grpAfterExecuting, 32);
        this.chckQuitDriversTestSuite.setText(ComposerExecutionMessageConstants.PREF_CHKBOX_QUIT_DRIVERS_AFTER_EXE_TEST_SUITE_COMPLETELY);
    }

    @Override
    protected void registerListeners() {
        this.cbLogTestSteps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExecutionSettingPage.this.featureController.canUse(ProductFeature.CONSOLE_LOG_CUSTOMIZATION)) {
                    ExecutionSettingPage.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.CONSOLE_LOG_CUSTOMIZATION);
                    ExecutionSettingPage.this.cbLogTestSteps.select(0);
                }
            }
        });
        this.cbHideHostName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExecutionSettingPage.this.featureController.canUse(ProductFeature.HIDE_HOSTNAME)) {
                    ExecutionSettingPage.this.productFeatureDialog.showNotAvailableFeature(ProductFeature.HIDE_HOSTNAME);
                    ExecutionSettingPage.this.cbHideHostName.select(1);
                }
            }
        });
        this.btnEnableVideoRecording.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutionSettingPage.this.updateControlState();
            }
        });
        Listener onChangeApplicable = event -> {
            if (event.widget == this.btnFailedTestCases) {
                this.btnAllTestCases.setSelection(!this.btnFailedTestCases.getSelection());
            } else {
                this.btnFailedTestCases.setSelection(!this.btnAllTestCases.getSelection());
            }
        };
        ComponentEventUtil.onClick((Widget)this.btnFailedTestCases, (Listener)onChangeApplicable);
        ComponentEventUtil.onClick((Widget)this.btnAllTestCases, (Listener)onChangeApplicable);
        Listener onChangeRecorder = event -> {
            if (event.widget == this.btnBrowserRecorder) {
                this.btnScreenRecorder.setSelection(!this.btnBrowserRecorder.getSelection());
            } else {
                this.btnBrowserRecorder.setSelection(!this.btnScreenRecorder.getSelection());
            }
            try {
                this.updateVideoFormatList();
            }
            catch (IOException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        };
        ComponentEventUtil.onClick((Widget)this.btnBrowserRecorder, (Listener)onChangeRecorder);
        ComponentEventUtil.onClick((Widget)this.btnScreenRecorder, (Listener)onChangeRecorder);
    }

    @Override
    protected void initialize() throws IOException {
        this.selectedExecutionConfiguration = this.defaultSettingStore.getExecutionConfiguration();
        this.runConfigs = RunConfigurationCollector.getInstance().getAllBuiltinRunConfigurationContributors();
        if (this.runConfigs.length > 0) {
            List<String> runConfigIds = Arrays.stream(this.runConfigs).map(config -> config.getId()).filter(id -> !id.equalsIgnoreCase(GlobalStringConstants.TESTCLOUD_NAME)).collect(Collectors.toList());
            int selectedIndex = Math.max(runConfigIds.indexOf(this.selectedExecutionConfiguration), 0);
            String[] runConfigIdList = runConfigIds.toArray(new String[0]);
            this.cbDefaultBrowser.setItems(runConfigIdList);
            this.cbDefaultBrowser.select(selectedIndex);
        }
        Boolean selectedLogTestSteps = this.defaultSettingStore.getLogTestSteps();
        this.cbLogTestSteps.setItems(new String[]{GlobalStringConstants.ENABLED, GlobalStringConstants.DISABLED});
        this.cbLogTestSteps.select(selectedLogTestSteps != false ? 0 : 1);
        if (!this.featureController.canUse(ProductFeature.CONSOLE_LOG_CUSTOMIZATION)) {
            this.cbLogTestSteps.select(0);
        }
        Boolean selectedHideHostName = this.defaultSettingStore.getHideHostName();
        this.cbHideHostName.setItems(new String[]{GlobalStringConstants.ENABLED, GlobalStringConstants.DISABLED});
        this.cbHideHostName.select(selectedHideHostName != false ? 0 : 1);
        if (!this.featureController.canUse(ProductFeature.CONSOLE_LOG_CUSTOMIZATION)) {
            this.cbHideHostName.select(1);
        }
        this.chckOpenReport.setSelection(this.defaultSettingStore.isPostExecOpenReport());
        this.chckQuitDriversTestCase.setSelection(this.defaultSettingStore.isPostTestCaseExecQuitDriver());
        this.chckQuitDriversTestSuite.setSelection(this.defaultSettingStore.isPostTestSuiteExecQuitDriver());
        this.updateVideoSettingInputs();
    }

    private void updateVideoSettingInputs() {
        try {
            this.btnEnableScreenshot.setSelection(this.store.getScreenCaptureOption());
            VideoRecorderSettings videoRecorderSettings = this.store.getVideoRecorderSettings();
            this.btnEnableVideoRecording.setSelection(videoRecorderSettings.isEnable());
            boolean isUseBrowserRecorder = videoRecorderSettings.isUseBrowserRecorder();
            this.btnBrowserRecorder.setSelection(isUseBrowserRecorder);
            this.btnScreenRecorder.setSelection(!isUseBrowserRecorder);
            boolean isRecordAllTestCases = videoRecorderSettings.isRecordAllTestCases();
            this.btnAllTestCases.setSelection(isRecordAllTestCases);
            this.btnFailedTestCases.setSelection(!isRecordAllTestCases);
            this.cbbVideoQuality.select(videoRecorderSettings.getVideoQuality().ordinal());
            this.updateVideoFormatList();
            this.updateControlState();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerExecutionMessageConstants.PAGE_ERROR_MSG_UNABLE_TO_READ_SETTINGS, (String)e.getMessage());
        }
    }

    private void updateVideoFormatList() throws IOException {
        VideoRecorderSettings videoRecorderSettings = this.store.getVideoRecorderSettings();
        boolean isUseBrowserRecorder = this.btnBrowserRecorder.getSelection();
        String[] videoFormatItems = isUseBrowserRecorder ? BROWSER_RECORDER_VIDEO_FORMAT_ITEMS : SCREENSHOOT_RECORDER_VIDEO_FORMAT_ITEMS;
        this.cbbVideoFormat.setItems(videoFormatItems);
        this.cbbVideoFormat.select(0);
        VideoFileFormat videoFormat = videoRecorderSettings.getVideoFormat();
        List<String> items = Arrays.asList(videoFormatItems);
        int index = IntStream.range(0, items.size()).filter(i -> ((String)items.get(i)).equals(videoFormat.toString())).findFirst().orElse(-1);
        if (index > 0) {
            this.cbbVideoFormat.select(index);
        }
    }

    private void updateControlState() {
        boolean isEnableVideoRecording = this.btnEnableVideoRecording.getSelection();
        ControlUtils.recursiveSetEnabled((Control)this.recorderTypeSetting, (boolean)isEnableVideoRecording);
        ControlUtils.recursiveSetEnabled((Control)this.applicableToSetting, (boolean)isEnableVideoRecording);
        ControlUtils.recursiveSetEnabled((Control)this.videoSetting, (boolean)isEnableVideoRecording);
    }

    @Override
    protected void performDefaults() {
        String selectedExecutionConfiguration = ExecutionDefaultSettingStore.getStore().getDefaultExecutionConfiguration();
        this.runConfigs = RunConfigurationCollector.getInstance().getAllBuiltinRunConfigurationContributors();
        if (this.runConfigs.length > 0) {
            List<String> runConfigIds = Arrays.stream(this.runConfigs).map(config -> config.getId()).filter(id -> !id.equalsIgnoreCase(GlobalStringConstants.TESTCLOUD_NAME)).collect(Collectors.toList());
            int selectedIndex = Math.max(runConfigIds.indexOf(selectedExecutionConfiguration), 0);
            String[] runConfigIdList = runConfigIds.toArray(new String[0]);
            this.cbDefaultBrowser.setItems(runConfigIdList);
            this.cbDefaultBrowser.select(selectedIndex);
        }
        this.cbLogTestSteps.select(0);
        this.cbHideHostName.select(1);
        this.chckOpenReport.setSelection(false);
        this.chckQuitDriversTestCase.setSelection(false);
        this.chckQuitDriversTestSuite.setSelection(true);
        this.updateVideoSettingInputs();
        super.performApply();
    }

    @Override
    protected boolean saveSettings() {
        if (this.container == null || this.container.isDisposed()) {
            return true;
        }
        try {
            if (this.runConfigs != null && this.runConfigs.length > 0 && !StringUtils.equals((CharSequence)this.cbDefaultBrowser.getText(), (CharSequence)this.selectedExecutionConfiguration)) {
                this.selectedExecutionConfiguration = this.cbDefaultBrowser.getText();
                this.defaultSettingStore.setExecutionConfiguration(this.selectedExecutionConfiguration);
            }
            this.defaultSettingStore.setLogTestSteps(this.cbLogTestSteps.getSelectionIndex() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false));
            this.defaultSettingStore.setHideHostName(this.cbHideHostName.getSelectionIndex() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false));
            this.defaultSettingStore.setPostExecOpenReport(this.chckOpenReport.getSelection());
            this.defaultSettingStore.setPostTestCaseExecQuitDriver(this.chckQuitDriversTestCase.getSelection());
            this.defaultSettingStore.setPostTestSuiteExecQuitDriver(this.chckQuitDriversTestSuite.getSelection());
            this.store.setScreenCaptureOption(this.btnEnableScreenshot.getSelection());
            TakeScreenshotSettings takeScreenshotSetting = new TakeScreenshotSettings();
            takeScreenshotSetting.setEnable(this.btnEnableScreenshot.getSelection());
            this.store.setTakeScreenSettings(takeScreenshotSetting);
            VideoRecorderSettings videoRecorderSettings = new VideoRecorderSettings();
            videoRecorderSettings.setEnable(this.btnEnableVideoRecording.getSelection());
            boolean isUseBrowserRecorder = this.btnBrowserRecorder.getSelection();
            videoRecorderSettings.setUseBrowserRecorder(isUseBrowserRecorder);
            boolean isRecordAllTestCases = this.btnAllTestCases.getSelection();
            videoRecorderSettings.setRecordAllTestCases(isRecordAllTestCases);
            String videoFormat = "";
            String[] videoFormatItems = isUseBrowserRecorder ? BROWSER_RECORDER_VIDEO_FORMAT_ITEMS : SCREENSHOOT_RECORDER_VIDEO_FORMAT_ITEMS;
            int index = this.cbbVideoFormat.getSelectionIndex();
            if (index >= 0 && index < videoFormatItems.length) {
                videoFormat = videoFormatItems[index];
            }
            if (StringUtils.isNotBlank((CharSequence)videoFormat)) {
                videoRecorderSettings.setVideoFormat(VideoFileFormat.fromString((String)videoFormat));
            }
            videoRecorderSettings.setVideoQuality(VideoQuality.values()[this.cbbVideoQuality.getSelectionIndex()]);
            this.store.setVideoRecorderSettings(videoRecorderSettings);
        }
        catch (IOException error) {
            LoggerSingleton.logError((Throwable)error);
            MultiStatusErrorDialog.showErrorDialog((Throwable)error, (String)ComposerExecutionMessageConstants.PAGE_ERROR_MSG_UNABLE_TO_UPDATE_SETTINGS, (String)error.getMessage());
            return false;
        }
        return true;
    }

    protected int applyZoom(int size) {
        return ComponentUtil.applyZoom((int)size);
    }
}

