/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.qtest.model;

import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.integration.qtest.model.ParityReportInput;
import com.kms.katalon.logging.LogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class TestSuiteParityReportInput
extends ParityReportInput {
    private static final String TEST_SUITE = "Test Suite";
    private TestSuiteEntity testSuite;

    public TestSuiteParityReportInput(TestSuiteEntity testSuite) {
        this.testSuite = testSuite;
    }

    @Override
    public FileEntity getExecutedEntity() {
        return this.testSuite;
    }

    @Override
    public List<TestCaseEntity> getExecutedTestCases() {
        try {
            HashSet<TestCaseEntity> testCases = new HashSet<TestCaseEntity>();
            for (TestSuiteTestCaseLink testCaseLink : this.testSuite.getTestSuiteTestCaseLinks()) {
                if (!testCaseLink.getIsRun()) continue;
                String testCaseId = testCaseLink.getTestCaseId();
                TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseId);
                testCases.add(testCase);
            }
            return new ArrayList<TestCaseEntity>(testCases);
        }
        catch (ControllerException e) {
            LogUtil.logError((Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public String getExecutedEntityType() {
        return TEST_SUITE;
    }
}

