/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.dsl.proposals;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.eclipse.codeassist.processors.IProposalFilterExtension;
import org.codehaus.groovy.eclipse.codeassist.requestor.ContentAssistContext;
import org.codehaus.groovy.eclipse.dsl.GroovyDSLCoreActivator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class DSLDProposalFilter
implements IProposalFilterExtension {
    private static final Pattern BASE_DESC = Pattern.compile("^.* - (\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");

    public List<ICompletionProposal> filterExtendedProposals(List<ICompletionProposal> proposals, ContentAssistContext context, JavaContentAssistInvocationContext javaContext) {
        if (!GroovyDSLCoreActivator.getDefault().isDSLDDisabled()) {
            LinkedHashMap<String, ICompletionProposal> map = new LinkedHashMap<String, ICompletionProposal>(proposals.size() * 3 / 2);
            for (ICompletionProposal proposal : proposals) {
                int r2;
                int r1;
                String key = DSLDProposalFilter.getKeyString(proposal);
                ICompletionProposal previous = map.put(key, proposal);
                if (!(previous instanceof IJavaCompletionProposal) || !(proposal instanceof IJavaCompletionProposal) || (r1 = ((IJavaCompletionProposal)previous).getRelevance()) <= (r2 = ((IJavaCompletionProposal)proposal).getRelevance())) continue;
                map.put(key, previous);
            }
            if (map.size() != proposals.size()) {
                return new ArrayList<ICompletionProposal>(map.values());
            }
        }
        return null;
    }

    private static String getKeyString(ICompletionProposal proposal) {
        String key = proposal.getDisplayString();
        Matcher m = BASE_DESC.matcher(key);
        if (m.find()) {
            key = m.group();
        }
        int lparen = key.indexOf(40);
        int rparen = key.indexOf(41, lparen);
        if (lparen > 0 && rparen > lparen + 1) {
            StringBuilder buf = new StringBuilder(key.length()).append(key, 0, lparen + 1);
            String[] tokens = key.substring(lparen + 1, rparen).split(", ");
            int i = 0;
            while (i < tokens.length) {
                int end;
                if (i != 0) {
                    buf.append(',');
                }
                if ((end = tokens[i].lastIndexOf(32)) < 0) {
                    end = tokens[i].length();
                }
                buf.append(tokens[i], 0, end);
                ++i;
            }
            buf.append(key, rparen, key.length());
            key = buf.toString();
        }
        return key;
    }
}

