/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.testcloud.dialogs;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.integration.testcloud.constants.IntegrationTestCloudComposerMessageConstants;
import com.kms.katalon.composer.integration.testcloud.dialogs.SetupTunnelInstructionDialog;
import com.kms.katalon.composer.integration.testcloud.dialogs.TestCloudMobileBrowsersTab;
import com.kms.katalon.composer.integration.testcloud.dialogs.TestCloudMobileNativesTab;
import com.kms.katalon.composer.integration.testcloud.dialogs.TestCloudWindowsBrowsersTab;
import com.kms.katalon.composer.integration.testcloud.interfaces.ITestCloudConfigurationDialog;
import com.kms.katalon.composer.integration.testcloud.utils.TestCloudMobileUtils;
import com.kms.katalon.composer.mobile.objectspy.interfaces.ITestCloudApplicationSelectorComposite;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.testcloud.core.model.APITestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudApplication;
import com.kms.katalon.testcloud.core.model.TestCloudBrowser;
import com.kms.katalon.testcloud.core.model.TestCloudBrowserVersion;
import com.kms.katalon.testcloud.core.model.TestCloudDesktopBrowser;
import com.kms.katalon.testcloud.core.model.TestCloudEntity;
import com.kms.katalon.testcloud.core.model.TestCloudEnvironment;
import com.kms.katalon.testcloud.core.model.TestCloudMobileAvailability;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudMobileOS;
import com.kms.katalon.testcloud.core.model.TestCloudMobileOSVersion;
import com.kms.katalon.testcloud.core.model.TestCloudOS;
import com.kms.katalon.testcloud.core.model.TestCloudSessionType;
import com.kms.katalon.testcloud.core.model.TestCloudTunnel;
import com.kms.katalon.testcloud.core.model.exception.TestCloudAPIException;
import com.kms.katalon.testcloud.core.model.exception.TestCloudException;
import com.kms.katalon.testcloud.core.service.ITestCloudController;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Creatable
public class TestCloudConfigurationDialog
extends Dialog
implements ITestCloudConfigurationDialog {
    public static final int CONTAINER_MARGIN = 15;
    public static final int BTN_WIDTH = 95;
    public static final int CBB_WIDTH = 30;
    public static final int DIA_WIDTH = SystemUtils.IS_OS_WINDOWS ? 600 : 800;
    public static final int DEFAULT_HORIZONTAL_INDENT = 10;
    public static final int BUTTON_BAR_VERTICAL_INDENT = 20;
    public static final int BUTTON_BAR_MARGIN_BOTTOM = 10;
    public static final int DIALOG_MARGIN_WIDTH = 15;
    public static final int DIALOG_MARGIN_HEIGHT = 20;
    public static final int BUTTON_HORIZONTAL_INDENT = 7;
    private static final String TESTCLOUD_DEVICE_OPTION = "platform.testcloud.deviceOS";
    private static final String TESTCLOUD_USING_TUNNEL_OPTION = "platform.testcloud.usingTunnel";
    private static final String TESTCLOUD_OS_NAME_OPTION = "platform.testcloud.os";
    private static final String TESTCLOUD_BROWSER_NAME_OPTION = "platform.testcloud.browsername";
    private static final String TESTCLOUD_BROWSER_VERSION_OPTION = "platform.testcloud.browserversion";
    private static final String TESTCLOUD_MOBILE_BROWSER_OS_NAME_OPTION = "platform.testcloud.mobile.browser.os";
    private static final String TESTCLOUD_MOBILE_BROWSER_OS_VERSION_OPTION = "platform.testcloud.mobile.browser.osVersion";
    private static final String TESTCLOUD_MOBILE_BROWSER_DEVICE_NAME_OPTION = "platform.testcloud.mobile.browser.deviceName";
    private static final String TESTCLOUD_MOBILE_BROWSER_HIGH_AVAILABLE_DEVICE_OPTION = "platform.testcloud.mobile.browser.highAvailableDevice";
    private static final String TESTCLOUD_MOBILE_NATIVE_OS_NAME_OPTION = "platform.testcloud.mobile.nativeApp.os";
    private static final String TESTCLOUD_MOBILE_NATIVE_OS_VERSION_OPTION = "platform.testcloud.mobile.nativeApp.osVersion";
    private static final String TESTCLOUD_MOBILE_NATIVE_DEVICE_NAME_OPTION = "platform.testcloud.mobile.nativeApp.deviceName";
    private static final String TESTCLOUD_MOBILE_NATIVE_HIGH_AVAILABLE_DEVICE_OPTION = "platform.testcloud.mobile.nativeApp.highAvailableDevice";
    private static final String TESTCLOUD_MOBILE_NATIVE_OVERRIDE_APPLICATION = "platform.testcloud.mobile.nativeApp.overrideApplication";
    private static final String TESTCLOUD_MOBILE_NATIVE_APPLICATION_ID = "platform.testcloud.mobile.nativeApp.applicationId";
    private static final int WINDOWS_BROWSERS_TAB = 0;
    private static final int MOBILE_BROWSERS_TAB = 1;
    private static final int MOBILE_NATIVE_APPS_TAB = 2;
    @Inject
    private ITestCloudApplicationSelectorComposite testcloudApplicationSelectorComposite;
    @Inject
    private ITestCloudController testcloudController;
    private int latestReloadTunnelRequestId = 0;
    private ScopedPreferenceStore preferenceStore = null;
    private CTabFolder environmentTab;
    private Composite tunnelComposite;
    private Composite applicationComposite;
    private Composite cbbApplicationComposite;
    private Button overrideApplicationCheckBox;
    private Button executeWithTunnelForPrivateDomainTesting;
    private Link lblTunnelStatus;
    private Button btnRefresh;
    private Button btnCancel;
    protected Button btnRun;
    private Label devicesWithLimitedAvailabilityMessage;
    private TestCloudWindowsBrowsersTab windowsBrowsersTab;
    private TestCloudMobileBrowsersTab mobileBrowsersTab;
    private TestCloudMobileNativesTab mobileNativesTab;
    private List<TestCloudOS> environmentList = new ArrayList<TestCloudOS>();
    private List<TestCloudMobileOS> mobileDeviceList = new ArrayList<TestCloudMobileOS>();
    private List<TestCloudApplication> testcloudApplicationList = new ArrayList<TestCloudApplication>();
    private TestCloudEntity selectingTestCloudEntity;
    private TestCloudSessionType selectingTestCloudSessionType;
    private String trialMessage;
    private String selectingTabName;
    private TestCloudApplication selectingMobileApplication;
    private Entity executionTarget;
    private boolean isOverrideApplication;
    private String selectingMobileApplicationId;
    @Inject
    private ITestCloudController testCloudController;

    public TestCloudConfigurationDialog() {
        super(Display.getCurrent().getActiveShell());
    }

    public TestCloudConfigurationDialog(TestCloudEntity testCloudEntity, String applicationId, TestCloudSessionType sessionType) {
        super(Display.getCurrent().getActiveShell());
        this.selectingTestCloudEntity = testCloudEntity;
        this.selectingTestCloudSessionType = sessionType;
        this.selectingMobileApplicationId = applicationId;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(IntegrationTestCloudComposerMessageConstants.DIA_TESTCLOUD_CONFIGURATION_TITLE);
    }

    private void createApplicationComposite(Composite parent) {
        this.applicationComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent).fill().marginTop(20).build();
        ComponentBuilder.label((Composite)this.applicationComposite).text("Application").build();
        Group applicationGroup = (Group)ComponentBuilder.group((Composite)this.applicationComposite).border(1).margin(0).fillHorizontal().build();
        Composite overrideComposite = (Composite)ComponentBuilder.gridContainer((Composite)applicationGroup, (int)2).build();
        this.overrideApplicationCheckBox = (Button)ComponentBuilder.checkBox((Composite)overrideComposite).text(IntegrationTestCloudComposerMessageConstants.LBL_OVERRIDE_APPLICATION).fillHorizontal().left().onSelection(event -> {
            this.selectingMobileApplication = null;
            this.isOverrideApplication = this.overrideApplicationCheckBox.getSelection();
            if (this.isOverrideApplication) {
                try {
                    this.selectingTestCloudEntity = this.getSelectedTestCloudEntity(this.selectingTabName);
                    this.fetchMobileApplication();
                    this.testcloudApplicationSelectorComposite.setTestCloudApplications(this.testcloudApplicationList, this.selectingTestCloudEntity.getPlatformName());
                }
                catch (InterruptedException | InvocationTargetException e) {
                    LoggerSingleton.logError((Throwable)e);
                }
            } else {
                this.testcloudApplicationSelectorComposite.reset();
            }
            this.testcloudApplicationSelectorComposite.setEnableComposite(this.isOverrideApplication);
            if (this.isOverrideApplication && this.validateApplicationName()) {
                this.btnRun.setEnabled(true);
            } else if (!this.isOverrideApplication) {
                this.btnRun.setEnabled(true);
            } else {
                this.btnRun.setEnabled(false);
            }
        }).build();
        Label tooltipsButton = new Label(overrideComposite, 0);
        tooltipsButton.setImage(ImageManager.getImage((String)"info_16.png"));
        tooltipsButton.setToolTipText(IntegrationTestCloudComposerMessageConstants.LBL_OVERRIDE_APPLICATION_TOOLTIP);
        this.cbbApplicationComposite = (Composite)ComponentBuilder.gridContainer((Composite)applicationGroup, (int)1).marginLeft(15).marginBottom(10).fillHorizontal().build();
        this.testcloudApplicationSelectorComposite.render(this.cbbApplicationComposite, 0, false);
        this.testcloudApplicationSelectorComposite.setEnableComposite(false);
        if (!this.selectingTabName.equalsIgnoreCase("Mobile Native Apps")) {
            ComponentUtil.setVisible((Control)this.applicationComposite, (boolean)false);
        }
    }

    protected Control createButtonBar(Composite parent) {
        this.getShell().setDefaultButton(this.btnRun);
        return this.buttonBar;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).autoWidth(DIA_WIDTH).fill().margin(20, 15).build();
        this.createTabComposite(container);
        this.devicesWithLimitedAvailabilityMessage = (Label)ComponentBuilder.label((Composite)container).text(IntegrationTestCloudComposerMessageConstants.MSG_DEVICE_WITH_LIMITED_AVAILABILITY).italic().build();
        ComponentUtil.setVisible((Control)this.devicesWithLimitedAvailabilityMessage, (boolean)this.selectingTabName.equalsIgnoreCase("Mobile Native Apps"));
        ComponentUtil.setVisible((Control)this.devicesWithLimitedAvailabilityMessage, (boolean)this.selectingTabName.equalsIgnoreCase("Mobile Browsers"));
        this.createTunnelComposite(container);
        this.createApplicationComposite(container);
        Composite btnBarComposite = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)3).fillHorizontal().right().verticalIndent(20).build();
        this.btnRefresh = (Button)ComponentBuilder.button((Composite)btnBarComposite).text(IntegrationTestCloudComposerMessageConstants.DIA_REFRESH_BTN).autoWidth(95).hide().build();
        this.btnCancel = (Button)ComponentBuilder.button((Composite)btnBarComposite).text(IntegrationTestCloudComposerMessageConstants.DIA_CANCEL_BTN).autoWidth(95).build();
        this.btnRun = (Button)ComponentBuilder.button((Composite)btnBarComposite).autoWidth(95).build();
        this.setTextForRunButton();
        ComponentBuilder.separator((Composite)container).colSpan(4).verticalIndent(10).build();
        Composite statusLine = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).colSpan(4).fillHorizontal().build();
        ComponentBuilder.label((Composite)statusLine).text("Notes: ").top().bold().build();
        ComponentBuilder.link((Composite)statusLine).text(this.trialMessage).fillHorizontal().build();
        this.setInput();
        this.registerControlListeners();
        this.selectingTabName = this.environmentTab.getSelection().getText();
        if (Objects.isNull(this.selectingTestCloudEntity)) {
            this.selectingTestCloudEntity = this.getSelectedTestCloudEntity(this.selectingTabName);
        }
        return container;
    }

    private void createTabComposite(Composite parent) {
        Composite labelComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent).fillHorizontal().build();
        ComponentBuilder.label((Composite)labelComposite).text("Environment").build();
        this.environmentTab = (CTabFolder)ComponentBuilder.tabFolder((Composite)parent).border().build();
        this.environmentTab.setLayoutData((Object)new GridData(4, -1, true, false));
        this.windowsBrowsersTab = new TestCloudWindowsBrowsersTab(this.environmentTab, this.environmentList);
        this.mobileBrowsersTab = new TestCloudMobileBrowsersTab(this.environmentTab, this.mobileDeviceList);
        this.mobileNativesTab = new TestCloudMobileNativesTab(this.environmentTab, this.mobileDeviceList);
        if (ColorUtil.isDarkTheme()) {
            this.windowsBrowsersTab.setForeground(ColorUtil.getColor((String)"#BBBBBB"));
            this.mobileBrowsersTab.setForeground(ColorUtil.getColor((String)"#BBBBBB"));
            this.mobileNativesTab.setForeground(ColorUtil.getColor((String)"#BBBBBB"));
            this.windowsBrowsersTab.setSelectionForeground(ColorUtil.getTextColor());
            this.mobileBrowsersTab.setSelectionForeground(ColorUtil.getTextColor());
            this.mobileNativesTab.setSelectionForeground(ColorUtil.getTextColor());
        }
        this.environmentTab.setSelection(0);
        this.selectingTabName = this.environmentTab.getSelection().getText();
    }

    private void createTunnelComposite(Composite parent) {
        this.tunnelComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).fill().build();
        this.executeWithTunnelForPrivateDomainTesting = (Button)ComponentBuilder.checkBox((Composite)this.tunnelComposite).text(IntegrationTestCloudComposerMessageConstants.DIA_EXECUTE_TUNNEL_LBL_V2).build();
        ComponentBuilder.helpButton((Composite)this.tunnelComposite, (String)IntegrationTestCloudComposerMessageConstants.DIA_TUNNEL_INFO_LINK).fillHorizontal().left().build();
        this.lblTunnelStatus = (Link)ComponentBuilder.link((Composite)this.tunnelComposite).horizontalIndent(10).fillHorizontal().height(0).colSpan(4).onSelection(event -> {
            SetupTunnelInstructionDialog instructionDialog = new SetupTunnelInstructionDialog(this.getShell());
            IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
            ContextInjectionFactory.inject((Object)((Object)instructionDialog), (IEclipseContext)context);
            instructionDialog.open();
        }).build();
    }

    private void fetchDesktopBrower() throws InvocationTargetException, InterruptedException {
        this.environmentList.clear();
        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(IntegrationTestCloudComposerMessageConstants.JOB_LOADING_ENVIRONMENTS, 2);
                        TestCloudEnvironment[] rawData = TestCloudConfigurationDialog.this.testCloudController.getEnvironments();
                        monitor.worked(1);
                        TestCloudConfigurationDialog.this.environmentList.addAll(TestCloudConfigurationDialog.this.testCloudController.parseEnvironmentsToOSForDialog(rawData));
                        monitor.worked(1);
                    }
                    catch (TestCloudAPIException e) {
                        LoggerSingleton.logError((Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private void fetchExtraInfo() throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(IntegrationTestCloudComposerMessageConstants.JOB_LOADING_TRIAL_INFORMATION, 1);
                        TestCloudConfigurationDialog.this.trialMessage = TestCloudConfigurationDialog.this.testCloudController.getGATrialMessage();
                        monitor.worked(1);
                    }
                    catch (TestCloudAPIException e) {
                        LoggerSingleton.logError((Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private void fetchMobileApplication() throws InvocationTargetException, InterruptedException {
        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(IntegrationTestCloudComposerMessageConstants.JOB_LOADING_MOBILE_APPLICATIONS, -1);
                try {
                    try {
                        TestCloudConfigurationDialog.this.testcloudApplicationList = TestCloudConfigurationDialog.this.testcloudController.requestTestCloudApplication();
                    }
                    catch (TestCloudException e) {
                        LoggerSingleton.logError((Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private void fetchMobileDevice() throws InvocationTargetException, InterruptedException {
        this.mobileDeviceList.clear();
        new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(IntegrationTestCloudComposerMessageConstants.JOB_LOADING_MOBILE_DEVICES, 2);
                        APITestCloudMobileDevice[] mobileData = TestCloudConfigurationDialog.this.testCloudController.getMobileDevices();
                        monitor.worked(1);
                        TestCloudConfigurationDialog.this.mobileDeviceList.addAll(TestCloudConfigurationDialog.this.testCloudController.parseMobileDevicesForDialog(mobileData));
                        monitor.worked(1);
                    }
                    catch (TestCloudAPIException e) {
                        LoggerSingleton.logError((Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        });
    }

    private ScopedPreferenceStore getPreferenceStore() {
        if (this.preferenceStore != null) {
            return this.preferenceStore;
        }
        return PreferenceStoreManager.getPreferenceStore(TestCloudConfigurationDialog.class);
    }

    private TestCloudEntity getSelectedTestCloudEntity(String selectedTab) {
        TestCloudDesktopBrowser testCloudEntity = null;
        switch (selectedTab) {
            case "Desktop Browsers": {
                testCloudEntity = ((TestCloudBrowserVersion)((TestCloudBrowser)this.environmentList.get(this.windowsBrowsersTab.getOSIndex()).getBrowsers().get(this.windowsBrowsersTab.getBrowserNameIndex())).getVersions().get(this.windowsBrowsersTab.getBrowserVersionIndex())).getEnvironment();
                break;
            }
            case "Mobile Browsers": {
                List<TestCloudMobileOS> deviceBrowserList = this.mobileDeviceList;
                if (this.mobileBrowsersTab != null && this.mobileBrowsersTab.getBtnHighAvailableDevice()) {
                    deviceBrowserList = TestCloudMobileUtils.filteredMobileDeviceList(this.mobileDeviceList, TestCloudMobileAvailability.HIGH);
                }
                if (deviceBrowserList == null || deviceBrowserList.isEmpty()) {
                    LogUtil.logError((String)"No devices are currently available at this time.");
                    return null;
                }
                testCloudEntity = (TestCloudEntity)((TestCloudMobileOSVersion)deviceBrowserList.get(this.mobileBrowsersTab.getMobileBrowserOSIndex()).getOsVersions().get(this.mobileBrowsersTab.getMobileBrowserOSVersionIndex())).getDeviceList().get(this.mobileBrowsersTab.getMobileBrowserDeviceNameIndex());
                if (this.mobileBrowsersTab == null) break;
                testCloudEntity.setHighAvailableDevice(this.mobileBrowsersTab.getBtnHighAvailableDevice());
                break;
            }
            case "Mobile Native Apps": {
                List<TestCloudMobileOS> deviceNativeList = this.mobileDeviceList;
                if (this.mobileNativesTab != null && this.mobileNativesTab.getBtnHighAvailableDevice()) {
                    deviceNativeList = TestCloudMobileUtils.filteredMobileDeviceList(this.mobileDeviceList, TestCloudMobileAvailability.HIGH);
                }
                if (deviceNativeList == null || deviceNativeList.isEmpty()) {
                    LogUtil.logError((String)"No devices are currently available at this time.");
                    return null;
                }
                testCloudEntity = (TestCloudEntity)((TestCloudMobileOSVersion)deviceNativeList.get(this.mobileNativesTab.getMobileNativeOSIndex()).getOsVersions().get(this.mobileNativesTab.getMobileNativeOSVersionIndex())).getDeviceList().get(this.mobileNativesTab.getMobileNativeDeviceNameIndex());
                if (this.mobileNativesTab == null) break;
                testCloudEntity.setHighAvailableDevice(this.mobileNativesTab.getBtnHighAvailableDevice());
                break;
            }
        }
        return testCloudEntity;
    }

    @Override
    public TestCloudEntity getSelectingEntity() {
        return this.selectingTestCloudEntity;
    }

    @Override
    public TestCloudApplication getSelectingMobileApplication() {
        TestCloudSessionType testCloudSessionType = this.getSelectingSessionType();
        if (testCloudSessionType == TestCloudSessionType.MOBILE_NATIVE && this.isOverrideApplication) {
            return this.selectingMobileApplication;
        }
        return null;
    }

    @Override
    public TestCloudSessionType getSelectingSessionType() {
        if (this.selectingTabName.equalsIgnoreCase("Desktop Browsers")) {
            this.selectingTestCloudSessionType = TestCloudSessionType.DESKTOP_BROWSER;
        } else if (this.selectingTabName.equalsIgnoreCase("Mobile Browsers")) {
            this.selectingTestCloudSessionType = TestCloudSessionType.MOBILE_BROWSER;
        } else if (this.selectingTabName.equalsIgnoreCase("Mobile Native Apps")) {
            this.selectingTestCloudSessionType = TestCloudSessionType.MOBILE_NATIVE;
        }
        return this.selectingTestCloudSessionType;
    }

    private void hideComponentBasedOnDevice(String name, boolean isPack) {
        this.btnRun.setEnabled(true);
        switch (name) {
            case "Mobile Native Apps": {
                ComponentUtil.hide((Control)this.tunnelComposite);
                ComponentUtil.show((Control)this.applicationComposite);
                ComponentUtil.show((Control)this.devicesWithLimitedAvailabilityMessage);
                ComponentUtil.setVisible((Control)this.btnRefresh, (!this.isMobileNativeTab() ? 1 : 0) != 0);
                if (this.isOverrideApplication && this.validateApplicationName()) {
                    this.btnRun.setEnabled(true);
                } else if (!this.isOverrideApplication) {
                    this.btnRun.setEnabled(true);
                } else {
                    this.btnRun.setEnabled(false);
                }
                if (!this.isOverrideApplication) break;
                this.testcloudApplicationSelectorComposite.setEnableComposite(true);
                break;
            }
            case "Mobile Browsers": {
                ComponentUtil.show((Control)this.devicesWithLimitedAvailabilityMessage);
                ComponentUtil.show((Control)this.tunnelComposite);
                ComponentUtil.hide((Control)this.applicationComposite);
                ComponentUtil.setVisible((Control)this.btnRefresh, (boolean)this.executeWithTunnelForPrivateDomainTesting.getSelection());
                break;
            }
            default: {
                ComponentUtil.show((Control)this.tunnelComposite);
                ComponentUtil.hide((Control)this.applicationComposite);
                ComponentUtil.hide((Control)this.devicesWithLimitedAvailabilityMessage);
                ComponentUtil.setVisible((Control)this.btnRefresh, (boolean)this.executeWithTunnelForPrivateDomainTesting.getSelection());
            }
        }
        ComponentUtil.requestLayout((Control)this.applicationComposite, (boolean)isPack);
        ComponentUtil.requestLayout((Control)this.devicesWithLimitedAvailabilityMessage, (boolean)isPack);
    }

    protected boolean isResizable() {
        return true;
    }

    private void loadLastWorkingTestCloudOptions() {
        String testCloudDevice;
        ScopedPreferenceStore prefStore = this.getPreferenceStore();
        switch (testCloudDevice = prefStore.contains(TESTCLOUD_DEVICE_OPTION) ? prefStore.getString(TESTCLOUD_DEVICE_OPTION) : "") {
            case "Desktop Browsers": {
                if (this.windowsBrowsersTab == null) break;
                String osNameOption = prefStore.contains(TESTCLOUD_OS_NAME_OPTION) ? prefStore.getString(TESTCLOUD_OS_NAME_OPTION) : "";
                String browserNameOption = prefStore.contains(TESTCLOUD_BROWSER_NAME_OPTION) ? prefStore.getString(TESTCLOUD_BROWSER_NAME_OPTION) : "";
                String browserVersionOption = prefStore.contains(TESTCLOUD_BROWSER_VERSION_OPTION) ? prefStore.getString(TESTCLOUD_BROWSER_VERSION_OPTION) : "";
                this.windowsBrowsersTab.selectOS(osNameOption);
                this.windowsBrowsersTab.selectBrowserName(browserNameOption);
                this.windowsBrowsersTab.selectBrowserVersion(browserVersionOption);
                this.environmentTab.setSelection(0);
                break;
            }
            case "Mobile Browsers": {
                if (this.mobileBrowsersTab == null) break;
                boolean highAvailableDevice = prefStore.contains(TESTCLOUD_MOBILE_BROWSER_HIGH_AVAILABLE_DEVICE_OPTION) ? prefStore.getBoolean(TESTCLOUD_MOBILE_BROWSER_HIGH_AVAILABLE_DEVICE_OPTION) : false;
                this.mobileBrowsersTab.selectHighAvailableDevice(highAvailableDevice);
                String mobileBrowserOsOption = prefStore.contains(TESTCLOUD_MOBILE_BROWSER_OS_NAME_OPTION) ? prefStore.getString(TESTCLOUD_MOBILE_BROWSER_OS_NAME_OPTION) : "";
                this.mobileBrowsersTab.selectMobileBrowserOS(mobileBrowserOsOption);
                String mobileBrowserOsVersion = prefStore.contains(TESTCLOUD_MOBILE_BROWSER_OS_VERSION_OPTION) ? prefStore.getString(TESTCLOUD_MOBILE_BROWSER_OS_VERSION_OPTION) : "";
                this.mobileBrowsersTab.selectMobileBrowserOSVersion(mobileBrowserOsVersion);
                String mobileBrowserDevice = prefStore.contains(TESTCLOUD_MOBILE_BROWSER_DEVICE_NAME_OPTION) ? prefStore.getString(TESTCLOUD_MOBILE_BROWSER_DEVICE_NAME_OPTION) : "";
                this.mobileBrowsersTab.selectMobileBrowserDevice(mobileBrowserDevice);
                this.environmentTab.setSelection(1);
                break;
            }
            case "Mobile Native Apps": {
                if (this.mobileNativesTab == null) break;
                boolean highAvailableDevice = prefStore.contains(TESTCLOUD_MOBILE_NATIVE_HIGH_AVAILABLE_DEVICE_OPTION) ? prefStore.getBoolean(TESTCLOUD_MOBILE_NATIVE_HIGH_AVAILABLE_DEVICE_OPTION) : false;
                this.mobileNativesTab.selectHighAvailableDevice(highAvailableDevice);
                String mobileNativeOsOption = prefStore.contains(TESTCLOUD_MOBILE_NATIVE_OS_NAME_OPTION) ? prefStore.getString(TESTCLOUD_MOBILE_NATIVE_OS_NAME_OPTION) : "";
                this.mobileNativesTab.selectMobileNativeOS(mobileNativeOsOption);
                String mobileNativeOsVersion = prefStore.contains(TESTCLOUD_MOBILE_NATIVE_OS_VERSION_OPTION) ? prefStore.getString(TESTCLOUD_MOBILE_NATIVE_OS_VERSION_OPTION) : "";
                this.mobileNativesTab.selectMobileNativeOSVersion(mobileNativeOsVersion);
                String mobileNativeDevice = prefStore.contains(TESTCLOUD_MOBILE_NATIVE_DEVICE_NAME_OPTION) ? prefStore.getString(TESTCLOUD_MOBILE_NATIVE_DEVICE_NAME_OPTION) : "";
                this.mobileNativesTab.selectMobileNativeDevice(mobileNativeDevice);
                this.isOverrideApplication = prefStore.contains(TESTCLOUD_MOBILE_NATIVE_OVERRIDE_APPLICATION) ? prefStore.getBoolean(TESTCLOUD_MOBILE_NATIVE_OVERRIDE_APPLICATION) : false;
                this.overrideApplicationCheckBox.setSelection(this.isOverrideApplication);
                if (this.isOverrideApplication) {
                    try {
                        this.fetchMobileApplication();
                        this.selectingTestCloudEntity = this.getSelectedTestCloudEntity("Mobile Native Apps");
                        this.testcloudApplicationSelectorComposite.setTestCloudApplications(this.testcloudApplicationList, this.selectingTestCloudEntity.getPlatformName());
                        this.testcloudApplicationSelectorComposite.setEnableComposite(this.isOverrideApplication);
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        LogUtil.logError((Throwable)e);
                    }
                    String applicationId = prefStore.contains(TESTCLOUD_MOBILE_NATIVE_APPLICATION_ID) ? prefStore.getString(TESTCLOUD_MOBILE_NATIVE_APPLICATION_ID) : "";
                    this.testcloudApplicationSelectorComposite.setSelectionApplication(applicationId);
                }
                if (this.isOverrideApplication && this.validateApplicationName()) {
                    this.btnRun.setEnabled(true);
                } else if (!this.isOverrideApplication) {
                    this.btnRun.setEnabled(true);
                } else {
                    this.btnRun.setEnabled(false);
                }
                this.environmentTab.setSelection(2);
                break;
            }
        }
        this.hideComponentBasedOnDevice(testCloudDevice, false);
        boolean usingTunnelOption = prefStore.contains(TESTCLOUD_USING_TUNNEL_OPTION) ? prefStore.getBoolean(TESTCLOUD_USING_TUNNEL_OPTION) : false;
        this.executeWithTunnelForPrivateDomainTesting.setSelection(usingTunnelOption);
        if (usingTunnelOption) {
            this.reloadTunnelStatus();
        }
        ComponentUtil.setVisible((Control)this.btnRefresh, (usingTunnelOption && !this.isMobileNativeTab() ? 1 : 0) != 0);
        if (this.selectingTestCloudEntity != null) {
            this.selectingTestCloudEntity.setUsingTunnel(usingTunnelOption);
        }
        this.selectingTabName = this.environmentTab.getSelection().getText();
    }

    private void loadSelectedTestCloudOptions(TestCloudEntity entity) {
        if (entity == null) {
            return;
        }
        if (this.selectingTestCloudSessionType != null) {
            TestCloudMobileDevice mobileDevice;
            if (this.selectingTestCloudSessionType == TestCloudSessionType.DESKTOP_BROWSER) {
                if (entity instanceof TestCloudDesktopBrowser) {
                    TestCloudDesktopBrowser desktopBrowser = (TestCloudDesktopBrowser)entity;
                    this.windowsBrowsersTab.loadSelectedTestCloudEnvironmentOptions(desktopBrowser);
                }
                this.environmentTab.setSelection((CTabItem)this.windowsBrowsersTab);
            }
            if (this.selectingTestCloudSessionType == TestCloudSessionType.MOBILE_BROWSER) {
                if (entity instanceof TestCloudMobileDevice) {
                    mobileDevice = (TestCloudMobileDevice)entity;
                    this.mobileBrowsersTab.loadSelectedTestCloudMobileOptions(mobileDevice);
                }
                this.environmentTab.setSelection((CTabItem)this.mobileBrowsersTab);
                ComponentUtil.show((Control)this.devicesWithLimitedAvailabilityMessage);
            }
            if (this.selectingTestCloudSessionType == TestCloudSessionType.MOBILE_NATIVE) {
                if (entity instanceof TestCloudMobileDevice) {
                    mobileDevice = (TestCloudMobileDevice)entity;
                    this.mobileNativesTab.loadSelectedTestCloudMobileNativeOptions(mobileDevice);
                }
                this.environmentTab.setSelection((CTabItem)this.mobileNativesTab);
                if (StringUtils.isNotEmpty((String)this.selectingMobileApplicationId)) {
                    this.overrideApplicationCheckBox.setSelection(true);
                    this.isOverrideApplication = this.overrideApplicationCheckBox.getSelection();
                    try {
                        this.fetchMobileApplication();
                    }
                    catch (InterruptedException | InvocationTargetException e) {
                        LoggerSingleton.logError((Throwable)e);
                    }
                    this.testcloudApplicationSelectorComposite.setTestCloudApplications(this.testcloudApplicationList, this.selectingTestCloudEntity.getPlatformName());
                    this.testcloudApplicationSelectorComposite.setEnableComposite(true);
                    this.testcloudApplicationSelectorComposite.setSelectionApplication(this.selectingMobileApplicationId);
                }
                ComponentUtil.hide((Control)this.tunnelComposite);
                ComponentUtil.show((Control)this.applicationComposite);
                ComponentUtil.show((Control)this.devicesWithLimitedAvailabilityMessage);
            }
        } else {
            if (entity instanceof TestCloudDesktopBrowser) {
                TestCloudDesktopBrowser desktop = (TestCloudDesktopBrowser)entity;
                this.windowsBrowsersTab.loadSelectedTestCloudEnvironmentOptions(desktop);
                this.environmentTab.setSelection((CTabItem)this.windowsBrowsersTab);
            }
            if (entity instanceof TestCloudMobileDevice) {
                TestCloudMobileDevice mobileBrowser = (TestCloudMobileDevice)entity;
                this.mobileBrowsersTab.loadSelectedTestCloudMobileOptions(mobileBrowser);
                this.environmentTab.setSelection((CTabItem)this.mobileBrowsersTab);
            }
        }
        this.executeWithTunnelForPrivateDomainTesting.setSelection(entity.isUsingTunnel());
        if (entity.isUsingTunnel()) {
            this.reloadTunnelStatus();
        }
        ComponentUtil.setVisible((Control)this.btnRefresh, (entity.isUsingTunnel() && !this.isMobileNativeTab() ? 1 : 0) != 0);
        this.selectingTabName = this.environmentTab.getSelection().getText();
    }

    @Override
    public int open() {
        try {
            this.fetchDesktopBrower();
            this.fetchMobileDevice();
            this.fetchExtraInfo();
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable cause = invocationTargetException.getCause();
            if (cause instanceof TestCloudAPIException) {
                MultiStatusErrorDialog.showErrorDialog((Throwable)cause, (String)IntegrationTestCloudComposerMessageConstants.TITLE_ERR_FETCH_TESTCLOUD_ENVIRONMENTS, (String)IntegrationTestCloudComposerMessageConstants.MSG_ERR_FETCH_TESTCLOUD_ENVIRONMENTS);
                this.close();
            }
            LoggerSingleton.logError((String)Arrays.toString(cause.getStackTrace()));
            return 1;
        }
        catch (InterruptedException interruptedException) {
            LogUtil.logError((Throwable)interruptedException);
            return 1;
        }
        return super.open();
    }

    private void registerControlListeners() {
        this.environmentTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudConfigurationDialog.this.selectingTabName = TestCloudConfigurationDialog.this.environmentTab.getSelection().getText();
                TestCloudConfigurationDialog.this.hideComponentBasedOnDevice(TestCloudConfigurationDialog.this.selectingTabName, true);
            }
        });
        this.btnRun.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedTab = TestCloudConfigurationDialog.this.environmentTab.getSelection().getText();
                TestCloudConfigurationDialog.this.selectingTestCloudEntity = TestCloudConfigurationDialog.this.getSelectedTestCloudEntity(selectedTab);
                if (!selectedTab.equalsIgnoreCase("Mobile Native Apps")) {
                    TestCloudConfigurationDialog.this.selectingTestCloudEntity.setUsingTunnel(TestCloudConfigurationDialog.this.executeWithTunnelForPrivateDomainTesting.getSelection());
                }
                try {
                    TestCloudConfigurationDialog.this.selectingTestCloudEntity.setTimeout(TestCloudConfigurationDialog.this.testCloudController.getOSTimeout(TestCloudConfigurationDialog.this.selectingTestCloudEntity.getOs()));
                }
                catch (TestCloudAPIException exception) {
                    LoggerSingleton.logError((Throwable)exception);
                }
                TestCloudApplication testCloudApplication = TestCloudConfigurationDialog.this.testcloudApplicationSelectorComposite.getSelectionApplication();
                if (Objects.nonNull(testCloudApplication)) {
                    TestCloudConfigurationDialog.this.selectingMobileApplication = testCloudApplication;
                }
                TestCloudConfigurationDialog.this.saveUserInputTestCloudOptions();
                TestCloudConfigurationDialog.this.trackOnConfiguredSuccessfully();
                TestCloudConfigurationDialog.this.okPressed();
            }
        });
        this.executeWithTunnelForPrivateDomainTesting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudConfigurationDialog.this.reloadTunnelStatus();
            }
        });
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudConfigurationDialog.this.reloadTunnelStatus();
            }
        });
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudConfigurationDialog.this.cancelPressed();
            }
        });
        EventBrokerSingleton.getInstance().getEventBroker().subscribe("TESTCLOUD/SELECT_MOBILE_NATIVE_OS", new EventHandler(){

            public void handleEvent(Event event) {
                if (TestCloudConfigurationDialog.this.overrideApplicationCheckBox != null && !TestCloudConfigurationDialog.this.overrideApplicationCheckBox.isDisposed()) {
                    TestCloudConfigurationDialog.this.overrideApplicationCheckBox.setSelection(false);
                    TestCloudConfigurationDialog.this.isOverrideApplication = TestCloudConfigurationDialog.this.overrideApplicationCheckBox.getSelection();
                    TestCloudConfigurationDialog.this.testcloudApplicationSelectorComposite.setEnableComposite(false);
                    TestCloudConfigurationDialog.this.selectingTestCloudEntity = TestCloudConfigurationDialog.this.getSelectedTestCloudEntity(TestCloudConfigurationDialog.this.selectingTabName);
                    TestCloudConfigurationDialog.this.testcloudApplicationSelectorComposite.reset();
                    TestCloudConfigurationDialog.this.selectingMobileApplication = null;
                    TestCloudConfigurationDialog.this.btnRun.setEnabled(true);
                }
            }
        });
    }

    private void reloadTunnelStatus() {
        int requestId;
        boolean useTunnel = this.executeWithTunnelForPrivateDomainTesting.getSelection();
        ComponentUtil.setVisible((Control)this.btnRefresh, (useTunnel && !this.isMobileNativeTab() ? 1 : 0) != 0);
        this.latestReloadTunnelRequestId = requestId = this.latestReloadTunnelRequestId + 1;
        if (useTunnel) {
            Executors.newFixedThreadPool(1).submit(() -> {
                try {
                    this.setTunnelProgressMessage(IntegrationTestCloudComposerMessageConstants.MSG_LOADING);
                    TestCloudTunnel[] tunnels = this.testCloudController.getTunnels();
                    if (tunnels.length <= 0) {
                        throw new NullPointerException(IntegrationTestCloudComposerMessageConstants.MSG_ERR_NO_TUNNEL);
                    }
                    if (requestId < this.latestReloadTunnelRequestId) {
                        return;
                    }
                    this.setTunnelProgressMessage(IntegrationTestCloudComposerMessageConstants.MSG_STATUS_AVAILABLE);
                }
                catch (TestCloudAPIException | NullPointerException fetchTunnelException) {
                    LoggerSingleton.logError((Throwable)fetchTunnelException);
                    UISynchronizeService.syncExec(() -> this.setTunnelErrorMessage(MessageFormat.format(IntegrationTestCloudComposerMessageConstants.MSG_TUNNEL_NOT_AVAILABLE, ComponentUtil.wrapLink((String)IntegrationTestCloudComposerMessageConstants.LNK_TUNNEL_SETUP_HELPER, (String)""))));
                }
            });
        } else {
            this.setTunnelProgressMessage("");
        }
    }

    private void saveUserInputTestCloudOptions() {
        ScopedPreferenceStore prefStore = this.getPreferenceStore();
        String testCloudDevice = this.environmentTab.getSelection().getText();
        prefStore.setValue(TESTCLOUD_DEVICE_OPTION, testCloudDevice);
        prefStore.setValue(TESTCLOUD_USING_TUNNEL_OPTION, this.executeWithTunnelForPrivateDomainTesting.getSelection());
        switch (testCloudDevice) {
            case "Desktop Browsers": {
                prefStore.setValue(TESTCLOUD_OS_NAME_OPTION, this.windowsBrowsersTab.getOS());
                prefStore.setValue(TESTCLOUD_BROWSER_NAME_OPTION, this.windowsBrowsersTab.getBrowserName());
                prefStore.setValue(TESTCLOUD_BROWSER_VERSION_OPTION, this.windowsBrowsersTab.getBrowserVersion());
                break;
            }
            case "Mobile Browsers": {
                prefStore.setValue(TESTCLOUD_MOBILE_BROWSER_OS_NAME_OPTION, this.mobileBrowsersTab.getMobileBrowserOS());
                prefStore.setValue(TESTCLOUD_MOBILE_BROWSER_OS_VERSION_OPTION, this.mobileBrowsersTab.getMobileBrowserOSVersion());
                prefStore.setValue(TESTCLOUD_MOBILE_BROWSER_DEVICE_NAME_OPTION, this.mobileBrowsersTab.getMobileBrowserDeviceName());
                prefStore.setValue(TESTCLOUD_MOBILE_BROWSER_HIGH_AVAILABLE_DEVICE_OPTION, this.mobileBrowsersTab.getBtnHighAvailableDevice());
                break;
            }
            case "Mobile Native Apps": {
                prefStore.setValue(TESTCLOUD_MOBILE_NATIVE_OS_NAME_OPTION, this.mobileNativesTab.getMobileNativeOS());
                prefStore.setValue(TESTCLOUD_MOBILE_NATIVE_OS_VERSION_OPTION, this.mobileNativesTab.getMobileNativeOSVersion());
                prefStore.setValue(TESTCLOUD_MOBILE_NATIVE_DEVICE_NAME_OPTION, this.mobileNativesTab.getMobileNativeDeviceName());
                prefStore.setValue(TESTCLOUD_MOBILE_NATIVE_OVERRIDE_APPLICATION, this.overrideApplicationCheckBox.getSelection());
                prefStore.setValue(TESTCLOUD_MOBILE_NATIVE_HIGH_AVAILABLE_DEVICE_OPTION, this.mobileNativesTab.getBtnHighAvailableDevice());
                if (this.testcloudApplicationSelectorComposite.getSelectionApplication() == null) break;
                prefStore.setValue(TESTCLOUD_MOBILE_NATIVE_APPLICATION_ID, this.testcloudApplicationSelectorComposite.getSelectionApplication().getId());
            }
        }
        try {
            prefStore.save();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    public void setExecutionTarget(Entity executionTarget) {
        this.executionTarget = executionTarget;
    }

    @Override
    public void reset() {
        this.selectingTestCloudEntity = null;
        this.selectingTestCloudSessionType = null;
        this.selectingTabName = "";
        this.isOverrideApplication = false;
    }

    private void setInput() {
        if (this.environmentList.isEmpty() && this.mobileDeviceList.isEmpty()) {
            this.selectingTestCloudEntity = null;
            return;
        }
        if (this.selectingTestCloudEntity == null) {
            this.loadLastWorkingTestCloudOptions();
            return;
        }
        this.loadSelectedTestCloudOptions(this.selectingTestCloudEntity);
    }

    protected void setTextForRunButton() {
        this.btnRun.setText(IntegrationTestCloudComposerMessageConstants.DIA_RUN_BTN);
    }

    private void setTunnelErrorMessage(String message) {
        this.setTunnelProgressMessage(message, true);
    }

    private void setTunnelProgressMessage(String message) {
        this.setTunnelProgressMessage(message, false);
    }

    private void setTunnelProgressMessage(String message, boolean isError) {
        UISynchronizeService.syncExec(() -> {
            if (isError) {
                ComponentUtil.showError((Control)this.lblTunnelStatus, (String)message, (boolean)true);
            } else {
                ComponentUtil.showSuccess((Control)this.lblTunnelStatus, (String)message, (boolean)true);
            }
        });
    }

    @Inject
    @Optional
    private void subscribeApplicationRefreshButtonSelected(@UIEventTopic(value="ON_APPLICATION_REFRESH_BUTTON_PRESSED") Map data) {
        try {
            if (this.cbbApplicationComposite != null && !this.cbbApplicationComposite.isDisposed()) {
                this.fetchMobileApplication();
                this.selectingTestCloudEntity = this.getSelectedTestCloudEntity(this.selectingTabName);
                UISynchronizeService.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TestCloudConfigurationDialog.this.testcloudApplicationSelectorComposite.setTestCloudApplications(TestCloudConfigurationDialog.this.testcloudApplicationList, TestCloudConfigurationDialog.this.selectingTestCloudEntity.getPlatformName());
                        if (TestCloudConfigurationDialog.this.validateApplicationName()) {
                            TestCloudConfigurationDialog.this.btnRun.setEnabled(true);
                        } else {
                            TestCloudConfigurationDialog.this.btnRun.setEnabled(false);
                        }
                    }
                });
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected void trackOnConfiguredSuccessfully() {
        Trackings.trackClickExecuteTestSuiteWithTestCloud();
    }

    private boolean validateApplicationName() {
        if (this.testcloudApplicationSelectorComposite.getSelectionApplication() == null) {
            return false;
        }
        TestCloudApplication selectingApplication = this.testcloudApplicationSelectorComposite.getSelectionApplication();
        return !"Application Name".equalsIgnoreCase(selectingApplication.getFileName());
    }

    private boolean isMobileNativeTab() {
        return "Mobile Native Apps".equalsIgnoreCase(this.environmentTab.getSelection().getText());
    }
}

