/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.testcloud.dialogs;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.integration.testcloud.constants.IntegrationTestCloudComposerMessageConstants;
import com.kms.katalon.composer.integration.testcloud.utils.TestCloudMobileUtils;
import com.kms.katalon.testcloud.core.model.TestCloudMobileAvailability;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudMobileOS;
import com.kms.katalon.testcloud.core.model.TestCloudMobileOSVersion;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TestCloudMobileNativesTab
extends CTabItem {
    public static final int DEFAULT_HORIZONTAL_INDENT = 10;
    public static final int BUTTON_HORIZONTAL_INDENT = 7;
    public static final int CBB_WIDTH = 30;
    private Combo cbbMobileNativeOS;
    private Combo cbbMobileNativeOSVersion;
    private Combo cbbMobileNativeDeviceName;
    private Button btnHighAvailableDevice;
    private List<TestCloudMobileOS> mobileDeviceList;
    private List<TestCloudMobileOS> originalMobileDeviceList;
    private String latestSelectionOs;
    private String latestSelectionOsVersion;
    private String latestSelectionDeviceName;

    public TestCloudMobileNativesTab(CTabFolder parent, List<TestCloudMobileOS> mobileDeviceList) {
        super(parent, 0);
        this.originalMobileDeviceList = mobileDeviceList;
        this.mobileDeviceList = TestCloudMobileUtils.filteredMobileDeviceList(mobileDeviceList, TestCloudMobileAvailability.HIGH);
        this.createMobileNativeTab(parent);
        this.btnHighAvailableDevice.setSelection(true);
        this.registerControlListeners();
        this.loadDataForCbbMobileNativeOs(this.mobileDeviceList);
    }

    private void createMobileNativeTab(CTabFolder tabFolder) {
        this.setText("Mobile Native Apps");
        Composite tabContent = (Composite)ComponentBuilder.gridContainer((Composite)tabFolder, (int)3).fill().margin(10, 10).center().build();
        this.cbbMobileNativeOS = (Combo)ComponentBuilder.comboBox((Composite)tabContent, (int)8).horizontalIndent(10).autoWidth(90).fillHorizontal().build();
        this.cbbMobileNativeOSVersion = (Combo)ComponentBuilder.comboBox((Composite)tabContent, (int)8).autoWidth(90).fillHorizontal().horizontalIndent(7).build();
        this.cbbMobileNativeDeviceName = (Combo)ComponentBuilder.comboBox((Composite)tabContent, (int)8).autoWidth(120).fillHorizontal().horizontalIndent(7).build();
        this.btnHighAvailableDevice = (Button)ComponentBuilder.button((Composite)tabContent, (int)32).text(IntegrationTestCloudComposerMessageConstants.DIA_BTN_HIGH_AVAILABILITY_DEVICES).fillHorizontal().horizontalIndent(7).build();
        this.setControl((Control)tabContent);
    }

    private void registerControlListeners() {
        this.cbbMobileNativeOS.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudMobileNativesTab.this.latestSelectionOs = TestCloudMobileNativesTab.this.cbbMobileNativeOS.getText();
                TestCloudMobileNativesTab.this.latestSelectionOsVersion = null;
                TestCloudMobileNativesTab.this.latestSelectionDeviceName = null;
                if (TestCloudMobileNativesTab.this.mobileDeviceList != null && !TestCloudMobileNativesTab.this.mobileDeviceList.isEmpty()) {
                    TestCloudMobileOS selectedOS = TestCloudMobileNativesTab.this.mobileDeviceList.get(TestCloudMobileNativesTab.this.cbbMobileNativeOS.getSelectionIndex());
                    TestCloudMobileNativesTab.this.loadDataForCbbMobileNativeOsVersion(selectedOS.getOsVersions());
                    EventBrokerSingleton.getInstance().getEventBroker().post("TESTCLOUD/SELECT_MOBILE_NATIVE_OS", null);
                }
            }
        });
        this.cbbMobileNativeOSVersion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudMobileNativesTab.this.latestSelectionOsVersion = TestCloudMobileNativesTab.this.cbbMobileNativeOSVersion.getText();
                if (TestCloudMobileNativesTab.this.mobileDeviceList != null && !TestCloudMobileNativesTab.this.mobileDeviceList.isEmpty()) {
                    TestCloudMobileOSVersion selectedOSVersion = (TestCloudMobileOSVersion)TestCloudMobileNativesTab.this.mobileDeviceList.get(TestCloudMobileNativesTab.this.cbbMobileNativeOS.getSelectionIndex()).getOsVersions().get(TestCloudMobileNativesTab.this.cbbMobileNativeOSVersion.getSelectionIndex());
                    TestCloudMobileNativesTab.this.loadDataForCbbMobileNativeDevice(selectedOSVersion.getDeviceList());
                }
            }
        });
        this.cbbMobileNativeDeviceName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudMobileNativesTab.this.latestSelectionDeviceName = TestCloudMobileNativesTab.this.cbbMobileNativeDeviceName.getText();
                TestCloudMobileNativesTab.this.cbbMobileNativeDeviceName.setToolTipText(TestCloudMobileNativesTab.this.cbbMobileNativeDeviceName.getText());
            }
        });
        this.btnHighAvailableDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TestCloudMobileNativesTab.this.latestSelectionOs = TestCloudMobileNativesTab.this.cbbMobileNativeOS.getText();
                TestCloudMobileNativesTab.this.latestSelectionOsVersion = TestCloudMobileNativesTab.this.cbbMobileNativeOSVersion.getText();
                TestCloudMobileNativesTab.this.latestSelectionDeviceName = TestCloudMobileNativesTab.this.cbbMobileNativeDeviceName.getText();
                TestCloudMobileNativesTab.this.mobileDeviceList = TestCloudMobileNativesTab.this.btnHighAvailableDevice.getSelection() ? TestCloudMobileUtils.filteredMobileDeviceList(TestCloudMobileNativesTab.this.originalMobileDeviceList, TestCloudMobileAvailability.HIGH) : TestCloudMobileNativesTab.this.originalMobileDeviceList;
                if (TestCloudMobileNativesTab.this.mobileDeviceList != null && !TestCloudMobileNativesTab.this.mobileDeviceList.isEmpty()) {
                    TestCloudMobileOS selectedOS = TestCloudMobileNativesTab.this.mobileDeviceList.get(TestCloudMobileNativesTab.this.cbbMobileNativeOS.getSelectionIndex());
                    TestCloudMobileNativesTab.this.loadDataForCbbMobileNativeOsVersion(selectedOS.getOsVersions());
                }
            }
        });
    }

    private void loadDataForCbbMobileNativeOs(List<TestCloudMobileOS> mobileOs) {
        int foundIndex;
        String[] osList = new String[mobileOs.size()];
        int i = 0;
        while (i < mobileOs.size()) {
            osList[i] = mobileOs.get(i).getOs();
            ++i;
        }
        this.cbbMobileNativeOS.setItems(osList);
        int indexSelectedOs = 0;
        if (this.latestSelectionOs != null && (foundIndex = Arrays.asList(osList).indexOf(this.latestSelectionOs)) != -1) {
            indexSelectedOs = foundIndex;
        }
        this.cbbMobileNativeOS.select(indexSelectedOs);
        if (!mobileOs.isEmpty()) {
            this.loadDataForCbbMobileNativeOsVersion(mobileOs.get(indexSelectedOs).getOsVersions());
        }
    }

    private void loadDataForCbbMobileNativeOsVersion(List<TestCloudMobileOSVersion> osVersions) {
        int foundIndex;
        String[] osVersionList = new String[osVersions.size()];
        int i = 0;
        while (i < osVersions.size()) {
            osVersionList[i] = osVersions.get(i).getOsVersion();
            ++i;
        }
        this.cbbMobileNativeOSVersion.setItems(osVersionList);
        int indexSelectedOsVersion = 0;
        if (this.latestSelectionOsVersion != null && (foundIndex = Arrays.asList(osVersionList).indexOf(this.latestSelectionOsVersion)) != -1) {
            indexSelectedOsVersion = foundIndex;
        }
        this.cbbMobileNativeOSVersion.select(indexSelectedOsVersion);
        if (!osVersions.isEmpty()) {
            this.loadDataForCbbMobileNativeDevice(osVersions.get(indexSelectedOsVersion).getDeviceList());
        }
    }

    private void loadDataForCbbMobileNativeDevice(List<TestCloudMobileDevice> listDevice) {
        int foundIndex;
        listDevice.sort(TestCloudMobileUtils.sortPrivateDevicesFirst());
        String[] deviceName = new String[listDevice.size()];
        int i = 0;
        while (i < listDevice.size()) {
            deviceName[i] = TestCloudMobileUtils.getDeviceDisplayName(listDevice.get(i));
            ++i;
        }
        this.cbbMobileNativeDeviceName.setItems(deviceName);
        int indexDevice = 0;
        if (this.latestSelectionDeviceName != null && (foundIndex = Arrays.asList(deviceName).indexOf(this.latestSelectionDeviceName)) != -1) {
            indexDevice = foundIndex;
        }
        this.cbbMobileNativeDeviceName.select(indexDevice);
        this.cbbMobileNativeDeviceName.setToolTipText(this.cbbMobileNativeDeviceName.getText());
    }

    public void selectMobileNativeOS(String nativeOS) {
        this.cbbMobileNativeOS.setText(nativeOS);
        if (this.mobileDeviceList != null && !this.mobileDeviceList.isEmpty()) {
            TestCloudMobileOS selectedOS = this.mobileDeviceList.get(this.cbbMobileNativeOS.getSelectionIndex());
            this.loadDataForCbbMobileNativeOsVersion(selectedOS.getOsVersions());
        }
    }

    public void selectMobileNativeOSVersion(String nativeOSVersion) {
        this.cbbMobileNativeOSVersion.setText(nativeOSVersion);
        if (this.mobileDeviceList != null && !this.mobileDeviceList.isEmpty()) {
            this.loadDataForCbbMobileNativeDevice(((TestCloudMobileOSVersion)this.mobileDeviceList.get(this.cbbMobileNativeOS.getSelectionIndex()).getOsVersions().get(this.cbbMobileNativeOSVersion.getSelectionIndex())).getDeviceList());
        }
    }

    public void selectMobileNativeDevice(String mobileNativeDevice) {
        this.cbbMobileNativeDeviceName.setText(mobileNativeDevice);
        this.cbbMobileNativeDeviceName.setToolTipText(this.cbbMobileNativeDeviceName.getText());
    }

    public void selectHighAvailableDevice(boolean isHighAvailableDevice) {
        this.mobileDeviceList = isHighAvailableDevice ? TestCloudMobileUtils.filteredMobileDeviceList(this.originalMobileDeviceList, TestCloudMobileAvailability.HIGH) : this.originalMobileDeviceList;
        this.loadDataForCbbMobileNativeOs(this.mobileDeviceList);
        this.btnHighAvailableDevice.setSelection(isHighAvailableDevice);
    }

    public void loadSelectedTestCloudMobileNativeOptions(TestCloudMobileDevice mobile) {
        this.btnHighAvailableDevice.setSelection(mobile.isHighAvailableDevice());
        this.mobileDeviceList = mobile.isHighAvailableDevice() ? TestCloudMobileUtils.filteredMobileDeviceList(this.originalMobileDeviceList, TestCloudMobileAvailability.HIGH) : this.originalMobileDeviceList;
        String[] mobileOsList = this.cbbMobileNativeOS.getItems();
        boolean foundOS = false;
        int i = 0;
        while (i < mobileOsList.length) {
            if (mobileOsList[i].equalsIgnoreCase(mobile.getOs())) {
                this.selectMobileNativeOS(mobile.getOs());
                foundOS = true;
                break;
            }
            ++i;
        }
        if (!foundOS) {
            this.selectMobileNativeOS("");
        }
        String[] mobileOsVersionList = this.cbbMobileNativeOSVersion.getItems();
        boolean foundMobileOsVersion = false;
        int i2 = 0;
        while (i2 < mobileOsVersionList.length) {
            if (mobileOsVersionList[i2].equalsIgnoreCase(mobile.getOsVersion())) {
                this.selectMobileNativeOSVersion(mobile.getOsVersion());
                foundMobileOsVersion = true;
                break;
            }
            ++i2;
        }
        if (!foundMobileOsVersion) {
            this.selectMobileNativeOSVersion("");
        }
        String[] deviceNameList = this.cbbMobileNativeDeviceName.getItems();
        int i3 = 0;
        while (i3 < deviceNameList.length) {
            if (deviceNameList[i3].equalsIgnoreCase(TestCloudMobileUtils.getDeviceDisplayName(mobile))) {
                this.selectMobileNativeDevice(TestCloudMobileUtils.getDeviceDisplayName(mobile));
                return;
            }
            ++i3;
        }
        this.selectMobileNativeDevice("");
    }

    public String getMobileNativeOS() {
        return this.cbbMobileNativeOS.getText();
    }

    public String getMobileNativeOSVersion() {
        return this.cbbMobileNativeOSVersion.getText();
    }

    public String getMobileNativeDeviceName() {
        return this.cbbMobileNativeDeviceName.getText();
    }

    public int getMobileNativeOSIndex() {
        return this.cbbMobileNativeOS.getSelectionIndex();
    }

    public int getMobileNativeOSVersionIndex() {
        return this.cbbMobileNativeOSVersion.getSelectionIndex();
    }

    public int getMobileNativeDeviceNameIndex() {
        return this.cbbMobileNativeDeviceName.getSelectionIndex();
    }

    public boolean getBtnHighAvailableDevice() {
        return this.btnHighAvailableDevice.getSelection();
    }
}

