/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.testcloud.utils;

import com.kms.katalon.testcloud.core.model.TestCloudCapability;
import com.kms.katalon.testcloud.core.model.TestCloudMobileAvailability;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudMobileOS;
import com.kms.katalon.testcloud.core.model.TestCloudMobileOSVersion;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class TestCloudMobileUtils {
    public static List<TestCloudMobileOS> filteredMobileDeviceList(List<TestCloudMobileOS> mobileOs, TestCloudMobileAvailability status) {
        return mobileOs.stream().map(os -> {
            List filteredOsVersions = os.getOsVersions().stream().map(osVersion -> {
                List availableDevices = osVersion.getDeviceList().stream().filter(device -> status == device.getCapability().getAvailability()).sorted(TestCloudMobileUtils.sortPrivateDevicesFirst()).collect(Collectors.toList());
                return availableDevices.isEmpty() ? null : new TestCloudMobileOSVersion(osVersion.getOsVersion(), availableDevices);
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return new TestCloudMobileOS(os.getOs(), filteredOsVersions);
        }).filter(os -> !os.getOsVersions().isEmpty()).collect(Collectors.toList());
    }

    public static String getDeviceDisplayName(TestCloudMobileDevice device) {
        if (device.getCapability() == null) {
            return device.getDisplayName();
        }
        return !TestCloudMobileAvailability.LOW.equals((Object)device.getCapability().getAvailability()) ? device.getDisplayName() : device.getDisplayName() + " *";
    }

    public static Comparator<? super TestCloudMobileDevice> sortPrivateDevicesFirst() {
        return (device1, device2) -> {
            boolean hasUdid2;
            TestCloudCapability capability1 = device1.getCapability();
            TestCloudCapability capability2 = device2.getCapability();
            boolean hasUdid1 = capability1 != null && StringUtils.isNotBlank((String)capability1.getUdid());
            boolean bl = hasUdid2 = capability2 != null && StringUtils.isNotBlank((String)capability2.getUdid());
            if (hasUdid1 == hasUdid2) {
                return device1.getDisplayName().compareTo(device2.getDisplayName());
            }
            return hasUdid1 ? -1 : 1;
        };
    }
}

