/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.driver.CancelState;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class CancelLock {
    private CancelState state = null;
    private OracleStatement statement = null;

    CancelLock(OracleStatement oracleStatement) {
        this.statement = oracleStatement;
        this.state = new CancelState();
    }

    boolean isIdle() {
        try (Monitor.CloseableLock closeableLock = this.state.acquireCloseableLock();){
            boolean bl = this.state.isIdle();
            return bl;
        }
    }

    boolean isCanceled() {
        try (Monitor.CloseableLock closeableLock = this.state.acquireCloseableLock();){
            boolean bl = this.state.isCanceled();
            return bl;
        }
    }

    void enterExecuting() {
        try (Monitor.CloseableLock closeableLock = this.state.acquireCloseableLock();){
            assert (this.state.isIdle());
            this.state.setExecuting();
        }
    }

    /*
     * Unable to fully structure code
     */
    void exitExecuting() {
        while (true) lbl-1000:
        // 5 sources

        {
            block13: {
                block12: {
                    var1_1 = this.state.acquireCloseableLock();
                    if (!this.state.isExecuting()) break block12;
                    this.state.setIdle();
                    if (var1_1 == null) break;
                    var1_1.close();
                    break;
                }
                if (!this.state.isCanceling()) break block13;
                try {
                    this.state.monitorWait();
                }
                finally {
                    if (var1_1 == null) ** GOTO lbl-1000
                    var1_1.close();
                }
            }
            try {
                if (!this.state.isCanceled()) continue;
                if (this.statement != null && this.statement.connection.cancelInProgressFlag) {
                }
                this.state.setIdle();
            }
            finally {
                if (var1_1 == null) continue;
                var1_1.close();
                continue;
            }
            break;
        }
    }

    boolean enterCanceling() {
        try (Monitor.CloseableLock closeableLock = this.state.acquireCloseableLock();){
            if (this.state.isExecuting()) {
                this.state.setCanceling();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    void exitCanceling() {
        try (Monitor.CloseableLock closeableLock = this.state.acquireCloseableLock();){
            assert (this.state.isCanceling());
            this.state.setCanceled();
            this.state.monitorNotify();
        }
    }
}

