/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.menus.ExtensionContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;
import org.sf.feeling.decompiler.actions.ExportSourceAction;

public class ExportSourceContributionFactory
extends ExtensionContributionFactory {
    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        boolean exportClasses;
        boolean exportRoot;
        ISelectionService selService = (ISelectionService)serviceLocator.getService(ISelectionService.class);
        List<Object> selectedJars = this.getSelectedElements(selService, IPackageFragmentRoot.class);
        boolean bl = exportRoot = selectedJars.size() == 1;
        if (exportRoot) {
            additions.addContributionItem((IContributionItem)new ActionContributionItem((IAction)new ExportSourceAction(selectedJars)), new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                    return EvaluationResult.TRUE;
                }
            });
            return;
        }
        if (selectedJars.size() > 1) {
            return;
        }
        List<Object> selectedPackages = this.getSelectedElements(selService, IPackageFragment.class);
        final List<Object> selectedClasses = this.getSelectedElements(selService, IClassFile.class);
        selectedClasses.addAll(selectedPackages);
        boolean bl2 = exportClasses = !selectedClasses.isEmpty();
        if (exportClasses) {
            additions.addContributionItem((IContributionItem)new ActionContributionItem((IAction)new ExportSourceAction(selectedClasses)), new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                    boolean menuVisible = ExportSourceContributionFactory.this.isMenuVisible(selectedClasses);
                    if (menuVisible) {
                        return EvaluationResult.TRUE;
                    }
                    return EvaluationResult.FALSE;
                }
            });
            return;
        }
    }

    private boolean isMenuVisible(List selection) {
        IPackageFragmentRoot root = null;
        int i = 0;
        while (i < selection.size()) {
            IPackageFragmentRoot packRoot = null;
            Object obj = selection.get(i);
            if (obj instanceof IPackageFragment) {
                IPackageFragment packageFragment = (IPackageFragment)obj;
                packRoot = (IPackageFragmentRoot)packageFragment.getParent();
            } else if (obj instanceof IClassFile) {
                IClassFile classFile = (IClassFile)obj;
                packRoot = (IPackageFragmentRoot)classFile.getParent().getParent();
            } else {
                return false;
            }
            if (root == null) {
                root = packRoot;
            } else if (root != packRoot) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private List<Object> getSelectedElements(ISelectionService selService, Class eleClass) {
        Iterator<Object> selections = this.getSelections(selService);
        ArrayList<Object> elements = new ArrayList<Object>();
        while (selections != null && selections.hasNext()) {
            Object select = selections.next();
            if (!eleClass.isInstance(select)) continue;
            elements.add(select);
        }
        return elements;
    }

    private Iterator<Object> getSelections(ISelectionService selService) {
        ISelection selection = selService.getSelection();
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.iterator();
        }
        return null;
    }
}

