/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import com.drgarbage.asm.ClassReader;
import com.drgarbage.asm.ClassVisitor;
import com.drgarbage.asm.render.impl.ClassFileDocument;
import com.drgarbage.asm.render.impl.ClassFileOutlineElement;
import com.drgarbage.asm.render.intf.IClassFileDocument;
import com.drgarbage.asm.render.intf.IDocumentUpdateListener;
import com.drgarbage.asm_ext.IConstantPoolVisitor;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.sf.feeling.decompiler.editor.DisassemblerDocument;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.UIUtil;

public class DisassemblerDocumentProvider
extends FileDocumentProvider {
    private IClassFileDocument classFileDocument = null;
    private IJavaElement classFileOutlineElement;
    private ArrayList<IDocumentUpdateListener> documentUpdateListeners;
    private IDocument document;

    public IJavaElement getClassFileOutlineElement() {
        return this.classFileOutlineElement;
    }

    public IClassFileDocument getClassFileDocument() {
        return this.classFileDocument;
    }

    public void addDocumentUpdateListener(IDocumentUpdateListener listener) {
        if (listener != null) {
            if (this.documentUpdateListeners == null) {
                this.documentUpdateListeners = new ArrayList();
            }
            this.documentUpdateListeners.add(listener);
        }
    }

    public void removeDocumentUpdateListener(IDocumentUpdateListener listener) {
        if (listener != null && this.documentUpdateListeners != null) {
            Iterator<IDocumentUpdateListener> it = this.documentUpdateListeners.iterator();
            while (it.hasNext()) {
                IDocumentUpdateListener l = it.next();
                if (l != listener) continue;
                it.remove();
            }
        }
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
            tools.setupJavaDocumentPartitioner(document, "___java_partitioning");
        }
        return document;
    }

    protected IDocument createEmptyDocument() {
        return new DisassemblerDocument(this, UIUtil.getActiveDecompilerEditor());
    }

    protected void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        if (!(contentStream instanceof BufferedInputStream)) {
            contentStream = new BufferedInputStream(contentStream);
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (DataInputStream in = new DataInputStream(contentStream);){
                ClassFileOutlineElement outlineElement = new ClassFileOutlineElement();
                ClassFileDocument doc = new ClassFileDocument((ClassVisitor)outlineElement);
                outlineElement.setClassFileDocument((IClassFileDocument)doc);
                ClassReader cr = new ClassReader((InputStream)in, (IConstantPoolVisitor)doc);
                cr.accept((ClassVisitor)doc, 0);
                document.set(doc.toString());
                this.classFileDocument = doc;
                this.classFileOutlineElement = outlineElement;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Logger.debug(e);
        }
        if (this.documentUpdateListeners != null) {
            for (IDocumentUpdateListener l : this.documentUpdateListeners) {
                l.documentUpdated(this.classFileDocument);
            }
        }
    }

    public boolean isModifiable(Object element) {
        return false;
    }

    public IDocument getDocument(Object element) {
        return this.document;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }
}

