/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.BaseDecompiler;
import org.sf.feeling.decompiler.editor.IDecompiler;
import org.sf.feeling.decompiler.editor.IDecompilerDescriptor;
import org.sf.feeling.decompiler.editor.NoStackTraceException;
import org.sf.feeling.decompiler.util.DefaultDecompilerDescriptorComparator;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.UIUtil;

public class ClassUtil {
    public static IDecompiler checkAvailableDecompiler(IDecompiler decompiler, File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                return ClassUtil.checkAvailableDecompiler(decompiler, fis);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.error(e);
            return decompiler;
        }
    }

    public static IDecompiler checkAvailableDecompiler(IDecompiler decompiler, InputStream is) {
        int classLevel = ClassUtil.getLevel(is);
        boolean debug = ClassUtil.isDebug();
        IDecompiler defaultDecompiler = ClassUtil.getDebugDecompiler(classLevel, debug);
        if (decompiler.supportLevel(classLevel)) {
            if (debug && !decompiler.supportDebugLevel(classLevel)) {
                String recommendation = "";
                if (JavaDecompilerPlugin.getDefault().isDebug().booleanValue()) {
                    recommendation = String.valueOf(recommendation) + "Disable the 'Align code for debugging' option. ";
                }
                if (UIUtil.isDebugPerspective()) {
                    recommendation = String.valueOf(recommendation) + "Switch to the Java perspective. ";
                }
                if (JavaDecompilerPlugin.getDefault().isDebugMode()) {
                    recommendation = String.valueOf(recommendation) + "Disable the debug Mode. ";
                }
                String msg = "Could not use " + decompiler.getClass().getSimpleName() + " for decompilation since the debug view is not supported. " + recommendation + "Falling back to " + defaultDecompiler.getClass().getSimpleName() + ".";
                JavaDecompilerPlugin.logInfo(msg);
                ((BaseDecompiler)decompiler).addException(new NoStackTraceException(msg));
                return defaultDecompiler;
            }
        } else {
            String msg = "Could not use " + decompiler.getClass().getSimpleName() + " for decompilation since the classLevel " + classLevel + " is not supported. " + "Falling back to " + defaultDecompiler.getClass().getSimpleName() + ".";
            JavaDecompilerPlugin.logInfo(msg);
            ((BaseDecompiler)decompiler).addException(new NoStackTraceException(msg));
            return defaultDecompiler;
        }
        return decompiler;
    }

    public static boolean isDebug() {
        return JavaDecompilerPlugin.getDefault().isDebug() != false || UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getLevel(InputStream is) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (DataInputStream data = new DataInputStream(is);){
                if (-889275714 != data.readInt()) {
                    return -1;
                }
                data.readUnsignedShort();
                int major = data.readUnsignedShort();
                return major - 44;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.error("Failed to get Class file version", e);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isClassFile(byte[] classData) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (DataInputStream data = new DataInputStream(new ByteArrayInputStream(classData));){
                if (-889275714 != data.readInt()) {
                    return false;
                }
                data.readUnsignedShort();
                data.readUnsignedShort();
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            Logger.error("Class file test failed", e);
            return false;
        }
    }

    public static String getClassQualifiedName(byte[] classData) throws IOException {
        ClassReader classReader = new ClassReader(classData);
        return classReader.getClassName();
    }

    public static IDecompiler getDebugDecompiler(int level, boolean debug) {
        Collection<IDecompilerDescriptor> descriptors = JavaDecompilerPlugin.getDefault().getDecompilerDescriptorMap().values();
        if (descriptors != null) {
            Optional<IDecompilerDescriptor> defaultDecompiler;
            Stream<IDecompilerDescriptor> stream = descriptors.stream();
            if (debug) {
                stream = stream.filter(d -> d.getDecompiler().supportDebugLevel(level));
            }
            if (!(defaultDecompiler = stream.sorted(new DefaultDecompilerDescriptorComparator()).findFirst()).isPresent()) {
                return null;
            }
            return defaultDecompiler.get().getDecompiler();
        }
        return null;
    }
}

