/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.codemanipulation.SortMembersOperation;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;

public class SortMemberUtil {
    private static IPackageFragmentRoot decompilerSourceFolder = null;

    public static String sortMember(String packageName, String className, String code) {
        IPackageFragmentRoot sourceRootFragment = SortMemberUtil.getDecompilerSourceFolder();
        if (sourceRootFragment == null) {
            return code;
        }
        try {
            if (!sourceRootFragment.getJavaProject().isOpen()) {
                sourceRootFragment.getJavaProject().open(null);
            }
            if (!sourceRootFragment.getPackageFragment(packageName).exists()) {
                sourceRootFragment.createPackageFragment(packageName, false, null);
            }
            IPackageFragment packageFragment = sourceRootFragment.getPackageFragment(packageName);
            IProject project = sourceRootFragment.getJavaProject().getProject();
            IFolder sourceFolder = project.getFolder("src");
            long time = System.currentTimeMillis();
            String javaName = className.replaceAll("(?i)\\.class", String.valueOf(time) + ".java");
            File locationFile = new File(sourceFolder.getFile(javaName).getLocation().toString());
            IFile javaFile = sourceFolder.getFile(javaName);
            if (!locationFile.getParentFile().exists()) {
                locationFile.getParentFile().mkdirs();
            }
            Throwable throwable = null;
            Object var13_14 = null;
            try (PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(locationFile, false)));){
                writer.println(code);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            javaFile.refreshLocal(0, null);
            ICompilationUnit iCompilationUnit = packageFragment.getCompilationUnit(locationFile.getName());
            iCompilationUnit.makeConsistent(null);
            iCompilationUnit.getResource().setLocalTimeStamp(new Date().getTime());
            iCompilationUnit.becomeWorkingCopy(null);
            new SortMembersOperation(iCompilationUnit, null, true).run(null);
            iCompilationUnit.commitWorkingCopy(true, null);
            iCompilationUnit.save(null, true);
            String content = iCompilationUnit.getSource();
            iCompilationUnit.delete(true, null);
            iCompilationUnit.destroy();
            if (content != null) {
                code = content;
            }
            packageFragment.getJavaProject().close();
        }
        catch (IOException | CoreException e) {
            JavaDecompilerPlugin.logError(e, "");
        }
        return code;
    }

    public static void deleteDecompilerProject() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(".decompiler");
        if (project != null && project.exists()) {
            try {
                project.delete(true, true, null);
            }
            catch (CoreException e) {
                JavaDecompilerPlugin.logError(e, "");
            }
        }
    }

    public static IPackageFragmentRoot getDecompilerSourceFolder() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(".decompiler");
        if (project == null) {
            return null;
        }
        if (!project.exists()) {
            try {
                project.create(null);
                project.open(null);
                IProjectDescription description = project.getDescription();
                String[] natures = description.getNatureIds();
                String[] newNatures = new String[natures.length + 1];
                System.arraycopy(natures, 0, newNatures, 0, natures.length);
                newNatures[natures.length] = "org.eclipse.jdt.core.javanature";
                description.setNatureIds(newNatures);
                project.setDescription(description, null);
            }
            catch (CoreException e1) {
                JavaDecompilerPlugin.logError(e1, "");
                return null;
            }
            if (!project.isOpen()) {
                return null;
            }
        } else if (!project.isOpen()) {
            try {
                project.open(null);
            }
            catch (CoreException e) {
                JavaDecompilerPlugin.logError(e, "");
                return null;
            }
        }
        if (decompilerSourceFolder != null) {
            return decompilerSourceFolder;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        try {
            LibraryLocation[] locations;
            ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
            IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
            LibraryLocation[] libraryLocationArray = locations = JavaRuntime.getLibraryLocations((IVMInstall)vmInstall);
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                LibraryLocation element = libraryLocationArray[n2];
                entries.add(JavaCore.newLibraryEntry((IPath)element.getSystemLibraryPath(), null, null));
                ++n2;
            }
            javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), null);
            IFolder sourceFolder = project.getFolder("src");
            sourceFolder.create(false, true, null);
            IPackageFragmentRoot codeGenFolder = javaProject.getPackageFragmentRoot((IResource)sourceFolder);
            IClasspathEntry[] oldEntries = javaProject.getRawClasspath();
            IClasspathEntry[] newEntries = new IClasspathEntry[oldEntries.length + 1];
            System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
            newEntries[oldEntries.length] = JavaCore.newSourceEntry((IPath)codeGenFolder.getPath());
            javaProject.setRawClasspath(newEntries, null);
            javaProject.open(null);
            decompilerSourceFolder = javaProject.getPackageFragmentRoot((IResource)sourceFolder);
            return decompilerSourceFolder;
        }
        catch (CoreException e) {
            JavaDecompilerPlugin.logError(e, "");
            return null;
        }
    }
}

