/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.lang.reflect.Method;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.core.NamedMember;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.sf.feeling.decompiler.util.ReflectionUtils;

public class SourceMapperUtil {
    private static final String MAP_SOURCE_METHOD_NAME = "mapSource";

    public static void mapSource(SourceMapper sourceMapper, IType type, char[] source, IBinaryType info) {
        SourceMapperUtil.mapSource(sourceMapper, type, source, info, null);
    }

    public static void mapSource(SourceMapper sourceMapper, IType type, char[] source, IBinaryType info, IJavaElement elementToFind) {
        Method mapSourceMethod = SourceMapperUtil.getMapSourceMethod(sourceMapper);
        if (mapSourceMethod == null) {
            mapSourceMethod = SourceMapperUtil.getLegacyMapSourceMethod(sourceMapper);
        }
        if (mapSourceMethod == null) {
            throw new IllegalStateException("Unable to invoke mapSource method on sourceMapper");
        }
        Object[] parameters = new Object[]{type, source, info, elementToFind};
        ReflectionUtils.invokeMethod(mapSourceMethod, sourceMapper, parameters);
    }

    private static Method getMapSourceMethod(SourceMapper sourceMapper) {
        return ReflectionUtils.getDeclaredMethod(sourceMapper, MAP_SOURCE_METHOD_NAME, new Class[]{NamedMember.class, char[].class, IBinaryType.class, IJavaElement.class});
    }

    private static Method getLegacyMapSourceMethod(SourceMapper sourceMapper) {
        return ReflectionUtils.getDeclaredMethod(sourceMapper, MAP_SOURCE_METHOD_NAME, new Class[]{IType.class, char[].class, IBinaryType.class, IJavaElement.class});
    }
}

