/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.custom.improvement.model;

import com.kms.katalon.core.exception.KatalonRuntimeException;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.util.FileHashUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;

public class CustomKeywordFile {
    private ProjectEntity project;
    private File file;
    private String contentHash;
    private String relativePath;
    private boolean exists = false;

    private CustomKeywordFile(ProjectEntity project, File file) {
        this.project = project;
        this.file = file;
        this.relativePath = this.computeRelativePath();
    }

    public ProjectEntity getProject() {
        return this.project;
    }

    public String getContentHash() {
        return this.contentHash;
    }

    public File getFile() {
        return this.file;
    }

    public boolean exists() {
        return this.exists;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    private String computeRelativePath() {
        try {
            File keywordFolder = CustomKeywordFile.getKeywordRootFolder(this.project);
            String keywordFolderPath = keywordFolder.getAbsolutePath();
            String keywordFilePath = this.file.getAbsolutePath();
            return PathUtil.absoluteToRelativePath((String)keywordFilePath, (String)keywordFolderPath);
        }
        catch (Exception e) {
            throw new KatalonRuntimeException((Throwable)e);
        }
    }

    public static CustomKeywordFile from(ProjectEntity project, File file) throws IOException {
        CustomKeywordFile keywordFile = new CustomKeywordFile(project, file);
        keywordFile.exists = file.exists();
        if (keywordFile.exists) {
            try {
                keywordFile.contentHash = FileHashUtil.getFileHash((Path)Paths.get(file.getAbsolutePath(), new String[0]), (String)"MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new KatalonRuntimeException((Throwable)e);
            }
        }
        return keywordFile;
    }

    private static File getKeywordRootFolder(ProjectEntity project) throws Exception {
        return new File(project.getFolderLocation(), "Keywords");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.relativePath == null ? 0 : this.relativePath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomKeywordFile other = (CustomKeywordFile)obj;
        return !(this.relativePath == null ? other.relativePath != null : !this.relativePath.equals(other.relativePath));
    }
}

