/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.webui.recorder.dialog.provider;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.testcase.ast.dialogs.IAstDialogBuilder;
import com.kms.katalon.composer.webui.recorder.constants.ComposerWebuiRecorderMessageConstants;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.element.tree.WebElementLabelProvider;
import com.kms.katalon.objectspy.element.tree.WebElementTreeContentProvider;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CapturedElementBrowserDialog
extends AbstractDialog
implements IAstDialogBuilder {
    private TreeViewer treeViewer;
    private List<WebElement> capturedElements;
    private WebElement selectedElement;

    public CapturedElementBrowserDialog(Shell parentShell, List<WebElement> capturedElements, WebElement selectedElement) {
        super(parentShell);
        this.capturedElements = capturedElements;
        this.selectedElement = selectedElement;
    }

    protected void registerControlModifyListeners() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WebElement webElement = (WebElement)CapturedElementBrowserDialog.this.treeViewer.getStructuredSelection().getFirstElement();
                if (webElement != null) {
                    CapturedElementBrowserDialog.this.selectedElement = webElement;
                }
                CapturedElementBrowserDialog.this.getButton(0).setEnabled(!(webElement instanceof WebPage));
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                WebElement webElement = (WebElement)CapturedElementBrowserDialog.this.treeViewer.getStructuredSelection().getFirstElement();
                if (webElement instanceof WebPage) {
                    CapturedElementBrowserDialog.this.treeViewer.setExpandedState((Object)webElement, true);
                } else {
                    CapturedElementBrowserDialog.this.okPressed();
                }
            }
        });
    }

    protected void setInput() {
        this.treeViewer.setInput(this.capturedElements);
        if (this.selectedElement != null) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedElement));
        }
    }

    protected Control createDialogContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.treeViewer = new TreeViewer(container, 2050);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setContentProvider((IContentProvider)new WebElementTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WebElementLabelProvider());
        this.treeViewer.setAutoExpandLevel(2);
        return container;
    }

    public Object getReturnValue() {
        return this.selectedElement;
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    public String getDialogTitle() {
        return ComposerWebuiRecorderMessageConstants.DIA_TITLE_CAPTURED_OBJECTS;
    }
}

