/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.search.view;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestDataTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.impl.tree.WindowsElementTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.search.view.QSearchInput;
import com.kms.katalon.composer.search.view.QSearchQuery;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.groovy.reference.TestArtifactScriptRefactor;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;

public class QSearchQueryBuilder {
    private static final String JAVA_LEGAL_NAME_REGEX = "[a-zA-Z_][a-zA-Z0-9_]*";
    private static final String CUSTOM_KEYWORD_REGEX_PREFIX = "CustomKeywords\\.\\'";
    private static final String GROOVY_FILE_FORMAT = "*.groovy";
    private static final String PROFILE_FILE_FORMAT = "*.glbl";
    private static final String TESTCASE_FILE_FORMAT = "*.tc";

    public static QSearchQuery getQuery(QSearchInput input) {
        return new QSearchQuery(input.getSearchText(), input.isRegExSearch(), input.isCaseSensitiveSearch(), input.getScope());
    }

    private static String[] getTestCaseReferencesFileNamePatterns() {
        ArrayList<Object> testCaseReferencesFileNamePatterns = new ArrayList<Object>();
        testCaseReferencesFileNamePatterns.add(GROOVY_FILE_FORMAT);
        testCaseReferencesFileNamePatterns.add("*" + TestSuiteEntity.getTestSuiteFileExtension());
        return testCaseReferencesFileNamePatterns.toArray(new String[testCaseReferencesFileNamePatterns.size()]);
    }

    private static String[] getTestDataReferencesFileNamePatterns() {
        ArrayList<Object> testDataFileNameReferencePatterns = new ArrayList<Object>();
        testDataFileNameReferencePatterns.add(GROOVY_FILE_FORMAT);
        testDataFileNameReferencePatterns.add("*" + TestSuiteEntity.getTestSuiteFileExtension());
        testDataFileNameReferencePatterns.add("*" + TestCaseEntity.getTestCaseFileExtension());
        return testDataFileNameReferencePatterns.toArray(new String[testDataFileNameReferencePatterns.size()]);
    }

    private static String[] getGlobalVariableReferencesFileNamePatterns() {
        ArrayList<String> globalVariableFileNameReferencePatterns = new ArrayList<String>();
        globalVariableFileNameReferencePatterns.add(GROOVY_FILE_FORMAT);
        return globalVariableFileNameReferencePatterns.toArray(new String[globalVariableFileNameReferencePatterns.size()]);
    }

    private static String[] getTestObjectReferencesFileNamePatterns() {
        ArrayList<Object> testObjectReferencesFileNamePatterns = new ArrayList<Object>();
        testObjectReferencesFileNamePatterns.add(GROOVY_FILE_FORMAT);
        testObjectReferencesFileNamePatterns.add(PROFILE_FILE_FORMAT);
        testObjectReferencesFileNamePatterns.add(TESTCASE_FILE_FORMAT);
        testObjectReferencesFileNamePatterns.add("*" + WebElementEntity.getWebElementFileExtension());
        return testObjectReferencesFileNamePatterns.toArray(new String[testObjectReferencesFileNamePatterns.size()]);
    }

    private static String[] getWindowsObjectReferencesFileNamePatterns() {
        ArrayList<String> windowsObjectReferencesFileNamePatterns = new ArrayList<String>();
        windowsObjectReferencesFileNamePatterns.add(GROOVY_FILE_FORMAT);
        windowsObjectReferencesFileNamePatterns.add(PROFILE_FILE_FORMAT);
        windowsObjectReferencesFileNamePatterns.add(TESTCASE_FILE_FORMAT);
        windowsObjectReferencesFileNamePatterns.add("*.wrs");
        return windowsObjectReferencesFileNamePatterns.toArray(new String[0]);
    }

    private static String[] getKeywordReferencesFileNamePatterns() {
        ArrayList<String> keywordFileNameReferencePatterns = new ArrayList<String>();
        keywordFileNameReferencePatterns.add(GROOVY_FILE_FORMAT);
        return keywordFileNameReferencePatterns.toArray(new String[keywordFileNameReferencePatterns.size()]);
    }

    public static QSearchQuery getReferenceQueryForTreeEntity(ITreeEntity treeEntity, ProjectEntity project) throws Exception {
        IProject groovyProject = GroovyUtil.getGroovyProject((ProjectEntity)project);
        if (treeEntity instanceof TestCaseTreeEntity) {
            return QSearchQueryBuilder.getTestCaseReferenceQuery((TestCaseTreeEntity)treeEntity, groovyProject);
        }
        if (treeEntity instanceof WebElementTreeEntity) {
            return QSearchQueryBuilder.getTestObjectReferenceQuery((WebElementTreeEntity)treeEntity, groovyProject);
        }
        if (treeEntity instanceof WindowsElementTreeEntity) {
            return QSearchQueryBuilder.getWindowsObjectReferenceQuery((WindowsElementTreeEntity)treeEntity, groovyProject);
        }
        if (treeEntity instanceof TestDataTreeEntity) {
            return QSearchQueryBuilder.getTestDataReferenceQuery((TestDataTreeEntity)treeEntity, groovyProject);
        }
        if (treeEntity instanceof KeywordTreeEntity) {
            return QSearchQueryBuilder.getKeywordReferenceQuery((KeywordTreeEntity)treeEntity, groovyProject);
        }
        if (treeEntity instanceof FolderTreeEntity) {
            FolderEntity folderEntity = (FolderEntity)treeEntity.getObject();
            switch (folderEntity.getFolderType()) {
                case DATAFILE: {
                    return QSearchQueryBuilder.getTestDataFolderReferenceQuery(folderEntity, groovyProject);
                }
                case KEYWORD: {
                    return QSearchQueryBuilder.getKeywordFolderReferenceQuery(groovyProject);
                }
                case TESTCASE: {
                    return QSearchQueryBuilder.getTestCaseFolderReferenceQuery(folderEntity, groovyProject);
                }
                case WEBELEMENT: {
                    return QSearchQueryBuilder.getTestObjectFolderReferenceQuery(folderEntity, groovyProject);
                }
            }
        } else if (treeEntity instanceof PackageTreeEntity) {
            PackageTreeEntity packageTreeEntity = (PackageTreeEntity)treeEntity;
            return QSearchQueryBuilder.getPackageReferenceQuery(packageTreeEntity, groovyProject);
        }
        return null;
    }

    public static String getSearchTextInScript(FileEntity entity) {
        TestArtifactScriptRefactor scriptReference = null;
        scriptReference = entity instanceof FolderEntity ? TestArtifactScriptRefactor.createForFolderEntity((FolderEntity)((FolderEntity)entity)) : (entity instanceof WebElementEntity ? TestArtifactScriptRefactor.createForTestObjectEntity((String)entity.getIdForDisplay()) : (entity instanceof WindowsElementEntity ? TestArtifactScriptRefactor.createForWindowsObjectEntity((String)entity.getIdForDisplay()) : new TestArtifactScriptRefactor(entity.getParentFolder().getFolderType(), entity.getIdForDisplay(), true, true, true)));
        StringBuilder searchTextBuilder = new StringBuilder();
        for (String potentialRef : scriptReference.getReferenceStrings()) {
            if (searchTextBuilder.length() > 0) {
                searchTextBuilder.append("|");
            }
            searchTextBuilder.append(Pattern.quote(potentialRef));
        }
        return searchTextBuilder.toString();
    }

    public static QSearchQuery getTestCaseReferenceQuery(TestCaseTreeEntity testCaseTreeEntity, IProject groovyProject) throws Exception {
        TestCaseEntity testCaseEntity = testCaseTreeEntity.getObject();
        if (testCaseEntity == null) {
            return null;
        }
        String testCaseId = testCaseEntity.getIdForDisplay();
        String searchTextMetaData = "(<testCaseId>" + Pattern.quote(testCaseId) + "</testCaseId>)";
        String searchText = QSearchQueryBuilder.getSearchTextInScript((FileEntity)testCaseEntity) + "|" + searchTextMetaData;
        boolean isCaseSensitive = true;
        boolean isRegExSearch = true;
        QSearchInput input = new QSearchInput(searchText, isCaseSensitive, isRegExSearch, QSearchQueryBuilder.getTestCaseReferencesFileNamePatterns(), groovyProject);
        return QSearchQueryBuilder.getQuery(input);
    }

    public static QSearchQuery getTestCaseFolderReferenceQuery(FolderEntity folderEntity, IProject groovyProject) throws Exception {
        if (folderEntity == null) {
            return null;
        }
        String folderId = folderEntity.getIdForDisplay() + "/";
        String searchTextMetaData = "(<testCaseId>" + Pattern.quote(folderId) + ".+</testCaseId>)";
        String searchText = QSearchQueryBuilder.getSearchTextInScript((FileEntity)folderEntity) + "|" + searchTextMetaData;
        boolean isCaseSensitive = true;
        boolean isRegExSearch = true;
        QSearchInput input = new QSearchInput(searchText, isCaseSensitive, isRegExSearch, QSearchQueryBuilder.getTestCaseReferencesFileNamePatterns(), groovyProject);
        return QSearchQueryBuilder.getQuery(input);
    }

    public static QSearchQuery getTestObjectReferenceQuery(WebElementTreeEntity testObjectTreeEntity, IProject groovyProject) throws Exception {
        WebElementEntity testObjectEntity = (WebElementEntity)testObjectTreeEntity.getObject();
        if (testObjectEntity == null) {
            return null;
        }
        String testObjectId = testObjectEntity.getIdForDisplay();
        String searchTextMetaData = "(<value>" + Pattern.quote(testObjectId) + "</value>)";
        String searchText = QSearchQueryBuilder.getSearchTextInScript((FileEntity)testObjectEntity) + "|" + searchTextMetaData;
        boolean isCaseSensitive = true;
        boolean isRegExSearch = true;
        QSearchInput input = new QSearchInput(searchText, isCaseSensitive, isRegExSearch, QSearchQueryBuilder.getTestObjectReferencesFileNamePatterns(), groovyProject);
        return QSearchQueryBuilder.getQuery(input);
    }

    public static QSearchQuery getWindowsObjectReferenceQuery(WindowsElementTreeEntity windowsObjectTreeEntity, IProject groovyProject) throws Exception {
        WindowsElementEntity windowsElementEntity = windowsObjectTreeEntity.getObject();
        if (windowsElementEntity == null) {
            return null;
        }
        String windowsObjectId = windowsElementEntity.getIdForDisplay();
        String searchTextMetaData = "(<value>" + Pattern.quote(windowsObjectId) + "</value>)";
        String searchText = QSearchQueryBuilder.getSearchTextInScript((FileEntity)windowsElementEntity) + "|" + searchTextMetaData;
        boolean isCaseSensitive = true;
        boolean isRegExSearch = true;
        QSearchInput input = new QSearchInput(searchText, isCaseSensitive, isRegExSearch, QSearchQueryBuilder.getWindowsObjectReferencesFileNamePatterns(), groovyProject);
        return QSearchQueryBuilder.getQuery(input);
    }

    public static QSearchQuery getTestObjectFolderReferenceQuery(FolderEntity folderEntity, IProject groovyProject) throws Exception {
        if (folderEntity == null) {
            return null;
        }
        String folderId = folderEntity.getIdForDisplay() + "/";
        String searchTextMetaData = "(<value>" + Pattern.quote(folderId) + ".+</value>)";
        String searchText = QSearchQueryBuilder.getSearchTextInScript((FileEntity)folderEntity) + "|" + searchTextMetaData;
        boolean isCaseSensitive = true;
        boolean isRegExSearch = true;
        QSearchInput input = new QSearchInput(searchText, isCaseSensitive, isRegExSearch, QSearchQueryBuilder.getTestObjectReferencesFileNamePatterns(), groovyProject);
        return QSearchQueryBuilder.getQuery(input);
    }

    public static QSearchQuery getTestDataReferenceQuery(TestDataTreeEntity testDataTreeEntity, IProject groovyProject) throws Exception {
        DataFileEntity testDataEntity = testDataTreeEntity.getObject();
        if (testDataEntity == null) {
            return null;
        }
        String testDataId = testDataEntity.getIdForDisplay();
        String searchTextMetaData = "(<testDataId>" + Pattern.quote(testDataId) + "</testDataId>)";
        String searchText = QSearchQueryBuilder.getSearchTextInScript((FileEntity)testDataEntity) + "|" + searchTextMetaData;
        boolean isCaseSensitive = true;
        boolean isRegExSearch = true;
        QSearchInput input = new QSearchInput(searchText, isCaseSensitive, isRegExSearch, QSearchQueryBuilder.getTestDataReferencesFileNamePatterns(), groovyProject);
        return QSearchQueryBuilder.getQuery(input);
    }

    public static QSearchQuery getTestDataFolderReferenceQuery(FolderEntity folderEntity, IProject groovyProject) throws Exception {
        if (folderEntity == null) {
            return null;
        }
        String folderId = folderEntity.getIdForDisplay() + "/";
        String searchTextMetaData = "(<testDataId>" + Pattern.quote(folderId) + ".+</testDataId>)";
        String searchText = QSearchQueryBuilder.getSearchTextInScript((FileEntity)folderEntity) + "|" + searchTextMetaData;
        boolean isCaseSensitive = true;
        boolean isRegExSearch = true;
        QSearchInput input = new QSearchInput(searchText, isCaseSensitive, isRegExSearch, QSearchQueryBuilder.getTestDataReferencesFileNamePatterns(), groovyProject);
        return QSearchQueryBuilder.getQuery(input);
    }

    public static QSearchQuery getGlobalVariablePrefrenceQuery(GlobalVariableEntity globalVariable, IProject groovyProject) {
        String searchText = "GlobalVariable." + globalVariable.getName();
        boolean isCaseSensitive = true;
        boolean isRegExSearch = false;
        QSearchInput input = new QSearchInput(searchText, isCaseSensitive, isRegExSearch, QSearchQueryBuilder.getGlobalVariableReferencesFileNamePatterns(), groovyProject);
        return QSearchQueryBuilder.getQuery(input);
    }

    public static QSearchQuery getKeywordReferenceQuery(KeywordTreeEntity keywordTreeEntity, IProject groovyProject) throws Exception {
        IFile keywordFile = (IFile)((ICompilationUnit)keywordTreeEntity.getObject()).getResource();
        if (keywordFile == null) {
            return null;
        }
        PackageTreeEntity parentPackageTreeEntity = (PackageTreeEntity)keywordTreeEntity.getParent();
        IPackageFragment packageFragment = (IPackageFragment)parentPackageTreeEntity.getObject();
        String packageName = packageFragment.getElementName().isEmpty() ? "" : packageFragment.getElementName() + "\\.";
        String searchText = CUSTOM_KEYWORD_REGEX_PREFIX + packageName + FilenameUtils.getBaseName((String)keywordFile.getName()) + "(\\.)[a-zA-Z_][a-zA-Z0-9_]*\\'";
        boolean isCaseSensitive = true;
        boolean isRegExSearch = true;
        QSearchInput input = new QSearchInput(searchText, isCaseSensitive, isRegExSearch, QSearchQueryBuilder.getKeywordReferencesFileNamePatterns(), groovyProject);
        return QSearchQueryBuilder.getQuery(input);
    }

    public static QSearchQuery getPackageReferenceQuery(PackageTreeEntity packageTreeEntity, IProject groovyProject) throws Exception {
        if (packageTreeEntity == null) {
            return null;
        }
        IPackageFragment packageFragment = (IPackageFragment)packageTreeEntity.getObject();
        String packageName = packageFragment.getElementName().isEmpty() ? "" : packageFragment.getElementName() + "\\.";
        String searchText = CUSTOM_KEYWORD_REGEX_PREFIX + packageName + "[a-zA-Z_][a-zA-Z0-9_]*(\\.)[a-zA-Z_][a-zA-Z0-9_]*\\'";
        boolean isCaseSensitive = true;
        boolean isRegExSearch = true;
        QSearchInput input = new QSearchInput(searchText, isCaseSensitive, isRegExSearch, QSearchQueryBuilder.getKeywordReferencesFileNamePatterns(), groovyProject);
        return QSearchQueryBuilder.getQuery(input);
    }

    public static QSearchQuery getKeywordFolderReferenceQuery(IProject groovyProject) throws Exception {
        String searchText = "CustomKeywords\\.\\'[a-zA-Z_][a-zA-Z0-9_]*((\\.)[a-zA-Z_][a-zA-Z0-9_]*)+\\'";
        boolean isCaseSensitive = true;
        boolean isRegExSearch = true;
        QSearchInput input = new QSearchInput(searchText, isCaseSensitive, isRegExSearch, QSearchQueryBuilder.getKeywordReferencesFileNamePatterns(), groovyProject);
        return QSearchQueryBuilder.getQuery(input);
    }
}

