/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.search.view;

import com.kms.katalon.composer.search.action.OpenEditorAction;
import com.kms.katalon.composer.search.view.provider.SearchResultPageLabelProvider;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.internal.ui.text.FileLabelProvider;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PartInitException;

public class QSearchResultPage
extends FileSearchPage {
    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IFile file = (IFile)match.getElement();
        if (!this.showEditor(file, offset, length)) {
            super.showMatch(match, offset, length, activate);
        }
    }

    private boolean showEditor(IFile file, int offset, int length) {
        block11: {
            ProjectEntity project;
            String fileExtension;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                block10: {
                                    String fileName = FilenameUtils.getBaseName((String)file.getFullPath().toString());
                                    fileExtension = "." + file.getFileExtension();
                                    project = ProjectController.getInstance().getCurrentProject();
                                    try {
                                        if (!fileExtension.equals(".groovy")) break block10;
                                        TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByScriptName(fileName);
                                        if (testCase != null) {
                                            OpenEditorAction.openEditor(testCase, offset, length);
                                            return true;
                                        }
                                        break block11;
                                    }
                                    catch (Exception exception) {}
                                }
                                if (!fileExtension.equals(TestCaseEntity.getTestCaseFileExtension())) break block12;
                                String testCaseId = file.getFullPath().toString().replace(file.getProject().getFullPath().toString() + "/", "").replace(TestCaseEntity.getTestCaseFileExtension(), "");
                                TestCaseEntity testCase = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseId);
                                OpenEditorAction.openTestCase(testCase);
                                return true;
                            }
                            if (!fileExtension.equals(WebElementEntity.getWebElementFileExtension())) break block13;
                            String testObjectId = file.getFullPath().toString().replace(file.getProject().getFullPath().toString() + "/", "").replace(WebElementEntity.getWebElementFileExtension(), "");
                            WebElementEntity testObject = ObjectRepositoryController.getInstance().getWebElementByDisplayPk(testObjectId);
                            OpenEditorAction.openTestObject(testObject);
                            return true;
                        }
                        if (!fileExtension.equals(TestSuiteEntity.getTestSuiteFileExtension())) break block14;
                        String testSuiteId = file.getFullPath().toString().replace(file.getProject().getFullPath().toString() + "/", "").replace(TestSuiteEntity.getTestSuiteFileExtension(), "");
                        TestSuiteEntity testSuite = TestSuiteController.getInstance().getTestSuiteByDisplayId(testSuiteId, project);
                        OpenEditorAction.openTestSuite(testSuite);
                        return true;
                    }
                    if (!fileExtension.equals(DataFileEntity.getTestDataFileExtension())) break block15;
                    String testDataId = file.getFullPath().toString().replace(file.getProject().getFullPath().toString() + "/", "").replace(DataFileEntity.getTestDataFileExtension(), "");
                    DataFileEntity testData = TestDataController.getInstance().getTestDataByDisplayId(testDataId);
                    OpenEditorAction.openTestData(testData);
                    return true;
                }
                if (!fileExtension.equals(ReportEntity.getReportFileExtension())) break block16;
                String reportDisplayId = file.getParent().getProjectRelativePath().toString();
                ReportEntity testData = ReportController.getInstance().getReportEntityByDisplayId(reportDisplayId, project);
                OpenEditorAction.openReport(testData);
                return true;
            }
            if (fileExtension.equals(ExecutionProfileEntity.getGlobalVariableFileExtension())) {
                String profileName = file.getName().replace(ExecutionProfileEntity.getGlobalVariableFileExtension(), "");
                ExecutionProfileEntity profile = GlobalVariableController.getInstance().getExecutionProfile(profileName, project);
                OpenEditorAction.openExecutionProfile(profile);
                return true;
            }
        }
        return false;
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        super.configureTreeViewer(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new SearchResultPageLabelProvider(new FileLabelProvider((AbstractTextSearchViewPage)this, 1)));
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (firstElement instanceof IFile) {
            if (this.getDisplayedMatchCount(firstElement) == 0 && !this.showEditor((IFile)firstElement, 0, 0)) {
                super.handleOpen(event);
            }
        } else if (firstElement instanceof LineElement) {
            super.handleOpen(event);
        }
    }
}

