/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.handler;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.util.TreeEntityUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.parts.ExplorerPart;
import com.kms.katalon.composer.windows.constant.ComposerWindowsMessage;
import com.kms.katalon.composer.windows.dialog.NewWindowsElementDialog;
import com.kms.katalon.composer.windows.handler.OpenWindowsElementHandler;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.EntityNameController;
import com.kms.katalon.controller.WindowsElementController;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WindowsElementEntity;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.IProductFeatureDialog;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NewWindowsElementHandler {
    @Inject
    private IFeatureController featureController;
    @Inject
    private IProductFeatureDialog productFeatureDialog;

    @Execute
    public void createNewWindowsElement(Shell activeShell) {
        if (!this.featureController.canUse(ProductFeature.WINDOWS_DESKTOP_TESTING)) {
            this.productFeatureDialog.showNotAvailableFeature(ProductFeature.WINDOWS_DESKTOP_TESTING);
            return;
        }
        try {
            ITreeEntity selectedTreeEntity = (ITreeEntity)ExplorerPart.getInstance().getSelectedTreeEntities().get(0);
            FolderTreeEntity folderTreeEntity = null;
            folderTreeEntity = selectedTreeEntity instanceof FolderTreeEntity ? (FolderTreeEntity)selectedTreeEntity : (FolderTreeEntity)selectedTreeEntity.getParent();
            FolderEntity folder = folderTreeEntity.getObject();
            String suggestedName = EntityNameController.getInstance().getAvailableName(ComposerWindowsMessage.TITLE_NEW_WINDOWS_OBJECT_NAME, folder, false);
            NewWindowsElementDialog dialog = new NewWindowsElementDialog(activeShell, folder, suggestedName);
            if (dialog.open() != 0) {
                return;
            }
            WindowsElementEntity testRunEntity = (WindowsElementEntity)dialog.getEntity();
            if (testRunEntity == null) {
                return;
            }
            WindowsElementEntity newWindowsElementEntity = WindowsElementController.getInstance().newWindowsElementEntity(folder, testRunEntity.getName());
            Trackings.trackCreatingObject((String)"windowsObject", (Object[])new Object[0]);
            ExplorerPart.getInstance().refreshTreeEntity((Object)folderTreeEntity);
            ExplorerPart.getInstance().setSelectedItems(new Object[]{TreeEntityUtil.getWindowsElementTreeEntity((WindowsElementEntity)newWindowsElementEntity, (FolderEntity)folder)});
            OpenWindowsElementHandler.getInstance().openWindowsElement(newWindowsElementEntity);
        }
        catch (FilePathTooLongException e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)"Unable to create Windows object", (String)e.getMessage());
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

