/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.handler;

import com.kms.katalon.composer.execution.handlers.AbstractExecutionHandler;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;
import com.kms.katalon.core.windows.driver.FlaUIDriverManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.execution.windows.WindowsDriverConnector;
import com.kms.katalon.execution.windows.WindowsRunConfiguration;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.session.core.model.ProductFeature;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class WindowsExecutionHandler
extends AbstractExecutionHandler {
    protected IRunConfiguration getRunConfigurationForExecution(String projectDir) throws IOException {
        WindowsRunConfiguration runConfig = new WindowsRunConfiguration(new WindowsDriverConnector(projectDir + File.separator + PropertySettingStoreUtil.INTERNAL_SETTING_ROOT_FOLDER_NAME));
        this.prepareFlaUIDriverIfNecessary(runConfig);
        return runConfig;
    }

    protected boolean checkExecutionEntitlement(LaunchMode launchMode) {
        if (!super.checkExecutionEntitlement(launchMode)) {
            return false;
        }
        if (!this.featureController.canUse(ProductFeature.WINDOWS_DESKTOP_TESTING)) {
            this.productFeatureDialog.showNotAvailableFeature(ProductFeature.WINDOWS_DESKTOP_TESTING);
            return false;
        }
        return true;
    }

    private void prepareFlaUIDriverIfNecessary(WindowsRunConfiguration runConfig) {
        if (runConfig == null) {
            return;
        }
        WindowsDriverConnector windowsDriverConnector = runConfig.getDriverConnector();
        String userDefinedDriverUrl = windowsDriverConnector.getDriverUrl();
        if (!StringUtils.isBlank((CharSequence)userDefinedDriverUrl)) {
            return;
        }
        ProxyInformation proxyInfo = ProxyPreferences.getSystemProxyInformation();
        ProxyConfig proxyConfig = proxyInfo == null ? null : proxyInfo.toNewProxyConfigModel();
        FlaUIDriverManager.FlaUIServer selfHostedServer = FlaUIDriverManager.getInstance().startLocalServer(FlaUIDriverManager.StartMode.ONLY_START_IF_NOT_HEALTHY, proxyConfig);
        if (selfHostedServer != null) {
            runConfig.useSelfHostedServer(selfHostedServer.getServerUrl());
        }
    }
}

