/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.windows.record;

import com.kms.katalon.composer.components.impl.control.CTableViewer;
import com.kms.katalon.composer.windows.element.CapturedWindowsElement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class RecordedWindowsElementTableViewer
extends CTableViewer {
    private static final String RUNTIME_ID_PROP = "RuntimeId";
    public List<CapturedWindowsElement> capturedElements;

    public RecordedWindowsElementTableViewer(Composite parent, int style) {
        super(parent, style);
    }

    public void setCaptureElements(List<CapturedWindowsElement> input) {
        this.capturedElements = new ArrayList<CapturedWindowsElement>(input);
        super.setInput(input);
    }

    public List<CapturedWindowsElement> getCapturedElements() {
        return this.capturedElements;
    }

    public CapturedWindowsElement getDuplicatedObject(CapturedWindowsElement element) {
        for (CapturedWindowsElement captured : this.capturedElements) {
            if (!captured.getProperties().containsKey(RUNTIME_ID_PROP) || !element.getProperties().containsKey(RUNTIME_ID_PROP) || !captured.getProperties().get(RUNTIME_ID_PROP).equals(element.getProperties().get(RUNTIME_ID_PROP)) || !StringUtils.isNotEmpty((CharSequence)captured.getProperties().get(RUNTIME_ID_PROP))) continue;
            return captured;
        }
        return null;
    }

    public CapturedWindowsElement addCapturedObject(CapturedWindowsElement element) {
        CapturedWindowsElement duplicatedElement = this.getDuplicatedObject(element);
        if (duplicatedElement != null) {
            return duplicatedElement;
        }
        List<String> currentNames = this.capturedElements.stream().map(e -> e.getName()).collect(Collectors.toList());
        if (currentNames.contains(element.getName())) {
            String suggestedName = this.findNameForElement(element.getName(), currentNames);
            element.setName(suggestedName);
        }
        this.capturedElements.add(element);
        this.refresh();
        this.setSelection((ISelection)new StructuredSelection((Object)element));
        this.showLastItem();
        return element;
    }

    private String findNameForElement(String name, List<String> currentNames) {
        Object suggestedName = name;
        int index = 0;
        while (currentNames.contains(suggestedName)) {
            suggestedName = name + "(" + ++index + ")";
        }
        return suggestedName;
    }

    public Object getInput() {
        return this.capturedElements;
    }

    public CapturedWindowsElement getElementByName(String name) {
        return this.capturedElements.stream().filter(e -> e.getName().equals(name)).findAny().orElseGet(null);
    }
}

