/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.platform.internal;

import com.katalon.platform.api.Extension;
import com.katalon.platform.api.ExtensionPoint;
import com.katalon.platform.api.Plugin;
import com.katalon.platform.api.lifecycle.ExtensionListener;
import com.katalon.platform.api.service.ExtensionManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ExtensionManagerImpl
implements ExtensionManager {
    private Map<String, Set<Extension>> extensionCollections = new HashMap<String, Set<Extension>>();
    private Map<String, ExtensionPoint> extensionPointCollections = new HashMap<String, ExtensionPoint>();

    @Override
    public Collection<Extension> getExtensions(String extensionPointId) {
        return this.extensionCollections.getOrDefault(extensionPointId, Collections.emptySet());
    }

    public void addExtension(String extensionPointId, Extension extension) {
        Set extensions = this.extensionCollections.getOrDefault(extensionPointId, new LinkedHashSet());
        extensions.add(extension);
        this.extensionCollections.put(extensionPointId, extensions);
    }

    public void addExtensionPoint(String extensionPointId, ExtensionPoint extensionPoint) {
        this.extensionPointCollections.put(extensionPointId, extensionPoint);
    }

    public void removeExtension(Extension extension) {
        String extensionPointId = extension.getExtensionPointId();
        Set extensions = this.extensionCollections.getOrDefault(extensionPointId, new LinkedHashSet());
        if (extensions.contains(extension)) {
            extensions.remove(extension);
        }
        this.extensionCollections.put(extensionPointId, extensions);
    }

    public void removeExtensionPoint(String extensionPointId) {
        this.extensionCollections.remove(extensionPointId);
        this.extensionPointCollections.remove(extensionPointId);
    }

    @Override
    public ExtensionPoint getExtensionPoint(String extensionPointId) {
        return this.extensionPointCollections.getOrDefault(extensionPointId, null);
    }

    public void registerExtensions(Plugin plugin) {
        plugin.getExtensions().stream().forEach(e -> {
            ExtensionListener serviceClass;
            ExtensionPoint extensionPoint = this.getExtensionPoint(e.getExtensionPointId());
            if (extensionPoint != null && (serviceClass = extensionPoint.getServiceClass()) != null) {
                try {
                    serviceClass.register((Extension)e);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.out);
                }
            }
        });
    }

    public void registerExtensionsPoint(Plugin plugin) {
        plugin.getExtensionPoints().stream().forEach(extensionPoint -> {
            ExtensionListener serviceClass = extensionPoint.getServiceClass();
            if (serviceClass != null) {
                serviceClass.onPostConstruct();
                this.getExtensions(extensionPoint.getPluginId()).stream().forEach(e -> serviceClass.register((Extension)e));
            }
        });
    }

    public void deregisterExtensionsPoint(Plugin plugin) {
        plugin.getExtensionPoints().stream().forEach(extensionPoint -> {
            ExtensionListener serviceClass = extensionPoint.getServiceClass();
            if (serviceClass != null) {
                serviceClass.onPreDestroy();
                this.getExtensions(extensionPoint.getPluginId()).stream().forEach(e -> serviceClass.deregister((Extension)e));
            }
        });
    }

    public void deregisterExtensions(Plugin plugin) {
        plugin.getExtensions().stream().forEach(e -> {
            ExtensionListener serviceClass;
            ExtensionPoint extensionPoint = this.getExtensionPoint(e.getExtensionPointId());
            if (extensionPoint != null && (serviceClass = extensionPoint.getServiceClass()) != null) {
                serviceClass.deregister((Extension)e);
            }
        });
    }
}

