/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.platform.internal.util;

import com.katalon.platform.api.Plugin;
import com.katalon.platform.api.lifecycle.ExtensionListener;
import com.katalon.platform.api.service.ApplicationManager;
import com.katalon.platform.internal.ExtensionImpl;
import com.katalon.platform.internal.ExtensionManagerImpl;
import com.katalon.platform.internal.ExtensionPointImpl;
import com.katalon.platform.internal.KatalonPluginImpl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.osgi.framework.Bundle;

public class PluginManifestParsingUtil {
    public static Plugin parsePlugin(Bundle bundle, IExtensionRegistry extensionRegistry) {
        IExtension[] extensions;
        ExtensionManagerImpl extensionManager = (ExtensionManagerImpl)ApplicationManager.getInstance().getExtensionManager();
        String symbolicName = bundle.getSymbolicName();
        KatalonPluginImpl pluginImpl = new KatalonPluginImpl(symbolicName);
        for (IExtension e : extensions = extensionRegistry.getExtensions(symbolicName)) {
            String pluginId;
            if (e.getExtensionPointUniqueIdentifier().equals("com.katalon.platform.extensions")) {
                try {
                    pluginId = e.getNamespaceIdentifier();
                    String extensionId = e.getConfigurationElements()[0].getAttribute("id");
                    String extensionPointId = e.getConfigurationElements()[0].getAttribute("extensionPointId");
                    Object implementationClass = e.getConfigurationElements()[0].createExecutableExtension("implementationClass");
                    ExtensionImpl newExtension = new ExtensionImpl(pluginId, extensionId, extensionPointId, implementationClass);
                    pluginImpl.addExtension(newExtension);
                    extensionManager.addExtension(extensionPointId, newExtension);
                }
                catch (CoreException | InvalidRegistryObjectException ex) {
                    ex.printStackTrace(System.out);
                }
            }
            if (!e.getExtensionPointUniqueIdentifier().equals("com.katalon.platform.extensions_point")) continue;
            try {
                pluginId = e.getNamespaceIdentifier();
                String extensionPointId = e.getConfigurationElements()[0].getAttribute("id");
                String interfaceClassName = e.getConfigurationElements()[0].getAttribute("interfaceClass");
                ExtensionListener serviceClass = null;
                if (e.getConfigurationElements()[0].getAttribute("serviceClass") != null) {
                    serviceClass = (ExtensionListener)e.getConfigurationElements()[0].createExecutableExtension("serviceClass");
                }
                ExtensionPointImpl newExtensionPoint = new ExtensionPointImpl(pluginId, extensionPointId, interfaceClassName, serviceClass);
                pluginImpl.addExtensionPoint(newExtensionPoint);
                extensionManager.addExtensionPoint(extensionPointId, newExtensionPoint);
            }
            catch (CoreException | InvalidRegistryObjectException ex) {
                ex.printStackTrace(System.out);
            }
        }
        return pluginImpl;
    }
}

