/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.format;

import io.cucumber.eclipse.editor.document.GherkinEditorDocument;
import io.cucumber.gherkin.utils.pretty.Pretty;
import io.cucumber.gherkin.utils.pretty.Syntax;
import io.cucumber.messages.types.GherkinDocument;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class GherkingFormatHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IFileEditorInput fileInput;
        GherkinEditorDocument document;
        IEditorPart editor;
        IEditorInput editorInput;
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        if (part instanceof IEditorPart && (editorInput = (editor = (IEditorPart)part).getEditorInput()) instanceof IFileEditorInput && (document = GherkinEditorDocument.get((IResource)(fileInput = (IFileEditorInput)editorInput).getFile())) != null) {
            this.formatDocument(document, fileInput.getFile());
        }
        return null;
    }

    private void formatDocument(GherkinEditorDocument document, IFile file) {
        Optional<GherkinDocument> gherkinDocument = document.getGherkinDocument();
        if (gherkinDocument.isEmpty()) {
            return;
        }
        String prettyPrint = Pretty.prettyPrint((GherkinDocument)gherkinDocument.get(), (Syntax)Syntax.gherkin);
        document.getDocument().set(prettyPrint);
    }
}

