/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.hyperlinks;

import io.cucumber.eclipse.editor.hyperlinks.IStepDefinitionOpener;
import io.cucumber.messages.types.Step;
import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Shell;

public class StepHyperlink
implements IHyperlink {
    private IRegion region;
    private Step stepDefintion;
    private ITextViewer textViewer;
    private Collection<IStepDefinitionOpener> openers;
    private IResource resource;

    public StepHyperlink(IRegion region, Step step, ITextViewer textViewer, IResource resource, Collection<IStepDefinitionOpener> openers) {
        this.region = region;
        this.stepDefintion = step;
        this.textViewer = textViewer;
        this.resource = resource;
        this.openers = openers;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return "Open step definition";
    }

    public String getTypeLabel() {
        return "Gherkin step";
    }

    public void open() {
        for (IStepDefinitionOpener opener : this.openers) {
            try {
                if (!opener.openInEditor(this.textViewer, this.resource, this.stepDefintion)) continue;
                return;
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        MessageDialog.openInformation((Shell)this.textViewer.getTextWidget().getShell(), (String)this.getTypeLabel(), (String)("No source found for step " + this.stepDefintion.getText()));
    }
}

