/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.eclipse.editor.marker;

import io.cucumber.eclipse.editor.Activator;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.ParseError;
import io.cucumber.messages.types.SourceReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class MarkerFactory {
    public static final String CUCUMBER_MARKER = "cucumber.eclipse.marker";
    public static final String STEPDEF_SYNTAX_ERROR = "cucumber.eclipse.marker.stepdef.syntaxerror";
    public static final String STEPDEF_VALIDATION_ERROR = "cucumber.eclipse.marker.gherkin.validation_error";
    public static final String GHERKIN_SYNTAX_ERROR = "cucumber.eclipse.marker.gherkin.syntaxerror";
    public static final String STEP_DEFINTION_MATCH = "cucumber.eclipse.marker.stepdef.matches";
    public static final String STEP_DEFINITION_MATCH_PATH_ATTRIBUTE = "cucumber.eclipse.marker.stepdef.matches.path";
    public static final String STEP_DEFINITION_MATCH_JDT_HANDLE_IDENTIFIER_ATTRIBUTE = "cucumber.eclipse.marker.stepdef.matches.jdt_handler_identifier";
    public static final String STEP_DEFINITION_MATCH_LINE_NUMBER_ATTRIBUTE = "cucumber.eclipse.marker.stepdef.matches.line_number";
    public static final String STEP_DEFINITION_MATCH_TEXT_ATTRIBUTE = "cucumber.eclipse.marker.stepdef.matches.text";
    public static final String SCENARIO_OUTLINE_EXAMPLE_UNMATCH = "cucumber.eclipse.marker.scenario_outline_example_unmatch";
    public static final String MULTIPLE_STEP_DEFINTIONS_MATCH = "cucumber.eclipse.marker.stepdef.multiple_matches";
    public static final String UNMATCHED_STEP = "cucumber.eclipse.marker.gherkin.unmatched_step";
    public static final String UNMATCHED_STEP_KEYWORD_ATTRIBUTE = "cucumber.eclipse.marker.gherkin.unmatched_step.keyword";
    public static final String UNMATCHED_STEP_NAME_ATTRIBUTE = "cucumber.eclipse.marker.gherkin.unmatched_step.name";
    public static final String UNMATCHED_STEP_PATH_ATTRIBUTE = "cucumber.eclipse.marker.gherkin.unmatched_step.path";
    public static final String UNMATCHED_STEP_SNIPPET_ATTRIBUTE = "cucumber.eclipse.marker.gherkin.unmatched_step.snippet";
    public static final String UNMATCHED_STEP_SNIPPTE_TYPE_ATTRIBUTE = "cucumber.eclipse.marker.gherkin.unmatched_step.snippet.type";
    public static final String NOT_A_CUCUMBER_PROJECT = "cucumber.eclipse.marker.not_a_cucumber_project";
    public static final String NOT_A_CUCUMBER_PROJECT_NAME_ATTRIBUTE = "cucumber.eclipse.marker.not_a_cucumber_project.project_name";
    public static final String CUCUMBER_NATURE_MISSING_MARKER = "cucumber.eclipse.marker.project.cucumber_nature_missing";

    private MarkerFactory() {
    }

    public static void validationErrorOnStepDefinition(final IResource resource, final Map<Integer, String> errors, final boolean persistent) {
        if (errors == null || errors.isEmpty()) {
            MarkerFactory.mark(resource, new IMarkerBuilder(){

                @Override
                public void build() throws CoreException {
                    MarkerFactory.deleteStepValidationErrors(resource);
                }
            });
            return;
        }
        MarkerFactory.mark(resource, new IMarkerBuilder(){

            @Override
            public void build() throws CoreException {
                MarkerFactory.deleteStepValidationErrors(resource);
                for (Map.Entry entry : errors.entrySet()) {
                    IMarker marker = resource.createMarker(MarkerFactory.STEPDEF_VALIDATION_ERROR);
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("message", entry.getValue());
                    marker.setAttribute("lineNumber", entry.getKey());
                    marker.setAttribute("transient", persistent);
                }
            }
        });
    }

    public void syntaxErrorOnStepDefinition(IResource stepDefinitionResource, Exception e) {
        MarkerFactory.syntaxErrorOnStepDefinition(stepDefinitionResource, e, 0);
    }

    private static void deleteStepValidationErrors(IResource resource) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = resource.findMarkers(STEPDEF_VALIDATION_ERROR, true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
    }

    public static void syntaxErrorOnStepDefinition(final IResource stepDefinitionResource, final Exception e, final int lineNumber) {
        MarkerFactory.mark(stepDefinitionResource, new IMarkerBuilder(){

            @Override
            public void build() throws CoreException {
                IMarker marker = stepDefinitionResource.createMarker(MarkerFactory.STEPDEF_SYNTAX_ERROR);
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)e.getMessage());
                marker.setAttribute("lineNumber", lineNumber);
            }
        });
    }

    public static void syntaxErrorOnGherkin(final IResource resource, final Iterable<ParseError> errors, final boolean persistent) {
        MarkerFactory.mark(resource, new IMarkerBuilder(){

            @Override
            public void build() throws CoreException {
                Map<Object, IMarker> existingMarker = MarkerFactory.getExistingMarker(resource, MarkerFactory.GHERKIN_SYNTAX_ERROR);
                for (ParseError error : errors) {
                    int column;
                    Integer line;
                    if (error.getSource().getLocation().isPresent()) {
                        SourceReference source = error.getSource();
                        Location location = (Location)source.getLocation().get();
                        Long l = location.getLine();
                        line = l == null ? null : Integer.valueOf(l.intValue());
                        column = location.getColumn().orElse(-1L).intValue();
                    } else {
                        line = -1;
                        column = -1;
                    }
                    Object sourceId = line > 0 ? String.valueOf(line) + ":" + column : "";
                    IMarker marker = existingMarker.remove(sourceId);
                    if (marker == null) {
                        marker = resource.createMarker(MarkerFactory.GHERKIN_SYNTAX_ERROR);
                        marker.setAttribute("sourceId", sourceId);
                    }
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("message", (Object)error.getMessage());
                    marker.setAttribute("lineNumber", (Object)line);
                    marker.setAttribute("lineNumber", (Object)line);
                    marker.setAttribute("transient", persistent);
                }
                for (IMarker obsolete : existingMarker.values()) {
                    obsolete.delete();
                }
            }
        });
    }

    public static void missingSteps(final IResource resource, final Map<Integer, Collection<String>> snippets, final String snippetType, final boolean persistent) {
        MarkerFactory.mark(resource, new IMarkerBuilder(){

            @Override
            public void build() throws CoreException {
                Map<Object, IMarker> existingMarker = MarkerFactory.getExistingMarker(resource, MarkerFactory.UNMATCHED_STEP);
                for (Map.Entry entry : snippets.entrySet()) {
                    int lineNumber = (Integer)entry.getKey();
                    int index = 0;
                    for (String snippet : (Collection)entry.getValue()) {
                        String sourceId;
                        IMarker marker;
                        if ((marker = existingMarker.remove(sourceId = snippetType + "_" + lineNumber + "_" + index++)) == null) {
                            marker = resource.createMarker(MarkerFactory.UNMATCHED_STEP);
                            marker.setAttribute("sourceId", (Object)sourceId);
                        }
                        marker.setAttribute("severity", 1);
                        marker.setAttribute("message", (Object)"Step  does not have a matching glue code");
                        marker.setAttribute("lineNumber", lineNumber);
                        marker.setAttribute("transient", persistent);
                        marker.setAttribute(MarkerFactory.UNMATCHED_STEP_SNIPPET_ATTRIBUTE, (Object)snippet);
                        marker.setAttribute(MarkerFactory.UNMATCHED_STEP_SNIPPTE_TYPE_ATTRIBUTE, (Object)snippetType);
                    }
                }
                for (IMarker obsolete : existingMarker.values()) {
                    obsolete.delete();
                }
            }
        });
    }

    private static Map<Object, IMarker> getExistingMarker(IResource resource, String type) throws CoreException {
        IMarker[] markers;
        HashMap<Object, IMarker> map = new HashMap<Object, IMarker>();
        IMarker[] iMarkerArray = markers = resource.findMarkers(type, true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String attribute = marker.getAttribute("sourceId", "");
            if (!attribute.isBlank()) {
                map.put(attribute, marker);
            }
            ++n2;
        }
        return map;
    }

    public void gherkinStepExampleUnmatch(final IDocument gherkinDocument, final IResource gherkinResource, final int lineNumber) {
        MarkerFactory.mark(gherkinResource, new IMarkerBuilder(){

            @Override
            public void build() throws CoreException {
                IMarker marker = null;
                int lineStartOffset = 0;
                IRegion lineInfo = null;
                String currentLine = null;
                try {
                    lineInfo = gherkinDocument.getLineInformation(lineNumber - 1);
                    lineStartOffset = lineInfo.getOffset();
                    currentLine = gherkinDocument.get(lineStartOffset, lineInfo.getLength());
                }
                catch (BadLocationException e) {
                    return;
                }
                String currentLineTrim = currentLine.trim();
                int statementStartOffset = lineStartOffset + currentLine.indexOf(currentLineTrim);
                Region stepRegion = new Region(statementStartOffset, currentLineTrim.length());
                marker = gherkinResource.createMarker(MarkerFactory.SCENARIO_OUTLINE_EXAMPLE_UNMATCH);
                marker.setAttribute("severity", 1);
                marker.setAttribute("message", (Object)String.format("No compatible step definition with %s", currentLineTrim));
                marker.setAttribute("lineNumber", lineNumber);
                marker.setAttribute("charStart", stepRegion.getOffset());
                marker.setAttribute("charEnd", stepRegion.getOffset() + stepRegion.getLength());
            }
        });
    }

    public void cleanMarkers(IResource resource) {
        try {
            resource.deleteMarkers(CUCUMBER_MARKER, true, 0);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "io.cucumber.eclipse.editor", String.format("Couldn't remove markers from %s", resource), (Throwable)e));
        }
    }

    public void cleanMarkersRecursively(IResource resource) {
        try {
            resource.deleteMarkers(CUCUMBER_MARKER, true, 2);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "io.cucumber.eclipse.editor", String.format("Couldn't remove markers from %s", resource), (Throwable)e));
        }
    }

    private static void mark(IResource resource, final IMarkerBuilder markerBuilder) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    markerBuilder.build();
                }
            };
            resource.getWorkspace().run(runnable, null, 1, null);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "io.cucumber.eclipse.editor", String.format("Failed to place marker %s", resource), (Throwable)e));
        }
    }

    public void cleanCucumberNatureMissing(IProject project) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = project.findMarkers(CUCUMBER_NATURE_MISSING_MARKER, false, 0);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
    }

    public static boolean hasMarker(IResource resource, String type, int lineNumber) throws CoreException {
        return MarkerFactory.getExistingMarker(resource, type).values().stream().filter(marker -> marker.getAttribute("lineNumber", -1) == lineNumber).findAny().isPresent();
    }

    private static interface IMarkerBuilder {
        public void build() throws CoreException;
    }
}

