/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.debug;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.Script;
import groovy.util.Proxy;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.eclipse.debug.JDIBinding;
import org.codehaus.groovy.eclipse.debug.JDIIterator;
import org.codehaus.groovy.eclipse.debug.JDIMetaClass;
import org.codehaus.groovy.eclipse.debug.JDIScriptLoader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaClassObject;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaPrimitiveValue;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;

public class JDITargetDelegate {
    private final IJavaDebugTarget target;
    private final IJavaThread thread;
    private String syntheticScriptName;
    private List<IJavaObject> permStorage = new ArrayList<IJavaObject>();
    private final Set<MetaClass> originalMetaClasses = new HashSet<MetaClass>();

    public JDITargetDelegate(IJavaDebugTarget target, IJavaThread thread) {
        this.target = target;
        this.thread = thread;
    }

    public IJavaDebugTarget getTarget() {
        return this.target;
    }

    public IJavaThread getThread() {
        return this.thread;
    }

    public void initialize(JDIScriptLoader loader) throws DebugException {
        ClassNode scriptClass = loader.getTheClass();
        this.syntheticScriptName = scriptClass.getName();
        Set<Class<?>> allClasses = new ClassStoreVisitor((ClassLoader)((Object)loader)).doVisit(scriptClass);
        for (Class<?> clazz : allClasses) {
            this.createMetaClassFor((ClassLoader)((Object)loader), clazz);
        }
    }

    private void createMetaClassFor(ClassLoader loader, Class<?> clazz) throws DebugException {
        MetaClass meta = GroovySystem.getMetaClassRegistry().getMetaClass(clazz);
        JDIMetaClass jidMetaClass = new JDIMetaClass(meta, this);
        GroovySystem.getMetaClassRegistry().setMetaClass(clazz, (MetaClass)jidMetaClass);
        this.originalMetaClasses.add(meta);
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                this.createMetaClassFor(loader, Integer.class);
            } else if (clazz == Double.TYPE) {
                this.createMetaClassFor(loader, Double.class);
            } else if (clazz == Boolean.TYPE) {
                this.createMetaClassFor(loader, Boolean.class);
            } else if (clazz == Character.TYPE) {
                this.createMetaClassFor(loader, Character.class);
            } else if (clazz == Short.TYPE) {
                this.createMetaClassFor(loader, Short.class);
            } else if (clazz == Byte.TYPE) {
                this.createMetaClassFor(loader, Byte.class);
            } else if (clazz == Long.TYPE) {
                this.createMetaClassFor(loader, Long.class);
            } else if (clazz == Float.TYPE) {
                this.createMetaClassFor(loader, Float.class);
            } else if (clazz == Void.TYPE) {
                this.createMetaClassFor(loader, Void.class);
            }
        }
    }

    public void cleanup() {
        if (!this.originalMetaClasses.isEmpty()) {
            for (MetaClass mc : this.originalMetaClasses) {
                GroovySystem.getMetaClassRegistry().removeMetaClass(mc.getTheClass());
            }
            this.originalMetaClasses.clear();
        }
        if (this.permStorage != null) {
            for (IJavaObject object : this.permStorage) {
                try {
                    object.enableCollection();
                }
                catch (DebugException e) {
                    if (e.getStatus().getException().getClass().getSimpleName().equals("VMDisconnectedException")) break;
                }
            }
            this.permStorage = null;
        }
    }

    public void disableCollection(IJavaObject object) {
        if (this.permStorage != null) {
            try {
                object.disableCollection();
                this.permStorage.add(object);
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
    }

    public Proxy createProxyFor(IJavaValue value) throws DebugException {
        if (value.isNull()) {
            return null;
        }
        JDIProxy jdiProxy = new JDIProxy();
        if (value instanceof IJavaPrimitiveValue) {
            value = this.toJDIObject(value);
        } else if (value.getJavaType().getName().equals("groovy.lang.Reference")) {
            value = ((IJavaObject)value).sendMessage("get", "()Ljava/lang/Object;", new IJavaValue[0], this.getThread(), false);
        }
        jdiProxy.setMetaClass(new JDIMetaClass(null, this.getMetaClass(value), this));
        jdiProxy.setAdaptee(value);
        return jdiProxy;
    }

    public IJavaObject getMetaClass(IJavaValue object) throws DebugException {
        IJavaFieldVariable metaClassField;
        if (object.isNull()) {
            object = ((IJavaClassType)this.getType("org.codehaus.groovy.runtime.NullObject")).getClassObject();
        } else if (object instanceof IJavaObject && (metaClassField = ((IJavaObject)object).getField("metaClass", false)) != null && metaClassField.getSignature().equals("Lgroovy/lang/MetaClass;")) {
            return (IJavaObject)metaClassField.getValue();
        }
        IJavaClassType invoker = (IJavaClassType)this.getType("org.codehaus.groovy.runtime.InvokerHelper");
        return (IJavaObject)invoker.sendMessage("getMetaClass", "(Ljava/lang/Object;)Lgroovy/lang/MetaClass;", new IJavaValue[]{object}, this.getThread());
    }

    public IJavaType getType(String className) throws DebugException {
        IJavaType[] types = this.target.getJavaTypes(className);
        IJavaType classClass = null;
        if (types != null && types.length > 0) {
            classClass = types[0];
        }
        if (classClass == null) {
            this.getClassObject(className);
            types = this.target.getJavaTypes(className);
            if (types != null && types.length > 0) {
                classClass = types[0];
            }
            if (classClass == null) {
                this.throwInvalidObjectException(className);
            }
        }
        return classClass;
    }

    private IJavaClassType getWrapperType(String className) throws DebugException {
        return (IJavaClassType)this.getType(JDITargetDelegate.getWrapperTypeName(className));
    }

    private static String getWrapperTypeName(String className) {
        switch (className) {
            case "boolean": {
                return "java.lang.Boolean";
            }
            case "byte": {
                return "java.lang.Byte";
            }
            case "char": {
                return "java.lang.Character";
            }
            case "double": {
                return "java.lang.Double";
            }
            case "float": {
                return "java.lang.Float";
            }
            case "int": {
                return "java.lang.Integer";
            }
            case "long": {
                return "java.lang.Long";
            }
            case "short": {
                return "java.lang.Short";
            }
            case "void": {
                return "java.lang.Void";
            }
        }
        throw new IllegalArgumentException(className);
    }

    protected IJavaObject newInstance(String className) throws DebugException {
        IJavaClassObject classObject = this.getClassObject(className);
        IJavaObject object = (IJavaObject)classObject.sendMessage("newInstance", "()Ljava/lang/Object;", null, this.thread, false);
        return object;
    }

    protected IJavaArray newArrayInstance(String className, int size) throws DebugException {
        IJavaClassObject classObject = this.getClassObject(className);
        IJavaArrayType arrayType = (IJavaArrayType)classObject.getInstanceType();
        IJavaArray object = arrayType.newInstance(size);
        this.disableCollection((IJavaObject)object);
        return object;
    }

    private IJavaClassObject getClassObject(String className) throws DebugException {
        IJavaClassType classClass = (IJavaClassType)this.getType("java.lang.Class");
        IJavaValue obj = classClass.sendMessage("forName", "(Ljava/lang/String;)Ljava/lang/Class;", new IJavaValue[]{this.target.newValue(className)}, this.thread);
        return (IJavaClassObject)obj;
    }

    public IJavaObject toJDIObject(Object o) throws DebugException {
        block60: {
            IJavaValue v;
            block61: {
                if (o == null) {
                    return (IJavaObject)this.target.nullValue();
                }
                if (o instanceof Proxy) {
                    o = ((Proxy)o).getAdaptee();
                }
                v = null;
                if (o instanceof IJavaValue) {
                    v = (IJavaValue)o;
                } else if (o instanceof Integer) {
                    v = this.target.newValue(((Integer)o).intValue());
                } else if (o instanceof Boolean) {
                    v = this.target.newValue(((Boolean)o).booleanValue());
                } else if (o instanceof Double) {
                    v = this.target.newValue(((Double)o).doubleValue());
                } else if (o instanceof Float) {
                    v = this.target.newValue(((Float)o).floatValue());
                } else if (o instanceof Long) {
                    v = this.target.newValue(((Long)o).longValue());
                } else if (o instanceof Short) {
                    v = this.target.newValue(((Short)o).shortValue());
                } else if (o instanceof Byte) {
                    v = this.target.newValue(((Byte)o).byteValue());
                } else if (o instanceof Character) {
                    v = this.target.newValue(((Character)o).charValue());
                }
                if (v == null) break block60;
                if (!(v instanceof IJavaPrimitiveValue)) break block61;
                String signature = null;
                switch (v.getSignature()) {
                    case "I": {
                        signature = "(I)Ljava/lang/Integer;";
                        break;
                    }
                    case "Z": {
                        signature = "(Z)Ljava/lang/Boolean;";
                        break;
                    }
                    case "D": {
                        signature = "(D)Ljava/lang/Double;";
                        break;
                    }
                    case "F": {
                        signature = "(F)Ljava/lang/Float;";
                        break;
                    }
                    case "J": {
                        signature = "(J)Ljava/lang/Long;";
                        break;
                    }
                    case "B": {
                        signature = "(B)Ljava/lang/Byte;";
                        break;
                    }
                    case "S": {
                        signature = "(S)Ljava/lang/Short;";
                        break;
                    }
                    case "C": {
                        signature = "(C)Ljava/lang/Character;";
                        break;
                    }
                    case "V": {
                        return (IJavaObject)this.target.nullValue();
                    }
                }
                return (IJavaObject)this.getWrapperType(v.getJavaType().getName()).sendMessage("valueOf", signature, new IJavaValue[]{v}, this.thread);
            }
            return (IJavaObject)v;
        }
        if (o instanceof String) {
            return (IJavaObject)this.target.newValue((String)o);
        }
        if (o instanceof Script) {
            return ((JDIBinding)((Script)o).getBinding()).getThis();
        }
        if (o instanceof Class) {
            String name = ((Class)o).getName();
            IJavaType type = this.getType(name);
            if (type instanceof IJavaReferenceType) {
                return ((IJavaReferenceType)type).getClassObject();
            }
            return (IJavaClassObject)this.getWrapperType(name).getField("TYPE").getValue();
        }
        if (o.getClass().isArray()) {
            int length = Array.getLength(o);
            boolean object = o instanceof Object[];
            IJavaArray array = this.newArrayInstance(o.getClass().getName(), length);
            int i = 0;
            while (i < length) {
                array.setValue(i, (IJavaValue)(object ? this.toJDIObject(((Object[])o)[i]) : this.toJDIValue(Array.get(o, i))));
                ++i;
            }
            return array;
        }
        if (o instanceof List) {
            return this.newJDIList((List)o);
        }
        if (o instanceof Map) {
            return this.newJDIMap((Map)o);
        }
        if (o instanceof GString) {
            return this.newJDIGString((GString)o);
        }
        if (o instanceof Closure) {
            return this.newJDIClosure((Closure)o);
        }
        return this.throwInvalidObjectException(o);
    }

    /*
     * Exception decompiling
     */
    public IJavaValue toJDIValue(Object o) throws DebugException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[19] lbl133 : CaseStatement: default:\u000a, @NONE, blocks:[19] lbl133 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IJavaObject newJDIGString(GString gstring) throws DebugException {
        String[] strings = gstring.getStrings();
        Object[] values = gstring.getValues();
        IJavaClassObject classObject = this.getClassObject("org.codehaus.groovy.runtime.GStringImpl");
        IJavaArray constructors = (IJavaArray)classObject.sendMessage("getDeclaredConstructors", "()[Ljava/lang/reflect/Constructor;", null, this.thread, false);
        IJavaObject constructor = (IJavaObject)constructors.getValue(0);
        IJavaArray args = this.newArrayInstance("[Ljava.lang.Object;", 2);
        args.setValue(0, (IJavaValue)this.toJDIObject(values));
        args.setValue(1, (IJavaValue)this.toJDIObject(strings));
        return (IJavaObject)constructor.sendMessage("newInstance", "([Ljava/lang/Object;)Ljava/lang/Object;", new IJavaValue[]{args}, this.thread, false);
    }

    private IJavaObject newJDIClosure(Closure<?> c) throws DebugException {
        IJavaClassType methodClosureClass = (IJavaClassType)this.getType("org.codehaus.groovy.runtime.MethodClosure");
        IJavaClassType closureClass = (IJavaClassType)this.getType("groovy.lang.Closure");
        IJavaClassObject jdiOwner = closureClass.getClassObject();
        IJavaObject jdiMethodName = this.toJDIObject("call");
        return methodClosureClass.newInstance("(Ljava/lang/Object;Ljava/lang/String;)V", new IJavaValue[]{jdiOwner, jdiMethodName}, this.thread);
    }

    private IJavaObject newJDIList(List<?> list) throws DebugException {
        IJavaObject jdiList = this.newInstance("java.util.ArrayList");
        for (Object obj : list) {
            jdiList.sendMessage("add", "(Ljava/lang/Object;)Z", new IJavaValue[]{this.toJDIObject(obj)}, this.thread, false);
        }
        return jdiList;
    }

    private IJavaObject newJDIMap(Map<?, ?> map) throws DebugException {
        IJavaObject jdiMap = this.newInstance("java.util.LinkedHashMap");
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            jdiMap.sendMessage("put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", new IJavaValue[]{this.toJDIObject(entry.getKey()), this.toJDIObject(entry.getValue())}, this.thread, false);
        }
        return jdiMap;
    }

    private IJavaObject throwInvalidObjectException(Object o) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "org.codehaus.groovy.eclipse.ui", 5012, "(Groovy) Invalid object " + String.valueOf(o), null));
    }

    public IJavaObject createMetaClassInDebuggedApplication(MetaClass metaClass) throws DebugException {
        Class clazz = metaClass.getTheClass();
        IJavaClassObject jdiClass = (clazz.isPrimitive() ? this.getWrapperType(clazz.getName()) : (IJavaReferenceType)this.getType(clazz.getName())).getClassObject();
        IJavaClassType groovySystem = (IJavaClassType)this.getType("groovy.lang.GroovySystem");
        IJavaObject metaRegistry = (IJavaObject)groovySystem.getField("META_CLASS_REGISTRY").getValue();
        return (IJavaObject)metaRegistry.sendMessage("getMetaClass", "(Ljava/lang/Class;)Lgroovy/lang/MetaClass;", new IJavaValue[]{jdiClass}, this.thread, false);
    }

    public Boolean convertToBoolean(IJavaValue result) throws DebugException {
        try {
            if (result instanceof IJavaPrimitiveValue) {
                return ((IJavaPrimitiveValue)result).getBooleanValue();
            }
            return Boolean.valueOf(((IJavaObject)result).getField("value", false).getValue().getValueString());
        }
        catch (Exception e) {
            if (!(e instanceof DebugException)) {
                throw new DebugException((IStatus)new Status(4, "org.codehaus.groovy.eclipse.ui", "(Groovy) Should have had a Boolean result", (Throwable)e));
            }
            throw (DebugException)((Object)e);
        }
    }

    public Integer convertToInteger(IJavaValue result) throws DebugException {
        try {
            if (result instanceof IJavaPrimitiveValue) {
                return ((IJavaPrimitiveValue)result).getIntValue();
            }
            return Integer.valueOf(((IJavaObject)result).getField("value", false).getValue().getValueString());
        }
        catch (Exception e) {
            if (!(e instanceof DebugException)) {
                throw new DebugException((IStatus)new Status(4, "org.codehaus.groovy.eclipse.ui", "(Groovy) Should have had a Boolean result", (Throwable)e));
            }
            throw (DebugException)((Object)e);
        }
    }

    public Iterator<Proxy> convertToIterator(IJavaValue result) throws DebugException {
        return new JDIIterator((IJavaObject)result, this);
    }

    class ClassStoreVisitor
    extends ClassCodeVisitorSupport {
        Set<Class<?>> referencedClasses;
        private final ClassLoader loader;

        ClassStoreVisitor(ClassLoader loader) {
            this.loader = loader;
        }

        Set<Class<?>> doVisit(ClassNode node) {
            this.referencedClasses = new HashSet();
            node.visitContents((GroovyClassVisitor)this);
            return this.referencedClasses;
        }

        protected SourceUnit getSourceUnit() {
            return null;
        }

        private void storeClass(ClassNode classNode) {
            block6: {
                try {
                    Class typeClass = classNode.getTypeClass();
                    if (typeClass != null) {
                        this.referencedClasses.add(typeClass);
                    }
                }
                catch (GroovyBugError e) {
                    if (!classNode.getModule().getDescription().equals("____Eval.groovy") || classNode.getName().equals(JDITargetDelegate.this.syntheticScriptName)) break block6;
                    try {
                        Class<?> typeClass = this.loader.loadClass(classNode.getName());
                        if (typeClass != null) {
                            this.referencedClasses.add(typeClass);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }

        public void visitStaticMethodCallExpression(StaticMethodCallExpression expression) {
            this.storeClass(expression.getType());
            super.visitStaticMethodCallExpression(expression);
        }

        public void visitClassExpression(ClassExpression expression) {
            this.storeClass(expression.getType());
            super.visitClassExpression(expression);
        }

        public void visitConstantExpression(ConstantExpression expression) {
            this.storeClass(expression.getType());
            super.visitConstantExpression(expression);
        }

        public void visitConstructorCallExpression(ConstructorCallExpression expression) {
            this.storeClass(expression.getType());
            super.visitConstructorCallExpression(expression);
        }

        public void visitListExpression(ListExpression expression) {
            this.storeClass(expression.getType());
            super.visitListExpression(expression);
        }

        public void visitMapExpression(MapExpression expression) {
            this.storeClass(expression.getType());
            super.visitMapExpression(expression);
        }

        public void visitMapEntryExpression(MapEntryExpression expression) {
            this.storeClass(expression.getType());
            super.visitMapEntryExpression(expression);
        }
    }

    private static final class JDIProxy
    extends Proxy {
        private JDIProxy() {
        }

        public void setAdaptee(Object object) {
            super.setAdaptee(Objects.requireNonNull(object));
        }

        public String toString() {
            return this.getAdaptee().toString();
        }
    }
}

